/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.Map;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.tree.AbstractInsnNode;
import org.ow2.asmdex.tree.LabelNode;

public class OperationInsnNode
extends AbstractInsnNode {
    public int destinationRegister;
    public int firstSourceRegister;
    public int secondSourceRegister;
    public int value;

    public OperationInsnNode(int opcode, int destinationRegister, int firstSourceRegister, int secondSourceRegister, int value) {
        super(opcode);
        this.destinationRegister = destinationRegister;
        this.firstSourceRegister = firstSourceRegister;
        this.secondSourceRegister = secondSourceRegister;
        this.value = value;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public void accept(MethodVisitor mv) {
        mv.visitOperationInsn(this.opcode, this.destinationRegister, this.firstSourceRegister, this.secondSourceRegister, this.value);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels) {
        return new OperationInsnNode(this.opcode, this.destinationRegister, this.firstSourceRegister, this.secondSourceRegister, this.value);
    }
}

