/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.Arrays;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.AnnotationSetItem;
import org.ow2.asmdex.structureWriter.Method;

public class AnnotationSetRefList {
    private AnnotationSetItem[] annotationSetItems;
    private final int nbParameters;
    private int nbAnnotationSetItemsUsed = 0;
    private final Method method;
    private static AnnotationSetItem emptyAnnotationSetItem = null;

    public AnnotationSetRefList(int nbParameters, Method method) {
        this.nbParameters = nbParameters;
        this.method = method;
        this.annotationSetItems = new AnnotationSetItem[nbParameters];
    }

    public void addAnnotationItem(int parameterIndex, AnnotationItem annotationItem) {
        AnnotationSetItem annotationSetItem;
        if (parameterIndex >= this.nbParameters) {
            try {
                throw new Exception("Annotation Parameter index >= Parameter count of this method.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.annotationSetItems[parameterIndex] == null) {
            annotationSetItem = new AnnotationSetItem();
            ++this.nbAnnotationSetItemsUsed;
        } else {
            annotationSetItem = this.annotationSetItems[parameterIndex];
        }
        annotationSetItem.addAnnotationItem(annotationItem);
        this.annotationSetItems[parameterIndex] = annotationSetItem;
    }

    public void close() {
        int i = 0;
        int size = this.annotationSetItems.length;
        while (i < size) {
            if (this.annotationSetItems[i] == null) {
                this.annotationSetItems[i] = AnnotationSetRefList.getEmptyAnnotationSetItem();
            }
            ++i;
        }
    }

    private static AnnotationSetItem getEmptyAnnotationSetItem() {
        if (emptyAnnotationSetItem == null) {
            emptyAnnotationSetItem = new AnnotationSetItem();
        }
        return emptyAnnotationSetItem;
    }

    public AnnotationSetItem[] getAnnotationSetItems() {
        return this.annotationSetItems;
    }

    public AnnotationSetItem getAnnotationSetItem(int parameterIndex) {
        return this.annotationSetItems[parameterIndex];
    }

    public int getNbAnnotationSetItem() {
        return this.annotationSetItems.length;
    }

    public int getNbAnnotationSetItemsUsed() {
        return this.nbAnnotationSetItemsUsed;
    }

    public Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        return Arrays.hashCode(this.annotationSetItems);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnnotationSetRefList) {
            AnnotationSetRefList asr = (AnnotationSetRefList)obj;
            return Arrays.equals(this.annotationSetItems, asr.annotationSetItems);
        }
        return false;
    }
}

