/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.ArrayList;
import java.util.List;
import org.ow2.asmdex.structureWriter.AnnotationSetItem;
import org.ow2.asmdex.structureWriter.AnnotationSetRefList;
import org.ow2.asmdex.structureWriter.Field;
import org.ow2.asmdex.structureWriter.Method;

public class AnnotationDirectoryItem {
    private AnnotationSetItem classAnnotationSetItems;
    private List<Field> annotatedFields = new ArrayList<Field>();
    private List<Method> annotatedMethods = new ArrayList<Method>();
    private List<AnnotationSetRefList> annotatedParameters = new ArrayList<AnnotationSetRefList>();
    private int hashcode = -1;
    public static final int CLASS_ANNOTATIONS_OFF_OFFSET = 0;
    public static final int FIELDS_SIZE_OFFSET = 4;
    public static final int ANNOTATED_METHODS_SIZE_OFFSET = 8;
    public static final int ANNOTATED_PARAMETERS_SIZE_OFFSET = 12;

    public void setClassAnnotationSetItem(AnnotationSetItem classAnnotations) {
        this.classAnnotationSetItems = classAnnotations;
    }

    public AnnotationSetItem getClassAnnotationSetItem() {
        return this.classAnnotationSetItems;
    }

    public List<Field> getAnnotatedFields() {
        return this.annotatedFields;
    }

    public List<Method> getAnnotatedMethods() {
        return this.annotatedMethods;
    }

    public List<AnnotationSetRefList> getAnnotatedParameters() {
        return this.annotatedParameters;
    }

    public int getNbAnnotatedFields() {
        return this.annotatedFields.size();
    }

    public int getNbAnnotatedMethods() {
        return this.annotatedMethods.size();
    }

    public int getNbAnnotatedParameters() {
        return this.annotatedParameters.size();
    }

    public void addAnnotatedField(Field field) {
        this.annotatedFields.add(field);
        this.hashcode = -1;
    }

    public void addAnnotatedMethods(Method method) {
        this.annotatedMethods.add(method);
        this.hashcode = -1;
    }

    public void addAnnotatedParameter(AnnotationSetRefList parameter) {
        this.annotatedParameters.add(parameter);
        this.hashcode = -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof AnnotationDirectoryItem) {
            AnnotationDirectoryItem adi = (AnnotationDirectoryItem)obj;
            result = this.classAnnotationSetItems.equals(adi.classAnnotationSetItems) && this.annotatedFields.equals(adi.annotatedFields) && this.annotatedMethods.equals(adi.annotatedMethods) && this.annotatedParameters.equals(adi.annotatedParameters);
        }
        return result;
    }

    public int hashCode() {
        if (this.hashcode != -1) {
            return this.hashcode;
        }
        int result = this.classAnnotationSetItems.hashCode();
        for (Field field : this.annotatedFields) {
            result += field.hashCode();
        }
        for (Method method : this.annotatedMethods) {
            result += method.hashCode();
        }
        for (AnnotationSetRefList parameter : this.annotatedParameters) {
            result += parameter.hashCode();
        }
        this.hashcode = result;
        return result;
    }
}

