/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureCommon;

import java.util.ArrayList;
import org.ow2.asmdex.instruction.Instruction;

public class Label {
    static final int RESOLVED = 2;
    public Object info;
    int status;
    int line = 0;
    int position = 0;
    private ArrayList<Instruction> referringInstructions = new ArrayList();

    public int getOffset() {
        if ((this.status & 2) == 0) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.position;
    }

    public void setOffset(int offset) {
        this.position = offset;
        this.status |= 2;
    }

    public boolean isResolved() {
        return (this.status & 2) != 0;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public ArrayList<Instruction> getReferringInstructions() {
        return this.referringInstructions;
    }

    public void addReferringInstruction(Instruction instruction) {
        this.referringInstructions.add(instruction);
    }

    public int hashCode() {
        return this.position;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Label) {
            Label label = (Label)obj;
            result = (this.status & 2) > 0 && (label.status & 2) > 0 && this.position == label.position;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(76 + System.identityHashCode(this));
        if ((this.status & 2) > 0) {
            result.append(" (offset 0x" + Integer.toHexString(this.position) + ", line " + this.line + ")");
        }
        return result.toString();
    }
}

