/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IOffsetInstruction;
import org.ow2.asmdex.instruction.IOneRegisterInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat21T
extends Instruction
implements IOneRegisterInstruction,
IOffsetInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int offset;
    private int instructionOffset;
    private Label label;

    @Override
    public Label getLabel() {
        return this.label;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getOffset(IDalvikValueReader reader, int opcode) {
        int readOffset = reader.sshort() * 2;
        return reader.getPos() - 4 + readOffset;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat21T(int opcode, Label label, int registerA, int instructionOffset) {
        super(opcode);
        this.label = label;
        this.registerA = registerA;
        this.instructionOffset = instructionOffset;
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public int getInstructionOffset() {
        return this.instructionOffset;
    }

    @Override
    public void setInstructionOffset(int instructionOffset) {
        this.instructionOffset = instructionOffset;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        int firstShort = ((this.registerA & 0xFF) << 8) + this.opcodeByte;
        int secondShort = (this.label.getOffset() - this.instructionOffset) / 2;
        out.putShort(firstShort);
        out.putShort(secondShort);
    }
}

