/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.DebugInstruction;
import org.ow2.asmdex.instruction.IDebugLocalVariableStartInstruction;
import org.ow2.asmdex.instruction.IDebugRegisterInstruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class DebugInstructionStartLocal
extends DebugInstruction
implements IDebugLocalVariableStartInstruction,
IDebugRegisterInstruction {
    protected int register;
    protected String name;
    protected String type;
    protected Label start;

    public DebugInstructionStartLocal(int register, String name, String type, Label start) {
        this.register = register;
        this.name = name;
        this.type = type;
        this.start = start;
    }

    @Override
    public int getRegister() {
        return this.register;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public int getOpcode() {
        return 3;
    }

    @Override
    public Label getLabel() {
        return this.start;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putByte(3);
        out.putUleb128(this.register);
        out.putUleb128p1(constantPool.getStringIndex(this.name));
        out.putUleb128p1(constantPool.getTypeIndex(this.type));
    }
}

