/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.encodedValue;

import java.util.ArrayList;
import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureWriter.AnnotationElement;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueAnnotation
extends EncodedValue {
    private int type = 29;
    private ArrayList<AnnotationElement> annotationElements = new ArrayList();
    private String annotationType;

    public EncodedValueAnnotation(String annotationType) {
        this.annotationType = annotationType;
    }

    public EncodedValueAnnotation(Object annotationType) {
        this.annotationType = (String)annotationType;
    }

    public void addAnnotationElement(AnnotationElement annotationElement) {
        this.annotationElements.add(annotationElement);
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        ByteVector bv = new ByteVector();
        bv.putByte(29);
        bv.putUleb128(constantPool.getTypeIndex(this.annotationType));
        bv.putUleb128(this.annotationElements.size());
        for (AnnotationElement annotationElement : this.annotationElements) {
            bv.putByteArray(annotationElement.encode(constantPool));
        }
        return bv.getData();
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public ArrayList<AnnotationElement> getAnnotationElements() {
        return this.annotationElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueAnnotation) {
            EncodedValueAnnotation encodedValue = (EncodedValueAnnotation)o;
            boolean bl = result = this.type == encodedValue.type && this.annotationType.equals(encodedValue.annotationType);
            if (result) {
                result = this.annotationElements.equals(encodedValue.annotationElements);
            }
        }
        return result;
    }

    public int hashCode() {
        int result = this.type + this.annotationType.hashCode();
        for (AnnotationElement annotationElement : this.annotationElements) {
            result += annotationElement.hashCode();
        }
        return result;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueAnnotation ev = (EncodedValueAnnotation)encodedValue;
        int result = this.annotationType.compareTo(ev.annotationType);
        if (result == 0) {
            int size2;
            int i = 0;
            int size1 = this.annotationElements.size();
            int size = size1 < (size2 = ev.annotationElements.size()) ? size1 : size2;
            while (result == 0 && i < size) {
                result = this.annotationElements.get(i).compareTo(ev.annotationElements.get(i));
                ++i;
            }
            if (result == 0) {
                result = size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
            }
        }
        return result;
    }
}

