/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.junit.Assert;

public class TestUtil {
    public static final String PATH_FOLDER_TEST = "test/";
    public static final String PATH_FOLDER_CONFORM = "conform/";
    public static final String PATH_FOLDER_TESTCASE = "test/case/";
    public static final String FILENAME_TESTDUMP_NO_EXTENSION = "TestDump";
    public static final String FILENAME_TESTDUMP = "TestDump.java";
    public static final String FULL_TEST_SUBFOLDER = "full/";
    public static final String SKIP_LINE_NUMBERS_TEST_SUBFOLDER = "skipLineNumbers/";
    public static final String FILENAME_HELLO_WORLD_DEX = "helloWorld.dex";
    public static final String FILENAME_ANNOTATION_TESTS_DEX = "annotationTests.dex";
    public static final String FILENAME_API_DEMOS_DEX = "apiDemos.dex";
    public static final String FILENAME_EXCEPTION_TESTS_DEMOS_DEX = "exceptionTests.dex";
    public static final String PATH_AND_FILENAME_HELLO_WORLD_DEX = "test/case/full/helloWorld.dex";
    public static final String PATH_AND_FILENAME_ANNOTATION_TESTS_DEX = "test/case/full/annotationTests.dex";
    public static final String PATH_AND_FILENAME_API_DEMOS_DEX = "test/case/skipLineNumbers/apiDemos.dex";
    public static final String PATH_AND_FILENAME_EXCEPTION_TESTS_DEX = "test/case/full/exceptionTests.dex";
    public static final String FILENAME_GENERATED_DEX = "generated.dex";
    public static final String FILENAME_ORIGINAL_DEX = "original.dex";
    public static final String FILENAME_ADAPTED_DEX = "adapted.dex";
    public static final String FILENAME_EXPECTED_DEX = "expected.dex";
    public static final String TEMP_SUBFOLDER_GENERATED = "generated/";
    public static final String TEMP_SUBFOLDER_EXPECTED = "expected/";
    public static final String TEMP_FOLDER_ROOT = "tmpAsmDexTest/";
    public static final String TEMP_FOLDER_GENERATED = "tmpAsmDexTest/generated/";
    public static final String TEMP_FOLDER_EXPECTED = "tmpAsmDexTest/expected/";
    private static final String BAKSMALI_JAR = "lib/baksmali.jar";
    private static final String DEBUG_LINE_MNEMONIC = ".line";
    private static final String SMALI_EXTENSION = ".smali";

    public static void removeTemporaryFolder() {
        String tempFolder = TEMP_FOLDER_ROOT.substring(0, TEMP_FOLDER_ROOT.length() - 1);
        File currentDir = new File("./");
        boolean found = false;
        File[] files = currentDir.listFiles();
        int size = files.length;
        int i = 0;
        while (!found && i < size) {
            File innerFile = files[i];
            String innerFileName = innerFile.getName();
            if (innerFileName.contains(tempFolder)) {
                TestUtil.deleteFileOrDirectory(innerFile);
                found = true;
                continue;
            }
            ++i;
        }
    }

    private static boolean deleteFileOrDirectory(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            File[] fileArray = fileOrDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File innerFile = fileArray[n2];
                if (!TestUtil.deleteFileOrDirectory(innerFile)) {
                    return false;
                }
                ++n2;
            }
        }
        return fileOrDirectory.delete();
    }

    public static int countFiles(File folderOrFile, String extension) {
        int count = 0;
        if (folderOrFile.isDirectory()) {
            File[] fileArray = folderOrFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File innerFile = fileArray[n2];
                count += TestUtil.countFiles(innerFile, extension);
                ++n2;
            }
        } else if (extension == null || folderOrFile.getName().endsWith(extension)) {
            ++count;
        }
        return count;
    }

    public static File createFileFromByteArray(byte[] bytes, String pathAndFileName) throws IOException {
        File outputFile = new File(pathAndFileName);
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(outputFile);
                outputStream.write(bytes);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return outputFile;
    }

    public static byte[] readFile(File file) {
        byte[] bytes;
        block21: {
            bytes = null;
            ByteArrayOutputStream buffer = null;
            FileInputStream inputStream = null;
            try {
                try {
                    int nbBytesRead;
                    inputStream = new FileInputStream(file);
                    buffer = new ByteArrayOutputStream();
                    byte[] dataRead = new byte[16384];
                    while ((nbBytesRead = ((InputStream)inputStream).read(dataRead)) != -1) {
                        buffer.write(dataRead, 0, nbBytesRead);
                    }
                    buffer.flush();
                    bytes = buffer.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block21;
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bytes;
    }

    public static byte[] readFile(String fileName) throws IOException {
        return TestUtil.readFile(new File(fileName));
    }

    public static long readUInt(byte[] bytes, int offset) {
        return (long)(bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16) | (long)(bytes[offset + 3] & 0xFF) << 24;
    }

    public static int readUShort(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static boolean testSmaliFoldersEquality(String folderName1, String folderName2, boolean skipLineNumbers) {
        File folder1 = new File(folderName1);
        File folder2 = new File(folderName2);
        int nbSmaliFiles1 = TestUtil.countFiles(folder1, SMALI_EXTENSION);
        int nbSmaliFiles2 = TestUtil.countFiles(folder2, SMALI_EXTENSION);
        Assert.assertEquals((String)"Not the same amount of generated .smali files.", (long)nbSmaliFiles1, (long)nbSmaliFiles2);
        return TestUtil.testSmaliFoldersEquality(folder1, folder2, skipLineNumbers);
    }

    public static boolean testSmaliFoldersEquality(File folder1, File folder2, boolean skipLineNumbers) {
        boolean result = true;
        int i = 0;
        File[] files = folder1.listFiles();
        int nbFiles = files.length;
        while (result && i < nbFiles) {
            File innerFile = files[i];
            if (innerFile.isDirectory()) {
                String path1 = String.valueOf(folder1.getPath()) + "/";
                String path2 = String.valueOf(folder2.getPath()) + "/";
                String innerFileString = innerFile.getPath();
                innerFileString = innerFileString.substring(path1.length());
                File secondFolder = new File(String.valueOf(path2) + innerFileString);
                result = TestUtil.testSmaliFoldersEquality(innerFile, secondFolder, skipLineNumbers);
                Assert.assertTrue((String)"Generated .smali files differ.", (boolean)result);
            } else {
                File secondFile = new File(String.valueOf(folder2.getPath()) + '/' + innerFile.getName());
                result = TestUtil.compareSmaliFiles(innerFile, secondFile, skipLineNumbers);
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean compareSmaliFiles(File file1, File file2, boolean skipLineNumbers) {
        reader1 = null;
        reader2 = null;
        equalLines = true;
        try {
            try {
                reader1 = new BufferedReader(new FileReader(file1));
                reader2 = new BufferedReader(new FileReader(file2));
                ** GOTO lbl25
                {
                    line1 = reader1.readLine();
                    do {
                        if (skipLineNumbers && line1 != null && line1.contains(".line")) continue block23;
                        line2 = reader2.readLine();
                        if (line2 != null) ** GOTO lbl17
                        equalLines = false;
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            line2 = reader2.readLine();
lbl17:
                            // 2 sources

                            ** while (skipLineNumbers && line2 != null && line2.contains((CharSequence)".line"))
                        }
lbl18:
                        // 1 sources

                        if (line1 == null) {
                            if (line2 == null) {
                                v0 = true;
                                continue;
                            }
                            v0 = false;
                            continue;
                        }
                        v0 = equalLines = line1.equals(line2);
lbl25:
                        // 5 sources

                    } while (equalLines && (line1 = reader1.readLine()) != null);
                }
                line1 = reader1.readLine();
                if (equalLines && line1 == null) {
                    line2 = reader2.readLine();
                    equalLines = line2 == null;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (reader1 != null) {
                    try {
                        reader1.close();
                    }
                    catch (IOException var9_10) {
                        // empty catch block
                    }
                }
                if (reader2 != null) {
                    try {
                        reader2.close();
                    }
                    catch (IOException var9_11) {}
                }
            }
            catch (IOException e) {
                block35: {
                    e.printStackTrace();
                    if (reader1 == null) break block35;
                    try {
                        reader1.close();
                    }
                    catch (IOException var9_12) {
                        // empty catch block
                    }
                }
                if (reader2 != null) {
                    try {
                        reader2.close();
                    }
                    catch (IOException var9_13) {}
                }
            }
        }
        finally {
            if (reader1 != null) {
                try {
                    reader1.close();
                }
                catch (IOException var9_16) {}
            }
            if (reader2 != null) {
                try {
                    reader2.close();
                }
                catch (IOException var9_17) {}
            }
        }
        return equalLines;
    }

    public static void createTemporaryFolder() {
        TestUtil.createFolder(TEMP_FOLDER_ROOT);
    }

    public static void createTemporaryFolders(String[] folders) {
        TestUtil.createTemporaryFolder();
        StringBuffer totalFolder = new StringBuffer(TEMP_FOLDER_ROOT);
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            totalFolder.append(folder);
            TestUtil.createFolder(totalFolder.toString());
            ++n2;
        }
    }

    private static void createFolder(String folder) {
        File tempFolder = new File(folder);
        if (!tempFolder.exists() && !tempFolder.mkdir()) {
            try {
                throw new IOException("Unable to create the temporary folder: " + folder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getStringFromStream(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
        return ((Object)writer).toString();
    }

    public static boolean testMapDexFiles(File dexFile1, File dexFile2) throws IOException {
        int[][] map1 = TestUtil.getMap(dexFile1);
        int[][] map2 = TestUtil.getMap(dexFile2);
        return Arrays.deepEquals((Object[])map1, (Object[])map2);
    }

    public static int[][] getMap(File dexFile) throws IOException {
        byte[] dataFile = TestUtil.readFile(dexFile);
        if (dataFile == null) {
            return null;
        }
        int mapOffset = (int)TestUtil.readUInt(dataFile, 52);
        int nbElements = (int)TestUtil.readUInt(dataFile, mapOffset);
        int currentOffset = mapOffset + 4;
        int[][] map = new int[nbElements][];
        int i = 0;
        while (i < nbElements) {
            map[i] = new int[2];
            map[i][0] = TestUtil.readUShort(dataFile, currentOffset);
            map[i][1] = TestUtil.readUShort(dataFile, currentOffset += 4);
            currentOffset += 8;
            ++i;
        }
        return map;
    }

    public static void baksmali(String[] args) throws IOException {
        File file = new File(BAKSMALI_JAR);
        try {
            URL url = new URL("jar:" + file.toURI().toString() + "!/");
            URLClassLoader jfl = new URLClassLoader(new URL[]{url});
            Class<?> baksmaliClass = jfl.loadClass("org.jf.baksmali.main");
            Method meth = baksmaliClass.getMethod("main", String[].class);
            meth.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new IOException("Cannot launch baksmali", e);
        }
    }
}

