/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.hex.util;

public enum Checksum {
    ONES_COMPLEMENT,
    TWOS_COMPLEMENT;


    public byte calculate(byte ... byArray) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("Values cannot be null!");
        }
        if (byArray.length < 2) {
            throw new IllegalArgumentException("Should have at least two values to calculate the checksum!");
        }
        int n = 0;
        for (byte by : byArray) {
            n += by;
        }
        switch (this) {
            case ONES_COMPLEMENT: {
                return (byte)(~n);
            }
            case TWOS_COMPLEMENT: {
                return (byte)(~n + 1);
            }
        }
        throw new IllegalArgumentException("Unhandled checksum!");
    }

    public int calculate(int ... nArray) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("Values cannot be null!");
        }
        if (nArray.length < 0) {
            throw new IllegalArgumentException("Should have at least one values to calculate the checksum!");
        }
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        switch (this) {
            case ONES_COMPLEMENT: {
                return ~n & 0xFFFF;
            }
            case TWOS_COMPLEMENT: {
                return ~n + 1 & 0xFFFF;
            }
        }
        throw new IllegalArgumentException("Unhandled checksum!");
    }
}

