/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

public final class ObjectFileType {
    public static final ObjectFileType NONE = new ObjectFileType(0, "no file type");
    public static final ObjectFileType REL = new ObjectFileType(1, "relocatable");
    public static final ObjectFileType EXEC = new ObjectFileType(2, "executable");
    public static final ObjectFileType DYN = new ObjectFileType(3, "shared object");
    public static final ObjectFileType CORE = new ObjectFileType(4, "core file");
    private static final ObjectFileType[] VALUES = new ObjectFileType[]{NONE, REL, EXEC, DYN, CORE};
    private static final int ET_LOOS = 65024;
    private static final int ET_HIOS = 65279;
    private static final int ET_LOPROC = 65280;
    private static final int ET_HIPROC = 65535;
    private final int type;
    private final String desc;

    public static ObjectFileType valueOf(int n) {
        for (ObjectFileType objectFileType : VALUES) {
            if (objectFileType.type != n) continue;
            return objectFileType;
        }
        if (n >= 65024 && n <= 65279) {
            return new ObjectFileType(n, "OS-specific object file");
        }
        if (n >= 65280 && n <= 65535) {
            return new ObjectFileType(n, "Processor-specific object file");
        }
        throw new IllegalArgumentException("Unknown object file type!");
    }

    private ObjectFileType(int n, String string) {
        this.type = n;
        this.desc = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObjectFileType objectFileType = (ObjectFileType)object;
        return this.type == objectFileType.type;
    }

    public int hashCode() {
        return 37 + this.type;
    }

    public String name() {
        return this.desc;
    }

    public int ordinal() {
        return this.type;
    }

    public String toString() {
        return this.desc;
    }
}

