/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.updater.utils;

import com.google.classyshark.updater.models.Release;
import com.google.classyshark.updater.utils.NamingUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class FileUtils {
    public static File downloadFileFrom(Release release) throws IOException {
        File file = new File(NamingUtils.buildNameFrom(release));
        if (!file.exists()) {
            FileUtils.obtainNewJarFrom(release, file);
        }
        return file;
    }

    private static void obtainNewJarFrom(Release release, File file) throws IOException {
        URL uRL = new URL(release.getDownloadURL());
        ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        fileOutputStream.close();
    }

    private void overwriteOld(File file) throws IOException {
        Path path = new File(NamingUtils.extractCurrentPath() + File.separator + "javax.script.filename").toPath();
        Files.copy(file.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
        file.delete();
    }
}

