/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.updater.models;

import com.google.classyshark.updater.models.ReleaseDownloadData;
import com.google.gson.annotations.SerializedName;

public class Release {
    private final String name;
    @SerializedName(value="prerelease")
    private final boolean preRelease;
    private final String body;
    private final ReleaseDownloadData[] assets;
    @SerializedName(value="created_at")
    private final String createdAt;

    private Release(String string, boolean bl, String string2, ReleaseDownloadData[] releaseDownloadDataArray, String string3) {
        this.name = string;
        this.preRelease = bl;
        this.body = string2;
        this.assets = releaseDownloadDataArray;
        this.createdAt = string3;
    }

    public Release() {
        this(String.format("%d.%d", 7, 1), false, "", null, "");
    }

    public boolean equals(Object object) {
        if (!(object instanceof Release)) {
            return false;
        }
        return this.name.equals(((Release)object).name);
    }

    private int getMajorVersion() {
        return this.getVersionField(0);
    }

    private int getVersionField(int n) {
        String string = this.name.split("\\s")[0];
        return Integer.parseInt(string.split("\\.")[n]);
    }

    private int getMinorVersion() {
        return this.getVersionField(1);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "REL:\t" + this.name + "\nCHANGELOG:\n" + this.body;
    }

    public boolean isNewerThan(Release release) {
        return this.getMajorVersion() > release.getMajorVersion() || this.getMajorVersion() == release.getMajorVersion() && this.getMinorVersion() > release.getMinorVersion();
    }

    public String getDownloadURL() {
        if (this.assets != null && this.assets.length > 0) {
            return this.assets[0].getURL();
        }
        return null;
    }

    public String getReleaseName() {
        return this.name;
    }

    public boolean isPreRelease() {
        return this.preRelease;
    }

    public String getChangelog() {
        return this.body;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }
}

