/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.java.dex;

import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.contentreader.dex.DexReader;
import com.google.classyshark.silverghost.io.SherlockHash;
import com.google.classyshark.silverghost.translator.apk.dashboard.ApkDashboard;
import com.google.classyshark.silverghost.translator.apk.dashboard.DynamicSymbolsInspector;
import com.google.classyshark.silverghost.translator.dex.DexInfoTranslator;
import com.google.classyshark.silverghost.translator.elf.ElfTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.lxtreme.binutils.elf.Elf;

public class MultidexReader {
    private MultidexReader() {
    }

    public static void fillApkDashboard(File file, ApkDashboard apkDashboard) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            block2: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                List<String> list;
                Object object2;
                if (zipEntry.getName().endsWith(".dex")) {
                    object2 = "ANALYZER_classes";
                    int n = Character.getNumericValue(zipEntry.getName().charAt(zipEntry.getName().length() - 5));
                    if (n != 28) {
                        object2 = "ANALYZER_classes" + n;
                    } else {
                        n = 0;
                    }
                    list = "dex";
                    object = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, (String)object2, (String)((Object)list));
                    apkDashboard.classesDexEntries.add(ApkDashboard.fillAnalysisPerClassesDexIndex(n, (File)object));
                    continue;
                }
                if (zipEntry.getName().endsWith("jar") || zipEntry.getName().endsWith("zip")) {
                    object2 = "inner_zip";
                    String string = "zip";
                    list = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, (String)object2, string);
                    object = new ZipInputStream(new FileInputStream((File)((Object)list)));
                    while (true) {
                        ZipEntry zipEntry2;
                        if ((zipEntry2 = ((ZipInputStream)object).getNextEntry()) == null) {
                            ((ZipInputStream)object).close();
                            continue block2;
                        }
                        if (!zipEntry2.getName().endsWith(".dex")) continue;
                        object2 = "inner_zip_classes";
                        string = "dex";
                        File file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, (ZipInputStream)object, (String)object2, string);
                        apkDashboard.customClassesDexEntries.add(ApkDashboard.fillAnalysisPerClassesDexIndex(99, file2));
                    }
                }
                if (!zipEntry.getName().startsWith("lib")) continue;
                object2 = ElfTranslator.extractElf(zipEntry.getName(), file);
                Elf elf = new Elf((File)object2);
                list = elf.getSharedDependencies();
                for (String string : list) {
                    apkDashboard.nativeDependencies.add(string);
                }
                object = new DynamicSymbolsInspector(elf);
                if (((DynamicSymbolsInspector)object).areErrors()) {
                    apkDashboard.nativeErrors.add(zipEntry.getName() + " " + ((DynamicSymbolsInspector)object).getErrors());
                }
                apkDashboard.nativeLibs.add(zipEntry.getName() + "\n");
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void readClassNamesFromMultidex(File file, List<String> list, List<ContentReader.Component> list2) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry zipEntry2;
                Object object;
                File file2;
                String string;
                String string2;
                if (zipEntry.getName().endsWith(".xml")) {
                    list.add(zipEntry.getName());
                }
                if (zipEntry.getName().endsWith(".dex")) {
                    string2 = zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf("."));
                    string = "dex";
                    file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string2, string);
                    object = DexReader.readClassNamesFromDex(file2);
                    list.add(string2 + ".dex");
                    list.addAll((Collection<String>)object);
                }
                if (zipEntry.getName().startsWith("lib")) {
                    list2.add(new ContentReader.Component(zipEntry.getName(), ContentReader.ARCHIVE_COMPONENT.NATIVE_LIBRARY));
                }
                if (!zipEntry.getName().endsWith("jar") && !zipEntry.getName().endsWith("zip")) continue;
                string2 = "inner_zip";
                string = "zip";
                file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string2, string);
                object = new ZipInputStream(new FileInputStream(file2));
                while ((zipEntry2 = ((ZipInputStream)object).getNextEntry()) != null) {
                    if (!zipEntry2.getName().endsWith(".dex")) continue;
                    string2 = "inner_zip_classes";
                    string = "dex";
                    File file3 = SherlockHash.INSTANCE.getFileFromZipStream(file, (ZipInputStream)object, string2, string);
                    List<String> list3 = DexReader.readClassNamesFromDex(file3);
                    String string3 = zipEntry.getName() + "###" + zipEntry2.getName();
                    list.add(string3);
                    list.addAll(list3);
                }
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static File extractClassesDexWithClass(String string, File file) {
        File file2 = new File("classes.dex");
        try {
            String string2;
            String string3;
            Object object;
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            block2: while (!((zipEntry = zipInputStream.getNextEntry()) == null || zipEntry.getName().endsWith(".dex") && (object = DexReader.readClassNamesFromDex(file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string3 = zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf(".")), string2 = "dex"))).contains(string))) {
                List<String> list;
                ZipEntry zipEntry2;
                if (!zipEntry.getName().endsWith("jar") && !zipEntry.getName().endsWith("zip")) continue;
                string3 = "inner_zip";
                string2 = "zip";
                object = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string3, string2);
                ZipInputStream zipInputStream2 = new ZipInputStream(new FileInputStream((File)object));
                do {
                    if ((zipEntry2 = zipInputStream2.getNextEntry()) != null) continue;
                    zipInputStream2.close();
                    continue block2;
                } while (!zipEntry2.getName().endsWith(".dex") || !(list = DexReader.readClassNamesFromDex(file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream2, string3 = "inner_zip_classes", string2 = "dex"))).contains(string));
                zipInputStream2.close();
                zipInputStream.close();
                return file2;
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file2;
    }

    public static File extractClassesDex(String string, File file, DexInfoTranslator dexInfoTranslator) {
        if (file.getName().endsWith(".dex")) {
            return file;
        }
        File file2 = new File("classes.dex");
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            block2: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                String string2;
                String string3;
                if (zipEntry.getName().endsWith(".dex")) {
                    string3 = zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf("."));
                    string2 = "dex";
                    object = string3 + ".dex";
                    file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string3, string2);
                    if (string.equals(object)) {
                        if (string.equals("classes.dex")) {
                            dexInfoTranslator.setIndex(0);
                            break;
                        }
                        dexInfoTranslator.setIndex(Integer.parseInt(string3.substring(string3.length() - 1)));
                        break;
                    }
                }
                if (!zipEntry.getName().endsWith("jar") && !zipEntry.getName().endsWith("zip")) continue;
                string3 = "inner_zip";
                string2 = "zip";
                object = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream, string3, string2);
                ZipInputStream zipInputStream2 = new ZipInputStream(new FileInputStream((File)object));
                while (true) {
                    ZipEntry zipEntry2;
                    if ((zipEntry2 = zipInputStream2.getNextEntry()) == null) {
                        zipInputStream2.close();
                        continue block2;
                    }
                    if (!zipEntry2.getName().endsWith(".dex")) continue;
                    string3 = "inner_zip_classes";
                    string2 = "dex";
                    file2 = SherlockHash.INSTANCE.getFileFromZipStream(file, zipInputStream2, string3, string2);
                    if (string.startsWith(zipEntry.getName())) break;
                }
                dexInfoTranslator.setIndex(99);
                zipInputStream.close();
                return file2;
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file2;
    }
}

