/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.java;

import com.google.classyshark.silverghost.contentreader.dex.DexlibLoader;
import com.google.classyshark.silverghost.translator.java.MetaObject;
import com.google.classyshark.silverghost.translator.java.clazz.asm.MetaObjectAsmClass;
import com.google.classyshark.silverghost.translator.java.clazz.reflect.ClassUtils;
import com.google.classyshark.silverghost.translator.java.clazz.reflect.MetaObjectClass;
import com.google.classyshark.silverghost.translator.java.dex.DexlibAdapter;
import com.google.classyshark.silverghost.translator.java.dex.MetaObjectDex;
import com.google.classyshark.silverghost.translator.java.dex.MultidexReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;

public class MetaObjectFactory {
    private MetaObjectFactory() {
    }

    public static MetaObject buildMetaObject(String string, File file) {
        MetaObject metaObject = file.getName().toLowerCase().endsWith(".jar") ? MetaObjectFactory.getMetaObjectFromJar(string, file) : (file.getName().toLowerCase().endsWith(".class") ? MetaObjectFactory.getMetaObjectFromClass(file) : (file.getName().toLowerCase().endsWith(".dex") ? MetaObjectFactory.getMetaObjectFromDex(string, file) : (file.getName().toLowerCase().endsWith(".apk") ? MetaObjectFactory.getMetaObjectFromApk(string, file) : (file.getName().toLowerCase().endsWith(".aar") ? MetaObjectFactory.getMetaObjectFromAar(string, file) : new MetaObjectClass(Exception.class)))));
        return metaObject;
    }

    private static MetaObject getMetaObjectFromAar(String string, File file) {
        try {
            ZipEntry zipEntry;
            File file2 = File.createTempFile("classes", "jar");
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (!zipEntry.getName().endsWith(".jar")) continue;
                byte[] byArray = new byte[8192];
                while ((n = zipInputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                MetaObject metaObject = MetaObjectFactory.getMetaObjectFromJar(string, file2);
                return metaObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new MetaObjectClass(Exception.class);
    }

    private static MetaObject getMetaObjectFromJar(String string, File file) {
        Class clazz;
        MetaObject metaObject = null;
        try {
            clazz = ClassUtils.loadClassFromJar(file.getPath(), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Exception.class;
        }
        catch (MalformedURLException malformedURLException) {
            clazz = Exception.class;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            metaObject = new MetaObjectAsmClass(string, file);
            return metaObject;
        }
        metaObject = MetaObjectFactory.verifyLoadedClassAndBuildASMFallback(string, file, metaObject, clazz);
        return metaObject;
    }

    private static MetaObject verifyLoadedClassAndBuildASMFallback(String string, File file, MetaObject metaObject, Class clazz) {
        try {
            if (clazz.getFields() != null) {
                metaObject = new MetaObjectClass(clazz);
            }
            if (clazz.getMethods() != null) {
                metaObject = new MetaObjectClass(clazz);
            }
            if (clazz.getConstructors() != null) {
                metaObject = new MetaObjectClass(clazz);
            }
            if (clazz.getDeclaredMethods() != null) {
                metaObject = new MetaObjectClass(clazz);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            metaObject = new MetaObjectAsmClass(string, file);
        }
        return metaObject;
    }

    private static MetaObject getMetaObjectFromApk(String string, File file) {
        MetaObject metaObject;
        try {
            File file2 = MultidexReader.extractClassesDexWithClass(string, file);
            metaObject = MetaObjectFactory.getMetaObjectFromDex(string, file2);
        }
        catch (Exception exception) {
            metaObject = new MetaObjectClass(Exception.class);
        }
        return metaObject;
    }

    private static MetaObject getMetaObjectFromDex(String string, File file) {
        MetaObject metaObject;
        try {
            DexFile dexFile = DexlibLoader.loadDexFile(file);
            ClassDef classDef = DexlibAdapter.getClassDefByName(string, dexFile);
            metaObject = new MetaObjectDex(classDef);
        }
        catch (Exception exception) {
            metaObject = new MetaObjectClass(Exception.class);
        }
        return metaObject;
    }

    private static MetaObject getMetaObjectFromClass(File file) {
        MetaObjectAsmClass metaObjectAsmClass = new MetaObjectAsmClass(file);
        return metaObjectAsmClass;
    }
}

