/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.contentreader.jar;

import com.google.classyshark.silverghost.contentreader.BinaryContentReader;
import com.google.classyshark.silverghost.contentreader.ContentReader;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JarReader
implements BinaryContentReader {
    private File binaryArchive;
    private List<String> allClassNames = new ArrayList<String>();
    private List<ContentReader.Component> components = new ArrayList<ContentReader.Component>();

    public JarReader(File file) {
        this.binaryArchive = file;
    }

    @Override
    public void read() {
        try {
            this.allClassNames = JarReader.readClassNamesFromJar(this.binaryArchive, this.components);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Collections.sort(this.allClassNames);
    }

    @Override
    public List<String> getClassNames() {
        return this.allClassNames;
    }

    @Override
    public List<ContentReader.Component> getComponents() {
        return this.components;
    }

    public static List<String> readClassNamesFromJar(File file, List<ContentReader.Component> list) throws Exception {
        JarEntry jarEntry;
        ArrayList<String> arrayList = new ArrayList<String>();
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            String string = jarEntry.getName();
            if (string.endsWith(".class")) {
                String string2 = string.replaceAll("/", "\\.");
                string2 = string2.substring(0, string2.lastIndexOf(46));
                arrayList.add(string2);
            }
            if (!jarEntry.getName().startsWith("resources") || !jarEntry.getName().startsWith(".so")) continue;
            list.add(new ContentReader.Component(jarEntry.getName(), ContentReader.ARCHIVE_COMPONENT.NATIVE_LIBRARY));
        }
        if (arrayList.isEmpty()) {
            throw new Exception();
        }
        return arrayList;
    }
}

