/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.displayarea;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.FileTransferHandler;
import com.google.classyshark.gui.panel.ViewerController;
import com.google.classyshark.gui.panel.displayarea.BatchDocument;
import com.google.classyshark.gui.panel.displayarea.IDisplayArea;
import com.google.classyshark.gui.panel.displayarea.doodles.Doodle;
import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.java.JavaTranslator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;

public class DisplayArea
implements IDisplayArea {
    private final JTextPane jTextPane;
    private Style style;
    private final Theme theme = GuiMode.getTheme();
    private DisplayDataState displayDataState;

    public DisplayArea(final ViewerController viewerController) {
        this.jTextPane = new JTextPane();
        this.theme.applyTo(this.jTextPane);
        this.jTextPane.setDragEnabled(true);
        this.jTextPane.setTransferHandler(new FileTransferHandler(viewerController));
        this.jTextPane.setEditable(false);
        this.jTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (DisplayArea.this.displayDataState == DisplayDataState.SHARKEY) {
                    return;
                }
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (mouseEvent.getClickCount() != 2) {
                    return;
                }
                int n = DisplayArea.this.jTextPane.viewToModel(mouseEvent.getPoint());
                try {
                    int n2 = Utilities.getRowStart(DisplayArea.this.jTextPane, n);
                    int n3 = Utilities.getRowEnd(DisplayArea.this.jTextPane, n);
                    String string = DisplayArea.this.jTextPane.getText().substring(n2, n3);
                    System.out.println(string);
                    if (DisplayArea.this.displayDataState == DisplayDataState.CLASSES_LIST || string.endsWith(".dex")) {
                        viewerController.onSelectedClassName(string);
                    } else if (DisplayArea.this.displayDataState == DisplayDataState.INSIDE_CLASS) {
                        if (string.contains("import")) {
                            viewerController.onSelectedImportFromMouseClick(this.getClassNameFromImportStatement(string));
                        } else {
                            n2 = Utilities.getWordStart(DisplayArea.this.jTextPane, n);
                            n3 = Utilities.getWordEnd(DisplayArea.this.jTextPane, n);
                            String string2 = DisplayArea.this.jTextPane.getText().substring(n2, n3);
                            viewerController.onSelectedTypeClassFromMouseClick(string2);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }

            public String getClassNameFromImportStatement(String string) {
                int n = string.indexOf("import ") + "import ".length();
                String string2 = string.trim().substring(n, string.indexOf(";"));
                return string2;
            }
        });
        this.jTextPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                int n = toolkit.getMenuShortcutKeyMask();
                if (keyEvent.getKeyChar() == 'c' && (keyEvent.getModifiers() & n) == n) {
                    String string = DisplayArea.this.jTextPane.getSelectedText();
                    if (string == null) {
                        string = DisplayArea.this.jTextPane.getText();
                    }
                    toolkit.getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.displaySharkey();
    }

    @Override
    public Component onAddComponentToPane() {
        return this.jTextPane;
    }

    @Override
    public void displaySearchResults(List<String> list, List<Translator.ELEMENT> list2, String string) {
        this.displayDataState = DisplayDataState.CLASSES_LIST;
        StyleConstants.setFontSize(this.style, 18);
        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
        this.clearText();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        this.jTextPane.setDocument(defaultStyledDocument);
        StyleConstants.setFontSize(this.style, 18);
        StyleConstants.setBackground(this.style, this.theme.getBackgroundColor());
        this.fillTokensToDoc(list2, defaultStyledDocument, true);
        StyleConstants.setFontSize(this.style, 18);
        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
        StyleConstants.setBackground(this.style, this.theme.getBackgroundColor());
        int n = 50;
        if (list.size() < n) {
            n = list.size();
        }
        for (int i = 0; i < n; ++i) {
            try {
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), list.get(i) + "\n", this.style);
                continue;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.jTextPane.setDocument(defaultStyledDocument);
        this.jTextPane.setCaretPosition(1);
    }

    @Override
    public void displayClassNames(List<String> list, String string) {
        StyleConstants.setFontSize(this.style, 18);
        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
        StyleConstants.setBackground(this.style, this.theme.getBackgroundColor());
        if (list.size() > 50) {
            this.displayAllClassesNames(list);
            return;
        }
        this.displayDataState = DisplayDataState.CLASSES_LIST;
        this.clearText();
        String string2 = "";
        String string3 = "";
        Document document = this.jTextPane.getDocument();
        for (String string4 : list) {
            String string5;
            int n = string4.indexOf(string);
            if (n > -1) {
                string2 = string4.substring(0, n);
                string5 = string4.substring(n, n + string.length());
                string3 = string4.substring(n + string.length(), string4.length());
            } else {
                string5 = string4;
            }
            try {
                document.insertString(document.getLength(), string2, this.style);
                StyleConstants.setBackground(this.style, this.theme.getSelectionBgColor());
                document.insertString(document.getLength(), string5, this.style);
                StyleConstants.setBackground(this.style, this.theme.getBackgroundColor());
                document.insertString(document.getLength(), string3 + "\n", this.style);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.jTextPane.setDocument(document);
    }

    private void displayAllClassesNames(List<String> list) {
        long l = System.currentTimeMillis();
        this.displayDataState = DisplayDataState.CLASSES_LIST;
        StyleConstants.setFontSize(this.style, 18);
        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
        this.clearText();
        BatchDocument batchDocument = new BatchDocument();
        this.jTextPane.setDocument(batchDocument);
        for (String string : list) {
            batchDocument.appendBatchStringNoLineFeed(string, this.style);
            batchDocument.appendBatchLineFeed(this.style);
        }
        try {
            batchDocument.processBatchUpdates(0);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.jTextPane.setDocument(batchDocument);
        System.out.println("UI update " + (System.currentTimeMillis() - l) + " ms");
    }

    @Override
    public void displayClass(String string) {
        Object object;
        this.displayDataState = DisplayDataState.INSIDE_CLASS;
        try {
            object = this.jTextPane.getDocument().getText(0, this.jTextPane.getDocument().getLength());
            if (((String)object).equals(DisplayArea.getOneColorFormattedOutput(string))) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.clearText();
        StyleConstants.setFontSize(this.style, 18);
        object = new DefaultStyledDocument();
        try {
            object.insertString(object.getLength(), DisplayArea.getOneColorFormattedOutput(string), this.style);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.jTextPane.setDocument((Document)object);
        this.jTextPane.setCaretPosition(1);
    }

    @Override
    public void displayClass(List<Translator.ELEMENT> list, String string) {
        this.displayDataState = DisplayDataState.INSIDE_CLASS;
        this.clearText();
        StyleConstants.setFontSize(this.style, 18);
        StyleConstants.setBackground(this.style, this.theme.getBackgroundColor());
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        this.fillTokensToDoc(list, defaultStyledDocument, false);
        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
        this.jTextPane.setDocument(defaultStyledDocument);
        int n = this.calcScrollingPosition(string);
        this.jTextPane.setCaretPosition(n);
    }

    private void fillTokensToDoc(List<Translator.ELEMENT> list, Document document, boolean bl) {
        try {
            for (Translator.ELEMENT eLEMENT : list) {
                switch (eLEMENT.tag) {
                    case MODIFIER: {
                        StyleConstants.setForeground(this.style, this.theme.getKeyWordsColor());
                        break;
                    }
                    case DOCUMENT: {
                        StyleConstants.setForeground(this.style, this.theme.getDefaultColor());
                        break;
                    }
                    case IDENTIFIER: {
                        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
                        break;
                    }
                    case ANNOTATION: {
                        StyleConstants.setForeground(this.style, this.theme.getAnnotationsColor());
                        break;
                    }
                    case XML_TAG: {
                        StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
                        break;
                    }
                    case XML_ATTR_NAME: {
                        StyleConstants.setForeground(this.style, this.theme.getKeyWordsColor());
                        break;
                    }
                    case XML_ATTR_VALUE: {
                        StyleConstants.setForeground(this.style, this.theme.getDefaultColor());
                        break;
                    }
                    case SELECTION: {
                        StyleConstants.setForeground(this.style, this.theme.getSelectionBgColor());
                        break;
                    }
                    default: {
                        StyleConstants.setForeground(this.style, Color.LIGHT_GRAY);
                    }
                }
                String string = eLEMENT.text;
                if (bl) {
                    string = string + "\n";
                }
                document.insertString(document.getLength(), string, this.style);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private int calcScrollingPosition(String string) {
        int n = 0;
        boolean bl = false;
        if ((string = string.trim()) != null && string.length() > 0) {
            Document document = this.jTextPane.getDocument();
            int n2 = string.length();
            try {
                if (n + n2 > document.getLength()) {
                    n = 0;
                }
                while (n + n2 <= document.getLength()) {
                    String string2 = document.getText(n, n2).toLowerCase();
                    if (string2.equalsIgnoreCase(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            return n;
        }
        return 1;
    }

    @Override
    public void displaySharkey() {
        this.displayDataState = DisplayDataState.SHARKEY;
        this.clearText();
        this.style = this.jTextPane.addStyle("STYLE", null);
        StyledDocument styledDocument = this.jTextPane.getStyledDocument();
        try {
            StyleConstants.setForeground(this.style, this.theme.getIdentifiersColor());
            StyleConstants.setFontSize(this.style, 13);
            StyleConstants.setFontFamily(this.style, "Menlo");
            styledDocument.insertString(styledDocument.getLength(), Doodle.get(), this.style);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.jTextPane.setDocument(styledDocument);
    }

    @Override
    public void displayError() {
        this.displayDataState = DisplayDataState.ERROR;
        this.clearText();
        this.style = this.jTextPane.addStyle("STYLE", null);
        StyledDocument styledDocument = this.jTextPane.getStyledDocument();
        try {
            StyleConstants.setForeground(this.style, this.theme.getDefaultColor());
            StyleConstants.setFontSize(this.style, 13);
            StyleConstants.setFontFamily(this.style, "Menlo");
            styledDocument.insertString(styledDocument.getLength(), "\n\n\n\t\t\t There was a problem loading the class  ", this.style);
            styledDocument.insertString(styledDocument.getLength(), Doodle.get(), this.style);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.jTextPane.setDocument(styledDocument);
    }

    private void clearText() {
        this.jTextPane.setText(null);
    }

    private static String getOneColorFormattedOutput(String string) {
        return string + "\n";
    }

    public static void main(String[] stringArray) {
        DisplayArea displayArea = new DisplayArea(null);
        JavaTranslator javaTranslator = new JavaTranslator(StringTokenizer.class);
        javaTranslator.apply();
        displayArea.displayClass(javaTranslator.getElementsList(), "");
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(displayArea.onAddComponentToPane());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static enum DisplayDataState {
        SHARKEY,
        CLASSES_LIST,
        INSIDE_CLASS,
        ERROR;

    }
}

