/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.ViewerController;
import com.google.classyshark.gui.panel.chart.RingChartPanel;
import com.google.classyshark.gui.panel.displayarea.DisplayArea;
import com.google.classyshark.gui.panel.displayarea.IDisplayArea;
import com.google.classyshark.gui.panel.io.CurrentFolderConfig;
import com.google.classyshark.gui.panel.io.FileChooserUtils;
import com.google.classyshark.gui.panel.io.RecentArchivesConfig;
import com.google.classyshark.gui.panel.methodscount.MethodsCountPanel;
import com.google.classyshark.gui.panel.toolbar.KeyUtils;
import com.google.classyshark.gui.panel.toolbar.Toolbar;
import com.google.classyshark.gui.panel.toolbar.ToolbarController;
import com.google.classyshark.gui.panel.tree.FilesTree;
import com.google.classyshark.gui.settings.SettingsFrame;
import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.silverghost.SilverGhost;
import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.exporter.Exporter;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import com.google.classyshark.silverghost.translator.Translator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ClassySharkPanel
extends JPanel
implements ToolbarController,
ViewerController,
KeyListener {
    private static final boolean IS_CLASSNAME_FROM_MOUSE_CLICK = true;
    private static final boolean VIEW_TOP_CLASS = true;
    public static final String ANDROID_MANIFEST_XML_SEARCH = "AndroidManifest.xml - ";
    private JFrame parentFrame;
    private Toolbar toolbar;
    private JSplitPane jSplitPane;
    private MethodsCountPanel methodsCountPanel;
    private int dividerLocation = 0;
    private IDisplayArea displayArea;
    private FilesTree filesTree;
    private RingChartPanel ringChartPanel;
    private boolean isDataLoaded = false;
    private final Theme theme = GuiMode.getTheme();
    private SilverGhost silverGhost = new SilverGhost();

    public ClassySharkPanel(JFrame jFrame, File file, String string) {
        this(jFrame);
        this.silverGhost.setBinaryArchive(file);
        this.updateUiAfterArchiveReadAndLoadClass(string);
    }

    public ClassySharkPanel(JFrame jFrame, File file) {
        this(jFrame);
        this.silverGhost.setBinaryArchive(file);
        this.displayArchive(this.silverGhost.getBinaryArchive());
    }

    public ClassySharkPanel(JFrame jFrame) {
        super(false);
        this.buildUI();
        this.parentFrame = jFrame;
        this.toolbar.setText("");
        this.theme.applyTo(this);
    }

    @Override
    public void onSelectedTypeClassFromMouseClick(String string) {
        for (String string2 : this.silverGhost.getImportsForCurrentClass()) {
            if (!string2.contains(string)) continue;
            this.onSelectedImportFromMouseClick(string2);
            return;
        }
        for (String string2 : this.silverGhost.getAllClassNames()) {
            if (!string2.contains(string)) continue;
            this.onSelectedImportFromMouseClick(string2);
            return;
        }
    }

    @Override
    public void onSelectedImportFromMouseClick(String string) {
        if (this.silverGhost.getAllClassNames().contains(string)) {
            this.onSelectedClassName(string);
        }
    }

    @Override
    public void onSelectedClassName(String string) {
        this.fillDisplayArea(string, true, true);
    }

    @Override
    public void openArchive() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileChooserUtils.acceptFile(file);
            }

            @Override
            public String getDescription() {
                return FileChooserUtils.getFileChooserDescription();
            }
        });
        jFileChooser.setCurrentDirectory(CurrentFolderConfig.INSTANCE.getCurrentDirectory());
        int n = jFileChooser.showOpenDialog(this);
        this.toolbar.setText("");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            CurrentFolderConfig.INSTANCE.setCurrentDirectory(jFileChooser.getCurrentDirectory());
            RecentArchivesConfig.INSTANCE.addArchive(file.getName(), jFileChooser.getCurrentDirectory());
            this.displayArchive(file);
        }
    }

    @Override
    public void onGoBackPressed() {
        this.toolbar.setText("");
        this.displayArea.displayClassNames(this.silverGhost.getAllClassNames(), "");
        this.silverGhost.initClassNameFiltering();
    }

    @Override
    public void onViewTopClassPressed() {
        String string = this.toolbar.getText();
        this.fillDisplayArea(string, true, false);
    }

    @Override
    public void onChangedTextFromTypingArea(String string) {
        this.fillDisplayArea(string, false, false);
    }

    @Override
    public void onMappingsButtonPressed() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        jFileChooser.setCurrentDirectory(CurrentFolderConfig.INSTANCE.getCurrentDirectory());
        int n = jFileChooser.showOpenDialog(this);
        this.toolbar.setText("");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.readMappingFile(file);
        }
    }

    @Override
    public void onExportButtonPressed() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Exporter.writeCurrentClass(ClassySharkPanel.this.silverGhost.getCurrentClassName(), ClassySharkPanel.this.silverGhost.getCurrentClassContent());
                Exporter.writeArchive(ClassySharkPanel.this.silverGhost.getBinaryArchive(), ClassySharkPanel.this.silverGhost.getAllClassNames());
                return null;
            }

            @Override
            protected void done() {
            }
        };
        swingWorker.execute();
    }

    @Override
    public void onChangeLeftPaneVisibility(boolean bl) {
        if (bl) {
            this.jSplitPane.setDividerLocation(this.dividerLocation);
        } else {
            this.dividerLocation = this.jSplitPane.getDividerLocation();
        }
        this.jSplitPane.getLeftComponent().setVisible(bl);
        this.jSplitPane.updateUI();
    }

    @Override
    public void onSettingsButtonPressed() {
        SettingsFrame settingsFrame = new SettingsFrame();
    }

    @Override
    public void displayArchive(File file) {
        this.silverGhost.setBinaryArchive(file);
        if (this.parentFrame != null) {
            this.parentFrame.setTitle(this.silverGhost.getBinaryArchive().getName());
        }
        this.readArchiveAndFillDisplayArea(null);
        this.toolbar.activateNavigationButtons();
        this.filesTree.setVisibleRoot();
        this.methodsCountPanel.loadFile(this.silverGhost.getBinaryArchive());
    }

    @Override
    public void onSelectedMethodCount(ClassNode classNode) {
        this.ringChartPanel.setRootNode(classNode);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isDataLoaded) {
            this.openArchive();
            return;
        }
        if (KeyUtils.isLeftArrowPressed(keyEvent)) {
            this.openArchive();
            return;
        }
        String string = ClassySharkPanel.processKeyPressWithTypedText(keyEvent, this.toolbar.getText());
        boolean bl = KeyUtils.isRightArrowPressed(keyEvent) || KeyUtils.isCommandKeyPressed(keyEvent);
        this.fillDisplayArea(string, bl, false);
    }

    private static String processKeyPressWithTypedText(KeyEvent keyEvent, String string) {
        String string2 = string;
        if (KeyUtils.isDeletePressed(keyEvent) && !string.isEmpty()) {
            string2 = string.substring(0, string.length() - 1);
            return string2;
        }
        if (KeyUtils.isLetterOrDigit(keyEvent)) {
            string2 = string2 + keyEvent.getKeyChar();
        }
        return string2;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void buildUI() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.ringChartPanel = new RingChartPanel(this);
        this.toolbar = new Toolbar(this);
        this.add((Component)this.toolbar, "North");
        this.toolbar.addKeyListenerToTypingArea(this);
        this.displayArea = new DisplayArea(this);
        final JScrollPane jScrollPane = new JScrollPane(this.displayArea.onAddComponentToPane());
        this.theme.applyTo(jScrollPane);
        this.filesTree = new FilesTree(this);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JScrollPane jScrollPane2 = new JScrollPane(this.filesTree.getJTree());
        this.theme.applyTo(jScrollPane2);
        jTabbedPane.addTab("Classes", jScrollPane2);
        this.methodsCountPanel = new MethodsCountPanel(this);
        jTabbedPane.addTab("Methods count", this.methodsCountPanel);
        this.theme.applyTo(jTabbedPane);
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ClassySharkPanel.this.jSplitPane.getDividerLocation();
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                if (jTabbedPane.getSelectedIndex() == 0) {
                    ClassySharkPanel.this.jSplitPane.setRightComponent(jScrollPane);
                } else {
                    ClassySharkPanel.this.jSplitPane.setRightComponent(ClassySharkPanel.this.ringChartPanel);
                }
                ClassySharkPanel.this.jSplitPane.setDividerLocation(n);
            }
        });
        this.jSplitPane = new JSplitPane(1);
        this.jSplitPane.setDividerSize(3);
        this.jSplitPane.setPreferredSize(new Dimension(1000, 700));
        this.jSplitPane.add((Component)jTabbedPane, "left");
        this.jSplitPane.add((Component)jScrollPane, "right");
        this.jSplitPane.getLeftComponent().setVisible(true);
        this.jSplitPane.setDividerLocation(300);
        this.theme.applyTo(this.jSplitPane);
        this.add((Component)this.jSplitPane, "Center");
    }

    private void updateUiAfterArchiveReadAndLoadClass(String string) {
        if (this.parentFrame != null) {
            this.parentFrame.setTitle(this.silverGhost.getBinaryArchive().getName());
        }
        this.readArchiveAndFillDisplayArea(string);
        this.toolbar.activateNavigationButtons();
        this.filesTree.setVisibleRoot();
        this.methodsCountPanel.loadFile(this.silverGhost.getBinaryArchive());
    }

    private void readArchiveAndFillDisplayArea(final String string) {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ClassySharkPanel.this.silverGhost.readContents();
                return null;
            }

            @Override
            protected void done() {
                if (ClassySharkPanel.this.silverGhost.isArchiveError()) {
                    ClassySharkPanel.this.filesTree.fillArchive(new File("ERROR"), new ArrayList<String>(), ClassySharkPanel.this.silverGhost.getComponents());
                    ClassySharkPanel.this.displayArea.displayError();
                    return;
                }
                ClassySharkPanel.this.filesTree.fillArchive(ClassySharkPanel.this.silverGhost.getBinaryArchive(), ClassySharkPanel.this.silverGhost.getAllClassNames(), ClassySharkPanel.this.silverGhost.getComponents());
                if (string != null) {
                    ClassySharkPanel.this.onSelectedClassName(string);
                } else {
                    ClassySharkPanel.this.displayArea.displaySharkey();
                }
                ClassySharkPanel.this.isDataLoaded = true;
            }
        };
        swingWorker.execute();
    }

    private void readMappingFile(final File file) {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private TokensMapper reverseMappings;

            @Override
            protected Void doInBackground() throws Exception {
                this.reverseMappings = ClassySharkPanel.this.silverGhost.readMappingFile(file);
                return null;
            }

            @Override
            protected void done() {
                ClassySharkPanel.this.silverGhost.addMappings(this.reverseMappings);
            }
        };
        swingWorker.execute();
    }

    private void fillDisplayArea(final String string, final boolean bl, final boolean bl2) {
        this.toolbar.setTypingAreaCaret();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private List<Translator.ELEMENT> displayedClassTokens = new ArrayList<Translator.ELEMENT>();
            private List<Translator.ELEMENT> manifestSearchResultsTokens = new ArrayList<Translator.ELEMENT>();
            private List<String> filteredClassNames = new ArrayList<String>();
            private String className = "";

            @Override
            protected Void doInBackground() throws Exception {
                if (bl2) {
                    this.className = string;
                    this.convertToManifestIfNeeded();
                    ClassySharkPanel.this.silverGhost.translateArchiveElement(this.className);
                    this.displayedClassTokens = ClassySharkPanel.this.silverGhost.getArchiveElementTokens();
                } else if (bl) {
                    this.className = ClassySharkPanel.this.silverGhost.getAutoCompleteClassName();
                    ClassySharkPanel.this.silverGhost.translateArchiveElement(this.className);
                    this.displayedClassTokens = ClassySharkPanel.this.silverGhost.getArchiveElementTokens();
                } else {
                    this.className = string;
                    this.convertToManifestIfNeeded();
                    this.filteredClassNames = ClassySharkPanel.this.silverGhost.filter(this.className);
                    this.manifestSearchResultsTokens = ClassySharkPanel.this.silverGhost.getManifestMatches(string);
                    this.checkIfOneClassAndPrepareTokens();
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.className.isEmpty()) {
                    return;
                }
                if (this.isUserClickedOnSearchResult()) {
                    if (this.clickedOnClass()) {
                        ClassySharkPanel.this.toolbar.setText(this.className);
                        ClassySharkPanel.this.displayArea.displayClass(this.displayedClassTokens, string);
                    } else {
                        ClassySharkPanel.this.toolbar.setText("AndroidManifest.xml");
                        this.displayManifestWithSpecificLine();
                    }
                } else if (this.noResults()) {
                    ClassySharkPanel.this.displayArea.displayError();
                } else if (this.oneResult()) {
                    ClassySharkPanel.this.displayArea.displayClass(this.displayedClassTokens, "");
                } else {
                    ClassySharkPanel.this.displayArea.displaySearchResults(this.filteredClassNames, this.manifestSearchResultsTokens, string);
                }
            }

            private boolean isUserClickedOnSearchResult() {
                return bl || bl2;
            }

            private boolean clickedOnClass() {
                return !this.displayedClassTokens.isEmpty();
            }

            private void displayManifestWithSpecificLine() {
                ClassySharkPanel.this.silverGhost.translateArchiveElement("AndroidManifest.xml");
                this.displayedClassTokens = ClassySharkPanel.this.silverGhost.getArchiveElementTokens();
                ClassySharkPanel.this.displayArea.displayClass(this.displayedClassTokens, this.className);
            }

            private void checkIfOneClassAndPrepareTokens() {
                if (this.oneResult()) {
                    String string2 = this.filteredClassNames.get(0);
                    ClassySharkPanel.this.silverGhost.translateArchiveElement(string2);
                    this.displayedClassTokens = ClassySharkPanel.this.silverGhost.getArchiveElementTokens();
                }
            }

            private boolean noResults() {
                return this.filteredClassNames.size() == 0 && this.manifestSearchResultsTokens.size() == 0;
            }

            private boolean oneResult() {
                return this.filteredClassNames.size() == 1;
            }

            private void convertToManifestIfNeeded() {
                if (string.startsWith(ClassySharkPanel.ANDROID_MANIFEST_XML_SEARCH)) {
                    this.className = "AndroidManifest.xml";
                }
            }
        };
        swingWorker.execute();
    }
}

