/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui;

import com.google.classyshark.gui.panel.ClassySharkPanel;
import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.gui.theme.ThemeManager;
import com.google.classyshark.updater.UpdateManager;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GuiMode {
    private static Theme theme = ThemeManager.getCurrentTheme();

    private GuiMode() {
    }

    public static void with(final List<String> list) {
        UpdateManager.getInstance().checkVersionGui();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiMode.buildAndShowClassyShark(list);
            }
        });
    }

    public static Theme getTheme() {
        return theme;
    }

    private static void buildAndShowClassyShark(List<String> list) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException | UnsupportedLookAndFeelException exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = GuiMode.buildClassySharkFrame(list);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        theme.applyTo(jFrame);
    }

    private static JFrame buildClassySharkFrame(List<String> list) {
        JFrame jFrame = new JFrame("ClassyShark");
        theme.applyTo(jFrame);
        if (list.size() == 0) {
            jFrame.getContentPane().add(new ClassySharkPanel(jFrame));
            return jFrame;
        }
        if (list.size() == 2) {
            jFrame.getContentPane().add(new ClassySharkPanel(jFrame, new File(list.get(1))));
            return jFrame;
        }
        if (list.size() == 3) {
            jFrame.getContentPane().add(new ClassySharkPanel(jFrame, new File(list.get(1)), list.get(2)));
            return jFrame;
        }
        return jFrame;
    }
}

