/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jack.objectweb.asm.Type;
import com.android.jack.objectweb.asm.tree.ClassNode;
import com.android.jill.JillException;
import com.android.jill.backend.jayce.JayceWriter;
import com.android.jill.backend.jayce.Token;
import com.android.jill.frontend.java.SourceInfoWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class JillWriter {
    @Nonnull
    protected final JayceWriter writer;
    @Nonnull
    protected final SourceInfoWriter sourceInfoWriter;

    public JillWriter(@Nonnull JayceWriter writer, @Nonnull SourceInfoWriter sourceInfoWriter) {
        this.writer = writer;
        this.sourceInfoWriter = sourceInfoWriter;
    }

    protected void writeValue(Object value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        if (value == null) {
            this.writer.writeNull();
        } else if (value instanceof Boolean) {
            this.writeValue((Boolean)value, classNode, currentLine);
        } else if (value instanceof Integer) {
            this.writeValue((Integer)value, classNode, currentLine);
        } else if (value instanceof Long) {
            this.writeValue((Long)value, classNode, currentLine);
        } else if (value instanceof Float) {
            this.writeValue(((Float)value).floatValue(), classNode, currentLine);
        } else if (value instanceof Double) {
            this.writeValue((Double)value, classNode, currentLine);
        } else if (value instanceof String) {
            this.writeValue((String)value, classNode, currentLine);
        } else if (value instanceof Type) {
            this.writeValue((Type)value, classNode, currentLine);
        } else {
            throw new JillException("Unsupported object value.");
        }
    }

    protected void writeValue(Object value) throws IOException {
        this.writeValue(value, null, 0);
    }

    protected void writeValue(@Nonnull String value) throws IOException {
        this.writeValue(value, null, 0);
    }

    protected void writeValue(@Nonnull String value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.STRING_LITERAL);
        this.writer.writeOpen();
        this.writer.writeString(value);
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue(boolean value, @CheckForNull ClassNode classNode, @Nonnegative int currenLine) throws IOException {
        this.writeDebugBegin(classNode, currenLine);
        this.writer.writeKeyword(Token.BOOLEAN_LITERAL);
        this.writer.writeOpen();
        this.writer.writeBoolean(value);
        this.writeDebugEnd(classNode, currenLine);
        this.writer.writeClose();
    }

    protected void writeValue(boolean value) throws IOException {
        this.writeValue(value, (ClassNode)null, 0);
    }

    protected void writeValue(byte value) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.BYTE_LITERAL);
        this.writer.writeOpen();
        this.writer.writeByte(value);
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    protected void writeValue(char value) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.CHAR_LITERAL);
        this.writer.writeOpen();
        this.writer.writeChar(value);
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    protected void writeValue(short value) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.SHORT_LITERAL);
        this.writer.writeOpen();
        this.writer.writeShort(value);
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    protected void writeValue(int value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.INT_LITERAL);
        this.writer.writeOpen();
        this.writer.writeInt(value);
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue(int value) throws IOException {
        this.writeValue(value, (ClassNode)null, 0);
    }

    protected void writeValue(float value) throws IOException {
        this.writeValue(value, (ClassNode)null, 0);
    }

    protected void writeValue(float value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.FLOAT_LITERAL);
        this.writer.writeOpen();
        this.writer.writeFloat(value);
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue(double value) throws IOException {
        this.writeValue(value, (ClassNode)null, 0);
    }

    protected void writeValue(double value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.DOUBLE_LITERAL);
        this.writer.writeOpen();
        this.writer.writeDouble(value);
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue(long value) throws IOException {
        this.writeValue(value, (ClassNode)null, 0);
    }

    protected void writeValue(long value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.LONG_LITERAL);
        this.writer.writeOpen();
        this.writer.writeLong(value);
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue() throws IOException {
        this.writeValue(null, 0);
    }

    protected void writeValue(@CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.NULL_LITERAL);
        this.writer.writeOpen();
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue(@Nonnull Type value) throws IOException {
        this.writeValue(value, null, 0);
    }

    protected void writeValue(@Nonnull Type value, @CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        this.writeDebugBegin(classNode, currentLine);
        this.writer.writeKeyword(Token.CLASS_LITERAL);
        this.writer.writeOpen();
        this.writer.writeId(value.getDescriptor());
        this.writeDebugEnd(classNode, currentLine);
        this.writer.writeClose();
    }

    protected void writeValue(@Nonnull Object[] value) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.ARRAY_LITERAL);
        this.writer.writeOpen();
        this.writer.writeOpenNodeList();
        for (int j = 0; j < value.length; ++j) {
            this.writeValue(value[j]);
        }
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    @Nonnull
    protected Object[] convertPrimitiveArrayToObject(@Nonnull Object array) {
        assert (array.getClass().isArray());
        assert (array.getClass().getComponentType().isPrimitive());
        int length = Array.getLength(array);
        Object[] objectArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            objectArray[i] = Array.get(array, i);
        }
        return objectArray;
    }

    protected void writeDebugBegin(@CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        if (classNode != null && currentLine != 0) {
            this.sourceInfoWriter.writeDebugBegin(classNode, currentLine);
        } else {
            this.sourceInfoWriter.writeUnknwonDebugBegin();
        }
    }

    protected void writeDebugEnd(@CheckForNull ClassNode classNode, @Nonnegative int currentLine) throws IOException {
        if (classNode != null && currentLine != 0) {
            this.sourceInfoWriter.writeDebugEnd(classNode, currentLine + 1);
        } else {
            this.sourceInfoWriter.writeUnknownDebugEnd();
        }
    }
}

