/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util.graph;

import com.android.jack.Jack;
import com.android.jack.util.graph.GraphNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class Graph<N extends GraphNode<N>> {
    @Nonnull
    private final List<N> nodes;
    @Nonnull
    private final N entry;
    @Nonnull
    private final N exit;

    public Graph(@Nonnull N entry, @Nonnull N exit, @Nonnull ArrayList<N> nodes) {
        assert (entry != null);
        assert (exit != null);
        assert (nodes != null);
        this.entry = entry;
        this.exit = exit;
        this.nodes = Jack.getUnmodifiableCollections().getUnmodifiableList(nodes);
    }

    @Nonnull
    public List<N> getNodes() {
        return this.nodes;
    }

    @Nonnull
    public N getEntryNode() {
        return this.entry;
    }

    @Nonnull
    public N getExitNode() {
        return this.exit;
    }
}

