/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.util.TextOutput;
import java.io.PrintWriter;
import java.util.Arrays;

public abstract class AbstractTextOutput
implements TextOutput {
    private final boolean compact;
    private int identLevel = 0;
    private static final int INDENT_GRANULARITY = 2;
    private char[][] indents = new char[][]{new char[0]};
    private boolean justNewlined;
    private PrintWriter out;
    private int position = 0;

    protected AbstractTextOutput(boolean compact) {
        this.compact = compact;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void indentIn() {
        ++this.identLevel;
        if (this.identLevel >= this.indents.length) {
            char[] newIndentLevel = new char[this.identLevel * 2];
            Arrays.fill(newIndentLevel, ' ');
            char[][] newIndents = new char[this.indents.length + 1][];
            System.arraycopy(this.indents, 0, newIndents, 0, this.indents.length);
            newIndents[this.identLevel] = newIndentLevel;
            this.indents = newIndents;
        }
    }

    @Override
    public void indentOut() {
        --this.identLevel;
    }

    @Override
    public void newline() {
        this.out.print('\n');
        ++this.position;
        this.justNewlined = true;
    }

    @Override
    public void newlineOpt() {
        if (!this.compact) {
            this.out.print('\n');
            ++this.position;
            this.justNewlined = true;
        }
    }

    @Override
    public void print(char c) {
        this.maybeIndent();
        this.out.print(c);
        ++this.position;
        this.justNewlined = false;
    }

    @Override
    public void print(char[] s) {
        this.maybeIndent();
        this.printAndCount(s);
        this.justNewlined = false;
    }

    @Override
    public void print(String s) {
        this.maybeIndent();
        this.printAndCount(s.toCharArray());
        this.justNewlined = false;
    }

    @Override
    public void printOpt(char c) {
        if (!this.compact) {
            this.maybeIndent();
            this.out.print(c);
            ++this.position;
        }
    }

    @Override
    public void printOpt(char[] s) {
        if (!this.compact) {
            this.maybeIndent();
            this.printAndCount(s);
        }
    }

    @Override
    public void printOpt(String s) {
        if (!this.compact) {
            this.maybeIndent();
            this.printAndCount(s.toCharArray());
        }
    }

    protected void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    private void maybeIndent() {
        if (this.justNewlined && !this.compact) {
            this.printAndCount(this.indents[this.identLevel]);
            this.justNewlined = false;
        }
    }

    private void printAndCount(char[] chars) {
        this.position += chars.length;
        this.out.print(chars);
    }
}

