/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.selection;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TournamentSelection
implements SelectionStrategy<Object> {
    private final NumberGenerator<Probability> selectionProbability;
    private String description = "Tournament Selection";

    public TournamentSelection(NumberGenerator<Probability> selectionProbability) {
        this.selectionProbability = selectionProbability;
    }

    public TournamentSelection(Probability selectionProbability) {
        this(new ConstantGenerator<Probability>(selectionProbability));
        if (selectionProbability.doubleValue() <= 0.5) {
            throw new IllegalArgumentException("Selection threshold must be greater than 0.5.");
        }
        this.description = "Tournament Selection (p = " + selectionProbability.toString() + ')';
    }

    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        ArrayList<S> selection = new ArrayList<S>(selectionSize);
        for (int i = 0; i < selectionSize; ++i) {
            EvaluatedCandidate<S> candidate1 = population.get(rng.nextInt(population.size()));
            EvaluatedCandidate<S> candidate2 = population.get(rng.nextInt(population.size()));
            boolean selectFitter = this.selectionProbability.nextValue().nextEvent(rng);
            if (selectFitter == naturalFitnessScores) {
                selection.add(candidate2.getFitness() > candidate1.getFitness() ? candidate2.getCandidate() : candidate1.getCandidate());
                continue;
            }
            selection.add(candidate2.getFitness() > candidate1.getFitness() ? candidate1.getCandidate() : candidate2.getCandidate());
        }
        return selection;
    }

    public String toString() {
        return this.description;
    }
}

