/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.selection;

import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class StochasticUniversalSampling
implements SelectionStrategy<Object> {
    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        double aggregateFitness = 0.0;
        for (EvaluatedCandidate<S> candidate : population) {
            aggregateFitness += this.getAdjustedFitness(candidate.getFitness(), naturalFitnessScores);
        }
        ArrayList<S> selection = new ArrayList<S>(selectionSize);
        double startOffset = rng.nextDouble();
        double cumulativeExpectation = 0.0;
        int index = 0;
        for (EvaluatedCandidate<S> candidate : population) {
            cumulativeExpectation += this.getAdjustedFitness(candidate.getFitness(), naturalFitnessScores) / aggregateFitness * (double)selectionSize;
            while (cumulativeExpectation > startOffset + (double)index) {
                selection.add(candidate.getCandidate());
                ++index;
            }
        }
        return selection;
    }

    private double getAdjustedFitness(double rawFitness, boolean naturalFitness) {
        if (naturalFitness) {
            return rawFitness;
        }
        return rawFitness == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / rawFitness;
    }

    public String toString() {
        return "Stochastic Universal Sampling";
    }
}

