/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.islands;

import com.android.jack.uncommons.watchmaker.framework.CandidateFactory;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.EvolutionEngine;
import com.android.jack.uncommons.watchmaker.framework.EvolutionObserver;
import com.android.jack.uncommons.watchmaker.framework.EvolutionUtils;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import com.android.jack.uncommons.watchmaker.framework.FitnessEvaluator;
import com.android.jack.uncommons.watchmaker.framework.GenerationalEvolutionEngine;
import com.android.jack.uncommons.watchmaker.framework.PopulationData;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import com.android.jack.uncommons.watchmaker.framework.TerminationCondition;
import com.android.jack.uncommons.watchmaker.framework.islands.Epoch;
import com.android.jack.uncommons.watchmaker.framework.islands.IslandEvolutionObserver;
import com.android.jack.uncommons.watchmaker.framework.islands.Migration;
import com.android.jack.uncommons.watchmaker.framework.termination.GenerationCount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class IslandEvolution<T> {
    private final List<EvolutionEngine<T>> islands;
    private final Migration migration;
    private final boolean naturalFitness;
    private final Random rng;
    private final Set<IslandEvolutionObserver<? super T>> observers = new CopyOnWriteArraySet<IslandEvolutionObserver<? super T>>();
    private List<TerminationCondition> satisfiedTerminationConditions;

    public IslandEvolution(int islandCount, Migration migration, CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, Random rng) {
        this(IslandEvolution.createIslands(islandCount, candidateFactory, evolutionScheme, fitnessEvaluator, selectionStrategy, rng), migration, fitnessEvaluator.isNatural(), rng);
    }

    public IslandEvolution(List<EvolutionEngine<T>> islands, Migration migration, boolean naturalFitness, Random rng) {
        this.islands = islands;
        this.migration = migration;
        this.naturalFitness = naturalFitness;
        this.rng = rng;
        int i = 0;
        while (i < islands.size()) {
            final int islandIndex = i++;
            EvolutionEngine<T> island = islands.get(islandIndex);
            island.addEvolutionObserver(new EvolutionObserver<T>(){

                @Override
                public void populationUpdate(PopulationData<? extends T> populationData) {
                    for (IslandEvolutionObserver islandObserver : IslandEvolution.this.observers) {
                        islandObserver.islandPopulationUpdate(islandIndex, populationData);
                    }
                }
            });
        }
    }

    private static <T> List<EvolutionEngine<T>> createIslands(int islandCount, CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, Random rng) {
        ArrayList<EvolutionEngine<T>> islands = new ArrayList<EvolutionEngine<T>>(islandCount);
        for (int i = 0; i < islandCount; ++i) {
            GenerationalEvolutionEngine<T> island = new GenerationalEvolutionEngine<T>(candidateFactory, evolutionScheme, fitnessEvaluator, selectionStrategy, rng);
            island.setSingleThreaded(true);
            islands.add(island);
        }
        return islands;
    }

    public T evolve(int populationSize, int eliteCount, int epochLength, int migrantCount, TerminationCondition ... conditions) {
        ExecutorService threadPool = Executors.newFixedThreadPool(this.islands.size());
        ArrayList<List<T>> islandPopulations = new ArrayList<List<T>>(this.islands.size());
        ArrayList evaluatedCombinedPopulation = new ArrayList();
        PopulationData data = null;
        List<TerminationCondition> satisfiedConditions = null;
        int currentEpochIndex = 0;
        long startTime = System.currentTimeMillis();
        while (satisfiedConditions == null) {
            List<Callable<List<EvaluatedCandidate<T>>>> islandEpochs = this.createEpochTasks(populationSize, eliteCount, epochLength, islandPopulations);
            try {
                List<Future<List<EvaluatedCandidate<T>>>> futures = threadPool.invokeAll(islandEpochs);
                evaluatedCombinedPopulation.clear();
                ArrayList evaluatedPopulations = new ArrayList(this.islands.size());
                for (Future<List<EvaluatedCandidate<T>>> future : futures) {
                    List<EvaluatedCandidate<T>> evaluatedIslandPopulation = future.get();
                    evaluatedCombinedPopulation.addAll(evaluatedIslandPopulation);
                    evaluatedPopulations.add(evaluatedIslandPopulation);
                }
                this.migration.migrate(evaluatedPopulations, migrantCount, this.rng);
                EvolutionUtils.sortEvaluatedPopulation(evaluatedCombinedPopulation, this.naturalFitness);
                data = EvolutionUtils.getPopulationData(evaluatedCombinedPopulation, this.naturalFitness, eliteCount, currentEpochIndex, startTime);
                this.notifyPopulationChange(data);
                islandPopulations.clear();
                for (List list : evaluatedPopulations) {
                    islandPopulations.add(IslandEvolution.toCandidateList(list));
                }
                ++currentEpochIndex;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                throw new IllegalStateException(ex);
            }
            satisfiedConditions = EvolutionUtils.shouldContinue(data, conditions);
        }
        threadPool.shutdownNow();
        this.satisfiedTerminationConditions = satisfiedConditions;
        return ((EvaluatedCandidate)evaluatedCombinedPopulation.get(0)).getCandidate();
    }

    private List<Callable<List<EvaluatedCandidate<T>>>> createEpochTasks(int populationSize, int eliteCount, int epochLength, List<List<T>> islandPopulations) {
        ArrayList<Callable<List<EvaluatedCandidate<T>>>> islandEpochs = new ArrayList<Callable<List<EvaluatedCandidate<T>>>>(this.islands.size());
        for (int i = 0; i < this.islands.size(); ++i) {
            islandEpochs.add(new Epoch<T>(this.islands.get(i), populationSize, eliteCount, islandPopulations.isEmpty() ? Collections.emptyList() : islandPopulations.get(i), new GenerationCount(epochLength)));
        }
        return islandEpochs;
    }

    private static <T> List<T> toCandidateList(List<EvaluatedCandidate<T>> evaluatedCandidates) {
        ArrayList<T> candidates = new ArrayList<T>(evaluatedCandidates.size());
        for (EvaluatedCandidate<T> evaluatedCandidate : evaluatedCandidates) {
            candidates.add(evaluatedCandidate.getCandidate());
        }
        return candidates;
    }

    public List<TerminationCondition> getSatisfiedTerminationConditions() {
        if (this.satisfiedTerminationConditions == null) {
            throw new IllegalStateException("EvolutionEngine has not terminated.");
        }
        return Collections.unmodifiableList(this.satisfiedTerminationConditions);
    }

    public void addEvolutionObserver(IslandEvolutionObserver<? super T> observer) {
        this.observers.add(observer);
    }

    public void removeEvolutionObserver(IslandEvolutionObserver<? super T> observer) {
        this.observers.remove(observer);
    }

    private void notifyPopulationChange(PopulationData<T> data) {
        for (IslandEvolutionObserver<T> observer : this.observers) {
            observer.populationUpdate(data);
        }
    }
}

