/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.factories;

import com.android.jack.uncommons.watchmaker.framework.CandidateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public abstract class AbstractCandidateFactory<T>
implements CandidateFactory<T> {
    @Override
    public List<T> generateInitialPopulation(int populationSize, Random rng) {
        ArrayList population = new ArrayList(populationSize);
        for (int i = 0; i < populationSize; ++i) {
            population.add(this.generateRandomCandidate(rng));
        }
        return Collections.unmodifiableList(population);
    }

    @Override
    public List<T> generateInitialPopulation(int populationSize, Collection<T> seedCandidates, Random rng) {
        if (seedCandidates.size() > populationSize) {
            throw new IllegalArgumentException("Too many seed candidates for specified population size.");
        }
        ArrayList population = new ArrayList(populationSize);
        population.addAll(seedCandidates);
        for (int i = seedCandidates.size(); i < populationSize; ++i) {
            population.add(this.generateRandomCandidate(rng));
        }
        return Collections.unmodifiableList(population);
    }
}

