/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.EmptyClinit;
import com.android.jack.transformations.InitializationExpression;
import com.android.jack.transformations.assertion.DynamicAssertionFeature;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Add a statement to clinit if the marker InitializationExpression is present.")
@Constraint(need={InitializationExpression.class, EmptyClinit.class})
@Transform(remove={InitializationExpression.class, ThreeAddressCodeForm.class})
@Support(value={DynamicAssertionFeature.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class FieldInitializer
implements RunnableSchedulable<JField> {
    @Override
    public void run(@Nonnull JField field) {
        InitializationExpression marker = field.getMarker(InitializationExpression.class);
        if (marker != null) {
            assert (field.isStatic()) : "Not yet supported";
            TransformationRequest request = new TransformationRequest(field);
            JMethod clinit = field.getEnclosingType().getMethod("<clinit>", (JType)JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), new JType[0]);
            JMethodBody body = (JMethodBody)clinit.getBody();
            assert (body != null);
            JStatement toPrepend = marker.getStatement();
            request.append(new PrependStatement(body.getBlock(), toPrepend));
            field.removeMarker(InitializationExpression.class);
            request.commit();
        }
    }
}

