/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JAbstractMethodCall;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NMethodCall;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NPolymorphicCall
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.POLYMORPHIC_CALL;
    @CheckForNull
    public NExpression instance;
    @CheckForNull
    public String receiverType;
    @CheckForNull
    public NMethodCall.ReceiverKind receiverKind;
    @CheckForNull
    public String methodName;
    @Nonnull
    public List<String> methodArgsType = Collections.emptyList();
    @CheckForNull
    public MethodKind methodKind;
    @CheckForNull
    public String returnType;
    @Nonnull
    public List<NExpression> args = Collections.emptyList();
    @CheckForNull
    public String callSiteReturnType;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JPolymorphicMethodCall pmc = (JPolymorphicMethodCall)node;
        this.instance = (NExpression)loader.load(pmc.getInstance());
        this.receiverType = ImportHelper.getSignatureName(pmc.getReceiverType());
        this.receiverKind = this.getReceiverKind(pmc);
        this.methodName = pmc.getMethodId().getName();
        this.methodArgsType = ImportHelper.getMethodArgsSignature(pmc.getMethodId());
        this.methodKind = pmc.getMethodId().getKind();
        this.returnType = ImportHelper.getSignatureName(pmc.getReturnTypeOfPolymorphicMethod());
        this.args = loader.load(NExpression.class, pmc.getArgs());
        this.sourceInfo = pmc.getSourceInfo();
        this.callSiteReturnType = ImportHelper.getSignatureName(pmc.getType());
    }

    private NMethodCall.ReceiverKind getReceiverKind(JAbstractMethodCall jMethodCall) {
        return jMethodCall.getReceiverType() instanceof JClass ? NMethodCall.ReceiverKind.CLASS : NMethodCall.ReceiverKind.INTERFACE;
    }

    @Override
    @Nonnull
    public JPolymorphicMethodCall exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.receiverType != null);
        assert (this.receiverKind != null);
        assert (this.methodName != null);
        assert (this.methodArgsType != null);
        assert (this.methodKind != null);
        assert (this.returnType != null);
        assert (this.instance != null);
        assert (this.callSiteReturnType != null);
        JClassOrInterface jReceiverType = this.receiverKind == NMethodCall.ReceiverKind.CLASS ? exportSession.getLookup().getClass(this.receiverType) : exportSession.getLookup().getInterface(this.receiverType);
        JType jReturnType = exportSession.getLookup().getType(this.returnType);
        JMethodId methodId = jReceiverType.getOrCreateMethodId(this.methodName, exportSession.getTypeListFromSignatureList(this.methodArgsType), this.methodKind, jReturnType);
        JPolymorphicMethodCall pmc = new JPolymorphicMethodCall(this.sourceInfo, this.instance.exportAsJast(exportSession), jReceiverType, methodId, exportSession.getLookup().getType(this.callSiteReturnType));
        for (NExpression arg : this.args) {
            pmc.addArg(arg.exportAsJast(exportSession));
        }
        return pmc;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.instance != null);
        assert (this.receiverType != null);
        assert (this.receiverKind != null);
        assert (this.methodName != null);
        assert (this.methodKind != null);
        assert (this.returnType != null);
        assert (this.sourceInfo != null);
        out.writeNode(this.instance);
        out.writeId(this.receiverType);
        out.writeReceiverKindEnum(this.receiverKind);
        out.writeId(this.methodName);
        out.writeIds(this.methodArgsType);
        out.writeMethodKindEnum(this.methodKind);
        out.writeId(this.returnType);
        out.writeNodes(this.args);
        out.writeId(this.callSiteReturnType);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.instance = in.readNode(NExpression.class);
        this.receiverType = in.readId();
        this.receiverKind = in.readReceiverKindEnum();
        this.methodName = in.readId();
        this.methodArgsType = in.readIds();
        this.methodKind = in.readMethodKindEnum();
        this.returnType = in.readId();
        this.args = in.readNodes(NExpression.class);
        this.callSiteReturnType = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

