/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NLiteral;
import com.android.jack.jayce.v0004.nodes.NMarker;
import com.android.jack.jayce.v0004.nodes.NNameValuePair;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NAnnotation
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.ANNOTATION;
    @CheckForNull
    public JRetentionPolicy retentionPolicy;
    @CheckForNull
    public String annotationType;
    @Nonnull
    public List<NNameValuePair> elements = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JAnnotation jAnnotation = (JAnnotation)node;
        this.retentionPolicy = jAnnotation.getRetentionPolicy();
        this.annotationType = ImportHelper.getSignatureName(jAnnotation.getType());
        this.elements = loader.load(NNameValuePair.class, jAnnotation.getNameValuePairs());
        this.sourceInfo = jAnnotation.getSourceInfo();
        this.markers = loader.load(NMarker.class, jAnnotation.getAllMarkers());
    }

    @Override
    @Nonnull
    public JAnnotation exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.retentionPolicy != null);
        assert (this.sourceInfo != null);
        assert (this.annotationType != null);
        JAnnotationType type = exportSession.getLookup().getAnnotationType(this.annotationType);
        JAnnotation jAnnotation = new JAnnotation(this.sourceInfo, this.retentionPolicy, type);
        for (NNameValuePair valuePair : this.elements) {
            jAnnotation.put(valuePair.exportAsJast(exportSession, type));
        }
        for (NMarker marker : this.markers) {
            jAnnotation.addMarker(marker.exportAsJast(exportSession));
        }
        return jAnnotation;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.retentionPolicy != null);
        out.writeRetentionPolicyEnum(this.retentionPolicy);
        out.writeId(this.annotationType);
        out.writeNodes(this.elements);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.retentionPolicy = in.readRetentionPolicyEnum();
        this.annotationType = in.readId();
        this.elements = in.readNodes(NNameValuePair.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

