/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NSourceInfo {
    @CheckForNull
    public String fileName;
    @Nonnegative
    public int startLine;
    @Nonnegative
    public int endLine;
    public int startColumn;
    public int endColumn;
    public static final NSourceInfo UNKNOWN = new NSourceInfo();

    public void importFromJast(@Nonnull SourceInfo sourceInfo) {
        this.fileName = sourceInfo.getFileName();
        this.startLine = sourceInfo.getStartLine();
        this.endLine = sourceInfo.getEndLine();
        this.startColumn = sourceInfo.getStartColumn();
        this.endColumn = sourceInfo.getEndColumn();
    }

    @Nonnull
    public SourceInfo exportAsJast(@Nonnull ExportSession exportSession) {
        if (this.fileName == null && this.startLine == 0 && this.endLine == 0 && this.startColumn == 0 && this.endColumn == 0) {
            return SourceInfo.UNKNOWN;
        }
        assert (this.fileName != null);
        return exportSession.getSession().getSourceInfoFactory().create(this.startColumn, this.endColumn, this.startLine, this.endLine, this.fileName);
    }
}

