/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.JayceFieldLoader;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NField;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NMarker;
import com.android.jack.load.FieldLoader;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class NEnumField
extends NField {
    @Nonnull
    public static final Token TOKEN = Token.ENUM_FIELD;
    public int ordinal = -1;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JEnumField jEnumField = (JEnumField)node;
        this.modifiers = jEnumField.getModifier();
        this.type = ImportHelper.getSignatureName(jEnumField.getType());
        this.name = jEnumField.getName();
        this.initialValue = (NLiteral)loader.load(jEnumField.getInitialValue());
        this.ordinal = jEnumField.ordinal();
        this.annotations = loader.load(NAnnotation.class, jEnumField.getAnnotations());
        this.markers = loader.load(NMarker.class, jEnumField.getAllMarkers());
        this.sourceInfo = loader.load(jEnumField.getSourceInfo());
    }

    @Override
    @Nonnull
    public JEnumField exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JayceClassOrInterfaceLoader enclosingLoader) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.name != null);
        assert (this.type != null);
        JDefinedEnum enclosingType = (JDefinedEnum)exportSession.getCurrentType();
        assert (enclosingType != null);
        JEnumField jField = new JEnumField(this.sourceInfo.exportAsJast(exportSession), this.name, this.ordinal, enclosingType, (JDefinedClass)exportSession.getLookup().getType(this.type), (FieldLoader)new JayceFieldLoader(this, this.fieldNodeIndex, enclosingLoader));
        assert (this.name != null);
        assert (this.type != null);
        exportSession.getFieldInitializerFieldResolver().addTarget(NEnumField.getResolverFieldId(this.name, this.type), jField);
        if (this.initialValue != null) {
            jField.setInitialValue(this.initialValue.exportAsJast(exportSession));
        }
        for (NMarker marker : this.markers) {
            jField.addMarker(marker.exportAsJast(exportSession));
        }
        return jField;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeInt(this.modifiers);
        out.writeId(this.type);
        out.writeId(this.name);
        out.writeNode(this.initialValue);
        out.writeInt(this.ordinal);
        out.writeNodes(this.annotations);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.modifiers = in.readInt();
        this.type = in.readId();
        this.name = in.readId();
        this.initialValue = in.readNode(NLiteral.class);
        this.ordinal = in.readInt();
        this.annotations = in.readNodes(NAnnotation.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

