/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NDoubleLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.DOUBLE_LITERAL;
    public double value;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDoubleLiteral jDoubleLiteral = (JDoubleLiteral)node;
        this.value = jDoubleLiteral.getValue();
        this.sourceInfo = loader.load(jDoubleLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JLiteral exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JDoubleLiteral jDoubleLiteral = new JDoubleLiteral(jSourceInfo, this.value);
        return jDoubleLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

