/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.template.utility;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.Macro;
import com.android.jack.freemarker.core.TemplateMarkupOutputModel;
import com.android.jack.freemarker.ext.beans.BeanModel;
import com.android.jack.freemarker.ext.beans.BooleanModel;
import com.android.jack.freemarker.ext.beans.CollectionModel;
import com.android.jack.freemarker.ext.beans.DateModel;
import com.android.jack.freemarker.ext.beans.EnumerationModel;
import com.android.jack.freemarker.ext.beans.IteratorModel;
import com.android.jack.freemarker.ext.beans.MapModel;
import com.android.jack.freemarker.ext.beans.NumberModel;
import com.android.jack.freemarker.ext.beans.OverloadedMethodsModel;
import com.android.jack.freemarker.ext.beans.SimpleMethodModel;
import com.android.jack.freemarker.ext.beans.StringModel;
import com.android.jack.freemarker.ext.util.WrapperTemplateModel;
import com.android.jack.freemarker.template.AdapterTemplateModel;
import com.android.jack.freemarker.template.TemplateBooleanModel;
import com.android.jack.freemarker.template.TemplateCollectionModel;
import com.android.jack.freemarker.template.TemplateCollectionModelEx;
import com.android.jack.freemarker.template.TemplateDateModel;
import com.android.jack.freemarker.template.TemplateDirectiveModel;
import com.android.jack.freemarker.template.TemplateHashModel;
import com.android.jack.freemarker.template.TemplateHashModelEx;
import com.android.jack.freemarker.template.TemplateMethodModel;
import com.android.jack.freemarker.template.TemplateMethodModelEx;
import com.android.jack.freemarker.template.TemplateModel;
import com.android.jack.freemarker.template.TemplateModelIterator;
import com.android.jack.freemarker.template.TemplateNodeModel;
import com.android.jack.freemarker.template.TemplateNumberModel;
import com.android.jack.freemarker.template.TemplateScalarModel;
import com.android.jack.freemarker.template.TemplateSequenceModel;
import com.android.jack.freemarker.template.TemplateTransformModel;
import java.util.HashSet;
import java.util.Set;

public class ClassUtil {
    private ClassUtil() {
    }

    public static Class forName(String className) throws ClassNotFoundException {
        try {
            ClassLoader ctcl = Thread.currentThread().getContextClassLoader();
            if (ctcl != null) {
                return Class.forName(className, true, ctcl);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Class.forName(className);
    }

    public static String getShortClassName(Class pClass) {
        return ClassUtil.getShortClassName(pClass, false);
    }

    public static String getShortClassName(Class pClass, boolean shortenFreeMarkerClasses) {
        if (pClass == null) {
            return null;
        }
        if (pClass.isArray()) {
            return ClassUtil.getShortClassName(pClass.getComponentType()) + "[]";
        }
        String cn = pClass.getName();
        if (cn.startsWith("java.lang.") || cn.startsWith("java.util.")) {
            return cn.substring(10);
        }
        if (shortenFreeMarkerClasses) {
            if (cn.startsWith("com.android.jack.freemarker.template.")) {
                return "f.t" + cn.substring(19);
            }
            if (cn.startsWith("com.android.jack.freemarker.ext.beans.")) {
                return "f.e.b" + cn.substring(20);
            }
            if (cn.startsWith("com.android.jack.freemarker.core.")) {
                return "f.c" + cn.substring(15);
            }
            if (cn.startsWith("com.android.jack.freemarker.ext.")) {
                return "f.e" + cn.substring(14);
            }
            if (cn.startsWith("com.android.jack.freemarker.")) {
                return "f" + cn.substring(10);
            }
        }
        return cn;
    }

    public static String getShortClassNameOfObject(Object obj) {
        return ClassUtil.getShortClassNameOfObject(obj, false);
    }

    public static String getShortClassNameOfObject(Object obj, boolean shortenFreeMarkerClasses) {
        if (obj == null) {
            return "Null";
        }
        return ClassUtil.getShortClassName(obj.getClass(), shortenFreeMarkerClasses);
    }

    private static Class getPrimaryTemplateModelInterface(TemplateModel tm) {
        if (tm instanceof BeanModel) {
            if (tm instanceof CollectionModel) {
                return TemplateSequenceModel.class;
            }
            if (tm instanceof IteratorModel || tm instanceof EnumerationModel) {
                return TemplateCollectionModel.class;
            }
            if (tm instanceof MapModel) {
                return TemplateHashModelEx.class;
            }
            if (tm instanceof NumberModel) {
                return TemplateNumberModel.class;
            }
            if (tm instanceof BooleanModel) {
                return TemplateBooleanModel.class;
            }
            if (tm instanceof DateModel) {
                return TemplateDateModel.class;
            }
            if (tm instanceof StringModel) {
                Object wrapped = ((BeanModel)tm).getWrappedObject();
                return wrapped instanceof String ? TemplateScalarModel.class : (tm instanceof TemplateHashModelEx ? TemplateHashModelEx.class : null);
            }
            return null;
        }
        if (tm instanceof SimpleMethodModel || tm instanceof OverloadedMethodsModel) {
            return TemplateMethodModelEx.class;
        }
        return null;
    }

    private static void appendTemplateModelTypeName(StringBuilder sb, Set typeNamesAppended, Class cl) {
        int initalLength = sb.length();
        if (TemplateNodeModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "node");
        }
        if (TemplateDirectiveModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "directive");
        } else if (TemplateTransformModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "transform");
        }
        if (TemplateSequenceModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "sequence");
        } else if (TemplateCollectionModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, TemplateCollectionModelEx.class.isAssignableFrom(cl) ? "extended_collection" : "collection");
        } else if (TemplateModelIterator.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "iterator");
        }
        if (TemplateMethodModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "method");
        }
        if (Environment.Namespace.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "namespace");
        } else if (TemplateHashModelEx.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "extended_hash");
        } else if (TemplateHashModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "hash");
        }
        if (TemplateNumberModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "number");
        }
        if (TemplateDateModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "date_or_time_or_datetime");
        }
        if (TemplateBooleanModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "boolean");
        }
        if (TemplateScalarModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "string");
        }
        if (TemplateMarkupOutputModel.class.isAssignableFrom(cl)) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "markup_output");
        }
        if (sb.length() == initalLength) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, "misc_template_model");
        }
    }

    private static Class getUnwrappedClass(TemplateModel tm) {
        Object unwrapped;
        try {
            unwrapped = tm instanceof WrapperTemplateModel ? ((WrapperTemplateModel)tm).getWrappedObject() : (tm instanceof AdapterTemplateModel ? ((AdapterTemplateModel)tm).getAdaptedObject(Object.class) : null);
        }
        catch (Throwable e) {
            unwrapped = null;
        }
        return unwrapped != null ? unwrapped.getClass() : null;
    }

    private static void appendTypeName(StringBuilder sb, Set typeNamesAppended, String name) {
        if (!typeNamesAppended.contains(name)) {
            if (sb.length() != 0) {
                sb.append("+");
            }
            sb.append(name);
            typeNamesAppended.add(name);
        }
    }

    public static String getFTLTypeDescription(TemplateModel tm) {
        if (tm == null) {
            return "Null";
        }
        HashSet typeNamesAppended = new HashSet();
        StringBuilder sb = new StringBuilder();
        Class primaryInterface = ClassUtil.getPrimaryTemplateModelInterface(tm);
        if (primaryInterface != null) {
            ClassUtil.appendTemplateModelTypeName(sb, typeNamesAppended, primaryInterface);
        }
        if (tm instanceof Macro) {
            ClassUtil.appendTypeName(sb, typeNamesAppended, ((Macro)tm).isFunction() ? "function" : "macro");
        }
        ClassUtil.appendTemplateModelTypeName(sb, typeNamesAppended, tm.getClass());
        Class unwrappedClass = ClassUtil.getUnwrappedClass(tm);
        String javaClassName = unwrappedClass != null ? ClassUtil.getShortClassName(unwrappedClass, true) : null;
        sb.append(" (");
        String modelClassName = ClassUtil.getShortClassName(tm.getClass(), true);
        if (javaClassName == null) {
            sb.append("wrapper: ");
            sb.append(modelClassName);
        } else {
            sb.append(javaClassName);
            sb.append(" wrapped into ");
            sb.append(modelClassName);
        }
        sb.append(")");
        return sb.toString();
    }

    public static Class primitiveClassToBoxingClass(Class primitiveClass) {
        if (primitiveClass == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveClass == Long.TYPE) {
            return Long.class;
        }
        if (primitiveClass == Double.TYPE) {
            return Double.class;
        }
        if (primitiveClass == Character.TYPE) {
            return Character.class;
        }
        if (primitiveClass == Float.TYPE) {
            return Float.class;
        }
        if (primitiveClass == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveClass == Short.TYPE) {
            return Short.class;
        }
        if (primitiveClass == Void.TYPE) {
            return Void.class;
        }
        return primitiveClass;
    }

    public static Class boxingClassToPrimitiveClass(Class boxingClass) {
        if (boxingClass == Integer.class) {
            return Integer.TYPE;
        }
        if (boxingClass == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxingClass == Long.class) {
            return Long.TYPE;
        }
        if (boxingClass == Double.class) {
            return Double.TYPE;
        }
        if (boxingClass == Character.class) {
            return Character.TYPE;
        }
        if (boxingClass == Float.class) {
            return Float.TYPE;
        }
        if (boxingClass == Byte.class) {
            return Byte.TYPE;
        }
        if (boxingClass == Short.class) {
            return Short.TYPE;
        }
        if (boxingClass == Void.class) {
            return Void.TYPE;
        }
        return boxingClass;
    }

    public static boolean isNumerical(Class type) {
        return Number.class.isAssignableFrom(type) || type.isPrimitive() && type != Boolean.TYPE && type != Character.TYPE && type != Void.TYPE;
    }
}

