/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.CommonMarkupOutputFormat;
import com.android.jack.freemarker.core.TemplateXMLOutputModel;
import com.android.jack.freemarker.template.TemplateModelException;
import com.android.jack.freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLOutputFormat
extends CommonMarkupOutputFormat<TemplateXMLOutputModel> {
    public static final XMLOutputFormat INSTANCE = new XMLOutputFormat();

    private XMLOutputFormat() {
    }

    @Override
    public String getName() {
        return "XML";
    }

    @Override
    public String getMimeType() {
        return "application/xml";
    }

    @Override
    public void output(String textToEsc, Writer out) throws IOException, TemplateModelException {
        StringUtil.XMLEnc(textToEsc, out);
    }

    @Override
    public String escapePlainText(String plainTextContent) {
        return StringUtil.XMLEnc(plainTextContent);
    }

    @Override
    public boolean isLegacyBuiltInBypassed(String builtInName) {
        return builtInName.equals("xml");
    }

    @Override
    protected TemplateXMLOutputModel newTemplateMarkupOutputModel(String plainTextContent, String markupContent) {
        return new TemplateXMLOutputModel(plainTextContent, markupContent);
    }
}

