/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.eclipse.jdt.internal.compiler;

import com.android.jack.eclipse.jdt.internal.compiler.ClassFile;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import java.util.Arrays;

public class ClassFilePool {
    public static final int POOL_SIZE = 25;
    ClassFile[] classFiles = new ClassFile[25];

    private ClassFilePool() {
    }

    public static ClassFilePool newInstance() {
        return new ClassFilePool();
    }

    public synchronized ClassFile acquire(SourceTypeBinding typeBinding) {
        int i = 0;
        while (i < 25) {
            ClassFile classFile = this.classFiles[i];
            if (classFile == null) {
                ClassFile newClassFile;
                this.classFiles[i] = newClassFile = new ClassFile(typeBinding);
                newClassFile.isShared = true;
                return newClassFile;
            }
            if (!classFile.isShared) {
                classFile.reset(typeBinding);
                classFile.isShared = true;
                return classFile;
            }
            ++i;
        }
        return new ClassFile(typeBinding);
    }

    public synchronized void release(ClassFile classFile) {
        classFile.isShared = false;
    }

    public void reset() {
        Arrays.fill(this.classFiles, null);
    }
}

