/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ecj.loader.jast;

import com.android.jack.ecj.loader.jast.AnnotationUtils;
import com.android.jack.ecj.loader.jast.JAstBinaryField;
import com.android.jack.ecj.loader.jast.JAstBinaryMethod;
import com.android.jack.ecj.loader.jast.JAstBinaryNestedType;
import com.android.jack.ecj.loader.jast.JAstClasspath;
import com.android.jack.ecj.loader.jast.LoaderUtils;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryField;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryType;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import com.android.jack.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import com.android.jack.ir.ast.HasEnclosingMethod;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.marker.SimpleName;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.util.NamingTools;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class JAstBinaryType
implements IBinaryType {
    @Nonnull
    private static final char[] OBJECT = "java/lang/Object".toCharArray();
    @Nonnull
    private final JDefinedClassOrInterface jDeclaredType;
    @Nonnull
    private final JAstClasspath classpathLocation;

    JAstBinaryType(@Nonnull JDefinedClassOrInterface jDeclaredType, @Nonnull JAstClasspath classpathLocation) {
        this.jDeclaredType = jDeclaredType;
        this.classpathLocation = classpathLocation;
    }

    @Override
    public int getModifiers() {
        JAstBinaryType enclosing;
        int modifiers;
        JAnnotation enclosingAnnotation = AnnotationUtils.getAnnotation(this.jDeclaredType, "Ldalvik/annotation/InnerClass;");
        if (enclosingAnnotation != null) {
            JNameValuePair pair = enclosingAnnotation.getNameValuePair("accessFlags");
            assert (pair != null);
            modifiers = ((JIntLiteral)pair.getValue()).getIntValue();
        } else {
            modifiers = this.jDeclaredType.getModifier();
        }
        modifiers = LoaderUtils.convertJAstModifiersToEcj(modifiers, this.jDeclaredType);
        JClassOrInterface enclosingType = this.jDeclaredType.getEnclosingType();
        if (enclosingType != null && !this.isAnonymous() && enclosingType instanceof JDefinedClassOrInterface && (enclosing = this.classpathLocation.findType((JDefinedClassOrInterface)enclosingType)) != null && LoaderUtils.isDeprecated(enclosing)) {
            modifiers |= 0x200000;
        }
        return modifiers;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    @Nonnull
    public char[] getFileName() {
        return (this.classpathLocation.getPath() + "|" + this.getBinaryName()).toCharArray();
    }

    @Override
    @CheckForNull
    public IBinaryAnnotation[] getAnnotations() {
        return AnnotationUtils.convertJAstAnnotationToEcj(this.jDeclaredType, true);
    }

    public boolean hasEnclosingMethod() {
        return this.jDeclaredType instanceof JDefinedClass && ((JDefinedClass)this.jDeclaredType).getEnclosingMethod() != null;
    }

    @Override
    @CheckForNull
    public char[] getEnclosingTypeName() {
        JMethod enclosingMethod;
        char[] enclosingTypeName = null;
        JClassOrInterface enclosingType = this.jDeclaredType.getEnclosingType();
        if (enclosingType == null && this.jDeclaredType instanceof JDefinedClass && (enclosingMethod = ((JDefinedClass)this.jDeclaredType).getEnclosingMethod()) != null) {
            enclosingType = enclosingMethod.getEnclosingType();
        }
        if (enclosingType != null) {
            enclosingTypeName = LoaderUtils.getQualifiedNameFormatter().getName(enclosingType).toCharArray();
        }
        return enclosingTypeName;
    }

    @Override
    @CheckForNull
    public IBinaryField[] getFields() {
        List<JField> fields = this.jDeclaredType.getFields();
        int totalFields = fields.size();
        if (totalFields == 0) {
            return null;
        }
        IBinaryField[] allFields = new IBinaryField[totalFields];
        int indexInAllFields = 0;
        for (JField field : fields) {
            JLiteral initialValue = null;
            initialValue = field.getLiteralInitializer();
            if (initialValue == null) {
                initialValue = field.getInitialValue();
            }
            allFields[indexInAllFields] = new JAstBinaryField(field, initialValue);
            ++indexInAllFields;
        }
        return allFields;
    }

    @Override
    @CheckForNull
    public char[] getGenericSignature() {
        return LoaderUtils.getGenericSignature(this.jDeclaredType);
    }

    @Override
    @CheckForNull
    public char[][] getInterfaceNames() {
        List<JInterface> implemented = this.jDeclaredType.getImplements();
        Object names = null;
        int interfaceCount = implemented.size();
        if (interfaceCount > 0) {
            names = new char[interfaceCount][];
            TypeFormatter formatter = LoaderUtils.getQualifiedNameFormatter();
            for (int i = 0; i < interfaceCount; ++i) {
                names[i] = formatter.getName(implemented.get(i)).toCharArray();
            }
        }
        return names;
    }

    @Override
    @CheckForNull
    public IBinaryNestedType[] getMemberTypes() {
        List<JClassOrInterface> members = this.jDeclaredType.getMemberTypes();
        IBinaryNestedType[] nestedTypesArray = null;
        if (!members.isEmpty()) {
            int nestedTypeCount = members.size();
            ArrayList<JAstBinaryNestedType> nestedTypes = new ArrayList<JAstBinaryNestedType>(nestedTypeCount);
            for (JClassOrInterface jNested : members) {
                if (!(jNested instanceof JDefinedClassOrInterface)) continue;
                JAstBinaryType nested = this.classpathLocation.findType((JDefinedClassOrInterface)jNested);
                assert (nested != null);
                if (nested.isAnonymous() || nested.isLocal()) continue;
                nestedTypes.add(new JAstBinaryNestedType(nested.jDeclaredType));
            }
            if (!nestedTypes.isEmpty()) {
                nestedTypesArray = nestedTypes.toArray(new IBinaryNestedType[nestedTypes.size()]);
            }
        }
        return nestedTypesArray;
    }

    @Override
    @CheckForNull
    public IBinaryMethod[] getMethods() {
        List<JMethod> jMethods = this.jDeclaredType.getMethods();
        int total = jMethods.size();
        IBinaryMethod[] methods = null;
        if (total != 0) {
            methods = new IBinaryMethod[total];
            int indexInMethods = 0;
            for (JMethod method : jMethods) {
                methods[indexInMethods] = new JAstBinaryMethod(method);
                ++indexInMethods;
            }
        }
        return methods;
    }

    @Override
    @CheckForNull
    public char[][][] getMissingTypeNames() {
        return null;
    }

    @Override
    @Nonnull
    public char[] getName() {
        return this.getBinaryName().toCharArray();
    }

    @Override
    @CheckForNull
    public char[] getSourceName() {
        char[] sourceNameArray;
        SimpleName typeInfo = this.jDeclaredType.getMarker(SimpleName.class);
        if (typeInfo != null) {
            return typeInfo.getSimpleName().toCharArray();
        }
        JAnnotation enclosingAnnotation = AnnotationUtils.getAnnotation(this.jDeclaredType, "Ldalvik/annotation/InnerClass;");
        if (enclosingAnnotation != null) {
            JNameValuePair pair = enclosingAnnotation.getNameValuePair("name");
            assert (pair != null) : "Invalid jayce file";
            JLiteral nameValue = pair.getValue();
            if (nameValue instanceof JNullLiteral) {
                sourceNameArray = null;
            } else {
                String sourceName = ((JAbstractStringLiteral)nameValue).getValue();
                sourceNameArray = sourceName.toCharArray();
            }
        } else {
            String binaryName = this.getBinaryName();
            String simpleName = NamingTools.getSimpleClassNameFromBinaryName(binaryName);
            sourceNameArray = simpleName.toCharArray();
        }
        return sourceNameArray;
    }

    @Override
    @CheckForNull
    public char[] getSuperclassName() {
        JClass superType = this.jDeclaredType.getSuperClass();
        if (superType != null) {
            return LoaderUtils.getQualifiedNameFormatter().getName(superType).toCharArray();
        }
        if (this.jDeclaredType instanceof JDefinedInterface) {
            return OBJECT;
        }
        return null;
    }

    @Override
    public long getTagBits() {
        return AnnotationUtils.getTagBits(this.jDeclaredType);
    }

    @Override
    public boolean isAnonymous() {
        boolean isAnonymous = false;
        SimpleName simpleNameInfo = this.jDeclaredType.getMarker(SimpleName.class);
        if (simpleNameInfo != null) {
            isAnonymous = simpleNameInfo.getSimpleName().isEmpty();
        } else {
            JAnnotation enclosingAnnotation = AnnotationUtils.getAnnotation(this.jDeclaredType, "Ldalvik/annotation/InnerClass;");
            if (enclosingAnnotation != null) {
                JNameValuePair pair = enclosingAnnotation.getNameValuePair("name");
                assert (pair != null);
                isAnonymous = pair.getValue() instanceof JNullLiteral;
            }
        }
        return isAnonymous;
    }

    @Override
    public boolean isLocal() {
        return !this.isAnonymous() && this.hasEnclosingMethod();
    }

    @Override
    public boolean isMember() {
        return !this.isAnonymous() && this.jDeclaredType.getEnclosingType() != null && !this.hasEnclosingMethod();
    }

    @Override
    @CheckForNull
    public char[] sourceFileName() {
        if (this.jDeclaredType.getSourceInfo() == SourceInfo.UNKNOWN) {
            return null;
        }
        String fileName = this.jDeclaredType.getSourceInfo().getFileName();
        int simpleNameIndex = fileName.lastIndexOf(47);
        if ((simpleNameIndex = Math.max(simpleNameIndex, fileName.lastIndexOf(92))) > 0) {
            fileName = fileName.substring(simpleNameIndex + 1);
        }
        return fileName.toCharArray();
    }

    @Nonnull
    public String toString() {
        return this.jDeclaredType.toString();
    }

    @Nonnull
    String getBinaryName() {
        return LoaderUtils.getQualifiedNameFormatter().getName(this.jDeclaredType);
    }

    @Override
    public char[] getEnclosingMethod() {
        JMethod enclosingMethod;
        char[] enclosingMethodName = null;
        if (this.jDeclaredType instanceof HasEnclosingMethod && (enclosingMethod = ((HasEnclosingMethod)((Object)this.jDeclaredType)).getEnclosingMethod()) != null) {
            enclosingMethodName = LoaderUtils.getSignatureFormatter().getName(enclosingMethod).toCharArray();
        }
        return enclosingMethodName;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }

    @Override
    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker walker, Object member, LookupEnvironment environment) {
        return walker;
    }
}

