/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.ir.ast.JStatement;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ConditionalBasicBlock
extends BasicBlock {
    @Nonnegative
    private static final int THEN_BLOCK_INDEX = 0;
    @Nonnegative
    private static final int ELSE_BLOCK_INDEX = 1;
    @Nonnegative
    private static final int FIXED_BLOCK_COUNT = 2;

    public ConditionalBasicBlock(@Nonnegative int id, @Nonnull List<JStatement> statements) {
        super(id, statements, 2);
    }

    public void setThenBlock(@Nonnull BasicBlock thenBb) {
        this.setSuccessor(0, thenBb);
    }

    public void setElseBlock(@Nonnull BasicBlock elseBb) {
        this.setSuccessor(1, elseBb);
    }

    @Nonnull
    public BasicBlock getThenBlock() {
        return (BasicBlock)this.getInternalSuccessors().get(0);
    }

    @Nonnull
    public BasicBlock getElseBlock() {
        return (BasicBlock)this.getInternalSuccessors().get(1);
    }
}

