/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dependency.library;

import com.android.jack.analysis.dependency.Dependency;
import com.android.jack.google.common.io.LineReader;
import com.android.jack.library.InputLibrary;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class LibraryDependencies
extends Dependency {
    @Nonnull
    public static final VPath vpath = new VPath("libraries", '/');
    @Nonnull
    private List<String> importedLibrariesDexDigest = new ArrayList<String>();
    @Nonnull
    private List<String> librariesOnClasspathDexDigest = new ArrayList<String>();

    public void addImportedLibraries(@Nonnull List<? extends InputLibrary> importedLibraries) {
        for (InputLibrary inputLibrary : importedLibraries) {
            this.importedLibrariesDexDigest.add(inputLibrary.getDigest());
        }
    }

    public void addLibrariesOnClasspath(@Nonnull List<? extends InputLibrary> librariesOnClasspath) {
        for (InputLibrary inputLibrary : librariesOnClasspath) {
            this.librariesOnClasspathDexDigest.add(inputLibrary.getDigest());
        }
    }

    public void write(@Nonnull PrintStream ps) {
        this.writeList(ps, this.librariesOnClasspathDexDigest);
        ps.println();
        this.writeList(ps, this.importedLibrariesDexDigest);
        ps.println();
    }

    @Override
    @Nonnull
    public void read(@Nonnull Readable readable) throws IOException {
        LineReader lr = new LineReader(readable);
        this.librariesOnClasspathDexDigest = this.readList(lr);
        this.importedLibrariesDexDigest = this.readList(lr);
    }

    public boolean hasSameLibraryOnClasspath(@Nonnull LibraryDependencies libraryDependencies) {
        return LibraryDependencies.compare(this.librariesOnClasspathDexDigest, libraryDependencies.librariesOnClasspathDexDigest);
    }

    public boolean hasSameImportedLibrary(@Nonnull LibraryDependencies libraryDependencies) {
        return LibraryDependencies.compare(this.importedLibrariesDexDigest, libraryDependencies.importedLibrariesDexDigest);
    }

    @Nonnull
    public List<String> getDigestOfImportedLibraries() {
        return this.importedLibrariesDexDigest;
    }

    @Nonnull
    public List<String> getDigestOfLibrariesOnClasspath() {
        return this.librariesOnClasspathDexDigest;
    }

    private static boolean compare(@Nonnull List<String> digests1, @Nonnull List<String> digests2) {
        if (digests1.size() != digests2.size()) {
            return false;
        }
        Iterator<String> digestToCompareIt = digests1.iterator();
        for (String digest : digests2) {
            String digestToCompare = digestToCompareIt.next();
            if (digest != null && digestToCompare != null && !digest.equals("") && !digestToCompare.equals("") && digest.equals(digestToCompare)) continue;
            return false;
        }
        return true;
    }
}

