/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import java.io.IOException;
import java.io.OutputStream;

public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final String scope;
    private final OutputStream debugStream;
    private final String state;
    private final String responseType;
    private final String userAgent;
    private HttpClientConfig httpClientConfig;
    private HttpClient httpClient;

    public OAuthConfig(String key, String secret) {
        this(key, secret, null, null, null, null, null, null, null, null);
    }

    public OAuthConfig(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.callback = callback;
        this.scope = scope;
        this.debugStream = debugStream;
        this.state = state;
        this.responseType = responseType;
        this.userAgent = userAgent;
        this.httpClientConfig = httpClientConfig;
        this.httpClient = httpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void log(String message) {
        if (this.debugStream != null) {
            message = message + '\n';
            try {
                this.debugStream.write(message.getBytes("UTF8"));
            }
            catch (IOException | RuntimeException e) {
                throw new RuntimeException("there were problems while writting to the debug stream", e);
            }
        }
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

