/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.staticobject;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.asm.ClassVisitor;
import com.oracle.truffle.api.impl.asm.FieldVisitor;
import com.oracle.truffle.api.impl.asm.Type;
import com.oracle.truffle.api.staticobject.ArrayBasedShapeGenerator;
import com.oracle.truffle.api.staticobject.FieldBasedShapeGenerator;
import com.oracle.truffle.api.staticobject.GeneratorClassLoader;
import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.api.staticobject.StaticPropertyKind;
import com.oracle.truffle.api.staticobject.StaticShape;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

abstract class ShapeGenerator<T> {
    protected static final Unsafe UNSAFE = ShapeGenerator.getUnsafe();
    private static final String DELIMITER = "$$";
    private static final AtomicInteger counter = new AtomicInteger();

    ShapeGenerator() {
    }

    abstract StaticShape<T> generateShape(StaticShape<T> var1, Map<String, StaticProperty> var2, boolean var3);

    static <T> ShapeGenerator<T> getShapeGenerator(TruffleLanguage<?> language, GeneratorClassLoader gcl, StaticShape<T> parentShape, StaticShape.StorageStrategy strategy) {
        Class<?> parentStorageClass = parentShape.getStorageClass();
        Class<?> storageSuperclass = strategy == StaticShape.StorageStrategy.ARRAY_BASED ? parentStorageClass.getSuperclass() : parentStorageClass;
        return ShapeGenerator.getShapeGenerator(language, gcl, storageSuperclass, parentShape.getFactoryInterface(), strategy);
    }

    static <T> ShapeGenerator<T> getShapeGenerator(TruffleLanguage<?> language, GeneratorClassLoader gcl, Class<?> storageSuperClass, Class<T> storageFactoryInterface, StaticShape.StorageStrategy strategy) {
        if (strategy == StaticShape.StorageStrategy.ARRAY_BASED) {
            return ArrayBasedShapeGenerator.getShapeGenerator(language, gcl, storageSuperClass, storageFactoryInterface);
        }
        return FieldBasedShapeGenerator.getShapeGenerator(gcl, storageSuperClass, storageFactoryInterface);
    }

    static String generateStorageName() {
        return ShapeGenerator.class.getPackage().getName().replace('.', '/') + "/GeneratedStaticObject" + DELIMITER + counter.incrementAndGet();
    }

    static String generateFactoryName(Class<?> generatedStorageClass) {
        return Type.getInternalName(generatedStorageClass) + DELIMITER + "Factory";
    }

    static void addStorageFields(ClassVisitor cv, Map<String, StaticProperty> staticProperties) {
        for (Map.Entry<String, StaticProperty> entry : staticProperties.entrySet()) {
            ShapeGenerator.addStorageField(cv, entry.getKey(), entry.getValue().getInternalKind(), entry.getValue().storeAsFinal());
        }
    }

    static void addStorageField(ClassVisitor cv, String propertyName, byte internalKind, boolean storeAsFinal) {
        int access = storeAsFinal ? 17 : 1;
        FieldVisitor fv = cv.visitField(access, propertyName, StaticPropertyKind.getDescriptor(internalKind), null, null);
        fv.visitEnd();
    }

    static <T> Class<? extends T> load(GeneratorClassLoader gcl, String internalName, byte[] bytes) {
        try {
            return gcl.defineGeneratedClass(internalName.replace('/', '.'), bytes, 0, bytes.length);
        }
        catch (ClassFormatError e) {
            throw new RuntimeException(e);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }
}

