/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.data;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transforms.tabular.TabularTransformDefinitionFactory;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformEntityNames;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TabularTransformSource
extends TransformSource {
    private final String tabularGraphName;
    private final List<String> sourceFiles;
    private final List<TabularTransform> transforms;
    private final TabularTransformEntityNames entityNames;
    private final boolean searchFavorited;
    private List<TransformDefinition> transformDefinitions;

    public TabularTransformSource(String name, String displayName, String tabularGraphName, List<String> sourceFiles, List<TabularTransform> transforms, TabularTransformEntityNames entityNames, boolean searchFavorited) {
        super(name, displayName);
        Args.notNullOrBlank((String)name, (String)"name");
        Args.notNullOrBlank((String)displayName, (String)"displayName");
        Args.notNullOrBlank((String)tabularGraphName, (String)"tabularGraphName");
        Args.notNull(sourceFiles, (String)"sourceFiles");
        Args.notNull(transforms, (String)"transforms");
        Args.notNull((Object)entityNames, (String)"entityNames");
        this.tabularGraphName = tabularGraphName;
        this.sourceFiles = Collections.unmodifiableList(new ArrayList<String>(sourceFiles));
        this.transforms = Collections.unmodifiableList(new ArrayList<TabularTransform>(transforms));
        this.entityNames = entityNames;
        this.searchFavorited = searchFavorited;
    }

    public String getTabularGraphName() {
        return this.tabularGraphName;
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public List<TabularTransform> getTabularTransforms() {
        return this.transforms;
    }

    public TabularTransformEntityNames getEntityNames() {
        return this.entityNames;
    }

    public boolean isSearchFavorited() {
        return this.searchFavorited;
    }

    public synchronized List<TransformDefinition> getTransforms() {
        if (this.transformDefinitions == null) {
            TabularTransformDefinitionFactory factory = new TabularTransformDefinitionFactory(this);
            this.transformDefinitions = factory.createTransforms();
        }
        return this.transformDefinitions;
    }

    public Optional<TabularTransform> getTabularTransform(TransformDescriptor transform) {
        Args.notNull((Object)transform, (String)"transform");
        return this.getTabularTransform(transform.getName());
    }

    public Optional<TabularTransform> getTabularTransform(String transformName) {
        Args.notNullOrBlank((String)transformName, (String)"transformName");
        List<TabularTransform> tabularTransforms = this.getTabularTransforms();
        for (TabularTransform tabularTransform : tabularTransforms) {
            if (!transformName.equals(tabularTransform.getTransformName(this))) continue;
            return Optional.of(tabularTransform);
        }
        return Optional.empty();
    }

    public TabularTransformSource setDisplayName(String displayName) {
        Args.notNullOrBlank((String)displayName, (String)"displayName");
        return new TabularTransformSource(this.getName(), displayName, this.getTabularGraphName(), this.getSourceFiles(), this.getTabularTransforms(), this.getEntityNames(), this.isSearchFavorited());
    }

    public TabularTransformSource setTabularTransforms(List<TabularTransform> tabularTransforms) {
        Args.notNull(tabularTransforms, (String)"tabularTransforms");
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), this.getSourceFiles(), tabularTransforms, this.getEntityNames(), this.isSearchFavorited());
    }

    public TabularTransformSource removeTabularTransforms(List<TabularTransform> tabularTransforms) {
        Args.notNull(tabularTransforms, (String)"tabularTransforms");
        ArrayList<TabularTransform> transforms = new ArrayList<TabularTransform>(this.getTabularTransforms());
        transforms.removeAll(tabularTransforms);
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), this.getSourceFiles(), transforms, this.getEntityNames(), this.isSearchFavorited());
    }

    public TabularTransformSource setEntityNames(TabularTransformEntityNames entityNames) {
        Args.notNull((Object)entityNames, (String)"entityNames");
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), this.getSourceFiles(), this.getTabularTransforms(), entityNames, this.isSearchFavorited());
    }

    public TabularTransformSource setSearchFavorited(boolean searchFavorited) {
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), this.getSourceFiles(), this.getTabularTransforms(), this.getEntityNames(), searchFavorited);
    }

    public TabularTransformSource addSourceFile(String sourceFile) {
        Args.notNullOrBlank((String)sourceFile, (String)"sourceFile");
        ArrayList<String> files = new ArrayList<String>(this.getSourceFiles());
        files.add(sourceFile);
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), files, this.getTabularTransforms(), this.getEntityNames(), this.isSearchFavorited());
    }

    public TabularTransformSource removeSourceFile(String sourceFile) {
        Args.notNullOrBlank((String)sourceFile, (String)"sourceFile");
        ArrayList<String> files = new ArrayList<String>(this.getSourceFiles());
        files.remove(sourceFile);
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), files, this.getTabularTransforms(), this.getEntityNames(), this.isSearchFavorited());
    }

    public TabularTransformSource removeSourceFiles(List<String> sourceFiles) {
        Args.notNull(sourceFiles, (String)"sourceFiles");
        ArrayList<String> files = new ArrayList<String>(this.getSourceFiles());
        files.removeAll(sourceFiles);
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), files, this.getTabularTransforms(), this.getEntityNames(), this.isSearchFavorited());
    }

    public TabularTransformSource setSourceFiles(List<String> files) {
        Args.notNull(files, (String)"files");
        return new TabularTransformSource(this.getName(), this.getDisplayName(), this.getTabularGraphName(), files, this.getTabularTransforms(), this.getEntityNames(), this.isSearchFavorited());
    }
}

