/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import com.paterva.maltego.ui.graph.actions.NewGraphAction;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class CloudGraphOpenAction
extends NewGraphAction {
    private GraphID maltegoGraphID;
    private String name;
    private DataObject gdo;

    public void setGraph(GraphID maltegoGraphID, String name) {
        this.maltegoGraphID = maltegoGraphID;
        this.name = name;
    }

    public void performAction() {
        if (this.maltegoGraphID == null) {
            RequestProcessor.getDefault().post(() -> SwingUtilities.invokeLater(() -> {
                throw new IllegalStateException("Graph not set.");
            }), 30);
        } else {
            GraphLifeCycleManager.getDefault().fireGraphOpening(this.maltegoGraphID);
            GraphLifeCycleManager.getDefault().fireGraphLoading(this.maltegoGraphID);
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("graphLoadingDone")) {
                        GraphViewNotificationAdapter.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                        SwingUtilities.invokeLater(() -> {
                            CloudGraphOpenAction.this.relayoutNewGraph();
                            Timer t = new Timer(2000, __ -> CloudGraphOpenAction.this.gdo.setModified(false));
                            t.setRepeats(false);
                            t.start();
                        });
                    }
                }
            };
            GraphViewNotificationAdapter.getDefault().addPropertyChangeListener(listener);
            super.performAction();
            this.maltegoGraphID = null;
            this.name = null;
        }
    }

    protected DataObject getDataObject() throws DataObjectNotFoundException, IOException {
        this.gdo = super.getDataObject();
        GraphCookie graphCookie = (GraphCookie)this.gdo.getCookie(GraphCookie.class);
        graphCookie.setGraphID(this.maltegoGraphID);
        graphCookie.onGraphLoaded();
        this.renameDataObject(this.gdo, this.name);
        return this.gdo;
    }

    private void relayoutNewGraph() {
        GraphView graphView = this.getTopGraphView();
        graphView.setLayout(new LayoutSettings(true, LayoutMode.CIRCULAR), true);
        graphView.doLayout();
    }

    private GraphView getTopGraphView() {
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null) {
            GraphViewCookie cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
            return cookie.getGraphView();
        }
        return null;
    }
}

