/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.labels;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.GraphType;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import yguard.A.A.E;
import yguard.A.A.Y;
import yguard.A.J.BA;
import yguard.A.J.SA;
import yguard.A.J.gB;

public class EntityPropertyLabelSettings {
    public static final String PREF_SHOW_PROPERTY_LABELS = "showEntityPropertyLabels";
    private static final Map<GraphID, EntityPropertyLabelSettings> _default = new HashMap<GraphID, EntityPropertyLabelSettings>();
    private boolean _isShowPropertyLabels = false;
    private boolean _isFirstUpdate = true;
    private final PreferenceChangeListener _prefsListener;
    private final GraphID _graphID;

    public static synchronized EntityPropertyLabelSettings getDefault(GraphID graphID) {
        if (_default.get(graphID) == null) {
            _default.put(graphID, new EntityPropertyLabelSettings(graphID));
        }
        return _default.get(graphID);
    }

    protected EntityPropertyLabelSettings(GraphID graphID) {
        this._graphID = graphID;
        this._prefsListener = new PreferenceListener();
        Preferences prefs = EntityPropertyLabelSettings.getPreferences();
        prefs.addPreferenceChangeListener(this._prefsListener);
    }

    public PreferenceChangeListener getPrefsListener() {
        return this._prefsListener;
    }

    private void update(boolean show) {
        if (this._isShowPropertyLabels != show || this._isFirstUpdate) {
            SA viewGraph;
            if (this._isFirstUpdate) {
                this._isFirstUpdate = false;
            }
            if ((viewGraph = GraphViewManager.getDefault().getViewGraph(this._graphID)) != null) {
                E nodes = viewGraph.\u00a4();
                while (nodes.ok()) {
                    Y node = nodes.B();
                    BA realizer = viewGraph.f(node);
                    if (realizer != null && realizer.labelCount() > 0) {
                        for (int i = 0; i < realizer.labelCount(); ++i) {
                            gB label = realizer.getLabel(i);
                            if (label == null || !(label instanceof EntityPropertyLabel)) continue;
                            EntityPropertyLabel propLabel = (EntityPropertyLabel)label;
                            propLabel.update();
                        }
                    }
                    nodes.next();
                }
                this._isShowPropertyLabels = show;
            }
        }
    }

    public static boolean isShowPropertyLabels(String graphType) {
        return EntityPropertyLabelSettings.getPreferences().getBoolean(EntityPropertyLabelSettings.getPreferenceKey(graphType), !"normal".equals(graphType));
    }

    public static void setShowPropertyLabels(String graphType, boolean show) {
        EntityPropertyLabelSettings.getPreferences().putBoolean(EntityPropertyLabelSettings.getPreferenceKey(graphType), show);
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(EntityPropertyLabelSettings.class);
    }

    private static String getPreferenceKey(String graphType) {
        return "showEntityPropertyLabels_" + graphType;
    }

    static {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphID graphID = (GraphID)evt.getNewValue();
                if (null != evt.getPropertyName()) {
                    switch (evt.getPropertyName()) {
                        case "graphClosing": {
                            PreferenceChangeListener prefsListener;
                            EntityPropertyLabelSettings settings = (EntityPropertyLabelSettings)_default.get(graphID);
                            if (settings == null || (prefsListener = settings.getPrefsListener()) == null) break;
                            Preferences prefs = EntityPropertyLabelSettings.getPreferences();
                            try {
                                prefs.removePreferenceChangeListener(prefsListener);
                            }
                            catch (IllegalArgumentException ex) {
                                if (ex.getMessage().contains("Listener not registered")) break;
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            break;
                        }
                        case "graphClosed": {
                            _default.remove(graphID);
                        }
                    }
                }
            }
        });
    }

    private class PreferenceListener
    implements PreferenceChangeListener {
        private PreferenceListener() {
        }

        @Override
        public void preferenceChange(final PreferenceChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (evt.getKey().startsWith(EntityPropertyLabelSettings.PREF_SHOW_PROPERTY_LABELS)) {
                        String graphType = evt.getKey().substring(EntityPropertyLabelSettings.PREF_SHOW_PROPERTY_LABELS.length() + 1);
                        GraphDataObject graphDataObject = GraphDataUtils.getGraphDataObject(EntityPropertyLabelSettings.this._graphID);
                        if (graphDataObject != null && graphType.equals(GraphType.getType(graphDataObject))) {
                            boolean show = EntityPropertyLabelSettings.isShowPropertyLabels(graphType);
                            EntityPropertyLabelSettings.this.update(show);
                        }
                    }
                }
            });
        }
    }
}

