/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.LabelViewMode;
import com.paterva.maltego.util.StringUtilities;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.SwingUtilities;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.J.U;
import yguard.A.J.gB;

public class NotesClickViewMode
extends LabelViewMode {
    public boolean isOverLabel(U view, double x2, double y2) {
        return this.getLabel(view, x2, y2, 2) != null;
    }

    public void mouseClicked(MouseEvent me) {
        gB label;
        super.mouseClicked(me);
        if (me.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(me) && (label = this.getLabel(this.view, this.view.toWorldCoordX(me.getX()), this.view.toWorldCoordY(me.getY()), 2)) != null) {
            this.notesClicked(label);
        }
        this.reactivateParent();
    }

    private void notesClicked(gB label) {
        gB notesEditLabel = this.view.getGraph2D().f(label.getNode()).getLabel(4);
        if (notesEditLabel != null) {
            MaltegoEntity entity = this.getEntity(label.getNode());
            String notes = entity.getNotes();
            boolean showNotes = entity.isShowNotes();
            if (StringUtilities.isNullOrEmpty((String)entity.getNotes())) {
                showNotes = true;
                notes = "(Click here to add notes)";
            } else if ("(Click here to add notes)".equals(entity.getNotes())) {
                showNotes = false;
                notes = "";
            } else {
                showNotes = !showNotes;
            }
            GraphTransactionHelper.doChangeNotes((D)this.getGraph2D(), Collections.singleton(entity), notes, showNotes);
        }
    }

    private MaltegoEntity getEntity(Y node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)this.view.getGraph2D());
        MaltegoEntity entity = wrapper.entity(node);
        return entity;
    }
}

