/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.util;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.ui.graph.GraphViewCookie;

public final class GraphViewStorageUtility {
    private static final String KEY = "GraphViewStorageKey";

    private GraphViewStorageUtility() {
    }

    public static void putGraphViewCookie(GraphID graphID, GraphViewCookie graphViewCookie) {
        GraphViewStorageUtility.putGraphViewCookie(graphID, graphViewCookie, false);
    }

    public static void putGraphViewCookie(GraphID graphID, GraphViewCookie graphViewCookie, boolean isListView) {
        GraphViewStorage gvs = new GraphViewStorage(graphViewCookie, isListView);
        GraphUserData.forGraph((GraphID)graphID).put((Object)KEY, (Object)gvs);
    }

    public static void putIsListView(GraphID graphID, boolean isListView) {
        GraphViewStorage gvs = (GraphViewStorage)GraphUserData.forGraph((GraphID)graphID).get((Object)KEY);
        gvs.setIsListView(isListView);
    }

    public static GraphViewCookie getGraphViewCookie(GraphID graphID) {
        Object obj = GraphUserData.forGraph((GraphID)graphID).get((Object)KEY);
        if (obj == null) {
            return null;
        }
        return ((GraphViewStorage)obj).getGraphViewCookie();
    }

    public static Boolean isListView(GraphID graphID) {
        Object obj = GraphUserData.forGraph((GraphID)graphID).get((Object)KEY);
        if (obj == null) {
            return null;
        }
        return ((GraphViewStorage)obj).isIsListView();
    }

    private static class GraphViewStorage {
        private final GraphViewCookie graphViewCookie;
        private boolean isListView;

        public GraphViewStorage(GraphViewCookie graphViewCookie, boolean isListView) {
            this.graphViewCookie = graphViewCookie;
            this.isListView = isListView;
        }

        public GraphViewCookie getGraphViewCookie() {
            return this.graphViewCookie;
        }

        public boolean isIsListView() {
            return this.isListView;
        }

        public void setIsListView(boolean isListView) {
            this.isListView = isListView;
        }
    }
}

