/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.pyramidio.PartialImageReader;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class DirectImageReader
implements PartialImageReader {
    private final File imageFile;
    private final Dimension dimension;

    public DirectImageReader(File imageFile) throws IOException {
        this.imageFile = imageFile;
        this.dimension = this.getImageDimension();
    }

    @Override
    public BufferedImage read(Rectangle rectangle) throws IOException {
        return this.readRegion(rectangle);
    }

    @Override
    public int getWidth() {
        return this.dimension.width;
    }

    @Override
    public int getHeight() {
        return this.dimension.height;
    }

    private Dimension getImageDimension() throws IOException {
        return this.executeWithImageReader(new Function<Dimension>(){

            @Override
            public Dimension apply(ImageReader imageReader) throws IOException {
                return new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
            }
        });
    }

    private BufferedImage readRegion(final Rectangle rectangle) throws IOException {
        return this.executeWithImageReader(new Function<BufferedImage>(){

            @Override
            public BufferedImage apply(ImageReader imageReader) throws IOException {
                ImageReadParam param = imageReader.getDefaultReadParam();
                param.setSourceRegion(rectangle);
                return imageReader.read(0, param);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T executeWithImageReader(Function<T> f) throws IOException {
        Throwable throwable = null;
        try (ImageInputStream iis = ImageIO.createImageInputStream(new FileInputStream(this.imageFile).getChannel());){
            T t;
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) throw new IOException("No codec found for image " + this.imageFile);
            ImageReader reader = readers.next();
            try {
                reader.setInput(iis);
                t = f.apply(reader);
                reader.dispose();
            }
            catch (Throwable throwable2) {
                try {
                    reader.dispose();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            return t;
        }
    }

    private static interface Function<T> {
        public T apply(ImageReader var1) throws IOException;
    }
}

