/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.licensed;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.ActivationException;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.free.B;
import com.paterva.maltego.licensing.json.rest.InvalidKeyPairException;
import com.paterva.maltego.licensing.json.rest.JsonLicenseRestRequests;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseResponse;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.serialize.M;
import com.paterva.maltego.licensing.serialize.N;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.licensed.FailurePanel;
import com.paterva.maltego.licensing.ui.wizard.licensed.SuccessPanel;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.keycloak.representations.AccessToken;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class MaltegoIdActivationController
extends PassFailProgressController<JsonLicenseResponse, SuccessPanel, FailurePanel> {
    private static final Logger LOG = Logger.getLogger(MaltegoIdActivationController.class.getName());
    private boolean forceActivate = false;

    public MaltegoIdActivationController() {
        this.setName("Maltego ID Activation");
        this.setDescription("A summary of the Maltego ID activation process is shown below.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected JsonLicenseResponse doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws ActivationException {
        boolean offlineActivation = Boolean.TRUE.equals(descriptor.getProperty("licensing.activation.offline"));
        if (offlineActivation) {
            return this.activateOffline(handle);
        }
        return this.activateOnline(handle);
    }

    private JsonLicenseResponse activateOnline(ProgressHandle handle) throws ActivationException {
        JsonLicenseResponse licenseResponse;
        boolean isCurrentLicenseIsMaltegoIdLicenseAndExpired;
        LOG.log(Level.INFO, "License wizard: MaltegoID activation - starting online activation");
        WizardDescriptor descriptor = this.getDescriptor();
        LicenseManager licMan = LicenseManager.A();
        boolean gatewayMaltegoId = Boolean.TRUE.equals(descriptor.getProperty("licensing.gateway-maltego-id"));
        boolean switchOrg = Boolean.TRUE.equals(descriptor.getProperty("licensing.switch-org.maltegoId"));
        Optional activation = N.B().D();
        A licenseMode = licMan.A(false);
        boolean bl = isCurrentLicenseIsMaltegoIdLicenseAndExpired = licenseMode.W() && licenseMode.R().M();
        if (isCurrentLicenseIsMaltegoIdLicenseAndExpired) {
            this.forceActivate = true;
        }
        LOG.log(Level.INFO, "License wizard: MaltegoID online activation - forced activation: {0}, switching org: {1}, activation present: {2}", new Object[]{this.forceActivate, switchOrg, activation.isPresent()});
        if (this.forceActivate || switchOrg || !activation.isPresent()) {
            handle.progress("Activating with Maltego ID");
            licenseResponse = JsonLicenseRestRequests.activateWithMaltegoID();
        } else {
            handle.progress("Checking activation with Maltego ID");
            licenseResponse = JsonLicenseRestRequests.isSameWithMaltegoID((String)((JsonLicenseResponse)activation.get()).getActivationId());
        }
        boolean maltegoIdMode = gatewayMaltegoId || switchOrg;
        boolean freeOnline = !maltegoIdMode;
        licMan.C(freeOnline);
        licMan.B(freeOnline);
        licMan.H(maltegoIdMode);
        licMan.G(false);
        licMan.I(false);
        licMan.E();
        AccessToken accessToken = CloudAuth.getDefault().getAccessToken();
        B.A().A(accessToken);
        return licenseResponse;
    }

    private JsonLicenseResponse activateOffline(ProgressHandle handle) throws ActivationException {
        boolean oldModeWasMaltegoIdOnline;
        LOG.log(Level.INFO, "License wizard: MaltegoID activation - starting offline activation");
        JsonLicenseResponse licenseResponse = (JsonLicenseResponse)this.getDescriptor().getProperty("licensing.activation.maltegoId");
        LicenseManager licMan = LicenseManager.A();
        A oldLicenseMode = licMan.A(false);
        boolean bl = oldModeWasMaltegoIdOnline = oldLicenseMode.W() && !oldLicenseMode.S();
        if (oldModeWasMaltegoIdOnline) {
            try {
                CloudAuth.getDefault().logout(true);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (licenseResponse != null) {
            handle.progress("Activating with Maltego ID");
            B.A().A(licenseResponse);
            licMan.C(false);
            licMan.B(false);
            licMan.H(true);
            licMan.G(true);
            licMan.I(false);
            licMan.A(oldLicenseMode);
            A newLicenseMode = licMan.A(false);
            if (newLicenseMode == null || newLicenseMode.D()) {
                throw new ActivationException("License file invalid.", true);
            }
        }
        return licenseResponse;
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected SuccessPanel createPassComponent() {
        return new SuccessPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, SuccessPanel component, JsonLicenseResponse license) {
        A licenseMode = LicenseManager.A().A(false);
        E capability = licenseMode.R().J();
        component.setProduct(capability.F());
        LOG.log(Level.INFO, "License wizard: MaltegoID activation - success");
    }

    protected void fail(FailurePanel component, Exception e) {
        Throwable t;
        LOG.log(Level.WARNING, "License wizard: MaltegoID activation - failure");
        Throwable throwable = t = e != null ? e.getCause() : null;
        if (t == null) {
            component.setError(null);
        } else if (t.getMessage() == null) {
            component.setError(t.toString());
        } else {
            component.setError(t.getMessage());
        }
        component.setOptionsVisible(false);
        component.setTitle("Activation failed!");
        if (e instanceof ActivationException) {
            ActivationException activationEx = (ActivationException)e;
            if (activationEx.isCommunicationError()) {
                component.setOptionsVisible(true);
                component.setTitle("Could not connect to the activation server!");
                if (activationEx.getDisplayMessage() == null) {
                    component.setDescription("This usually means that you have no internet connection or that your proxy settings are incorrect.\n\nTo change your proxy settings click on the options button. Use the \"Retry Activation\" button to retry the activation process");
                } else {
                    component.setDescription(activationEx.getDisplayMessage());
                }
                component.setRetryAction(() -> this.readSettings(this.getDescriptor()));
            } else {
                boolean isKeyPairInvalid;
                if (activationEx.getDisplayMessage() == null) {
                    component.setDescription("Current activation could not be verified. Please re-activate or contact the Maltego help desk at support@maltego.com.");
                } else {
                    component.setDescription(activationEx.getDisplayMessage());
                }
                Throwable cause = activationEx.getCause();
                boolean bl = isKeyPairInvalid = cause != null && cause instanceof InvalidKeyPairException;
                if (isKeyPairInvalid) {
                    component.setError(null);
                }
                if (activationEx.isCanReactivate() || isKeyPairInvalid) {
                    component.setRetryAction(() -> {
                        if (isKeyPairInvalid) {
                            M.E();
                        }
                        this.forceActivate = true;
                        this.readSettings(this.getDescriptor());
                    });
                }
            }
        } else {
            component.setDescription("This usually means that you have exceeded the maximum number of activations.\n\nPlease contact the Maltego help desk at support@maltego.com.");
        }
    }
}

