/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.PandoraStore;
import com.pinkmatter.pandora.lucene.LuceneConnection;
import com.pinkmatter.pandora.lucene.LuceneSearcher;
import com.pinkmatter.pandora.lucene.serialize.IndexSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneStore
implements PandoraStore {
    private final LuceneConnection _connection;
    private long _lastKey = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(LuceneStore.class);
    private boolean _autoCommit = true;
    private boolean _autoKey = true;
    private LuceneSearcher _searcher;

    public LuceneStore(LuceneConnection connection) {
        this(connection, true, true);
    }

    public LuceneStore(LuceneConnection connection, boolean autoCommit, boolean autoKey) {
        this._connection = connection;
        this._autoCommit = autoCommit;
        this._autoKey = autoKey;
        LOG.info("Created PandoraStore with auto commit {}, and auto key {}", (Object)this._autoCommit, (Object)this._autoKey);
    }

    private LuceneSearcher getSearcher() throws PandoraException {
        if (this._searcher == null) {
            this._searcher = new LuceneSearcher(this._connection, true);
        }
        return this._searcher;
    }

    public long checkAdd(Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Checking if data is valid for adding: {}", metaData);
        long key = this.addImpl(metaData, null, true);
        LOG.debug("Data is valid for adding with key: {}", (Object)key);
        return key;
    }

    public long add(Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Adding data : {}", metaData);
        long key = this.addImpl(metaData, null, false);
        LOG.debug("Data added with key: {}", (Object)key);
        return key;
    }

    public long checkAdd(Map<String, Object> metaData, Date birthDate) throws PandoraException {
        LOG.debug("Checking if data with birthdate {} is valid for adding: {}", (Object)birthDate, metaData);
        long key = this.addImpl(metaData, birthDate, true);
        LOG.debug("Data is valid for adding with key: {}", (Object)key);
        return key;
    }

    public long add(Map<String, Object> metaData, Date birthDate) throws PandoraException {
        LOG.debug("Adding data with birthdate {}: {}", (Object)birthDate, metaData);
        long key = this.addImpl(metaData, birthDate, false);
        LOG.debug("Data added with key {} and with birthdate {}", (Object)key, (Object)birthDate);
        return key;
    }

    public void checkAdd(long key, Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Checking if data with supplied key {} is valid for adding: {}", (Object)key, metaData);
        this.addImpl(key, metaData, null, true);
        LOG.debug("Data is valid for adding with supplied key {} ", (Object)key);
    }

    public void add(long key, Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Adding data with supplied key {} : {}", (Object)key, metaData);
        this.addImpl(key, metaData, null, false);
        LOG.debug("Data added with supplied key {} ", (Object)key);
    }

    public void checkAdd(long key, Map<String, Object> metaData, Date birthDate) throws PandoraException {
        LOG.debug("Checking if data with supplied key {} and birthDate {} is valid for adding: {}", new Object[]{key, birthDate, metaData});
        this.addImpl(key, metaData, birthDate, true);
        LOG.debug("Data is valid for adding with supplied key: {} and birthDate {}", (Object)key, (Object)birthDate);
    }

    public void add(long key, Map<String, Object> metaData, Date birthDate) throws PandoraException {
        LOG.debug("Adding data with supplied key {} and birthDate {}: {}", new Object[]{key, birthDate, metaData});
        this.addImpl(key, metaData, birthDate, false);
        LOG.debug("Data added with supplied key: {} and birthDate {}", (Object)key, (Object)birthDate);
    }

    public void checkReplace(long key, Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Checking if data is valid to replace key {} : {}", (Object)key, metaData);
        this.replaceImpl(key, metaData, true);
        LOG.debug("Data is valid to replace key: {}", (Object)key);
    }

    public void replace(long key, Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Replacing data for key {} : {}", (Object)key, metaData);
        this.replaceImpl(key, metaData, false);
        LOG.debug("Data replaced for key: {}", (Object)key);
    }

    public void checkUpdate(long key, Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Checking if data is valid to update key {} : {}", (Object)key, metaData);
        this.updateImpl(key, metaData, true);
        LOG.debug("Data is valid to update key: {}", (Object)key);
    }

    public void update(long key, Map<String, Object> metaData) throws PandoraException {
        LOG.debug("Updating data for key {} : {}", (Object)key, metaData);
        this.updateImpl(key, metaData, false);
        LOG.debug("Data updated for key: {}", (Object)key);
    }

    public void checkRemove(long key) throws PandoraException {
        LOG.debug("Checking if artifact with key {} can be removed", (Object)key);
        this.removeImpl(key, true);
        LOG.debug("Artifact with key {} can be removed", (Object)key);
    }

    public void remove(long key) throws PandoraException {
        LOG.debug("Removing artifact with key {}", (Object)key);
        this.removeImpl(key, false);
        LOG.debug("Artifact with key {} removed", (Object)key);
    }

    public boolean exists(long key) throws PandoraException {
        try {
            LOG.debug("Checking if artifact with key {} exists", (Object)key);
            return this.getSearcher().query().filterContains("__key", (Object[])new Long[]{key}).count() > 0L;
        }
        catch (PandoraException ex) {
            throw new PandoraException(String.format("Error checking existence of artifact with key %d. %s", key, ex.getMessage()), (Throwable)ex);
        }
    }

    public Artifact getArtifact(long key) throws PandoraException {
        return this.getSearcher().getArtifact(key);
    }

    public Artifact getArtifactSkeleton(long key) throws PandoraException {
        return this.getSearcher().getArtifactSkeleton(key);
    }

    private synchronized long addImpl(Map<String, Object> metaData, Date birthDate, boolean testOnly) throws PandoraException {
        try {
            long key = this.getNextKey();
            Map<String, Object> storeMap = LuceneStore.createStoreMap(key, metaData, birthDate);
            IndexSerializer serializer = new IndexSerializer();
            Document doc = new Document();
            serializer.write(storeMap, doc);
            if (!testOnly) {
                this.reserveKey(key);
                this._connection.addDocument(doc);
                if (this._autoCommit) {
                    this._connection.commit();
                }
            }
            return key;
        }
        catch (IOException ex) {
            throw new PandoraException("Error adding artifact.", (Throwable)ex);
        }
    }

    private synchronized void addImpl(long key, Map<String, Object> metaData, Date birthDate, boolean testOnly) throws PandoraException {
        try {
            Map<String, Object> storeMap = LuceneStore.createStoreMap(key, metaData, birthDate);
            IndexSerializer serializer = new IndexSerializer();
            Document doc = new Document();
            serializer.write(storeMap, doc);
            if (!testOnly) {
                this._connection.addDocument(doc);
                if (this._autoCommit) {
                    this._connection.commit();
                }
            }
        }
        catch (IOException ex) {
            throw new PandoraException("Error adding artifact.", (Throwable)ex);
        }
    }

    private synchronized void replaceImpl(long key, Map<String, Object> metaData, boolean testOnly) throws PandoraException {
        Artifact artifact = this.getArtifactSkeleton(key);
        if (artifact == null) {
            throw new PandoraException(String.format("Cannot replace artifact with key %s because it does not exist", key));
        }
        Map<String, Object> storeMap = LuceneStore.createStoreMap(key, metaData, artifact.getBirthDate());
        this.deleteAndPut(key, storeMap, testOnly);
    }

    private void updateImpl(long key, Map<String, Object> metaData, boolean testOnly) throws PandoraException {
        Artifact artifact = this.getArtifact(key);
        if (artifact == null) {
            throw new PandoraException(String.format("Cannot update artifact with key %s because it does not exist", key));
        }
        artifact.putAll(metaData);
        Map<String, Object> storeMap = LuceneStore.createStoreMap(key, (Map<String, Object>)artifact, artifact.getBirthDate());
        this.deleteAndPut(key, storeMap, testOnly);
    }

    private void deleteAndPut(long key, Map<String, Object> metaData, boolean testOnly) throws PandoraException {
        block7: {
            try {
                IndexSerializer serializer = new IndexSerializer();
                Document doc = new Document();
                serializer.write(metaData, doc);
                if (testOnly) break block7;
                try {
                    Query keyQuery = this.getKeyQuery(key);
                    this._connection.deleteDocuments(keyQuery);
                }
                catch (IOException ex) {
                    throw new PandoraException(String.format("Error while trying to delete old artifact with key %d", key), (Throwable)ex);
                }
                try {
                    this._connection.addDocument(doc);
                }
                catch (IOException ex) {
                    throw new PandoraException(String.format("Error while trying to replace artifact with key %d", key), (Throwable)ex);
                }
                if (this._autoCommit) {
                    this._connection.commit();
                }
            }
            catch (IOException ex) {
                throw new PandoraException(String.format("Error replacing artifact for key %d. %s", key, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private static Map<String, Object> createStoreMap(long key, Map<String, Object> metaData, Date birthDate) throws PandoraException {
        LuceneStore.checkReservedProperty(metaData, "__key");
        LuceneStore.checkReservedProperty(metaData, "__index-date");
        LuceneStore.checkReservedProperty(metaData, "__birth-date");
        Date currentDate = new Date();
        LinkedHashMap<String, Object> storeMap = new LinkedHashMap<String, Object>(metaData);
        storeMap.put("__key", key);
        storeMap.put("__index-date", currentDate);
        storeMap.put("__birth-date", birthDate == null ? currentDate : birthDate);
        return storeMap;
    }

    private static void checkReservedProperty(Map<String, Object> metaData, String property) throws PandoraException {
        if (metaData.containsKey(property)) {
            throw new PandoraException(String.format("Data contains a key %s which is a reserved key name.", property));
        }
    }

    private synchronized void removeImpl(long key, boolean testOnly) throws PandoraException {
        try {
            Query keyQuery = this.getKeyQuery(key);
            if (!testOnly) {
                this._connection.deleteDocuments(keyQuery);
                if (this._autoCommit) {
                    this._connection.commit();
                }
            }
        }
        catch (IOException ex) {
            throw new PandoraException(String.format("Error removing artifact with key %d.", key), (Throwable)ex);
        }
    }

    private Query getKeyQuery(long key) throws PandoraException {
        PandoraFilter.Contains PandoraFilter2 = new PandoraFilter.Contains("__key", (Object[])new Long[]{key});
        return this._connection.getSchema(false).getQueryHelper().createQuery((PandoraFilter)PandoraFilter2);
    }

    private long findLastUsedKey() throws PandoraException {
        try {
            Long key = (Long)this.getSearcher().getMaximumValue("__key");
            if (key == null) {
                key = -1L;
                long count = this.getSearcher().query().count();
                if (count > 0L) {
                    throw new PandoraException(String.format("Sanity check failed! Store has %d artifacts, but no key could be found. This should NEVER happen!", count));
                }
            }
            return key;
        }
        catch (PandoraException ex) {
            throw new PandoraException("Error while trying to find last used artifact key from the store.", (Throwable)ex);
        }
    }

    private synchronized void initKey() throws PandoraException {
        if (this._lastKey < 0L) {
            this._lastKey = this.findLastUsedKey();
        }
    }

    private synchronized long getNextKey() throws PandoraException {
        this.checkAutoKeyMode();
        this.initKey();
        return this._lastKey + 1L;
    }

    private synchronized void reserveKey(long key) throws PandoraException {
        this.checkAutoKeyMode();
        this.initKey();
        if (key <= this._lastKey) {
            throw new PandoraException(String.format("Cannot reserve index key %s. Key must be greater than the last used key %s.", key, this._lastKey));
        }
        this._lastKey = key;
    }

    private void checkAutoKeyMode() throws PandoraException {
        if (!this._autoKey) {
            throw new PandoraException("Store operation is not allowed in manual key mode!");
        }
    }

    public void commit() throws PandoraException {
        try {
            this._connection.commit();
        }
        catch (IOException ex) {
            throw new PandoraException("Error while trying to commit.", (Throwable)ex);
        }
    }

    public boolean isAutoCommit() {
        return this._autoCommit;
    }

    public void setAutoCommit(boolean auto) {
        this._autoCommit = auto;
        LOG.info("Changed store to auto commit {}", (Object)this._autoCommit);
    }

    public boolean isAutoKeyMode() {
        return this._autoKey;
    }
}

