/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.transform.descriptor.TransformRepositoriesLock;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.util.FileUtilities;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class V2TransformSetRepository {
    private static final String MALTEGO_FOLDER = "Maltego/V2Compatibility";
    private static final String SET_FOLDER = "TransformSets";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_CUSTOM = "custom";
    private Set<TransformSet> _sets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TransformSet> sets() {
        if (this._sets == null) {
            this._sets = new HashSet<TransformSet>();
            Object object = TransformRepositoriesLock.LOCK;
            synchronized (object) {
                try {
                    FileObject setFolder = V2TransformSetRepository.getOrCreateSetFolder();
                    if (setFolder != null) {
                        for (FileObject fo : setFolder.getChildren()) {
                            TransformSet set = V2TransformSetRepository.loadSet(fo);
                            set.markClean();
                            this._sets.add(set);
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return this._sets;
    }

    public Set<TransformSet> allSets() {
        return this.sets();
    }

    public boolean contains(String name) {
        TransformSet set = this.get(name);
        return set != null;
    }

    public TransformSet get(String name) {
        for (TransformSet set : this.sets()) {
            if (!set.getName().equals(name)) continue;
            return set;
        }
        return null;
    }

    private static TransformSet loadSet(FileObject fo) {
        TransformSet set = new TransformSet(fo.getNameExt());
        set.setDescription((String)fo.getAttribute(ATTR_DESCRIPTION));
        boolean custom = true;
        Object customObject = fo.getAttribute(ATTR_CUSTOM);
        if (customObject != null) {
            custom = (Boolean)customObject;
        }
        set.setCustom(custom);
        for (FileObject child : fo.getChildren()) {
            set.addTransform(child.getNameExt());
        }
        return set;
    }

    private static FileObject getOrCreateSetFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)V2TransformSetRepository.getOrCreateMaltegoFolder(), (String)SET_FOLDER);
    }

    private static FileObject getOrCreateMaltegoFolder() throws IOException {
        FileObject root = FileUtil.getConfigRoot();
        return FileUtilities.getOrCreate((FileObject)root, (String)MALTEGO_FOLDER);
    }
}

