/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.ui.dialog.ComponentSizer;
import com.paterva.maltego.util.ui.dialog.DefaultWindowHandle;
import com.paterva.maltego.util.ui.dialog.FloatingWindowDescriptor;
import com.paterva.maltego.util.ui.dialog.FloatingWindowDisplayer;
import com.paterva.maltego.util.ui.dialog.WindowHandle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.ImageUtilities;
import org.openide.windows.WindowManager;

public class DefaultFloatingWindowDisplayer
extends FloatingWindowDisplayer {
    @Override
    public WindowHandle create(Window parent, FloatingWindowDescriptor descriptor) {
        final JDialog dialog = new JDialog(parent, descriptor.getTitle());
        if (!GraphicsUtil.useCustomLafFrameDecorations((boolean)false)) {
            dialog.setUndecorated(true);
        } else {
            dialog.getRootPane().setWindowDecorationStyle(0);
        }
        dialog.setModal(descriptor.isModal());
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        if (descriptor.isHeaderVisible()) {
            ActionListener closeListener = null;
            if (descriptor.isCloseButtonVisible()) {
                closeListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                    }
                };
            }
            Component header = this.getHeaderComponent(closeListener, descriptor.getIcon());
            content.add(header, "North");
            if (descriptor.isMovable() || descriptor.isResizable()) {
                ComponentSizer sizer = new ComponentSizer(dialog);
                sizer.setAllowMoving(descriptor.isMovable());
                sizer.setAllowResize(descriptor.isResizable());
            }
        }
        content.add(this.getControl(descriptor.getInnerPane()), "Center");
        dialog.setContentPane(content);
        dialog.pack();
        this.setLocation((Dialog)dialog, descriptor.getPositionRelativeTo(), descriptor.getPosition());
        return new DefaultWindowHandle(dialog);
    }

    private Component getHeaderComponent(ActionListener closeListener, Icon icon) {
        JButton closeButton = null;
        Component iconComponent = null;
        if (closeListener != null) {
            closeButton = this.createCloseButton();
            closeButton.addActionListener(closeListener);
        }
        if (icon != null) {
            iconComponent = this.createIconComponent(icon);
        }
        final int rightInset = closeButton == null ? 0 : closeButton.getPreferredSize().width + 1;
        final int leftInset = iconComponent == null ? 0 : iconComponent.getPreferredSize().width + 1;
        JPanel header = new JPanel(new BorderLayout()){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.lightGray);
                int width = this.getWidth() - 2 - rightInset;
                int y = 2;
                int x = 1 + leftInset;
                for (int i = 0; i < this.getHeight() / 3; ++i) {
                    g.drawLine(x, y, width, y);
                    y += 2;
                }
            }
        };
        header.setPreferredSize(new Dimension(100, 12));
        if (closeButton != null) {
            header.add((Component)closeButton, "East");
        }
        return header;
    }

    private Component getControl(Object innerPane) {
        if (innerPane instanceof Component) {
            return (Component)innerPane;
        }
        return new JLabel(innerPane.toString());
    }

    private void setLocation(Dialog dialog, int positionRelative, int position) {
        Rectangle bounds = positionRelative == 1 ? WindowManager.getDefault().getMainWindow().getBounds() : GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setLocation(dialog, bounds, position);
    }

    private void setLocation(Dialog dialog, Rectangle bounds, int position) {
        int y;
        int x;
        switch (position) {
            case 0: {
                x = bounds.x + (bounds.width - dialog.getWidth()) / 2;
                y = bounds.y + (bounds.height - dialog.getHeight()) / 2;
                break;
            }
            case 1: {
                x = bounds.x;
                y = bounds.y;
                break;
            }
            case 3: {
                x = bounds.x + bounds.width - dialog.getWidth();
                y = bounds.y;
                break;
            }
            case 4: {
                x = bounds.x + bounds.width - dialog.getWidth();
                y = bounds.y + bounds.height - dialog.getHeight();
                break;
            }
            case 2: {
                x = bounds.x;
                y = bounds.y + bounds.height - dialog.getHeight();
                break;
            }
            default: {
                x = bounds.x;
                y = bounds.y;
            }
        }
        dialog.setLocation(x, y);
    }

    private JButton createCloseButton() {
        ImageIcon closeIcon = new ImageIcon(ImageUtilities.loadImage((String)"/com/paterva/maltego/util/ui/dialog/Close.png"));
        JButton closeButton = new JButton(closeIcon);
        closeButton.setBorder(BorderFactory.createEmptyBorder());
        closeButton.setPreferredSize(new Dimension(closeIcon.getIconWidth(), closeIcon.getIconHeight()));
        closeButton.setHorizontalAlignment(4);
        closeButton.setFocusPainted(false);
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        return closeButton;
    }

    private Component createIconComponent(Icon icon) {
        JLabel label = new JLabel(icon);
        return label;
    }
}

